/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.service.function;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.CheckingBillExistDataModel;
import kd.fi.er.business.trip.model.CheckingBillHeaderModel;
import kd.fi.er.business.trip.model.CheckingBillModel;
import kd.fi.er.business.trip.model.HotelCheckingBillDetailModel;
import kd.fi.er.business.trip.model.MealCheckingBillDetailModel;
import kd.fi.er.business.trip.model.PlaneCheckingBillDetailModel;
import kd.fi.er.business.trip.model.TrainCheckingBillDetailModel;
import kd.fi.er.business.trip.model.VehicleCheckingBillDetailModel;
import kd.fi.er.business.trip.service.function.template.InPutFunctionTemp;
import kd.fi.er.business.trip.service.validate.Validate;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCheckingInvoke<T>
extends InPutFunctionTemp {
    private static final Log logger = LogFactory.getLog(AbstractCheckingInvoke.class);

    public AbstractCheckingInvoke() {
    }

    public AbstractCheckingInvoke(Map params) {
        super(params);
    }

    @Override
    protected String supplier() {
        return null;
    }

    @Override
    protected String function() {
        return "checkingInvoke";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveInfos(Object infos) {
        List checkingModels = (List)infos;
        if (checkingModels == null || checkingModels.isEmpty()) {
            return;
        }
        AtomicInteger i = new AtomicInteger(0);
        int intValue = TripSyncConfigUtil.getIntValue("trip_sync_order_size", 100);
        boolean checkingDataByBillNo = TripSyncConfigUtil.getBoolean("checkingdata_by_billno");
        for (CheckingBillModel abstractCheckingModel : checkingModels) {
            if (null == abstractCheckingModel.getCheckingBillDetailModels()) continue;
            CheckingBillModel checkingBillModelSave = new CheckingBillModel();
            List<AbstractCheckingBillDetailModel> checkingBillDetailModels = abstractCheckingModel.getCheckingBillDetailModels();
            List partitiondetail = Lists.partition(checkingBillDetailModels, (int)intValue);
            checkingBillModelSave.setCheckingBillHeaderModel(abstractCheckingModel.getCheckingBillHeaderModel());
            for (List abstractCheckingBillDetailModels : partitiondetail) {
                ArrayList<CheckingBillModel> checkingModelsSaves = new ArrayList<CheckingBillModel>(1);
                i.getAndAdd(1);
                checkingBillModelSave.setCheckingBillDetailModels(abstractCheckingBillDetailModels);
                checkingModelsSaves.add(checkingBillModelSave);
                if (checkingDataByBillNo) {
                    AbstractCheckingInvoke abstractCheckingInvoke = this;
                    synchronized (abstractCheckingInvoke) {
                        this.saveCheckingBill(checkingModelsSaves);
                    }
                } else {
                    this.saveCheckingBill(checkingModelsSaves);
                }
                logger.info("\u5206\u6279\u6b21\u4fdd\u5b58\uff1a\u7b2c+" + i.get() + "\u6279\u6b21\u4fdd\u5b58\u7ed3\u675f");
            }
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u7ed3\u7b97\u5355\u4fdd\u5b58,end");
    }

    private void saveCheckingBill(Object infos) {
        List checkingModels = (List)infos;
        if (checkingModels == null || checkingModels.size() < 1) {
            return;
        }
        if (TripSyncConfigUtil.getBoolean("trip_sync_orderbill_isverify_mustinput")) {
            StringBuilder message = new StringBuilder();
            for (CheckingBillModel checkingBillModel : checkingModels) {
                Validate result = checkingBillModel.validate();
                if (result.result.success) continue;
                message.append(checkingBillModel.getCheckingBillHeaderModel().getBillNo()).append(':').append(result.result.message.toString());
            }
            if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u51fa\u9519:%s", (String)"AbstractCheckingInvoke_0", (String)"fi-er-business", (Object[])new Object[0]), message));
            }
        }
        this.validateBeforeSave(checkingModels);
        CheckingBillExistDataModel model = new CheckingBillExistDataModel();
        try {
            this.changeBatchOrdernum(checkingModels);
            for (CheckingBillModel checkingModel : checkingModels) {
                checkingModel.addExistDataFilter(model);
            }
            model.query();
            for (CheckingBillModel checkingModel : checkingModels) {
                checkingModel.generateData();
            }
            this.handleBeforeSave(model.getCheckingbillDetailMapping());
            model.save();
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u7ed3\u7b97\u5355\u4fdd\u5b58,\u5931\u8d25:", (Throwable)e);
            throw e;
        }
        this.handleAfterSave(model.getCheckingbillDetailMapping());
    }

    protected void validateBeforeSave(List<? extends CheckingBillModel> checkingModels) {
    }

    protected void handleBeforeSave(Map<String, DynamicObject> checkingbillDetailMapping) {
    }

    protected void handleAfterSave(Map<String, DynamicObject> checkingbillDetailMapping) {
    }

    protected void handleHeadCheckingExtCovert(CheckingBillHeaderModel headerCheckingModel, JSONObject headerCheckingJsonInfo) {
    }

    protected void handlePlaneCheckingExtCovert(PlaneCheckingBillDetailModel planeCheckingModel, JSONObject planeCheckingJsonInfo) {
    }

    protected void handleHotelCheckingExtCovert(HotelCheckingBillDetailModel hotelCheckingModel, JSONObject hotelCheckingJsonInfo) {
    }

    protected void handleCarCheckingExtCovert(VehicleCheckingBillDetailModel carCheckingModel, JSONObject carCheckingJsonInfo) {
    }

    protected void handleTrainCheckingExtCovert(TrainCheckingBillDetailModel trainCheckingModel, JSONObject trainCheckingJsonInfo) {
    }

    protected void handleMealCheckingExtCovert(MealCheckingBillDetailModel mealCheckingModel, JSONObject mealCheckingJsonInfo) {
    }

    protected void handleQueryParamsExt(String url, JSONObject jsonObject, Map<String, Object> map) {
    }

    private void changeBatchOrdernum(List<? extends CheckingBillModel> checkingModels) {
        if (null == checkingModels || null == checkingModels.get(0) || null == checkingModels.get(0).getCheckingBillHeaderModel() || !Supplier.XIECHENG.getValue().equals(checkingModels.get(0).getCheckingBillHeaderModel().getServer())) {
            return;
        }
        HashMap orderNumMap = new HashMap(8);
        for (CheckingBillModel checkingBillModel : checkingModels) {
            for (AbstractCheckingBillDetailModel checkingBillDetailModel : checkingBillModel.getCheckingBillDetailModels()) {
                if (null == checkingBillDetailModel.getBatchno() || checkingBillDetailModel.getBatchno().trim().isEmpty()) continue;
                if (null == orderNumMap.get(checkingBillDetailModel.getBillFormId())) {
                    HashSet<String> orderNums = new HashSet<String>(8);
                    orderNums.add(checkingBillDetailModel.getOrderNum());
                    orderNumMap.put(checkingBillDetailModel.getBillFormId(), orderNums);
                    continue;
                }
                ((Set)orderNumMap.get(checkingBillDetailModel.getBillFormId())).add(checkingBillDetailModel.getOrderNum());
            }
        }
        if (orderNumMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : orderNumMap.entrySet()) {
            Set setvalue;
            String formid = (String)entry.getKey();
            DynamicObjectCollection allchecking = QueryServiceHelper.query((String)formid, (String)"ordernum,batchno", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", (Object)(setvalue = (Set)entry.getValue()))});
            if (null == allchecking || allchecking.isEmpty()) continue;
            Map checkingnumMap = allchecking.stream().collect(Collectors.toMap(v -> v.getString("ordernum"), Function.identity(), (v1, v2) -> v1));
            for (CheckingBillModel checkingBillModel : checkingModels) {
                for (AbstractCheckingBillDetailModel checkingBillDetailModel : checkingBillModel.getCheckingBillDetailModels()) {
                    DynamicObject checking = (DynamicObject)checkingnumMap.get(checkingBillDetailModel.getOrderNum());
                    if (null == checking || null == checking.getString("batchno") || null == checkingBillDetailModel.getBatchno() || checking.getString("batchno").trim().equals(checkingBillDetailModel.getBatchno().trim())) continue;
                    String batchno = checkingBillDetailModel.getBatchno().replaceAll("-", "");
                    String fix = batchno.length() >= 4 ? batchno.substring(batchno.length() - 4) : batchno;
                    checkingBillDetailModel.setOrderNum(checkingBillDetailModel.getOrderNum() + "-" + fix);
                }
            }
        }
    }
}

