/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.service.function.template;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.business.trip.supplier.Supplier;
import org.apache.commons.lang3.StringUtils;

public abstract class InPutFunctionTemp<T> {
    private static final Log logger = LogFactory.getLog(InPutFunctionTemp.class);
    protected List<TripSyncLogParam> tripSyncLogParamList = null;
    protected TripSyncLogParam tripSyncLogParam = null;
    protected Map<String, ? extends Object> params;

    public Map<String, ? extends Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, ? extends Object> params) {
        this.params = params;
    }

    public InPutFunctionTemp() {
    }

    public InPutFunctionTemp(Map<String, ? extends Object> params) {
        this.params = params;
    }

    public void execute() {
        this.initSyncLogParam();
        try {
            T t = this.process(this.params);
            Object modelList = this.convert(t);
            this.saveInfos(modelList);
        }
        catch (Exception e) {
            this.setErrorMsg(e);
            logger.error("\u5546\u65c5\u96c6\u6210,\u5931\u8d25:", (Throwable)e);
            throw e;
        }
        finally {
            this.handleErrorLog();
        }
    }

    private void initSyncLogParam() {
        this.tripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), this.supplier(), this.function());
        this.tripSyncLogParamList = new LinkedList<TripSyncLogParam>();
    }

    private void setErrorMsg(Exception e) {
        this.tripSyncLogParam.setStatus("B");
        this.tripSyncLogParam.setMessage(e);
        this.tripSyncLogParamList.forEach(v -> {
            v.setStatus("B");
            v.setMessage(e);
        });
    }

    private void handleErrorLog() {
        if (this.tripSyncLogParamList.size() < 1) {
            this.tripSyncLogParamList = new LinkedList<TripSyncLogParam>();
            this.tripSyncLogParamList.add(this.tripSyncLogParam);
        }
        Set<String> billIds = this.tripSyncLogParamList.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getBillid())).map(v -> v.getBillid()).collect(Collectors.toSet());
        TripSyncLogUtils.delErrByBillId(billIds);
        if (Supplier.CHAILVYIHAO.name().equalsIgnoreCase(this.supplier())) {
            TripSyncLogUtils.delErrByServerFunction(this.supplier(), this.function());
        }
        TripSyncLogUtils.saveErrorLog(this.tripSyncLogParamList);
    }

    protected abstract String supplier();

    protected abstract String function();

    protected abstract T process(Map<String, ? extends Object> var1);

    protected abstract Object convert(T var1);

    protected abstract void saveInfos(Object var1);
}

