/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.service.function.template;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.common.utils.ThrowableHelper;
import org.apache.commons.lang3.StringUtils;

public abstract class OutPutFunctionTemp<T> {
    private static Log logger = LogFactory.getLog(OutPutFunctionTemp.class);
    protected List<TripSyncLogParam> tripSyncLogParamList = null;
    protected TripSyncLogParam tripSyncLogParam = null;
    protected Object pk;
    protected Map params;

    public Object getPk() {
        return this.pk;
    }

    public void setPk(Object pk) {
        this.pk = pk;
    }

    public Map getParams() {
        return this.params;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public OutPutFunctionTemp() {
    }

    public OutPutFunctionTemp(Object pk) {
        this.pk = pk;
    }

    public OutPutFunctionTemp(Map params) {
        this.params = params;
    }

    public String execute() {
        this.initSyncLogParam();
        String code = null;
        try {
            Object innerData = this.getInnerData();
            T t = this.convert(innerData);
            code = this.batPushProcess(t);
            this.handleErrorLog(code);
        }
        catch (Exception e) {
            try {
                this.setErrorMsg(e);
                logger.error("\u5546\u65c5\u96c6\u6210,\u5931\u8d25:{}", (Object)ThrowableHelper.toString((Exception)e));
                throw e;
            }
            catch (Throwable throwable) {
                this.handleErrorLog(code);
                throw throwable;
            }
        }
        return code;
    }

    private void initSyncLogParam() {
        this.tripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), this.supplier(), this.function());
        this.tripSyncLogParamList = new LinkedList<TripSyncLogParam>();
    }

    protected void setErrorMsg(Exception e) {
        this.tripSyncLogParam.setStatus("B");
        this.tripSyncLogParam.setMessage(e);
        this.tripSyncLogParamList.forEach(v -> {
            v.setStatus("B");
            v.setMessage(e);
        });
    }

    protected void handleErrorLog(String code) {
        if (this.tripSyncLogParamList.size() < 1) {
            if (!StringUtils.equals((CharSequence)"200", (CharSequence)code)) {
                this.tripSyncLogParam.setStatus("B");
            }
            this.tripSyncLogParamList = new LinkedList<TripSyncLogParam>();
            this.tripSyncLogParamList.add(this.tripSyncLogParam);
        }
        Map billIdMap = this.tripSyncLogParamList.stream().filter(v -> StringUtils.isNotBlank((CharSequence)v.getBillid())).collect(Collectors.groupingBy(v -> v.getServer(), Collectors.mapping(v -> v.getBillid(), Collectors.toSet())));
        billIdMap.forEach((k, v) -> TripSyncLogUtils.delErrByServerBillIds(k, v));
        if ("orgInvoke".equalsIgnoreCase(this.function()) || "userInvoke".equalsIgnoreCase(this.function())) {
            TripSyncLogUtils.delErrByServerFunction(this.supplier(), this.function());
        }
        TripSyncLogUtils.saveErrorLog(this.tripSyncLogParamList);
    }

    protected abstract String supplier();

    protected abstract String function();

    protected abstract Object getInnerData();

    protected abstract T convert(Object var1);

    protected abstract String batPushProcess(T var1);
}

