/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.service.function.template.InPutFunctionTemp;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.trip.util.TripCityUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import org.apache.commons.lang3.StringUtils;

public class CTripCityInvoke
extends InPutFunctionTemp<JSONObject> {
    private static Log logger = LogFactory.getLog(CTripCityInvoke.class);

    @Override
    protected String supplier() {
        return Supplier.XIECHENG.name();
    }

    @Override
    protected String function() {
        return "tripCityInvoke";
    }

    @Override
    protected JSONObject process(Map<String, ?> params) throws TripException {
        JSONObject postJson = new JSONObject();
        postJson.put("Auth", (Object)CorpSync.getAuthentification());
        this.tripSyncLogParam.setRequesturl("https://corpsz.ctrip.com/flightBaseData/queryCity");
        this.tripSyncLogParam.setRequestdata(postJson);
        String result = HttpRetryServiceHelper.PostData("https://corpsz.ctrip.com/flightBaseData/queryCity", postJson.toJSONString());
        this.tripSyncLogParam.setResponsedata(result);
        JSONObject planeJson = JSONObject.parseObject((String)result);
        postJson.put("CountryId", (Object)1);
        String hotelStr = HttpRetryServiceHelper.PostData("https://ct.ctrip.com/corpopenapi/HotelCity/GetCountryCityExtend", postJson.toJSONString());
        JSONObject hotelJson = JSONObject.parseObject((String)hotelStr);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("plane", (Object)planeJson);
        jsonObject.put("hotel", (Object)hotelJson);
        return jsonObject;
    }

    @Override
    protected Object convert(JSONObject jsonObject) throws TripException {
        if (jsonObject == null) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u65e5\u5fd7\u96c6\u6210,\u83b7\u53d6\u643a\u7a0b\u57ce\u5e02\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\u3002", (String)"CTripCityInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        JSONArray cropCityJsonArrays = new JSONArray();
        JSONObject planeJson = (JSONObject)jsonObject.get((Object)"plane");
        JSONObject hotelJson = (JSONObject)jsonObject.get((Object)"hotel");
        ArrayList restCityList = Lists.newArrayListWithCapacity((int)planeJson.size());
        List<DynamicObject> cityDynamicObjectList = this.matchPlaneCityNew(planeJson, cropCityJsonArrays, restCityList);
        JSONArray cropHotelCityJsonArrays = new JSONArray();
        cityDynamicObjectList.addAll(this.matchHotelCity(hotelJson, cropHotelCityJsonArrays, restCityList));
        if (CollectionUtils.isEmpty(cityDynamicObjectList)) {
            return null;
        }
        return cityDynamicObjectList;
    }

    @Override
    protected void saveInfos(Object infos) throws TripException {
        List tripCityDynamicObjectList = (List)infos;
        TripCityUtil.saveTripCityData(tripCityDynamicObjectList);
    }

    private List<DynamicObject> matchHotelCity(JSONObject jsonObject, JSONArray cropHotelCityJsonArrays, List<DynamicObject> restCityList) {
        JSONObject jsonStatusObject = jsonObject.getJSONObject("Status");
        long startTime = System.currentTimeMillis();
        logger.info("\u5269\u4f59\u672a\u5339\u914d\u57ce\u5e02\u5927\u5c0f" + restCityList.size());
        if (jsonStatusObject.getString("ErrorCode").equals("0")) {
            JSONArray currDataArray = jsonObject.getJSONArray("Data");
            if (currDataArray != null) {
                cropHotelCityJsonArrays.addAll((Collection)currDataArray);
                logger.info("\u9152\u5e97\u6570\u636e\u5927\u5c0f" + cropHotelCityJsonArrays.size());
            }
        } else {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> cityDynamicObjectList = new ArrayList<DynamicObject>();
        List<Object> finalRestCityList = new ArrayList();
        if (cropHotelCityJsonArrays != null && cropHotelCityJsonArrays.size() > 0 && cropHotelCityJsonArrays.get(0) != null) {
            finalRestCityList = restCityList.stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("admindivisionid.country.name")) && dynamicObject.getString("admindivisionid.country.name").startsWith(((JSONObject)cropHotelCityJsonArrays.get(0)).getString("CountryName"))).collect(Collectors.toList());
        }
        if (finalRestCityList.size() > 0) {
            int restSize = finalRestCityList.size();
            HashMap<String, Integer> tmpMap = new HashMap<String, Integer>(restSize);
            for (int i = 0; i < restSize; ++i) {
                DynamicObject dynamicObject2 = (DynamicObject)finalRestCityList.get(i);
                String adminName = dynamicObject2.getString("admindivisionid.name");
                adminName = TripCityUtil.judgeCityName(adminName);
                if (tmpMap.containsKey(adminName = adminName.trim())) continue;
                tmpMap.put(adminName, i);
            }
            int paramValue = TripSyncConfigUtil.getIntValue("trip_cityid_update", 0, Arrays.asList(1, 0));
            for (int i = 0; i < cropHotelCityJsonArrays.size(); ++i) {
                Integer index;
                JSONObject cropCityJsonArray = (JSONObject)cropHotelCityJsonArrays.get(i);
                String cityName = cropCityJsonArray.getString("CityName");
                String cityId = cropCityJsonArray.getString("City");
                String cityEnName = cropCityJsonArray.getString("CityEName");
                if (!tmpMap.containsKey(cityName = cityName.trim()) || (index = (Integer)tmpMap.get(cityName)) >= restSize) continue;
                DynamicObject dynamicObject3 = (DynamicObject)finalRestCityList.get(index);
                String cityid = dynamicObject3.getString("cityid");
                if (StringUtils.isNotBlank((CharSequence)cityid) && 0 == paramValue) {
                    dynamicObject3.set("cityid", (Object)cityId);
                }
                if (StringUtils.isBlank((CharSequence)cityid) || "0".equals(cityid)) {
                    dynamicObject3.set("cityid", (Object)cityId);
                }
                dynamicObject3.set("namepinyin", (Object)cityEnName);
                cityDynamicObjectList.add(dynamicObject3);
            }
        }
        logger.info("\u9152\u5e97\u57ce\u5e02\u7ed3\u675f\u5339\u914d" + (System.currentTimeMillis() - startTime));
        return cityDynamicObjectList;
    }

    private DynamicObject[] removeArrEle(DynamicObject[] cityObjMaps, DynamicObject delEle) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(Arrays.asList(cityObjMaps));
        list.removeAll(Collections.singletonList(delEle));
        cityObjMaps = list.toArray(new DynamicObject[0]);
        return cityObjMaps;
    }

    private List<FourTuple<String, String, DynamicObject, String>> dealCityObjMaps(DynamicObject[] tmpCityObjMaps, Set<String> countryFullSpellSet, Map<String, List<Integer>> adminNameAndIndexMap, Map<String, List<Integer>> fullSpellAndIndexMap) {
        countryFullSpellSet.clear();
        ArrayList needCycleData = Lists.newArrayListWithCapacity((int)16);
        HashSet tmpSet = Sets.newHashSetWithExpectedSize((int)tmpCityObjMaps.length);
        Collections.addAll(tmpSet, tmpCityObjMaps);
        Iterator iterator = tmpSet.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            String adminName;
            DynamicObject cityDynamicObject = (DynamicObject)iterator.next();
            String countryName = cityDynamicObject.getString("admindivisionid.country.name");
            if (StringUtils.isEmpty((CharSequence)countryName) || StringUtils.isEmpty((CharSequence)(adminName = cityDynamicObject.getString("admindivisionid.name")))) continue;
            if (countryName.startsWith(ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"AbstractCityInvoke_1", (String)"fi-er-business", (Object[])new Object[0]))) {
                if (adminNameAndIndexMap.containsKey(adminName = TripCityUtil.judgeCityName(adminName))) {
                    List<Integer> dataIndex = adminNameAndIndexMap.get(adminName);
                    dataIndex.add(index++);
                } else {
                    ArrayList dataIndexs = Lists.newArrayListWithCapacity((int)16);
                    dataIndexs.add(index++);
                    adminNameAndIndexMap.put(adminName, dataIndexs);
                }
            } else {
                List<Object> dataIndexs;
                String tmpFullSpell = cityDynamicObject.getString("admindivisionid.fullspell");
                if (StringUtils.isEmpty((CharSequence)tmpFullSpell)) continue;
                String fullSpell = tmpFullSpell.replaceAll(" City", "").replaceAll(" city", "").replaceAll(" Area", "").replaceAll(" area", "").replaceAll(" County", "").replaceAll(" county", "").replaceAll(" District", "").replaceAll(" district", "");
                String fullSpellLowerCase = fullSpell.toLowerCase();
                countryFullSpellSet.add(fullSpellLowerCase);
                if (fullSpellAndIndexMap.containsKey(fullSpellLowerCase)) {
                    dataIndexs = fullSpellAndIndexMap.get(fullSpellLowerCase);
                    dataIndexs.add(index++);
                } else {
                    dataIndexs = Lists.newArrayListWithCapacity((int)16);
                    dataIndexs.add(index++);
                    fullSpellAndIndexMap.put(fullSpellLowerCase, dataIndexs);
                }
            }
            if (countryName.startsWith(ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"AbstractCityInvoke_1", (String)"fi-er-business", (Object[])new Object[0]))) {
                countryName = countryName.replaceAll(countryName, ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"AbstractCityInvoke_1", (String)"fi-er-business", (Object[])new Object[0]));
            }
            FourTuple<String, String, DynamicObject, String> fourTuple = new FourTuple<String, String, DynamicObject, String>(adminName, "", cityDynamicObject, countryName);
            needCycleData.add(fourTuple);
        }
        return needCycleData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DynamicObject> matchPlaneCityNew(JSONObject jsonObject, JSONArray cropCityJsonArrays, List<DynamicObject> restCityList) {
        JSONObject jsonStatusObject = jsonObject.getJSONObject("status");
        if (jsonStatusObject.getString("errorCode").equals("0")) {
            this.tripSyncLogParam.setStatus("A");
            JSONArray currDataArray = jsonObject.getJSONArray("datas");
            if (currDataArray != null) {
                cropCityJsonArrays.addAll((Collection)currDataArray);
            }
        } else {
            this.tripSyncLogParam.setStatus("B");
            return new ArrayList<DynamicObject>();
        }
        String setectProperties = "id,nameen,admindivisionid.country.name,admindivisionid.fullspell,code,cityID,namePinyin";
        DynamicObject[] cityObjMaps = BusinessDataServiceHelper.load((String)"er_city", (String)setectProperties, (QFilter[])new QFilter[0]);
        final HashSet countryFullSpellSet = Sets.newHashSetWithExpectedSize((int)16);
        final HashMap adminNameAndIndexMap = Maps.newHashMapWithExpectedSize((int)16);
        final HashMap fullSpellAndIndexMap = Maps.newHashMapWithExpectedSize((int)16);
        List<FourTuple<Integer, String, String, String>> resultDatas = this.dealJson(cropCityJsonArrays);
        final List<FourTuple<String, String, DynamicObject, String>> needCycleDatas = this.dealCityObjMaps(cityObjMaps, countryFullSpellSet, adminNameAndIndexMap, fullSpellAndIndexMap);
        final List partition = Lists.partition(resultDatas, (int)1000);
        int size = partition.size();
        final CountDownLatch countDownLatch = new CountDownLatch(size);
        logger.info("partitionList size {}", (Object)size);
        RequestContext context = RequestContext.get();
        final List<DynamicObject> cityDynamicObjectList = Collections.synchronizedList(new ArrayList());
        try {
            final int paramValue = TripSyncConfigUtil.getIntValue("trip_cityid_update", 0, Arrays.asList(1, 0));
            int i = 0;
            while (i < size) {
                final int finalI = i++;
                ThreadService.execute((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            ArrayList tmpCityDynamicObject = Lists.newArrayListWithCapacity((int)16);
                            List dynamicObjects = (List)partition.get(finalI);
                            int jsonSize = dynamicObjects.size();
                            for (int i = 0; i < jsonSize; ++i) {
                                FourTuple fourTuple = (FourTuple)dynamicObjects.get(i);
                                String second = (String)fourTuple.second;
                                String[] flagArr = second.split("#");
                                String countryId = flagArr[0];
                                String countryName = flagArr[1];
                                String name = flagArr[2];
                                if ("1".equals(countryId)) {
                                    if (!adminNameAndIndexMap.containsKey(name = TripCityUtil.judgeCityName(name))) continue;
                                    Integer cityId = (Integer)fourTuple.first;
                                    List matchDataIndex = (List)adminNameAndIndexMap.get(name);
                                    CTripCityInvoke.this.setValue(fourTuple, flagArr[3], countryName, cityId, matchDataIndex, needCycleDatas, tmpCityDynamicObject, paramValue);
                                    continue;
                                }
                                String cityEnName = (String)fourTuple.four;
                                String cityEnNameLowerCase = cityEnName.toLowerCase();
                                if (!countryFullSpellSet.contains(cityEnNameLowerCase) || !fullSpellAndIndexMap.containsKey(cityEnNameLowerCase)) continue;
                                Integer cityId = (Integer)fourTuple.first;
                                List matchDataIndex = (List)fullSpellAndIndexMap.get(cityEnNameLowerCase);
                                CTripCityInvoke.this.setValue(fourTuple, flagArr[3], countryName, cityId, matchDataIndex, needCycleDatas, tmpCityDynamicObject, paramValue);
                            }
                            if (CollectionUtils.isNotEmpty((Collection)tmpCityDynamicObject)) {
                                cityDynamicObjectList.addAll(tmpCityDynamicObject);
                            }
                        }
                        catch (Exception e) {
                            logger.error("execute sub thread error", (Throwable)e);
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    }
                }, (TaskType)TaskType.ER_LOWFREQUENCYTASK_TASK, (RequestContext)context);
            }
            countDownLatch.await();
        }
        catch (Exception e) {
            logger.error("main thread error", (Throwable)e);
        }
        logger.info("need update datas{}", (Object)cityDynamicObjectList.size());
        List cityList = Arrays.stream(cityObjMaps).collect(Collectors.toList());
        cityList.removeAll(cityDynamicObjectList);
        restCityList.addAll(cityList);
        return cityDynamicObjectList;
    }

    private void setValue(FourTuple<Integer, String, String, String> fourTuple, String value, String countryName, Integer cityId, List<Integer> matchDataIndex, List<FourTuple<String, String, DynamicObject, String>> needCycleDatas, List<DynamicObject> cityDynamicObjectList, int paramValue) {
        int indexSize = matchDataIndex.size();
        for (int index = 0; index < indexSize; ++index) {
            FourTuple<String, String, DynamicObject, String> matchData = needCycleDatas.get(matchDataIndex.get(index));
            String tmpCountryName = (String)matchData.four;
            if (!countryName.equals(tmpCountryName)) continue;
            DynamicObject third = (DynamicObject)matchData.third;
            third.set("code", (Object)value);
            String cityid = third.getString("cityid");
            if (StringUtils.isNotBlank((CharSequence)cityid) && 0 == paramValue) {
                third.set("cityid", (Object)cityId);
            }
            if ("0".equals(cityid)) {
                third.set("cityid", (Object)cityId);
            }
            third.set("namepinyin", fourTuple.third);
            cityDynamicObjectList.add(third);
        }
    }

    private List<FourTuple<Integer, String, String, String>> dealJson(JSONArray cropCityJsonArrays) {
        ArrayList resultDatas = Lists.newArrayListWithCapacity((int)cropCityJsonArrays.size());
        for (Object cityObject : cropCityJsonArrays) {
            JSONObject cropCity = (JSONObject)cityObject;
            String name_En = cropCity.getString("name_En");
            String name_EnStr = name_En.replaceAll("[\\pP\\p{Punct}]", "");
            String countryId = cropCity.getString("countryID");
            Integer poiType = cropCity.getInteger("poiType");
            String name = cropCity.getString("name");
            String countryName = cropCity.getString("countryName");
            String code = cropCity.getString("code");
            if (poiType != 5 || StringUtils.isBlank((CharSequence)code)) continue;
            String flagStr = countryId + "#" + countryName + "#" + name + "#" + code;
            resultDatas.add(new FourTuple<Integer, String, String, String>(cropCity.getIntValue("cityID"), flagStr, cropCity.getString("namePinyin"), name_EnStr));
        }
        return resultDatas;
    }

    private int getFixedThreads() {
        int cpus = Runtime.getRuntime().availableProcessors();
        int fixedThreads = cpus + 1;
        logger.info("current thread nums {}", (Object)fixedThreads);
        return fixedThreads;
    }

    static class FourTuple<A, B, C, D> {
        public final A first;
        public final B second;
        public final C third;
        public final D four;

        public FourTuple(A a, B b, C c, D d) {
            this.first = a;
            this.second = b;
            this.third = c;
            this.four = d;
        }
    }
}

