/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.model.DailyVehicleBillModel;
import kd.fi.er.business.trip.service.function.AbstractDailyVehicleBillInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.trip.util.TripCityUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.commons.lang.StringUtils;

public class CTripDailyVehicleBillInvoke
extends AbstractDailyVehicleBillInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(CTripDailyVehicleBillInvoke.class);
    private static final String SUCCESS = "Success";

    public CTripDailyVehicleBillInvoke(Object pk) {
        super(pk);
    }

    public CTripDailyVehicleBillInvoke() {
    }

    @Override
    protected String supplier() {
        return Supplier.XIECHENG.name();
    }

    protected JSONObject convert(Object value) {
        if (this.pk != null) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u7528\u8f66\u7533\u8bf7\u5355,\u5355\u636ebillid\u4e3a:" + this.pk);
            return this.convertPushBill(value);
        }
        String syncStatus = (String)this.getParams().get("syncStatus");
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u7528\u8f66\u7533\u8bf7\u5355,\u540c\u6b65\u7684\u72b6\u6001\u6709:1_\u63a8\u9001\u5355\u636e,\u5f53\u524d\u72b6\u6001\u4e3a:" + syncStatus);
        switch (syncStatus) {
            case "1": {
                return this.convertPushBill(value);
            }
            case "2": {
                return this.convertCloseBill(value);
            }
        }
        return null;
    }

    protected String batPushProcess(Object value) {
        JSONObject ApprovalJson;
        JSONObject status;
        if (value == null) {
            return null;
        }
        JSONObject t = (JSONObject)value;
        JSONObject requestJson = new JSONObject();
        requestJson.put("request", (Object)t);
        String jsonStr = JSON.toJSONString((Object)requestJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        String url = "https://ct.ctrip.com/switchapi/approval.svc/rest/setapproval";
        this.tripSyncLogParam.setRequestdata(value);
        this.tripSyncLogParam.setRequesturl(url);
        String result = HttpServiceHelper.PostData(url, jsonStr);
        this.tripSyncLogParam.setResponsedata(result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject != null && (status = (ApprovalJson = jsonObject.getJSONObject("SetApprovalResult")).getJSONObject("Status")).getBoolean(SUCCESS).booleanValue()) {
            return "200";
        }
        return null;
    }

    protected JSONObject convertPushBill(Object info) {
        DailyVehicleBillModel reqbill = (DailyVehicleBillModel)info;
        JSONObject bodyDataJson = new JSONObject();
        JSONArray CarQuickEndorsementDetails = new JSONArray();
        HashSet<JSONObject> passengerSet = new HashSet<JSONObject>();
        HashSet<JSONObject> passengerNameSet = new HashSet<JSONObject>();
        String employeeID = reqbill.getApplyEmpNum();
        JSONObject passengerOb1 = new JSONObject();
        JSONObject passengerNumOb1 = new JSONObject();
        JSONObject passengerNameOb1 = new JSONObject();
        passengerOb1.put("Name", (Object)reqbill.getApplyEmpName());
        passengerOb1.put("EID", (Object)reqbill.getApplyEmpNum());
        passengerNameOb1.put("Name", (Object)reqbill.getApplyEmpName());
        passengerNumOb1.put("EID", (Object)reqbill.getApplyEmpNum());
        passengerSet.add(passengerOb1);
        passengerNameSet.add(passengerNameOb1);
        if (!reqbill.getApplyEmpNum().equals(reqbill.getCreatEmpNum())) {
            JSONObject passengerOb2 = new JSONObject();
            JSONObject passengerNumOb2 = new JSONObject();
            JSONObject passengerNameOb2 = new JSONObject();
            passengerOb2.put("Name", (Object)reqbill.getCreatEmpName());
            passengerOb2.put("EID", (Object)reqbill.getCreatEmpNum());
            passengerNameOb2.put("Name", (Object)reqbill.getCreatEmpName());
            passengerNumOb2.put("EID", (Object)reqbill.getCreatEmpNum());
            passengerSet.add(passengerOb2);
            passengerNameSet.add(passengerNameOb2);
            employeeID = employeeID + "," + reqbill.getCreatEmpNum();
        }
        HashSet<Long> admindivisionIDs = new HashSet<Long>(1);
        admindivisionIDs.add(reqbill.getVehiclecity());
        List<Set<String>> citylist = TripCityUtil.getCityCodeAndIds(admindivisionIDs);
        Set<String> cityIds = citylist.get(1);
        String cityIdsStr = StringUtils.join((Object[])cityIds.toArray(), (String)",");
        Map<String, Object> tripControlSettingMap = new HashMap<String, Object>();
        tripControlSettingMap = this.getTripSetting(tripControlSettingMap, reqbill.getCompanyId());
        DynamicObject tripCtrlObject = (DynamicObject)tripControlSettingMap.get("tripCtrlObject");
        JSONObject CarQuickEndorsementDetail = new JSONObject();
        CarQuickEndorsementDetail.put("ProductType", (Object)"10");
        CarQuickEndorsementDetail.put("Cities", (Object)cityIdsStr);
        CarQuickEndorsementDetail.put("ArrivalCities", (Object)cityIdsStr);
        CarQuickEndorsementDetail.put("BeginUseDate", (Object)TripCommonUtil.date2TimeStamp(reqbill.getStartdate(), "yyyy-MM-dd"));
        CarQuickEndorsementDetail.put("EndUseDate", (Object)TripCommonUtil.date2TimeStamp(reqbill.getEnddate(), "yyyy-MM-dd"));
        CarQuickEndorsementDetail.put("EffectivenessAmount", (Object)reqbill.getVehiclenumber());
        if (tripCtrlObject != null) {
            Integer carSkipFields = (Integer)tripControlSettingMap.get("carSkipFields");
            String carPeopleCtr = tripCtrlObject.getString("cartrippeoplectrl");
            if (StringUtils.isNotEmpty((String)carPeopleCtr) && "1".equals(carPeopleCtr)) {
                CarQuickEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerSet).toString()));
            } else if (StringUtils.isNotEmpty((String)carPeopleCtr) && "0".equals(carPeopleCtr)) {
                CarQuickEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerNameSet).toString()));
            } else if (StringUtils.isNotEmpty((String)carPeopleCtr) && "2".equals(carPeopleCtr)) {
                CarQuickEndorsementDetail.put("PassengerList", JSONArray.parse((String)((Object)passengerNameSet).toString()));
                carSkipFields = carSkipFields + 1;
            }
            CarQuickEndorsementDetail.put("SkipFields", (Object)carSkipFields);
        } else {
            CarQuickEndorsementDetail.put("SkipFields", (Object)2046);
        }
        CarQuickEndorsementDetails.add((Object)CarQuickEndorsementDetail);
        JSONObject extendField = new JSONObject();
        extendField.put("FieldName", (Object)"CostCenter1");
        extendField.put("FieldValue", (Object)reqbill.getCostCompany());
        extendField.put("FieldType", (Object)"String");
        JSONArray extendFieldList = new JSONArray();
        extendFieldList.add((Object)extendField);
        try {
            JSONObject auth = CorpSync.getAuthentification();
            bodyDataJson.put("Auth", (Object)auth);
        }
        catch (KDBizException e) {
            this.tripSyncLogParam.setRequesturl("https://ct.ctrip.com/SwitchAPI/Order/Ticket");
            this.tripSyncLogParam.setStatus("B");
            throw new KDBizException(new ErrorCode("doPost", String.format(ResManager.loadKDString((String)"\u6267\u884c\u8bf7\u6c42\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\u3002%s", (String)"CTripDailyVehicleBillInvoke_0", (String)"fi-er-business", (Object[])new Object[0]), new Object[]{e})), new Object[0]);
        }
        bodyDataJson.put("EmployeeID", (Object)employeeID);
        bodyDataJson.put("ApprovalNumber", (Object)reqbill.getBillNo());
        bodyDataJson.put("Status", (Object)1);
        bodyDataJson.put("CarQuickEndorsementDetails", (Object)CarQuickEndorsementDetails);
        bodyDataJson.put("ExtendFieldList", (Object)extendFieldList);
        return bodyDataJson;
    }

    private Map<String, Object> getTripSetting(Map<String, Object> tripControlSettingMap, Long orgId) {
        DynamicObject tripCtrlObject;
        if (orgId != null && (tripCtrlObject = TripCommonUtil.getTripControlSettings(orgId, this.supplier())) != null) {
            String cardatectrl;
            String hotelcityctrl;
            String hoteldatectrl;
            String cityctrl;
            logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u7528\u8f66\u7533\u8bf7\u5355,tripCtrlObject != null");
            int flightSkipFields = 64991;
            int hotelSkipFields = 16367;
            int carSkipFields = 2046;
            flightSkipFields -= 8;
            String datectrl = tripCtrlObject.getString("domairdatectrl");
            if (!"0".equals(datectrl)) {
                flightSkipFields = flightSkipFields - 2 - 4 - 128 - 256;
            }
            if (!"0".equals(cityctrl = tripCtrlObject.getString("domaircityctrl"))) {
                flightSkipFields = flightSkipFields - 16 - 1024;
            }
            if (!"0".equals(hoteldatectrl = tripCtrlObject.getString("hoteldatectrl"))) {
                hotelSkipFields = hotelSkipFields - 1 - 2 - 4 - 8;
            }
            if (!"0".equals(hotelcityctrl = tripCtrlObject.getString("hotelcityctrl"))) {
                hotelSkipFields -= 32;
            }
            hotelSkipFields -= 4096;
            hotelSkipFields -= 512;
            hotelSkipFields -= 1024;
            String carcityctrl = tripCtrlObject.getString("carcityctrl");
            if (!"0".equals(carcityctrl)) {
                carSkipFields -= 2;
            }
            if (!"0".equals(cardatectrl = tripCtrlObject.getString("cardatectrl"))) {
                carSkipFields = carSkipFields - 8 - 16;
            }
            tripControlSettingMap.put("orgId", orgId);
            tripControlSettingMap.put("tripCtrlObject", tripCtrlObject);
            tripControlSettingMap.put("flightSkipFields", flightSkipFields);
            tripControlSettingMap.put("hotelSkipFields", hotelSkipFields);
            tripControlSettingMap.put("carSkipFields", carSkipFields);
        }
        return tripControlSettingMap;
    }

    private JSONObject convertCloseBill(Object value) {
        JSONObject jsonObject = this.convertPushBill(value);
        jsonObject.put("Status", (Object)"0");
        return jsonObject;
    }
}

