/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.servicehelper.invoice.Brief;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.service.function.AbstractInvoiceSendInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.utils.ErCommonUtils;

public class CTripInvoiceSendInvoke
extends AbstractInvoiceSendInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(CTripInvoiceSendInvoke.class);
    private static final String CTRIPINVOICESENDINVOKE = "CTripInvoiceSendInvoke";
    private Map<String, String> successMap = new HashMap<String, String>();
    private Map<String, String> errorMap = new HashMap<String, String>();

    public CTripInvoiceSendInvoke() {
    }

    public CTripInvoiceSendInvoke(DynamicObject[] invoices) {
        super(invoices);
    }

    @Override
    protected String supplier() {
        return Supplier.XIECHENG.getValue();
    }

    @Override
    protected Object getInnerData() {
        return this.pk;
    }

    protected JSONObject convert(Object value) {
        DynamicObject[] invoices = (DynamicObject[])value;
        JSONObject convert = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < invoices.length; ++i) {
            jsonArray.add((Object)this.toJsonObject(invoices[i]));
        }
        convert.put("invoices", (Object)jsonArray);
        return convert;
    }

    private JSONObject toJsonObject(DynamicObject dobj) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", dobj.getPkValue());
        jsonObject.put("batchno", dobj.get("batchno"));
        jsonObject.put("operationtype", dobj.get("operationtype"));
        jsonObject.put("accountid", dobj.get("accountid"));
        jsonObject.put("expcommitcomnum", (Object)dobj.getDynamicObject("expcommitcomnum").getString("name"));
        jsonObject.put("invoiceamount", dobj.get("settleamountwithtax"));
        jsonObject.put("invoiceheadnametype", dobj.get("invoiceheadnametype"));
        jsonObject.put("invoicetype", dobj.get("invoicetype"));
        this.handleInvoiceSendExtDataConvert(dobj, jsonObject);
        return jsonObject;
    }

    protected String batPushProcess(Object invoiceOrderDatas) {
        return this.process(invoiceOrderDatas);
    }

    private String process(Object invoiceOrderDatas) {
        DynamicObject invoiceOrder;
        ErCommonUtils.removeKeyFromAppCache(CTRIPINVOICESENDINVOKE + RequestContext.get().getTenantId());
        JSONObject jsonObject = (JSONObject)invoiceOrderDatas;
        JSONArray invoices = jsonObject.getJSONArray("invoices");
        List<String> accountIdSet = invoices.stream().map(v -> ((JSONObject)v).getString("accountid")).collect(Collectors.toList());
        Map<String, String> invoiceHeadMap = this.queryInvoiceHeadInfo(accountIdSet);
        Map<String, List<Object>> accountMap = invoices.stream().collect(Collectors.groupingBy(v -> ((JSONObject)v).getString("accountid")));
        Set<Map.Entry<String, List<Object>>> accountEntrySet = accountMap.entrySet();
        for (Map.Entry<String, List<Object>> accountEntry : accountEntrySet) {
            String accountId = accountEntry.getKey();
            List<Object> settlementBatchNoList = accountEntry.getValue();
            Map<String, List<Object>> batchNoMap = settlementBatchNoList.stream().collect(Collectors.groupingBy(v -> ((JSONObject)v).getString("batchno")));
            for (Map.Entry<String, List<Object>> batchNoMapEntry : batchNoMap.entrySet()) {
                String settlementBatchNo = batchNoMapEntry.getKey();
                List<Object> orderList = batchNoMapEntry.getValue();
                JSONObject jSONObject = this.getInvoiceDetailMoney(settlementBatchNo, accountId);
                Map<String, Object> balanceMap = this.dataProcess(jSONObject);
                for (Object orderObj : orderList) {
                    JSONObject invoiceOrder2 = (JSONObject)orderObj;
                    this.submitInvoiceRequest(invoiceHeadMap, balanceMap, invoiceOrder2);
                }
            }
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u53d1\u7968\u5f00\u5177,successMap" + JSONObject.toJSONString(this.successMap));
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u53d1\u7968\u5f00\u5177,errorMap" + JSONObject.toJSONString(this.errorMap));
        Set<String> success = this.successMap.keySet();
        Set<String> error = this.errorMap.keySet();
        String code = "200";
        HashSet<String> invoiceOrderIds = new HashSet<String>();
        if (success.size() > 0) {
            invoiceOrderIds.addAll(success);
        }
        if (error.size() > 0) {
            code = "300";
            invoiceOrderIds.addAll(error);
        }
        if (invoiceOrderIds.size() < 1) {
            return code;
        }
        DynamicObject[] invoiceOrders = BusinessDataServiceHelper.load((String)"er_invoiceorderbill", (String)"invoicestatus, invoicestatustime", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceOrderIds.stream().map(e -> Long.parseLong(e)).collect(Collectors.toList()))});
        Map<String, DynamicObject> invoiceOrderMap = Arrays.stream(invoiceOrders).collect(Collectors.toMap(v -> v.getString("id"), v -> v));
        if (invoiceOrderMap == null || invoiceOrderMap.size() < 1) {
            return code;
        }
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(success.size());
        Date currentDate = new Date();
        for (String string : success) {
            invoiceOrder = invoiceOrderMap.get(string);
            invoiceOrder.set("invoicestatus", (Object)"2");
            invoiceOrder.set("invoicestatustime", (Object)currentDate);
            resultList.add(invoiceOrder);
        }
        for (Map.Entry entry : this.errorMap.entrySet()) {
            invoiceOrder = invoiceOrderMap.get(entry.getKey());
            invoiceOrder.set("invoicestatus", entry.getValue());
            invoiceOrder.set("invoicestatustime", (Object)currentDate);
            resultList.add(invoiceOrder);
        }
        this.successMap.clear();
        this.errorMap.clear();
        SaveServiceHelper.save((DynamicObject[])resultList.toArray(new DynamicObject[resultList.size()]));
        return code;
    }

    private Map<String, String> queryInvoiceHeadInfo(List<String> accountIdSet) {
        HashMap<String, String> ret = new HashMap<String, String>();
        DynamicObject[] accountInfosFromDB = BusinessDataServiceHelper.load((String)"er_invoicehead_rel", (String)"accountid,corpcompany,invocieheadid", (QFilter[])new QFilter[]{new QFilter("accountid", "in", accountIdSet)});
        List existAccount = Stream.of(accountInfosFromDB).map(v -> v.getString("accountid")).collect(Collectors.toList());
        accountIdSet.removeAll(existAccount);
        ArrayList accountInfosFromHttp = new ArrayList();
        if (accountIdSet.size() > 0) {
            accountIdSet.forEach(accountID -> {
                JSONObject invoiceHeadDetail = this.getInvoiceHeadDetail((String)accountID);
                accountInfosFromHttp.addAll(this.convertToDynamicObject((String)accountID, invoiceHeadDetail));
            });
        }
        if (accountInfosFromHttp.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])accountInfosFromHttp.toArray(new DynamicObject[0]));
        }
        accountInfosFromHttp.stream().forEach(v -> ret.put(v.getString("corpcompany"), v.getString("invocieheadid")));
        Stream.of(accountInfosFromDB).forEach(v -> ret.put(v.getString("corpcompany"), v.getString("invocieheadid")));
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u53d1\u7968\u5f00\u5177,\u67e5\u8be2\u5230\u7684\u516c\u53f8\u5bf9\u5e94\u7684\u62ac\u5934\u4fe1\u606f\u4e3a:" + SerializationUtils.toJsonString(ret));
        return ret;
    }

    private JSONObject getInvoiceHeadDetail(String accountID) {
        JSONObject auth = CorpSync.getCacheAuthentification(CTRIPINVOICESENDINVOKE);
        JSONObject paramJson = new JSONObject();
        paramJson.put("Auth", (Object)auth);
        paramJson.put("AccountID", (Object)accountID);
        String jsonStr = paramJson.toJSONString();
        JSONObject retJson = HttpRetryServiceHelper.doPost("https://ct.ctrip.com/SwitchApi/CorpSettlement/GetInvoiceHeadDetail", jsonStr, JSONObject.class);
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u53d1\u7968\u5f00\u5177,\u6839\u636e\u4e3b\u8d26\u6237id,\u67e5\u8be2\u53d1\u7968\u62ac\u5934,\u8fd4\u56de\u7ed3\u679c\u4e3a:%s", JSON.toJSONString((Object)retJson)));
        return retJson;
    }

    private List<DynamicObject> convertToDynamicObject(String acountID, JSONObject invoiceHeadDetail) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (0 == invoiceHeadDetail.getJSONObject("Status").getInteger("ErrorCode")) {
            JSONArray headList = invoiceHeadDetail.getJSONArray("InvoiceHeadList");
            for (int i = 0; i < headList.size(); ++i) {
                JSONObject json = headList.getJSONObject(i);
                DynamicObject dobj = BusinessDataServiceHelper.newDynamicObject((String)"er_invoicehead_rel");
                dobj.set("invocieheadid", json.get((Object)"InvoiceHeadID"));
                dobj.set("corpcompany", json.get((Object)"CorpName"));
                dobj.set("accountid", (Object)acountID);
                list.add(dobj);
            }
        }
        return list;
    }

    private JSONObject getInvoiceDetailMoney(String settlementBatchNo, String accountID) {
        JSONObject auth = CorpSync.getCacheAuthentification(CTRIPINVOICESENDINVOKE);
        JSONObject paramJson = new JSONObject();
        paramJson.put("Auth", (Object)auth);
        paramJson.put("SettlementBatchNo", (Object)settlementBatchNo);
        paramJson.put("AccountID", (Object)accountID);
        String jsonStr = paramJson.toJSONString();
        JSONObject retJson = HttpRetryServiceHelper.doPost("https://ct.ctrip.com/SwitchApi/CorpSettlement/GetInvoiceDetailMoney", jsonStr, JSONObject.class);
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u53d1\u7968\u5f00\u5177,\u67e5\u8be2\u53ef\u5f00\u7968\u91d1\u989d,\u8fd4\u56de\u7ed3\u679c:%s", JSON.toJSONString((Object)retJson)));
        return retJson;
    }

    private Map<String, Object> dataProcess(JSONObject invoiceDetailMoney) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (invoiceDetailMoney.getJSONObject("Status").getIntValue("ErrorCode") == 0) {
            JSONObject detail = invoiceDetailMoney.getJSONObject("InvoiceDetailMoney");
            BigDecimal ordinaryCanMoney = detail.getBigDecimal("OrdinaryInvoiceCanMoney");
            BigDecimal valueAddedCanMoney = detail.getBigDecimal("ValueAddedInvoiceCanMoney");
            JSONArray invoiceItemList = detail.getJSONArray("InvoiceItemList");
            HashMap<String, BigDecimal> invoiceItemMap = new HashMap<String, BigDecimal>();
            if (invoiceItemList != null) {
                Iterator iterator = invoiceItemList.iterator();
                while (iterator.hasNext()) {
                    JSONObject next = JSON.parseObject((String)JSON.toJSONString(iterator.next()));
                    String invoiceItemNameType = Brief.getValueByInvoiceNameAndBriefName(next.getString("InvoiceItemType"), next.getString("InvoiceItemName"));
                    invoiceItemMap.put(invoiceItemNameType, next.getBigDecimal("InvoiceItemCanMoney"));
                }
            }
            ret.put("ordinaryCanMoney", ordinaryCanMoney);
            ret.put("valueAddedCanMoney", valueAddedCanMoney);
            ret.put("invoiceItemMap", invoiceItemMap);
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u53d1\u7968\u5f00\u5177,dataProcess.ret=" + ret);
        return ret;
    }

    private void submitInvoiceRequest(Map<String, String> invoiceHeadMap, Map<String, Object> balanceMap, JSONObject invoice) {
        BigDecimal invoiceAmount = invoice.getBigDecimal("invoiceamount");
        String invoiceHeadNameType = invoice.getString("invoiceheadnametype");
        String settlementBatchNo = invoice.getString("batchno");
        String custInvSequence = invoice.getString("id");
        TripSyncLogParam currentLog = this.tripSyncLogParam.clone();
        currentLog.setBillid(custInvSequence);
        currentLog.setBillno(settlementBatchNo);
        if (this.checkAmount(invoiceAmount, invoiceHeadNameType, balanceMap)) {
            Integer invoiceItemNameType;
            Integer invoiceType;
            String corpcompany;
            String invoiceHeadID;
            String accountID = invoice.getString("accountid");
            JSONObject retJson = this.submitInvoiceRequest(custInvSequence, settlementBatchNo, accountID, invoiceHeadID = invoiceHeadMap.get(corpcompany = invoice.getString("expcommitcomnum")), invoiceType = Integer.valueOf(invoice.getString("invoicetype")), invoiceItemNameType = Integer.valueOf(invoice.getString("invoiceheadnametype")), invoiceAmount, currentLog);
            if ("0".equals(retJson.getJSONObject("Status").getString("ErrorCode"))) {
                this.successMap.put(invoice.getString("id"), retJson.getInteger("InvoiceId").toString());
            } else {
                currentLog.setStatus("B");
                currentLog.setMessage(retJson.getJSONObject("Status").getString("Message"));
                this.errorMap.put(invoice.getString("id"), "5");
            }
        } else {
            currentLog.setStatus("B");
            currentLog.setRequestdata(balanceMap);
            currentLog.setMessage(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u53ef\u5f00\u7968\u91d1\u989d\u4e0d\u8db3\uff0c\u5f00\u7968\u7533\u8bf7\u91d1\u989d\uff1a%1$s\uff0c\u5f00\u7968\u7533\u8bf7\u53d1\u7968\u6458\u8981\uff1a%2$s\u3002", (String)"CTripInvoiceSendInvoke_2", (String)"fi-er-business", (Object[])new Object[0]), invoiceAmount, invoiceHeadNameType));
            logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u53d1\u7968\u5f00\u5177,\u5f00\u7968\u7533\u8bf7\u5355id[%s]\u53ef\u5f00\u91d1\u989d\u4e0d\u8db3", invoice.get((Object)"id")));
            this.errorMap.put(invoice.getString("id"), "6");
        }
        this.tripSyncLogParamList.add(currentLog);
    }

    private boolean checkAmount(BigDecimal invoiceAmount, String invoiceHeadNameType, Map<String, Object> balanceMap) {
        Object obj = balanceMap.get("invoiceItemMap");
        if (obj != null) {
            Map invoiceItemMap = (Map)obj;
            BigDecimal invoiceItemCanMoney = invoiceItemMap.getOrDefault(invoiceHeadNameType, BigDecimal.ZERO);
            logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u53d1\u7968\u5f00\u5177,\u6821\u9a8c\u672c\u6b21\u5f00\u7968\u91d1\u989d\u4e0e\u53ef\u5f00\u7968\u91d1\u989d,invoiceHeadNameType=[%s],invoiceAmount=[%s],invoiceItemCanMoney=[%s]", invoiceHeadNameType, invoiceAmount, invoiceItemCanMoney));
            if (invoiceAmount.compareTo(invoiceItemCanMoney) <= 0) {
                invoiceItemMap.put(invoiceHeadNameType, invoiceItemCanMoney.subtract(invoiceAmount));
                return true;
            }
        }
        return false;
    }

    private JSONObject submitInvoiceRequest(String custInvSequence, String settlementBatchNo, String accountID, String invoiceHeadID, Integer invoiceType, Integer invoiceItemNameType, BigDecimal invoiceMoney, TripSyncLogParam tripSyncLogParam) {
        JSONObject auth = CorpSync.getCacheAuthentification(CTRIPINVOICESENDINVOKE);
        JSONObject paramJson = new JSONObject();
        paramJson.put("Auth", (Object)auth);
        paramJson.put("SettlementBatchNo", (Object)settlementBatchNo);
        paramJson.put("AccountID", (Object)accountID);
        paramJson.put("InvoiceHeadId", (Object)invoiceHeadID);
        paramJson.put("InvoiceType", (Object)invoiceType);
        paramJson.put("InvoiceItemNameType", (Object)invoiceItemNameType);
        paramJson.put("InvoiceMoney", (Object)invoiceMoney);
        paramJson.put("CustInvSequence", (Object)custInvSequence);
        String jsonStr = paramJson.toJSONString();
        tripSyncLogParam.setRequestdata(jsonStr);
        tripSyncLogParam.setRequesturl("https://ct.ctrip.com/SwitchApi/CorpSettlement/SubmitInvoice");
        JSONObject retJson = HttpRetryServiceHelper.doPost("https://ct.ctrip.com/SwitchApi/CorpSettlement/SubmitInvoice", jsonStr, JSONObject.class);
        tripSyncLogParam.setResponsedata(retJson);
        logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u53d1\u7968\u5f00\u5177,\u5f00\u7968\u7533\u8bf7,\u8fd4\u56de\u7ed3\u679c:%s", JSON.toJSONString((Object)retJson)));
        return retJson;
    }
}

