/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.HotelOrderModel;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.model.TrainOrderModel;
import kd.fi.er.business.trip.model.VehicleOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.invoke.CTripOrderInvoke;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.CTripPlaneOrderConvert;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CTripPropMapping;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TTripPropMapping;
import kd.fi.er.business.trip.util.CTripHotelUtil;
import kd.fi.er.business.trip.util.TripClassUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import org.apache.commons.lang.StringUtils;

public class CTripOrderUpdateInvoke
extends CTripOrderInvoke {
    private static final Log logger = LogFactory.getLog(CTripOrderUpdateInvoke.class);

    @Override
    protected JSONObject process(Map params) throws TripException {
        String data = (String)params.get("jsondata");
        if (data != null) {
            return JSONObject.parseObject((String)data);
        }
        JSONObject dataJsonObject = this.getOrderUpdateDatas(params);
        return dataJsonObject;
    }

    private JSONObject getOrderUpdateDatas(Map<String, String> params) {
        JSONObject statusJson;
        Boolean sucess;
        String businessType = params.get("businessType");
        JSONObject postJson = new JSONObject();
        String dayCountSign = "";
        String url = "";
        int scope_settlement_data = TripSyncConfigUtil.getIntValue("scope_settlement_data", 0, Arrays.asList(0, 1));
        switch (businessType) {
            case "PLANE": {
                dayCountSign = "ctrip_getPlaneOrderT2_daycount";
                url = "https://ct.ctrip.com/switchapi/FlightOrderSettlement/GetCorpAccountFlightOrderSettlements?type=jso";
                if (scope_settlement_data == 0) {
                    postJson.put("PayType", (Object)"Y");
                    break;
                }
                postJson.put("PayType", (Object)"ALL");
                break;
            }
            case "TRAIN": {
                dayCountSign = "ctrip_getTrainOrderT2_daycount";
                url = "https://ct.ctrip.com/switchapi/SettlementTrainOrder/SearchSettlementTrainOrderDetail";
                if (scope_settlement_data != 0) break;
                postJson.put("SettlementType", (Object)"M");
                break;
            }
            case "CAR": {
                dayCountSign = "ctrip_getCarOrderT2_daycount";
                url = "https://ct.ctrip.com/switchapi/CarOrderSettlement/SearchSettlementCarOrderDetail";
                if (scope_settlement_data != 0) break;
                postJson.put("SelType", (Object)"M");
                break;
            }
            case "HOTEL": {
                dayCountSign = "ctrip_getHotelOrderT2_daycount";
                url = "https://ct.ctrip.com/switchapi/SettlementHltOrder/SearchSettlementHltOrderDetail";
                if (scope_settlement_data != 0) break;
                postJson.put("PayType", (Object)"Y");
            }
        }
        if (null != params.get("ordernum")) {
            postJson.put("OrderID", (Object)params.get("ordernum"));
            this.tripSyncLogParam.setBillid(params.get("ordernum"));
            this.tripSyncLogParam.setBillno(params.get("ordernum"));
        }
        if (null != params.get("checkingbillnum") && !params.get("checkingbillnum").isEmpty()) {
            String billId = String.valueOf(params.get("checkingbillnum"));
            postJson.put("BatchNo", (Object)params.get("checkingbillnum"));
            this.tripSyncLogParam.setBillid(billId);
            this.tripSyncLogParam.setBillno(billId);
        }
        String dateFromStr = "";
        String dateToStr = "";
        if (null != params.get("beginDate") && null != params.get("endDate")) {
            dateFromStr = TripCommonUtil.date2TimeStamp(TripCommonUtil.strToDate(String.valueOf(params.get("beginDate")), "EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), "yyyy-MM-dd");
            dateToStr = TripCommonUtil.date2TimeStamp(TripCommonUtil.strToDate(String.valueOf(params.get("endDate")), "EEE MMM dd HH:mm:ss zzz yyyy", Locale.US), "yyyy-MM-dd");
            postJson.put("DateFrom", (Object)dateFromStr);
            postJson.put("DateTo", (Object)dateToStr);
        } else if (null == params.get("ordernum")) {
            int dayCount = TripSyncConfigUtil.getIntValue(dayCountSign, 2);
            Calendar cal = Calendar.getInstance();
            Date dateTo = cal.getTime();
            cal.add(5, -dayCount);
            Date dateFrom = cal.getTime();
            dateFromStr = TripCommonUtil.date2TimeStamp(dateFrom, "yyyy-MM-dd");
            dateToStr = TripCommonUtil.date2TimeStamp(dateTo, "yyyy-MM-dd");
        }
        postJson.put("Auth", (Object)CorpSync.getAuthentification());
        postJson.put("DateFrom", (Object)dateFromStr);
        postJson.put("DateTo", (Object)dateToStr);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("businessType", businessType);
        this.handleQueryParamsExt(url, postJson, map);
        this.tripSyncLogParam.setRequesturl(url);
        this.tripSyncLogParam.setRequestdata(postJson);
        String result = HttpRetryServiceHelper.PostData(url, postJson.toJSONString());
        this.tripSyncLogParam.setResponsedata(result);
        JSONObject backJson = JSONObject.parseObject((String)result);
        if (backJson != null && (sucess = (statusJson = (statusJson = backJson.getJSONObject("Status")) == null ? new JSONObject() : statusJson).getBoolean("Success")).booleanValue()) {
            return backJson;
        }
        this.tripSyncLogParam.setStatus("B");
        return null;
    }

    @Override
    protected Object convert(Object value) throws TripException {
        if (value == null) {
            return new ArrayList();
        }
        JSONObject orderBillUpdateJson = (JSONObject)value;
        List<Object> orderModels = new ArrayList();
        try {
            JSONArray planeSettlementArray = orderBillUpdateJson.getJSONArray("FlightOrderAccountSettlementList");
            planeSettlementArray = planeSettlementArray == null ? new JSONArray() : planeSettlementArray;
            JSONArray trainSettlementArray = orderBillUpdateJson.getJSONArray("LstTrainSettlement");
            trainSettlementArray = trainSettlementArray == null ? new JSONArray() : trainSettlementArray;
            JSONArray hotelSettlementArray = orderBillUpdateJson.getJSONArray("LstHtlSettlement");
            hotelSettlementArray = hotelSettlementArray == null ? new JSONArray() : hotelSettlementArray;
            JSONArray carSettlementArray = orderBillUpdateJson.getJSONArray("CarOrderAccountSettlementList");
            JSONArray jSONArray = carSettlementArray = carSettlementArray == null ? new JSONArray() : carSettlementArray;
            if (planeSettlementArray != null && !planeSettlementArray.isEmpty()) {
                orderModels = this.planeOrderUpdateConvert(planeSettlementArray);
            }
            if (trainSettlementArray != null && !trainSettlementArray.isEmpty()) {
                orderModels = this.trainOrderUpdateConvert(trainSettlementArray);
            }
            if (hotelSettlementArray != null && !hotelSettlementArray.isEmpty()) {
                orderModels = this.hotelOrderUpdateConvert(hotelSettlementArray);
            }
            if (carSettlementArray != null && !carSettlementArray.isEmpty()) {
                orderModels = this.carOrderUpdateConvert(carSettlementArray);
            }
            Set orderNumSet = orderModels.stream().map(AbstractOrderModel::getOrderNum).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            if (this.params != null && CollectionUtils.isNotEmpty(orderNumSet)) {
                this.params.put("orderNums", orderNumSet);
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u8ba2\u5355,\u8865\u5145\u6570\u636e\u5931\u8d25:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u643a\u7a0b\u8ba2\u5355\u6570\u636e\u66f4\u65b0\u5931\u8d25\u3002", (String)"CTripOrderUpdateInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
        }
        return orderModels;
    }

    private List<VehicleOrderModel> carOrderUpdateConvert(JSONArray carSettlementArray) {
        List<VehicleOrderModel> orderModels = new ArrayList<VehicleOrderModel>(carSettlementArray.size());
        for (int i = 0; i < carSettlementArray.size(); ++i) {
            JSONObject carSettlementObject = carSettlementArray.getJSONObject(i);
            JSONArray carSettlementDetails = carSettlementObject.getJSONArray("CarSettlementDetailList");
            carSettlementDetails = carSettlementDetails == null ? new JSONArray() : carSettlementDetails;
            for (int j = 0; j < carSettlementDetails.size(); ++j) {
                BigDecimal personAmount;
                JSONObject carSettlementDetail = carSettlementDetails.getJSONObject(j);
                JSONObject settlementBaseInfo = carSettlementDetail.getJSONObject("SettlementBaseInfo");
                settlementBaseInfo = settlementBaseInfo == null ? new JSONObject() : settlementBaseInfo;
                int ProductType2 = settlementBaseInfo.getIntValue("ProductType");
                if (ProductType2 != 4) {
                    return orderModels;
                }
                VehicleOrderModel vehicleOrderModel = new VehicleOrderModel();
                vehicleOrderModel.setChecking(Boolean.TRUE);
                JSONObject orderDetail = carSettlementDetail.getJSONObject("OrderDetail");
                orderDetail = orderDetail == null ? new JSONObject() : orderDetail;
                JSONObject carOrderBaseInfo = orderDetail.getJSONObject("OrderBaseInfo");
                carOrderBaseInfo = carOrderBaseInfo == null ? new JSONObject() : carOrderBaseInfo;
                JSONObject carOrderCorpInfo = orderDetail.getJSONObject("CorpInfo");
                carOrderCorpInfo = carOrderCorpInfo == null ? new JSONObject() : carOrderCorpInfo;
                JSONObject carOrderQuickProductInfo = orderDetail.getJSONObject("QuickProductInfo");
                carOrderQuickProductInfo = carOrderQuickProductInfo == null ? new JSONObject() : carOrderQuickProductInfo;
                vehicleOrderModel.setServer(Supplier.XIECHENG.name());
                vehicleOrderModel.setOaBillNum(carOrderBaseInfo.getOrDefault((Object)"CorpTravelEndorsementId", (Object)"").toString());
                vehicleOrderModel.setOperationType(AbstractOrderModel.OperationType.C);
                vehicleOrderModel.setOrderStatus(ConvertUtil.getEnum(carOrderBaseInfo.getOrDefault((Object)"OrderStatus", (Object)"").toString(), VehicleOrderModel.OrderStatus.class));
                String createTimeStr = settlementBaseInfo.getOrDefault((Object)"CreateTime", (Object)"").toString();
                Date createTime = TripCommonUtil.strToDate(createTimeStr, "yyyy-MM-dd HH:mm:ss");
                String orderDateStr = carOrderBaseInfo.getOrDefault((Object)"OrderDate", (Object)"").toString();
                Date orderDate = TripCommonUtil.strToDate(orderDateStr, "yyyy-MM-dd HH:mm:ss");
                vehicleOrderModel.setOaBillNum(carOrderCorpInfo.getOrDefault((Object)"JouneryId", (Object)"").toString());
                vehicleOrderModel.setHappendDate(createTime);
                vehicleOrderModel.setOrderDate(orderDate);
                vehicleOrderModel.setOrderNatrue(AbstractOrderModel.OrderNatrue.A);
                vehicleOrderModel.setOrderSort(AbstractOrderModel.OrderSort.A);
                vehicleOrderModel.setOrderNum(carOrderBaseInfo.getOrDefault((Object)"OrderID", (Object)"").toString());
                vehicleOrderModel.setParentOrderNum(carOrderBaseInfo.getOrDefault((Object)"OrderID", (Object)"").toString());
                vehicleOrderModel.setOrderType(AbstractOrderModel.OrderType.O);
                vehicleOrderModel.setProductType(AbstractOrderModel.ProductType.A);
                vehicleOrderModel.setSourceBookedId(carOrderBaseInfo.getOrDefault((Object)"PreEmployeeID", (Object)"").toString());
                vehicleOrderModel.setBookedname(carOrderBaseInfo.getOrDefault((Object)"UserName", (Object)"").toString());
                vehicleOrderModel.setCityName(carOrderQuickProductInfo.getOrDefault((Object)"DepartureCityName", (Object)"").toString());
                vehicleOrderModel.setDepartAddress(carOrderQuickProductInfo.getOrDefault((Object)"DepartureAddressDetail", (Object)"").toString());
                vehicleOrderModel.setArriveAddress(carOrderQuickProductInfo.getOrDefault((Object)"ArrivalAddressDetail", (Object)"").toString());
                String useTimeStr = carOrderQuickProductInfo.getOrDefault((Object)"UseTime", (Object)"").toString();
                Date useTime = TripCommonUtil.strToDate(useTimeStr, "yyyy-MM-dd HH:mm:ss.SSS");
                vehicleOrderModel.setUseTime(useTime);
                vehicleOrderModel.setProductType(CTripOrderUpdateInvoke.setCarProductType(settlementBaseInfo.getOrDefault((Object)"SelType", (Object)"").toString()));
                vehicleOrderModel.setDistance(carOrderQuickProductInfo.getOrDefault((Object)"NormalDistance", (Object)"").toString());
                BigDecimal amount = TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("RealAmountHasPost"));
                if ("M".equals(settlementBaseInfo.getOrDefault((Object)"SelType", (Object)"").toString())) {
                    vehicleOrderModel.setTotalAmount(amount.setScale(2, 4));
                    vehicleOrderModel.setServiceFee(TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("ServerFee")).add(TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("PostServiceFee"))).add(TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("ExpressFee"))));
                    vehicleOrderModel.setDealAmount(TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("Amount")).add(TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("CarValueAddFee"))).add(TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("CarAddTaxAmount"))).add(TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("PenaltyFee"))).add(TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("ServerFee"))).add(TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("ExpressFee"))).add(TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("PostServiceFee"))).setScale(2, 4));
                    personAmount = TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("PersonAmount"));
                    vehicleOrderModel.setPersonalFee(personAmount.setScale(2, 4));
                    vehicleOrderModel.setServiceFeePaytype("1");
                } else if ("N".equals(settlementBaseInfo.getOrDefault((Object)"SelType", (Object)"").toString())) {
                    personAmount = TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("PostServiceFee"));
                    BigDecimal CarAddTaxAmount = TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("CarAddTaxAmount"));
                    BigDecimal totalAmount = personAmount.add(CarAddTaxAmount);
                    vehicleOrderModel.setTotalAmount(totalAmount.setScale(2, 4));
                    BigDecimal realAmountHasPost = TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("RealAmountHasPost"));
                    vehicleOrderModel.setPersonalFee(realAmountHasPost.subtract(totalAmount).setScale(2, 4));
                    vehicleOrderModel.setServiceFee(TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("PostServiceFee")).setScale(2, 4));
                    vehicleOrderModel.setDealAmount(TripClassUtil.getDefaultBigDecimal(settlementBaseInfo.getBigDecimal("PostServiceFee")).setScale(2, 4));
                    vehicleOrderModel.setProductType(AbstractOrderModel.ProductType.B);
                    vehicleOrderModel.setServiceFeePaytype("1");
                }
                vehicleOrderModel.setVehicleType(ConvertUtil.getEnum(carOrderQuickProductInfo.getOrDefault((Object)"VehicleId", (Object)"1").toString(), VehicleOrderModel.VehicleType.class));
                vehicleOrderModel.setPasseger(carOrderBaseInfo.getOrDefault((Object)"PreEmployeeID", (Object)"").toString());
                vehicleOrderModel.setPassegername(carOrderBaseInfo.getOrDefault((Object)"UserName", (Object)"").toString());
                vehicleOrderModel.setPaymentStatus(ConvertUtil.getEnum(carOrderBaseInfo.getOrDefault((Object)"PaymentStatus", (Object)"").toString(), VehicleOrderModel.PaymentStatus.class));
                orderModels.add(vehicleOrderModel);
            }
        }
        orderModels = this.handleRepeatVehicleTicketNo(orderModels);
        return orderModels;
    }

    private static AbstractOrderModel.ProductType setCarProductType(String productType) {
        if ("M".equals(productType)) {
            return AbstractOrderModel.ProductType.A;
        }
        return AbstractOrderModel.ProductType.B;
    }

    private List<HotelOrderModel> hotelOrderUpdateConvert(JSONArray hotelSettlementArray) throws CloneNotSupportedException {
        List<HotelOrderModel> orderModels = new ArrayList<HotelOrderModel>(hotelSettlementArray.size());
        for (int i = 0; i < hotelSettlementArray.size(); ++i) {
            JSONObject hotelSettlementObjects = hotelSettlementArray.getJSONObject(i);
            JSONArray hotelSettlementDetails = hotelSettlementObjects.getJSONArray("LstHotelSettlementDetail");
            hotelSettlementDetails = hotelSettlementDetails == null ? new JSONArray() : hotelSettlementDetails;
            boolean paramValue = (Boolean)ActionLocalCache.get().get("Split_hotel_settlement", "Split_hotel_settlement", () -> TripSyncConfigUtil.getBoolean("Split_hotel_settlement", Boolean.TRUE));
            if (!paramValue) {
                CTripHotelUtil.handleHotelJson(hotelSettlementDetails);
            }
            block1: for (int j = 0; j < hotelSettlementDetails.size(); ++j) {
                HotelOrderModel orderModel = new HotelOrderModel();
                orderModel.setChecking(Boolean.TRUE);
                JSONObject hotelSettlementDetail = hotelSettlementDetails.getJSONObject(j);
                JSONObject settlementDetailObject = hotelSettlementDetail.getJSONObject("SettlementDetail");
                settlementDetailObject = settlementDetailObject == null ? new JSONObject() : settlementDetailObject;
                JSONObject orderDetailObject = hotelSettlementDetail.getJSONObject("OrderDetail");
                orderDetailObject = orderDetailObject == null ? new JSONObject() : orderDetailObject;
                JSONObject hotelDetailObject = hotelSettlementDetail.getJSONObject("HotelDetail");
                hotelDetailObject = hotelDetailObject == null ? new JSONObject() : hotelDetailObject;
                orderModel.setOrderNum(settlementDetailObject.getOrDefault((Object)"OrderID", (Object)"").toString());
                orderModel.setServer(Supplier.XIECHENG.name());
                BigDecimal amount = TripClassUtil.getDefaultBigDecimal(settlementDetailObject.getBigDecimal("Amount"));
                BigDecimal servicefee = TripClassUtil.getDefaultBigDecimal(settlementDetailObject.getBigDecimal("Servicefee"));
                BigDecimal extraCharge = TripClassUtil.getDefaultBigDecimal(settlementDetailObject.getBigDecimal("ExtraCharge"));
                BigDecimal frontendServiceFee = TripClassUtil.getDefaultBigDecimal(settlementDetailObject.getBigDecimal("FrontendServiceFee"));
                BigDecimal expressFee = TripClassUtil.getDefaultBigDecimal(settlementDetailObject.getBigDecimal("ExpressFee"));
                BigDecimal settlementPersonAmt = TripClassUtil.getDefaultBigDecimal(orderDetailObject.getBigDecimal("SettlementPersonAmt"));
                orderModel.setRoomAmount(amount.subtract(frontendServiceFee).subtract(expressFee).add(settlementPersonAmt).setScale(2, 4));
                if (null != settlementDetailObject && "Y".equals(settlementDetailObject.getOrDefault((Object)"PayType", (Object)"").toString())) {
                    orderModel.setServiceFee(frontendServiceFee.add(servicefee).setScale(2, 4));
                    orderModel.setTotalAmount(amount.add(servicefee).add(extraCharge).setScale(2, 4));
                } else {
                    orderModel.setServiceFee(servicefee.setScale(2, 4));
                    orderModel.setTotalAmount(servicefee.setScale(2, 4));
                }
                orderModel.setPersonalFee(settlementPersonAmt);
                orderModel.setUnbookFee(BigDecimal.ZERO);
                orderModel.setProductType(CTripOrderUpdateInvoke.setProductType(settlementDetailObject.getOrDefault((Object)"PayType", (Object)"").toString()));
                orderModel.setServer(Supplier.XIECHENG.name());
                orderModel.setParentOrderNum(settlementDetailObject.getOrDefault((Object)"OrderID", (Object)"").toString());
                String journeyID = orderDetailObject.getOrDefault((Object)"HotelRelatedJourneyNo", (Object)"").toString();
                orderModel.setOaBillNum(journeyID);
                orderModel.setServer(Supplier.XIECHENG.name());
                Date createTime = TripCommonUtil.strToDate(settlementDetailObject.getOrDefault((Object)"Createtime", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS");
                Date orderDate = TripCommonUtil.strToDate(orderDetailObject.getOrDefault((Object)"OrderDate", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS");
                orderModel.setOrderDate(orderDate);
                orderModel.setHappendDate(orderDate);
                orderModel.setOrderNatrue(AbstractOrderModel.OrderNatrue.A);
                orderModel.setOrderType(AbstractOrderModel.OrderType.O);
                orderModel.setOrderNum(settlementDetailObject.getOrDefault((Object)"OrderID", (Object)"").toString());
                orderModel.setOrderStatus(HotelOrderModel.OrderStatus.G);
                orderModel.setSourceBookedId(orderDetailObject.getOrDefault((Object)"EmployeeID", (Object)"").toString());
                orderModel.setBookedName(orderDetailObject.getOrDefault((Object)"EmployeeName", (Object)"").toString());
                orderModel.setHotelName(hotelDetailObject.getOrDefault((Object)"HotelName", (Object)"").toString());
                if (null != hotelDetailObject.getBoolean("IsDomestic") && hotelDetailObject.getBoolean("IsDomestic").booleanValue()) {
                    orderModel.setOrderSort(AbstractOrderModel.OrderSort.A);
                    orderModel.setOperationType(AbstractOrderModel.OperationType.A);
                } else {
                    orderModel.setOrderSort(AbstractOrderModel.OrderSort.B);
                    orderModel.setOperationType(AbstractOrderModel.OperationType.E);
                }
                orderModel.setCheckinDate(TripCommonUtil.strToDate(orderDetailObject.getOrDefault((Object)"StartTime", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS"));
                orderModel.setCheckoutDate(TripCommonUtil.strToDate(orderDetailObject.getOrDefault((Object)"EndTime", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS"));
                orderModel.setRoomStyleName(orderDetailObject.getOrDefault((Object)"RoomName", (Object)"").toString());
                orderModel.setRoomCount(orderDetailObject.getIntValue("RoomQuantity"));
                orderModel.setCityName(hotelDetailObject.getOrDefault((Object)"CityName", (Object)"").toString());
                JSONArray travelers = orderDetailObject.getJSONArray("ClientDetailList");
                travelers = travelers == null ? new JSONArray() : travelers;
                String clientName = settlementDetailObject.getOrDefault((Object)"ClientName", (Object)"").toString();
                orderModel.setPriceBillingType(CTripHotelUtil.dealInvoiceType(orderDetailObject));
                int size = travelers.size();
                for (int z = 0; z < size; ++z) {
                    BigDecimal personal_down;
                    BigDecimal room_down;
                    BigDecimal service_down;
                    BigDecimal amount_down;
                    boolean breakFlag = false;
                    boolean orginBreak = false;
                    HotelOrderModel hotelTravelersOrderModel = (HotelOrderModel)orderModel.clone();
                    JSONObject traveler = travelers.getJSONObject(z);
                    hotelTravelersOrderModel.setSourceTravelerId(traveler.getOrDefault((Object)"EmployeeID", (Object)"").toString());
                    String tmpClientName = traveler.getOrDefault((Object)"ClientName", (Object)"").toString();
                    hotelTravelersOrderModel.setTravelerName(tmpClientName);
                    if (paramValue) {
                        if (size > 1) {
                            hotelTravelersOrderModel.setOrderNum(hotelTravelersOrderModel.getOrderNum() + "-" + (z + 1));
                            amount_down = orderModel.getTotalAmount().divide(new BigDecimal(size), 2, 1);
                            service_down = orderModel.getServiceFee().divide(new BigDecimal(size), 2, 1);
                            room_down = orderModel.getRoomAmount().divide(new BigDecimal(size), 2, 1);
                            personal_down = orderModel.getPersonalFee().divide(new BigDecimal(size), 2, 1);
                            if (z == 0) {
                                BigDecimal amount_rest = orderModel.getTotalAmount().subtract(amount_down.multiply(new BigDecimal(size - 1)));
                                BigDecimal service_rest = orderModel.getServiceFee().subtract(service_down.multiply(new BigDecimal(size - 1)));
                                BigDecimal room_rest = orderModel.getRoomAmount().subtract(room_down.multiply(new BigDecimal(size - 1)));
                                BigDecimal personal_rest = orderModel.getPersonalFee().subtract(personal_down.multiply(new BigDecimal(size - 1)));
                                hotelTravelersOrderModel.setTotalAmount(amount_rest);
                                hotelTravelersOrderModel.setServiceFee(service_rest);
                                hotelTravelersOrderModel.setRoomAmount(room_rest);
                                hotelTravelersOrderModel.setPersonalFee(personal_rest);
                            } else {
                                hotelTravelersOrderModel.setTotalAmount(amount_down);
                                hotelTravelersOrderModel.setServiceFee(service_down);
                                hotelTravelersOrderModel.setRoomAmount(room_down);
                                hotelTravelersOrderModel.setPersonalFee(personal_down);
                            }
                        }
                    } else if (tmpClientName.equals(clientName)) {
                        breakFlag = true;
                        if (size > 1) {
                            hotelTravelersOrderModel.setOrderNum(hotelTravelersOrderModel.getOrderNum() + "-" + (z + 1));
                        }
                        amount_down = orderModel.getTotalAmount();
                        service_down = orderModel.getServiceFee();
                        room_down = orderModel.getRoomAmount();
                        personal_down = orderModel.getPersonalFee();
                        hotelTravelersOrderModel.setTotalAmount(amount_down);
                        hotelTravelersOrderModel.setServiceFee(service_down);
                        hotelTravelersOrderModel.setRoomAmount(room_down);
                        hotelTravelersOrderModel.setPersonalFee(personal_down);
                        if (StringUtils.isNotBlank((String)traveler.getString("ClientPreApprovalNo"))) {
                            hotelTravelersOrderModel.setOaBillNum(traveler.getString("ClientPreApprovalNo"));
                        }
                        if ("R".equals(settlementDetailObject.getOrDefault((Object)"DetailType", (Object)"").toString())) {
                            orginBreak = true;
                            HotelOrderModel hotelRefundOrderModel = (HotelOrderModel)hotelTravelersOrderModel.clone();
                            hotelRefundOrderModel.setOrderNum(hotelRefundOrderModel.getOrderNum() + "-T1");
                            hotelRefundOrderModel.setOrderStatus(HotelOrderModel.OrderStatus.I);
                            hotelRefundOrderModel.setOrderType(AbstractOrderModel.OrderType.T);
                            orderModels.add(hotelRefundOrderModel);
                        }
                    }
                    if ("R".equals(settlementDetailObject.getOrDefault((Object)"DetailType", (Object)"").toString()) && paramValue) {
                        HotelOrderModel hotelRefundOrderModel = (HotelOrderModel)hotelTravelersOrderModel.clone();
                        hotelRefundOrderModel.setOrderNum(hotelRefundOrderModel.getOrderNum() + "-T1");
                        hotelRefundOrderModel.setOrderStatus(HotelOrderModel.OrderStatus.I);
                        hotelRefundOrderModel.setOrderType(AbstractOrderModel.OrderType.T);
                        orderModels.add(hotelRefundOrderModel);
                    } else {
                        if (!paramValue && breakFlag && !orginBreak) {
                            orderModels.add(hotelTravelersOrderModel);
                        }
                        if (paramValue) {
                            orderModels.add(hotelTravelersOrderModel);
                        }
                    }
                    if (breakFlag) continue block1;
                }
            }
        }
        orderModels = CTripOrderUpdateInvoke.handleRepeatHotelTicketNo(orderModels);
        return orderModels;
    }

    private static AbstractOrderModel.ProductType setProductType(String productType) {
        if ("Y".equals(productType)) {
            return AbstractOrderModel.ProductType.A;
        }
        return AbstractOrderModel.ProductType.B;
    }

    private List<PlaneOrderModel> planeOrderUpdateConvert(JSONArray planesettlementArray) {
        int coupons_tax_deduction = TripSyncConfigUtil.getIntValue("coupons_tax_deduction", 0, Arrays.asList(0, 1));
        List<PlaneOrderModel> orderModels = new ArrayList<PlaneOrderModel>(planesettlementArray.size());
        for (int i = 0; i < planesettlementArray.size(); ++i) {
            JSONObject planeSettlementObjects = planesettlementArray.getJSONObject(i);
            JSONArray planeSettlementDetail = planeSettlementObjects.getJSONArray("OrderSettlementList");
            planeSettlementDetail = planeSettlementDetail == null ? new JSONArray() : planeSettlementDetail;
            for (int j = 0; j < planeSettlementDetail.size(); ++j) {
                PlaneOrderModel planeOrderModel = new PlaneOrderModel();
                planeOrderModel.setChecking(Boolean.TRUE);
                JSONObject OrderSettlementList = planeSettlementDetail.getJSONObject(j);
                JSONObject flightOrderSettlementBaseInfo = OrderSettlementList.getJSONObject("OrderSettlementBaseInfo");
                flightOrderSettlementBaseInfo = flightOrderSettlementBaseInfo == null ? new JSONObject() : flightOrderSettlementBaseInfo;
                JSONObject flightOrderPassenger = OrderSettlementList.getJSONObject("OrderPassengerInfo");
                flightOrderPassenger = flightOrderPassenger == null ? new JSONObject() : flightOrderPassenger;
                JSONObject orderFlightInfo = OrderSettlementList.getJSONObject("OrderFlightInfo");
                orderFlightInfo = orderFlightInfo == null ? new JSONObject() : orderFlightInfo;
                String orderID = flightOrderSettlementBaseInfo.getOrDefault((Object)"OrderID", (Object)"").toString();
                String toCityName = orderFlightInfo.getOrDefault((Object)"ACityName", (Object)"").toString();
                String passengerName = flightOrderPassenger.getOrDefault((Object)"PassengerName", (Object)"").toString();
                String orderDetailType = flightOrderSettlementBaseInfo.getOrDefault((Object)"OrderDetailType", (Object)"").toString();
                String orderNum = CorpSync.splicOrderNumNotype(orderID, passengerName, toCityName) + "-O";
                CTripPlaneOrderConvert.updateConvert(planeOrderModel, OrderSettlementList);
                planeOrderModel.setOrderType(AbstractOrderModel.OrderType.O);
                switch (orderDetailType) {
                    case "\u6539\u7b7e": {
                        planeOrderModel.setOrderType(AbstractOrderModel.OrderType.G);
                        planeOrderModel.setOrderStatus(PlaneOrderModel.OrderStatus.C);
                        break;
                    }
                    case "\u9000\u7968": {
                        planeOrderModel.setOrderType(AbstractOrderModel.OrderType.T);
                        planeOrderModel.setOrderStatus(PlaneOrderModel.OrderStatus.E);
                        planeOrderModel.setOrderType(AbstractOrderModel.OrderType.T);
                        break;
                    }
                    case "\u53d6\u6d88": {
                        planeOrderModel.setOrderType(AbstractOrderModel.OrderType.Q);
                        break;
                    }
                    case "\u8c03\u6574": {
                        planeOrderModel.setOrderType(AbstractOrderModel.OrderType.Z);
                        break;
                    }
                    case "\u51fa\u7968": {
                        planeOrderModel.setOrderType(AbstractOrderModel.OrderType.O);
                        break;
                    }
                    default: {
                        planeOrderModel.setOrderType(AbstractOrderModel.OrderType.O);
                    }
                }
                orderNum = CTripOrderUpdateInvoke.handelOrderNum(orderNum, planeOrderModel.getOrderType().getKey());
                planeOrderModel.setOrderNum(orderNum);
                planeOrderModel.setStandPrice(TripClassUtil.getDefaultBigDecimal(orderFlightInfo.getBigDecimal("StandardPrice")));
                planeOrderModel.setDiscount(TripClassUtil.getDefaultBigDecimal(orderFlightInfo.getBigDecimal("PriceRate")).multiply(new BigDecimal(100)));
                planeOrderModel.setTicketPrice(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("Price")).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PriceDifferential"))));
                planeOrderModel.setAirportPrice(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("Tax")));
                planeOrderModel.setTax(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("Tax")));
                planeOrderModel.setFuelPrice(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("OilFee")));
                planeOrderModel.setRefundAmount(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("Refund")));
                planeOrderModel.setAssuranceAmount(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("InsuranceFee")));
                planeOrderModel.setEndorsementAmount(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("DateChangeFee")));
                planeOrderModel.setServiceFee(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("ServiceFee")).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("RefundServiceFee"))).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("ReBookingServiceFee"))).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("ItineraryFee"))).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("ServicePackagePrice"))).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PostServiceFee"))).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("SendTicketFee"))));
                Integer orderType = flightOrderSettlementBaseInfo.getInteger("OrderType");
                Integer n = orderType = orderType == null ? Integer.valueOf(1) : orderType;
                if (2 == orderType) {
                    BigDecimal postServiceFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PostServiceFee"));
                    planeOrderModel.setTotalAmount(postServiceFee.setScale(2, 4));
                    BigDecimal personalfee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("RealAmountWithPostServiceFee"));
                    planeOrderModel.setPersonalFee(personalfee.subtract(postServiceFee).setScale(2, 4));
                    planeOrderModel.setProductType(AbstractOrderModel.ProductType.B);
                    planeOrderModel.setServiceFeePaytype("1");
                } else if (1 == orderType) {
                    BigDecimal amount = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("Amount")).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PostServiceFee")));
                    planeOrderModel.setTotalAmount(amount.setScale(2, 4));
                    BigDecimal personalPayTicketFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PersonalPayTicketFee"));
                    BigDecimal personalPayOilFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PersonalPayOilFee"));
                    BigDecimal personalPayBaseServiceFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PersonalPayBaseServiceFee"));
                    BigDecimal personalPayRefundServiceFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PersonalPayRefundServiceFee"));
                    BigDecimal personalPayTax = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PersonalPayTax"));
                    BigDecimal rebookInsuranceFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("RebookInsuranceFee"));
                    BigDecimal personalChannelFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PersonalChannelFee"));
                    BigDecimal personalRebookFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PersonalRebookFee"));
                    BigDecimal personalfee = personalPayTicketFee.add(personalPayOilFee).add(personalPayBaseServiceFee).add(personalPayRefundServiceFee).add(personalPayTax).add(rebookInsuranceFee).add(personalChannelFee).add(personalRebookFee);
                    planeOrderModel.setPersonalFee(personalfee.setScale(2, 4));
                    planeOrderModel.setServiceFeePaytype("1");
                }
                BigDecimal coupon = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("Coupon"));
                if (coupons_tax_deduction == 1) {
                    planeOrderModel.setServiceFee(planeOrderModel.getServiceFee().add(coupon));
                } else {
                    planeOrderModel.setOtherAmount(coupon);
                }
                planeOrderModel.setServer(Supplier.XIECHENG.name());
                this.handlePlaneOrderExtCovert(planeOrderModel, OrderSettlementList);
                orderModels.add(planeOrderModel);
            }
        }
        orderModels = CTripOrderUpdateInvoke.handleRepeatTicketNo(orderModels);
        return orderModels;
    }

    private static List<PlaneOrderModel> handleRepeatTicketNo(List<PlaneOrderModel> details) {
        ArrayListMultimap mapS = ArrayListMultimap.create();
        ArrayList<PlaneOrderModel> newDetails = new ArrayList<PlaneOrderModel>(details.size());
        ArrayList<String> orderNums = new ArrayList<String>(details.size());
        details.forEach(arg_0 -> CTripOrderUpdateInvoke.lambda$handleRepeatTicketNo$1((Multimap)mapS, arg_0));
        for (PlaneOrderModel detail : details) {
            if (orderNums.contains(detail.getOrderNum())) continue;
            BigDecimal size = new BigDecimal(mapS.get((Object)detail.getOrderNum()).size());
            if (size.longValue() > 1L) {
                List list = (List)mapS.get((Object)detail.getOrderNum());
                detail.setTotalAmount(list.stream().map(e -> e.getTotalAmount() == null ? BigDecimal.ZERO : e.getTotalAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setAirportPrice(list.stream().map(e -> e.getAirportPrice() == null ? BigDecimal.ZERO : e.getAirportPrice()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setFuelPrice(list.stream().map(e -> e.getFuelPrice() == null ? BigDecimal.ZERO : e.getFuelPrice()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setRefundAmount(list.stream().map(e -> e.getRefundAmount() == null ? BigDecimal.ZERO : e.getRefundAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setAssuranceAmount(list.stream().map(e -> e.getAssuranceAmount() == null ? BigDecimal.ZERO : e.getAssuranceAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setServiceFee(list.stream().map(e -> e.getServiceFee() == null ? BigDecimal.ZERO : e.getServiceFee()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setOtherAmount(list.stream().map(e -> e.getOtherAmount() == null ? BigDecimal.ZERO : e.getOtherAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setTicketPrice(list.stream().map(e -> e.getTicketPrice() == null ? BigDecimal.ZERO : e.getTicketPrice()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                detail.setEndorsementAmount(list.stream().map(e -> e.getEndorsementAmount() == null ? BigDecimal.ZERO : e.getEndorsementAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            }
            newDetails.add(detail);
            orderNums.add(detail.getOrderNum());
        }
        return newDetails;
    }

    private static List<HotelOrderModel> handleRepeatHotelTicketNo(List<HotelOrderModel> details) {
        ArrayListMultimap mapS = ArrayListMultimap.create();
        ArrayList<HotelOrderModel> newDetails = new ArrayList<HotelOrderModel>(details.size());
        ArrayList<String> orderNums = new ArrayList<String>(details.size());
        details.forEach(arg_0 -> CTripOrderUpdateInvoke.lambda$handleRepeatHotelTicketNo$11((Multimap)mapS, arg_0));
        for (HotelOrderModel detail : details) {
            if (orderNums.contains(detail.getOrderNum())) continue;
            BigDecimal size = new BigDecimal(mapS.get((Object)detail.getOrderNum()).size());
            if (size.longValue() > 1L) {
                List list = (List)mapS.get((Object)detail.getOrderNum());
                detail.setTotalAmount(list.stream().map(e -> e.getTotalAmount() == null ? BigDecimal.ZERO : e.getTotalAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setServiceFee(list.stream().map(e -> e.getServiceFee() == null ? BigDecimal.ZERO : e.getServiceFee()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setRoomAmount(list.stream().map(e -> e.getRoomAmount() == null ? BigDecimal.ZERO : e.getRoomAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setPersonalFee(list.stream().map(e -> e.getPersonalFee() == null ? BigDecimal.ZERO : e.getPersonalFee()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
            }
            newDetails.add(detail);
            orderNums.add(detail.getOrderNum());
        }
        return newDetails;
    }

    private static String handelOrderNum(String orderNum, String orderType) {
        if (orderNum.contains("-")) {
            orderNum = orderNum.substring(0, orderNum.lastIndexOf(45) + 1) + orderType;
            return orderNum;
        }
        return orderNum;
    }

    private List<TrainOrderModel> trainOrderUpdateConvert(JSONArray trainSettelArray) {
        List<TrainOrderModel> orderModels = new ArrayList<TrainOrderModel>(trainSettelArray.size());
        for (int i = 0; i < trainSettelArray.size(); ++i) {
            JSONObject trainSettlementObjects = trainSettelArray.getJSONObject(i);
            JSONArray trainSettlementDetail = trainSettlementObjects.getJSONArray("LstTrainSettlementDetail");
            trainSettlementDetail = trainSettlementDetail == null ? new JSONArray() : trainSettlementDetail;
            for (int j = 0; j < trainSettlementDetail.size(); ++j) {
                JSONObject OrderSettlementList = trainSettlementDetail.getJSONObject(j);
                if (null == OrderSettlementList) continue;
                JSONObject traintOrderSettlementBaseInfo = OrderSettlementList.getJSONObject("TrainSettlementOrder");
                traintOrderSettlementBaseInfo = traintOrderSettlementBaseInfo == null ? new JSONObject() : traintOrderSettlementBaseInfo;
                JSONObject traintSettlementPassengerInfo = OrderSettlementList.getJSONObject("TrainSettlementPassenger");
                traintSettlementPassengerInfo = traintSettlementPassengerInfo == null ? new JSONObject() : traintSettlementPassengerInfo;
                JSONObject traintSettlementTicketInfo = OrderSettlementList.getJSONObject("TrainSettlementTicket");
                traintSettlementTicketInfo = traintSettlementTicketInfo == null ? new JSONObject() : traintSettlementTicketInfo;
                JSONObject trainSettlementDetailInfo = OrderSettlementList.getJSONObject("TrainSettlementDetail");
                trainSettlementDetailInfo = trainSettlementDetailInfo == null ? new JSONObject() : trainSettlementDetailInfo;
                TrainOrderModel trainOrderModel = new TrainOrderModel();
                trainOrderModel.setChecking(Boolean.TRUE);
                String orderID = traintOrderSettlementBaseInfo.getOrDefault((Object)"OrderId", (Object)"").toString();
                String passengerName = traintSettlementPassengerInfo.getOrDefault((Object)"PassengerName", (Object)"").toString();
                String arriveaddress = null;
                if (traintSettlementTicketInfo != null) {
                    arriveaddress = traintSettlementTicketInfo.getOrDefault((Object)"ArrivalCityName", (Object)"").toString();
                }
                String detailType = trainSettlementDetailInfo.getOrDefault((Object)"DetailType", (Object)"").toString();
                String subDetailType = trainSettlementDetailInfo.getOrDefault((Object)"SubDetailType", (Object)"").toString();
                String orderNumNotype = CorpSync.splicOrderNumNotype(orderID, passengerName, arriveaddress);
                trainOrderModel.setOrderNum(orderNumNotype + "-" + detailType + "-" + subDetailType);
                trainOrderModel.setBookedname(traintOrderSettlementBaseInfo.getOrDefault((Object)"UserName", (Object)"").toString());
                trainOrderModel.setSourceBookedId(traintOrderSettlementBaseInfo.getOrDefault((Object)"PreEmployeeID", (Object)"").toString());
                trainOrderModel.setPassegername(passengerName);
                trainOrderModel.setPasseger(traintSettlementPassengerInfo.getOrDefault((Object)"EmployeeID", (Object)"").toString());
                trainOrderModel.setOaBillNum(traintOrderSettlementBaseInfo.getOrDefault((Object)"JouneryID", (Object)"").toString());
                Date orderDate = TripCommonUtil.strToDate(traintOrderSettlementBaseInfo.getOrDefault((Object)"TargetDate", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS");
                trainOrderModel.setOrderDate(orderDate);
                Date happendDate = TripCommonUtil.strToDate(trainSettlementDetailInfo.getOrDefault((Object)"Createtime", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS");
                trainOrderModel.setHappendDate(happendDate);
                trainOrderModel.setParentOrderNum(orderID);
                trainOrderModel.setOrderSort(AbstractOrderModel.OrderSort.A);
                trainOrderModel.setOrderNatrue(AbstractOrderModel.OrderNatrue.A);
                trainOrderModel.setProductType(CTripPropMapping.setProductType(trainSettlementDetailInfo.getOrDefault((Object)"SettlementType", (Object)"").toString()));
                AbstractOrderModel.OrderType orderType = CTripPropMapping.setOrderType(trainSettlementDetailInfo.getOrDefault((Object)"DetailType", (Object)"").toString());
                trainOrderModel.setOrderType(orderType);
                trainOrderModel.setServer(Supplier.XIECHENG.name());
                if (traintSettlementTicketInfo != null) {
                    trainOrderModel.setDepartAddress(traintSettlementTicketInfo.getOrDefault((Object)"DepartureCityName", (Object)"").toString());
                    trainOrderModel.setArriveAddress(arriveaddress);
                    trainOrderModel.setDepartCity(traintSettlementTicketInfo.getOrDefault((Object)"DepartureCityName", (Object)"").toString());
                    trainOrderModel.setArriveCity(arriveaddress);
                    Date departureDate = TripCommonUtil.strToDate(traintSettlementTicketInfo.getOrDefault((Object)"DepartureDate", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS");
                    trainOrderModel.setDepartTime(departureDate);
                    Date arrivalDate = TripCommonUtil.strToDate(traintSettlementTicketInfo.getOrDefault((Object)"ArrivalDate", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS");
                    trainOrderModel.setArriveTime(arrivalDate);
                    trainOrderModel.setVendorName(traintSettlementTicketInfo.getOrDefault((Object)"TrainName", (Object)"").toString());
                    trainOrderModel.setTrainseat(TTripPropMapping.trainSeatMap().get(traintSettlementTicketInfo.getOrDefault((Object)"FirstSeatTypeName", (Object)"").toString()));
                }
                if ("N".equals(trainSettlementDetailInfo.getOrDefault((Object)"SettlementType", (Object)"").toString())) {
                    BigDecimal postServiceFee = TripClassUtil.getDefaultBigDecimal(trainSettlementDetailInfo.getBigDecimal("PostServiceFee"));
                    trainOrderModel.setTotalAmount(postServiceFee.setScale(2, 4));
                    BigDecimal realAmountHasPost = TripClassUtil.getDefaultBigDecimal(trainSettlementDetailInfo.getBigDecimal("RealAmountHasPost"));
                    trainOrderModel.setPersonalFee(realAmountHasPost.subtract(postServiceFee).setScale(2, 4));
                    trainOrderModel.setProductType(AbstractOrderModel.ProductType.B);
                    trainOrderModel.setServiceFeePaytype("1");
                } else if ("M".equals(trainSettlementDetailInfo.getOrDefault((Object)"SettlementType", (Object)"").toString())) {
                    BigDecimal realAmountHasPost = TripClassUtil.getDefaultBigDecimal(trainSettlementDetailInfo.getBigDecimal("RealAmountHasPost"));
                    trainOrderModel.setTotalAmount(realAmountHasPost.setScale(2, 4));
                    BigDecimal PersonalPayTicketFee = TripClassUtil.getDefaultBigDecimal(trainSettlementDetailInfo.getBigDecimal("PersonalPayTicketFee"));
                    BigDecimal PersonalPayServiceFee = TripClassUtil.getDefaultBigDecimal(trainSettlementDetailInfo.getBigDecimal("PersonalPayServiceFee"));
                    BigDecimal PersonalPayOtherFee = TripClassUtil.getDefaultBigDecimal(trainSettlementDetailInfo.getBigDecimal("PersonalPayOtherFee"));
                    BigDecimal personalfee = PersonalPayTicketFee.add(PersonalPayServiceFee).add(PersonalPayOtherFee);
                    trainOrderModel.setPersonalFee(personalfee.setScale(2, 4));
                    trainOrderModel.setServiceFeePaytype("1");
                }
                trainOrderModel.setServiceFee(TripClassUtil.getDefaultBigDecimal(trainSettlementDetailInfo.getBigDecimal("ServerFee")).add(TripClassUtil.getDefaultBigDecimal(trainSettlementDetailInfo.getBigDecimal("ReBookingServiceFee"))).add(TripClassUtil.getDefaultBigDecimal(trainSettlementDetailInfo.getBigDecimal("PostServiceFee"))));
                trainOrderModel.setRefundamount(TripClassUtil.getDefaultBigDecimal(trainSettlementDetailInfo.getBigDecimal("TrainOtherFee")));
                trainOrderModel.setDealAmount(TripClassUtil.getDefaultBigDecimal(trainSettlementDetailInfo.getBigDecimal("InsuranceFee")));
                trainOrderModel.setTicketPrice(TripClassUtil.getDefaultBigDecimal(trainSettlementDetailInfo.getBigDecimal("TrainChangePrice")));
                String orderStatus = CTripPropMapping.ctripTrainOrderStatusMap().get(trainSettlementDetailInfo.getOrDefault((Object)"DetailType", (Object)"O").toString());
                trainOrderModel.setOrderStatus(orderStatus);
                trainOrderModel.setOperationType(AbstractOrderModel.OperationType.F);
                this.handleTrainOrderExtCovert(trainOrderModel, OrderSettlementList);
                orderModels.add(trainOrderModel);
            }
        }
        orderModels = this.handleRepeatTrainTicketNo(orderModels);
        return orderModels;
    }

    private List<TrainOrderModel> handleRepeatTrainTicketNo(List<TrainOrderModel> details) {
        ArrayListMultimap mapS = ArrayListMultimap.create();
        ArrayList<TrainOrderModel> newDetails = new ArrayList<TrainOrderModel>(details.size());
        ArrayList<String> orderNums = new ArrayList<String>(details.size());
        details.forEach(arg_0 -> CTripOrderUpdateInvoke.lambda$handleRepeatTrainTicketNo$20((Multimap)mapS, arg_0));
        for (TrainOrderModel detail : details) {
            if (orderNums.contains(detail.getOrderNum())) continue;
            BigDecimal size = new BigDecimal(mapS.get((Object)detail.getOrderNum()).size());
            if (size.longValue() > 1L) {
                List list = (List)mapS.get((Object)detail.getOrderNum());
                detail.setTotalAmount(list.stream().filter(e -> e.getTotalAmount() != null).map(e -> e.getTotalAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setRefundamount(list.stream().filter(e -> e.getRefundamount() != null).map(e -> e.getRefundamount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setDealAmount(list.stream().filter(e -> e.getDealAmount() != null).map(e -> e.getDealAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setServiceFee(list.stream().filter(e -> e.getServiceFee() != null).map(e -> e.getServiceFee()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setTicketPrice(list.stream().map(e -> e.getTicketPrice() == null ? BigDecimal.ZERO : e.getTicketPrice()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
            }
            newDetails.add(detail);
            orderNums.add(detail.getOrderNum());
        }
        return newDetails;
    }

    private List<VehicleOrderModel> handleRepeatVehicleTicketNo(List<VehicleOrderModel> details) {
        ArrayListMultimap mapS = ArrayListMultimap.create();
        ArrayList<VehicleOrderModel> newDetails = new ArrayList<VehicleOrderModel>(details.size());
        ArrayList<String> orderNums = new ArrayList<String>(details.size());
        details.forEach(arg_0 -> CTripOrderUpdateInvoke.lambda$handleRepeatVehicleTicketNo$35((Multimap)mapS, arg_0));
        for (VehicleOrderModel detail : details) {
            if (orderNums.contains(detail.getOrderNum())) continue;
            BigDecimal size = new BigDecimal(mapS.get((Object)detail.getOrderNum()).size());
            if (size.longValue() > 1L) {
                List list = (List)mapS.get((Object)detail.getOrderNum());
                detail.setTotalAmount(list.stream().filter(e -> e.getTotalAmount() != null).map(e -> e.getTotalAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setDealAmount(list.stream().filter(e -> e.getDealAmount() != null).map(e -> e.getDealAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
                detail.setServiceFee(list.stream().filter(e -> e.getServiceFee() != null).map(e -> e.getServiceFee()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
            }
            newDetails.add(detail);
            orderNums.add(detail.getOrderNum());
        }
        return newDetails;
    }

    private static /* synthetic */ void lambda$handleRepeatVehicleTicketNo$35(Multimap mapS, VehicleOrderModel e) {
        mapS.put((Object)e.getOrderNum(), (Object)e);
    }

    private static /* synthetic */ void lambda$handleRepeatTrainTicketNo$20(Multimap mapS, TrainOrderModel e) {
        mapS.put((Object)e.getOrderNum(), (Object)e);
    }

    private static /* synthetic */ void lambda$handleRepeatHotelTicketNo$11(Multimap mapS, HotelOrderModel e) {
        mapS.put((Object)e.getOrderNum(), (Object)e);
    }

    private static /* synthetic */ void lambda$handleRepeatTicketNo$1(Multimap mapS, PlaneOrderModel e) {
        mapS.put((Object)e.getOrderNum(), (Object)e);
    }
}

