/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.HotelOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.trip.util.CTripHotelUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import org.apache.commons.lang.StringUtils;

public class CTripHotelOrderConvert {
    private static final Log logger = LogFactory.getLog(CTripHotelOrderConvert.class);
    public static final List<String> PAY_TYPE_LIST = Arrays.asList("\u516c\u53f8\u8d26\u6237", "\u7b2c\u4e09\u65b9\u8d26\u6237");

    public static List<AbstractOrderModel> convert(JSONObject hotelObject) throws CloneNotSupportedException {
        if (hotelObject == null) {
            return new ArrayList<AbstractOrderModel>();
        }
        ArrayList<AbstractOrderModel> orders = new ArrayList<AbstractOrderModel>(4);
        HotelOrderModel hotelOrderModel = new HotelOrderModel();
        boolean paramValue = (Boolean)ActionLocalCache.get().get("Split_hotel_settlement", "Split_hotel_settlement", () -> TripSyncConfigUtil.getBoolean("Split_hotel_settlement", Boolean.TRUE));
        String orderStatus = (String)hotelObject.getOrDefault((Object)"OrderStatus", (Object)"");
        if (!Arrays.asList("\u5df2\u6210\u4ea4", "\u5df2\u4ed8\u6b3e", "\u5df2\u53d6\u6d88").contains(orderStatus)) {
            return orders;
        }
        hotelOrderModel.setServer(Supplier.XIECHENG.name());
        String payType = (String)hotelObject.getOrDefault((Object)"PayType", (Object)"");
        if (!PAY_TYPE_LIST.contains(payType)) {
            return new ArrayList<AbstractOrderModel>();
        }
        hotelOrderModel.setOrderDate(hotelObject.getDate("OrderDate"));
        hotelOrderModel.setOrderNum((String)hotelObject.getOrDefault((Object)"OrderID", (Object)""));
        hotelOrderModel.setParentOrderNum((String)hotelObject.getOrDefault((Object)"OrderID", (Object)""));
        hotelOrderModel.setOrderType(AbstractOrderModel.OrderType.O);
        hotelOrderModel.setHappendDate(hotelObject.getDate("OrderDate"));
        hotelOrderModel.setOrderStatus(CTripHotelOrderConvert.setOrderStatus(orderStatus));
        hotelOrderModel.setOrderNatrue(CTripHotelOrderConvert.setOrderNatrue((String)hotelObject.getOrDefault((Object)"Corp_payType", (Object)"")));
        hotelOrderModel.setProductType(CTripHotelOrderConvert.setProductType(payType));
        hotelOrderModel.setOverDesc((String)hotelObject.getOrDefault((Object)"LowPriceRC_VV", (Object)""));
        if (null != hotelObject.getBoolean("IsDomestic") && hotelObject.getBoolean("IsDomestic").booleanValue()) {
            hotelOrderModel.setOperationType(AbstractOrderModel.OperationType.A);
            hotelOrderModel.setOrderSort(AbstractOrderModel.OrderSort.A);
        } else {
            hotelOrderModel.setOperationType(AbstractOrderModel.OperationType.E);
            hotelOrderModel.setOrderSort(AbstractOrderModel.OrderSort.B);
        }
        hotelOrderModel.setOaBillNum((String)hotelObject.getOrDefault((Object)"JourneyNo", (Object)""));
        hotelOrderModel.setSourceBookedId((String)hotelObject.getOrDefault((Object)"PreEmployeeID", (Object)""));
        hotelOrderModel.setBookedName((String)hotelObject.getOrDefault((Object)"PreEmployeeName", (Object)""));
        hotelOrderModel.setTravelerName((String)hotelObject.getOrDefault((Object)"ClientName", (Object)""));
        hotelOrderModel.setCityName((String)hotelObject.getOrDefault((Object)"CityName", (Object)""));
        hotelOrderModel.setHotelName((String)hotelObject.getOrDefault((Object)"HotelName", (Object)""));
        hotelOrderModel.setHotelAddress((String)hotelObject.getOrDefault((Object)"Address", (Object)""));
        hotelOrderModel.setCheckinDate(TripCommonUtil.convertToDate((String)hotelObject.getOrDefault((Object)"StartTime", (Object)"")));
        hotelOrderModel.setCheckoutDate(TripCommonUtil.convertToDate((String)hotelObject.getOrDefault((Object)"EndTime", (Object)"")));
        hotelOrderModel.setRoomStyleName((String)hotelObject.getOrDefault((Object)"RoomName", (Object)""));
        hotelOrderModel.setRoomCount(hotelObject.getIntValue("RoomQuantity"));
        hotelOrderModel.setPriceBillingType(CTripHotelUtil.dealInvoiceType(hotelObject));
        JSONArray travelers = hotelObject.getJSONArray("ClientInfo");
        travelers = travelers == null ? new JSONArray() : travelers;
        int size = travelers.size();
        for (int j = 0; j < size; ++j) {
            HotelOrderModel hotelTravelersOrderModel = (HotelOrderModel)hotelOrderModel.clone();
            JSONObject traveler = travelers.getJSONObject(j);
            if (null == traveler) continue;
            String journeyID = traveler.getOrDefault((Object)"ClientPreApprovalNo", (Object)"").toString();
            if (StringUtils.isNotBlank((String)journeyID) && !paramValue) {
                hotelTravelersOrderModel.setOaBillNum(journeyID);
            }
            hotelTravelersOrderModel.setSourceTravelerId((String)traveler.getOrDefault((Object)"EmployeeID", (Object)""));
            hotelTravelersOrderModel.setTravelerName((String)traveler.getOrDefault((Object)"ClientName", (Object)""));
            hotelTravelersOrderModel.setTotalAmount(ConvertUtil.getOrderAmountInit());
            if (size > 1) {
                hotelTravelersOrderModel.setOrderNum(hotelOrderModel.getOrderNum() + "-" + (j + 1));
            }
            orders.add(hotelTravelersOrderModel);
            if (!orderStatus.equals("\u5df2\u53d6\u6d88")) continue;
            HotelOrderModel hotelRefundOrderModel = (HotelOrderModel)hotelTravelersOrderModel.clone();
            hotelRefundOrderModel.setOrderNum(hotelRefundOrderModel.getOrderNum() + "-T1");
            hotelRefundOrderModel.setOrderDate(new Date());
            hotelRefundOrderModel.setOrderType(AbstractOrderModel.OrderType.T);
            hotelRefundOrderModel.setHappendDate(new Date());
            hotelRefundOrderModel.setTotalAmount(ConvertUtil.getOrderAmountInit());
            orders.add(hotelRefundOrderModel);
        }
        return orders;
    }

    private static AbstractOrderModel.ProductType setProductType(String payType) {
        switch (payType) {
            case "\u516c\u53f8\u8d26\u6237": 
            case "\u7b2c\u4e09\u65b9\u8d26\u6237": {
                return AbstractOrderModel.ProductType.A;
            }
        }
        return AbstractOrderModel.ProductType.B;
    }

    private static AbstractOrderModel.OrderNatrue setOrderNatrue(String corp_payType) {
        switch (corp_payType) {
            case "\u516c\u8d39": {
                return AbstractOrderModel.OrderNatrue.A;
            }
        }
        return AbstractOrderModel.OrderNatrue.B;
    }

    private static HotelOrderModel.OrderStatus setOrderStatus(String orderStatus) {
        switch (orderStatus) {
            case "\u786e\u8ba4\u4e2d": {
                return HotelOrderModel.OrderStatus.C;
            }
            case "\u5df2\u6210\u4ea4": {
                return HotelOrderModel.OrderStatus.G;
            }
            case "\u5df2\u53d6\u6d88": {
                return HotelOrderModel.OrderStatus.I;
            }
            case "\u5df2\u786e\u8ba4": 
            case "\u5df2\u4ed8\u6b3e": 
            case "\u5df2\u6536\u6b3e": {
                return HotelOrderModel.OrderStatus.E;
            }
        }
        return null;
    }
}

