/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.invoke.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.PlaneCheckingBillDetailModel;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.trip.util.TripClassUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import org.apache.commons.lang.StringUtils;

public class CTripPlaneCheckingDetailConvert {
    private static final Log logger = LogFactory.getLog(CTripPlaneCheckingDetailConvert.class);

    public static List<PlaneCheckingBillDetailModel> convert(JSONObject OrderSettlementList) throws CloneNotSupportedException {
        String date;
        String accCheckBatchNo;
        ArrayList<PlaneCheckingBillDetailModel> details = new ArrayList<PlaneCheckingBillDetailModel>(4);
        PlaneCheckingBillDetailModel planeCheckingBillDetailModel = new PlaneCheckingBillDetailModel();
        int coupons_tax_deduction = TripSyncConfigUtil.getIntValue("coupons_tax_deduction", 0, Arrays.asList(0, 1));
        JSONObject flightOrderSettlementBaseInfo = OrderSettlementList.getJSONObject("OrderSettlementBaseInfo");
        flightOrderSettlementBaseInfo = flightOrderSettlementBaseInfo == null ? new JSONObject() : flightOrderSettlementBaseInfo;
        JSONObject flightOrderBaseInfo = OrderSettlementList.getJSONObject("OrderBaseInfo");
        flightOrderBaseInfo = flightOrderBaseInfo == null ? new JSONObject() : flightOrderBaseInfo;
        JSONObject flightOrderPassenger = OrderSettlementList.getJSONObject("OrderPassengerInfo");
        flightOrderPassenger = flightOrderPassenger == null ? new JSONObject() : flightOrderPassenger;
        JSONObject flightOrderRebookInfo = OrderSettlementList.getJSONObject("OrderRebookInfo");
        flightOrderRebookInfo = flightOrderRebookInfo == null ? new JSONObject() : flightOrderRebookInfo;
        JSONObject flightOrderRefundInfo = OrderSettlementList.getJSONObject("OrderRefundInfo");
        flightOrderRefundInfo = flightOrderRefundInfo == null ? new JSONObject() : flightOrderRefundInfo;
        JSONObject orderFlightInfo = OrderSettlementList.getJSONObject("OrderFlightInfo");
        orderFlightInfo = orderFlightInfo == null ? new JSONObject() : orderFlightInfo;
        JSONArray segmentPrintInfoList = orderFlightInfo.getJSONArray("SegmentPrintInfoList");
        segmentPrintInfoList = segmentPrintInfoList == null ? new JSONArray() : segmentPrintInfoList;
        String orderID = flightOrderSettlementBaseInfo.getOrDefault((Object)"OrderID", (Object)"").toString();
        String ticketNo = flightOrderPassenger.getOrDefault((Object)"TicketNo", (Object)"").toString();
        planeCheckingBillDetailModel.setOaBillNum(flightOrderBaseInfo.getOrDefault((Object)"JourneyID", (Object)"").toString());
        planeCheckingBillDetailModel.setTicketNum(CTripPlaneCheckingDetailConvert.handelTicketNo(ticketNo));
        planeCheckingBillDetailModel.setParentordernum(orderID);
        planeCheckingBillDetailModel.setOrderType(AbstractOrderModel.OrderType.O);
        planeCheckingBillDetailModel.setOrderStatus(PlaneOrderModel.OrderStatus.A);
        planeCheckingBillDetailModel.setAccountID(flightOrderSettlementBaseInfo.getIntValue("AccountID"));
        planeCheckingBillDetailModel.setBatchno(flightOrderSettlementBaseInfo.getOrDefault((Object)"AccCheckBatchNo", (Object)"").toString());
        planeCheckingBillDetailModel.setSubBatchno(flightOrderSettlementBaseInfo.getOrDefault((Object)"SubAccCheckBatchNo", (Object)"").toString());
        Date happenDate = TripCommonUtil.strToDate(flightOrderSettlementBaseInfo.getOrDefault((Object)"CreateTime", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS");
        planeCheckingBillDetailModel.setHappendDate(happenDate);
        if (!TripSyncConfigUtil.getBoolean("ttrip_period_value", Boolean.TRUE).booleanValue() && (accCheckBatchNo = flightOrderSettlementBaseInfo.getOrDefault((Object)"AccCheckBatchNo", (Object)"").toString()).contains("_") && (date = accCheckBatchNo.substring(accCheckBatchNo.lastIndexOf("_") + 1)).length() == 8) {
            Calendar cal = Calendar.getInstance();
            cal.set(Integer.parseInt(date.substring(0, 4)), Integer.parseInt(date.substring(4, 6)) - 1, Integer.parseInt(date.substring(6, 8)));
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            planeCheckingBillDetailModel.setHappendDate(cal.getTime());
        }
        planeCheckingBillDetailModel.setServer(Supplier.XIECHENG.name());
        Date orderDate = TripCommonUtil.strToDate(flightOrderBaseInfo.getOrDefault((Object)"OrderDate", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS");
        planeCheckingBillDetailModel.setOrderDate(orderDate);
        if ("I".equals(flightOrderBaseInfo.getOrDefault((Object)"FlightClass", (Object)"").toString())) {
            planeCheckingBillDetailModel.setOrderSort(AbstractCheckingBillDetailModel.OrderSort.B);
            planeCheckingBillDetailModel.setOperationType(AbstractOrderModel.OperationType.D);
        } else {
            planeCheckingBillDetailModel.setOrderSort(AbstractCheckingBillDetailModel.OrderSort.A);
            planeCheckingBillDetailModel.setOperationType(AbstractOrderModel.OperationType.B);
        }
        planeCheckingBillDetailModel.setOrderNatrue(AbstractOrderModel.OrderNatrue.A);
        planeCheckingBillDetailModel.setProductType(CTripPlaneCheckingDetailConvert.setProductType(flightOrderSettlementBaseInfo.getIntValue("OrderType")));
        planeCheckingBillDetailModel.setSourceBookedId(flightOrderBaseInfo.getOrDefault((Object)"PreEmployeeID", (Object)"").toString());
        planeCheckingBillDetailModel.setBookedname(flightOrderBaseInfo.getOrDefault((Object)"Name", (Object)"").toString());
        planeCheckingBillDetailModel.setSourceTravelerId(flightOrderBaseInfo.getOrDefault((Object)"EmployeeID", (Object)"").toString());
        String travelername = flightOrderPassenger.getOrDefault((Object)"PassengerName", (Object)"").toString();
        planeCheckingBillDetailModel.setTravelername(travelername);
        Integer orderType = flightOrderSettlementBaseInfo.getIntValue("OrderType");
        if (2 == orderType) {
            BigDecimal postServiceFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PostServiceFee"));
            planeCheckingBillDetailModel.setTotalAmount(postServiceFee.setScale(2, 4));
            BigDecimal personalfee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("RealAmountWithPostServiceFee"));
            planeCheckingBillDetailModel.setPersonalFee(personalfee.subtract(postServiceFee).setScale(2, 4));
            planeCheckingBillDetailModel.setProductType(AbstractOrderModel.ProductType.B);
            planeCheckingBillDetailModel.setServiceFeePaytype("1");
        } else if (1 == orderType) {
            BigDecimal amount = flightOrderSettlementBaseInfo.getBigDecimal("Amount").add(flightOrderSettlementBaseInfo.getBigDecimal("PostServiceFee"));
            planeCheckingBillDetailModel.setTotalAmount(amount.setScale(2, 4));
            BigDecimal personalPayTicketFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PersonalPayTicketFee"));
            BigDecimal personalPayOilFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PersonalPayOilFee"));
            BigDecimal personalPayBaseServiceFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PersonalPayBaseServiceFee"));
            Object personalPayRefundServiceFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PersonalPayRefundServiceFee"));
            BigDecimal personalPayTax = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PersonalPayTax"));
            BigDecimal rebookInsuranceFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("RebookInsuranceFee"));
            BigDecimal personalChannelFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PersonalChannelFee"));
            BigDecimal personalRebookFee = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PersonalRebookFee"));
            BigDecimal personalfee = personalPayTicketFee.add(personalPayOilFee).add(personalPayBaseServiceFee).add((BigDecimal)personalPayRefundServiceFee).add(personalPayTax).add(rebookInsuranceFee).add(personalChannelFee).add(personalRebookFee);
            planeCheckingBillDetailModel.setPersonalFee(personalfee.setScale(2, 4));
            planeCheckingBillDetailModel.setServiceFeePaytype("1");
        }
        planeCheckingBillDetailModel.setFlightNo(orderFlightInfo.getOrDefault((Object)"Flight", (Object)"").toString());
        planeCheckingBillDetailModel.setFromCityName(orderFlightInfo.getOrDefault((Object)"DCityName", (Object)"").toString());
        String toCityName = orderFlightInfo.getOrDefault((Object)"ACityName", (Object)"").toString();
        planeCheckingBillDetailModel.setToCityName(toCityName);
        planeCheckingBillDetailModel.setTicketPrice(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("Price")).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PriceDifferential"))));
        planeCheckingBillDetailModel.setDiscount(TripClassUtil.getDefaultBigDecimal(orderFlightInfo.getBigDecimal("PriceRate")).multiply(new BigDecimal(100)));
        planeCheckingBillDetailModel.setAirportPrice(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("Tax")));
        planeCheckingBillDetailModel.setFuelPrice(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("OilFee")));
        planeCheckingBillDetailModel.setRefundAmount(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("Refund")));
        planeCheckingBillDetailModel.setAssuranceAmount(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("InsuranceFee")));
        planeCheckingBillDetailModel.setServiceFee(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("ServiceFee")).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("RefundServiceFee"))).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("ReBookingServiceFee"))).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("ItineraryFee"))).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("ServicePackagePrice"))).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("PostServiceFee"))).add(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("SendTicketFee"))));
        planeCheckingBillDetailModel.setCabin(orderFlightInfo.getOrDefault((Object)"ClassName", (Object)"").toString());
        planeCheckingBillDetailModel.setCabinClass(orderFlightInfo.getOrDefault((Object)"SubClass", (Object)"").toString());
        planeCheckingBillDetailModel.setAirlineName(orderFlightInfo.getOrDefault((Object)"AirLineName", (Object)"").toString());
        planeCheckingBillDetailModel.setTakeOffTime(TripCommonUtil.strToDate(orderFlightInfo.getOrDefault((Object)"TakeOffTime", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS"));
        planeCheckingBillDetailModel.setLandingtime(TripCommonUtil.strToDate(orderFlightInfo.getOrDefault((Object)"ArrivalTime", (Object)"").toString(), "yyyy-MM-dd HH:mm:ss.SSS"));
        String orderNumNotype = CorpSync.splicOrderNumNotype(orderID, travelername, toCityName);
        String orderDetailType = flightOrderSettlementBaseInfo.getOrDefault((Object)"OrderDetailType", (Object)"").toString();
        BigDecimal coupon = TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("Coupon"));
        if (coupons_tax_deduction == 1) {
            planeCheckingBillDetailModel.setServiceFee(planeCheckingBillDetailModel.getServiceFee().add(coupon));
        } else {
            planeCheckingBillDetailModel.setOtherAmount(coupon);
        }
        switch (orderDetailType) {
            case "\u6539\u7b7e": {
                if (flightOrderRebookInfo != null) {
                    planeCheckingBillDetailModel.setTicketNum(CTripPlaneCheckingDetailConvert.handelTicketNo(flightOrderRebookInfo.getOrDefault((Object)"TicketNo", (Object)"").toString()));
                    planeCheckingBillDetailModel.setFlightNo(flightOrderRebookInfo.getOrDefault((Object)"ExchangeFlight", (Object)"").toString());
                    travelername = flightOrderRebookInfo.getOrDefault((Object)"PassengerName", (Object)"").toString();
                    planeCheckingBillDetailModel.setTravelername(travelername);
                    planeCheckingBillDetailModel.setFromCityName(flightOrderRebookInfo.getOrDefault((Object)"DCityName", (Object)"").toString());
                    toCityName = flightOrderRebookInfo.getOrDefault((Object)"ACityName", (Object)"").toString();
                    planeCheckingBillDetailModel.setToCityName(toCityName);
                    planeCheckingBillDetailModel.setCabin(flightOrderRebookInfo.getOrDefault((Object)"CClass", (Object)"").toString());
                    planeCheckingBillDetailModel.setCabinClass(flightOrderRebookInfo.getOrDefault((Object)"CClassName", (Object)"").toString());
                    planeCheckingBillDetailModel.setAirlineName(flightOrderRebookInfo.getOrDefault((Object)"RebookAirLineName", (Object)"").toString());
                    planeCheckingBillDetailModel.setTakeOffTime(flightOrderRebookInfo.getDate("RebookTakeOffTime"));
                    planeCheckingBillDetailModel.setLandingtime(flightOrderRebookInfo.getDate("RebookArrivalTime"));
                }
                planeCheckingBillDetailModel.setOrderType(AbstractOrderModel.OrderType.G);
                planeCheckingBillDetailModel.setOrderStatus(PlaneOrderModel.OrderStatus.C);
                break;
            }
            case "\u9000\u7968": {
                if (flightOrderRefundInfo != null) {
                    planeCheckingBillDetailModel.setTicketNum(CTripPlaneCheckingDetailConvert.handelTicketNo(flightOrderRefundInfo.getOrDefault((Object)"TicketNo", (Object)"").toString()));
                    planeCheckingBillDetailModel.setFlightNo(flightOrderRefundInfo.getOrDefault((Object)"Flight", (Object)"").toString());
                }
                planeCheckingBillDetailModel.setOrderType(AbstractOrderModel.OrderType.T);
                planeCheckingBillDetailModel.setOrderStatus(PlaneOrderModel.OrderStatus.E);
                break;
            }
            case "\u53d6\u6d88": {
                planeCheckingBillDetailModel.setOrderType(AbstractOrderModel.OrderType.Q);
                break;
            }
            case "\u8c03\u6574": {
                planeCheckingBillDetailModel.setOrderType(AbstractOrderModel.OrderType.Z);
            }
        }
        planeCheckingBillDetailModel.setEndorsementAmount(TripClassUtil.getDefaultBigDecimal(flightOrderSettlementBaseInfo.getBigDecimal("DateChangeFee")));
        planeCheckingBillDetailModel.setOrderNum(orderNumNotype + "-" + planeCheckingBillDetailModel.getOrderType().getKey());
        if (segmentPrintInfoList != null) {
            for (int j = 0; j < segmentPrintInfoList.size(); ++j) {
                String printTime;
                String segmentTicketNo;
                JSONObject segmentPrintInfo = segmentPrintInfoList.getJSONObject(j);
                if (segmentPrintInfo == null || !StringUtils.equals((String)ticketNo, (String)(segmentTicketNo = CTripPlaneCheckingDetailConvert.handelTicketNo(segmentPrintInfo.getOrDefault((Object)"TicketNo", (Object)"").toString())))) continue;
                String printNo = segmentPrintInfo.getOrDefault((Object)"PrintNo", (Object)"").toString();
                if (printNo != null) {
                    planeCheckingBillDetailModel.setItinerarynum(printNo);
                }
                if ((printTime = segmentPrintInfo.getOrDefault((Object)"PrintTime", (Object)"").toString()) == null) continue;
                planeCheckingBillDetailModel.setItinerarydate(TripCommonUtil.convertToDate(segmentPrintInfo.getOrDefault((Object)"PrintTime", (Object)"").toString()));
            }
        }
        details.add(planeCheckingBillDetailModel);
        return details;
    }

    private static String handelTicketNo(String ticketNo) {
        if (ticketNo != null && ticketNo.contains("-")) {
            ticketNo = ticketNo.substring(ticketNo.indexOf("-") + 1, ticketNo.length());
            return ticketNo;
        }
        return ticketNo;
    }

    private static AbstractOrderModel.ProductType setProductType(int productType) {
        if (1 == productType) {
            return AbstractOrderModel.ProductType.A;
        }
        return AbstractOrderModel.ProductType.B;
    }
}

