/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.ctrip.systemexternal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class CorpSync {
    private static Log logger = LogFactory.getLog(CorpSync.class);
    private static final String SUCCESS = "Success";

    public static JSONObject getCacheAuthentification(String key) {
        JSONObject cacheToken;
        key = key + RequestContext.get().getTenantId();
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String strCache = (String)cache.get(key);
        if (StringUtils.isBlank((CharSequence)strCache)) {
            cacheToken = CorpSync.getAuthentification();
            strCache = JSONObject.toJSONString((Object)cacheToken);
            cache.put(key, (Object)strCache, 1800);
        }
        cacheToken = (JSONObject)JSONObject.parseObject((String)strCache, JSONObject.class);
        return cacheToken;
    }

    public static JSONObject getAuthentification() {
        JSONObject auth = new JSONObject();
        Map<String, String> corpMap = TripCommonUtil.getTripServiceInfo(Supplier.XIECHENG.name());
        String token = CorpSync.getTicket("https://ct.ctrip.com/SwitchAPI/Order/Ticket", corpMap);
        auth.put("Ticket", (Object)token);
        auth.put("AppKey", (Object)corpMap.get("appkey"));
        return auth;
    }

    public static String getTicket(String url, Map<String, String> corpMap) {
        String token = null;
        JSONObject postJson = new JSONObject();
        postJson.put("appKey", (Object)corpMap.get("appkey"));
        postJson.put("appSecurity", (Object)corpMap.get("appsecurity"));
        String postString = postJson.toJSONString();
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u83b7\u53d6Token,\u8bf7\u6c42\u53c2\u6570" + postString);
        String result = HttpRetryServiceHelper.PostData(url, postString);
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u83b7\u53d6Token,URL:" + url + ",getticket:" + result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject != null) {
            if (url.equals("https://ct.ctrip.com/corpservice/authorize/getticket")) {
                if (jsonObject.getBoolean(SUCCESS).booleanValue()) {
                    token = jsonObject.getString("Token");
                }
            } else {
                JSONObject status = jsonObject.getJSONObject("Status");
                if (status.getBoolean(SUCCESS).booleanValue()) {
                    token = jsonObject.getString("Ticket");
                }
            }
        }
        return token;
    }

    @Deprecated
    public static JSONArray getCropCity() {
        JSONArray currDataArray;
        JSONArray dataArray = new JSONArray();
        JSONObject postJson = new JSONObject();
        postJson.put("Auth", (Object)CorpSync.getAuthentification());
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u83b7\u53d6\u57ce\u5e02,\u63a5\u53e3\u4e0a\u9001\u6570\u636e:" + postJson.toJSONString());
        String result = HttpRetryServiceHelper.PostData("https://corpsz.ctrip.com/flightBaseData/queryCity", postJson.toJSONString());
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        JSONObject jsonStatusObject = jsonObject.getJSONObject("status");
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u83b7\u53d6\u57ce\u5e02,\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:" + jsonStatusObject.toString());
        String errorCode = jsonStatusObject.getString("errorCode");
        if (errorCode.equals("0") && (currDataArray = jsonObject.getJSONArray("datas")) != null) {
            dataArray.addAll((Collection)currDataArray);
        }
        return dataArray;
    }

    public static void getCheckingBillByBatchNo(String businessType) {
        String startDate = CorpSync.getLastMonthContractDate();
        DynamicObject mainAccountObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_corpaccountsetting", (String)"id,number,entryentity,entryentity.mainaccountname", (QFilter[])new QFilter[0]);
        if (mainAccountObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u6279\u6b21\u53f7\u83b7\u53d6\u643a\u7a0b\u7ed3\u7b97\u5355\u6570\u636e\uff0c\u4e3b\u8d26\u6237\u4e3a\u7a7a\u3002", (String)"CorpSync_0", (String)"fi-er-business", (Object[])new Object[0]));
        }
        String corpID = mainAccountObject.getString("number");
        DynamicObjectCollection mainAccountEntry = mainAccountObject.getDynamicObjectCollection("entryentity");
        HashSet<String> mainaccountList = new HashSet<String>();
        for (DynamicObject accountObject : mainAccountEntry) {
            String mainaccountname = accountObject.getString("mainaccountname");
            mainaccountList.add(mainaccountname);
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u7ed3\u7b97\u5355,\u4e3b\u8d26\u6237\u96c6\u5408\u5927\u5c0f:" + mainaccountList.size());
        ErCommonUtils.removeKeyFromAppCache("CTripCheckingInvoke" + RequestContext.get().getTenantId());
        for (String mainAccount : mainaccountList) {
            HashMap<String, String> params = new HashMap<String, String>();
            String batchNo = corpID + "_" + mainAccount + "_" + startDate;
            params.put("BatchNo", batchNo);
            params.put("businessType", businessType);
            ITripService tripService = TripServiceFactory.getTripService("CTripService");
            try {
                tripService.synSettlementsFromTrip(params);
            }
            catch (Exception e) {
                logger.error("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u7ed3\u7b97\u5355,\u83b7\u53d6\u5bf9\u8d26\u5355\u5f02\u5e38:", (Throwable)e);
            }
        }
    }

    private static String getLastMonthContractDate() {
        Map<String, String> serviceInfoMap = TripCommonUtil.getTripServiceInfo(Supplier.XIECHENG.name());
        String contractDateStr = serviceInfoMap.get("reservedfield2");
        if (contractDateStr == null || StringUtils.isBlank((CharSequence)contractDateStr)) {
            contractDateStr = "1";
        }
        int contractDate = Integer.parseInt(contractDateStr);
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        cal.set(5, contractDate);
        return new SimpleDateFormat("yyyyMMdd").format(cal.getTime());
    }

    public static String splicOrderNumNotype(String orderId, String passagerName, String toCity) {
        if (toCity == null) {
            return orderId + "-" + passagerName;
        }
        return orderId + "-" + passagerName + "-" + toCity;
    }

    public static String splicOldOrderNum(String orderId, String ticketNum, String OrderType2) {
        if ("O".equals(OrderType2)) {
            return orderId + "-" + ticketNum;
        }
        return orderId + "-" + ticketNum + "-" + OrderType2;
    }
}

