/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.invoke;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.service.function.AbstractLoginInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.common.ExternalConstants;

public class DiDiTripAuthLoginInvoke
extends AbstractLoginInvoke {
    private static Log logger = LogFactory.getLog(DiDiTripAuthLoginInvoke.class);

    private String getTripAuthToken() {
        String open_auth_token = null;
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(Supplier.DIDI.name());
        String client_id = supplierMap.get("appkey");
        String client_secret = supplierMap.get("appsecurity");
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("client_id", client_id);
        signMap.put("client_secret", client_secret);
        signMap.put("out_company_id", RequestContext.get().getAccountId());
        signMap.put("out_company_name", RequestContext.get().getTenantId());
        signMap.put("auth_scope", "1|2|3");
        signMap.put("callback", "kingdee");
        signMap.put("out_member_id", String.valueOf(CommonServiceHelper.getCurrentUserID()));
        signMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        String signKey = supplierMap.get("reservedfield1");
        String authSign = DiDiServiceUtil.genSign(signMap, signKey);
        JSONObject authObj = new JSONObject(signMap);
        authObj.put("sign", (Object)authSign);
        authObj.remove((Object)"sign_key");
        String result = HttpRetryServiceHelper.PostData((String)ExternalConstants.DIDIURLMAP.get("openAuthTokenKey"), authObj.toString());
        JSONObject resultJsonObject = JSONObject.parseObject((String)result);
        if (resultJsonObject == null || !"0".equals(resultJsonObject.getString("errno"))) {
            return null;
        }
        JSONObject data = (JSONObject)resultJsonObject.get((Object)"data");
        open_auth_token = data.getString("open_auth_token");
        return open_auth_token;
    }

    @Override
    public String login() {
        String open_auth_token = this.getTripAuthToken();
        StringBuilder urlBuilder = new StringBuilder((String)ExternalConstants.DIDIURLMAP.get("openAuthLoginKey"));
        urlBuilder.append("?open_auth_token=").append(open_auth_token);
        return urlBuilder.toString();
    }

    @Override
    protected void process(String loginString) {
    }
}

