/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.trip.model.TripSyncDataMappingModel;
import kd.fi.er.business.trip.service.function.AbstractOrgInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiOrgAndUserInvokeUtil;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.util.TripSyncDataMappingUtil;
import kd.fi.er.common.ExternalConstants;
import org.apache.commons.lang3.StringUtils;

public class DiDiTripOrgInvoke
extends AbstractOrgInvoke<Set<JSONObject>> {
    private static Log logger = LogFactory.getLog(DiDiTripOrgInvoke.class);

    @Override
    protected String supplier() {
        return Supplier.DIDI.name();
    }

    @Override
    protected Object getInnerData() {
        this.bizInfoObject = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)"lastsyncorgtamp", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
        this.lastSyncOrgTamp = this.bizInfoObject.getString("lastsyncorgtamp");
        return this.queryChangeInfo();
    }

    private Map<String, JSONArray> queryChangeInfo() {
        Date changetime = TripCommonUtil.convertToDate(this.lastSyncOrgTamp);
        int paramValue = TripSyncConfigUtil.getIntValue("budget_center_id", 1);
        QFilter qFilter = 3 == paramValue ? new QFilter("view", "=", (Object)10L) : new QFilter("view", "=", (Object)1L);
        if (this.params != null && null != this.params.get("orgList")) {
            qFilter.and(new QFilter("org", "in", this.params.get("orgList")));
        } else {
            QFilter createtimeFilter = new QFilter("createtime", ">=", (Object)changetime);
            QFilter modifytimeFilter = new QFilter("modifytime", ">=", (Object)changetime);
            QFilter timeFilter = createtimeFilter.or(modifytimeFilter);
            qFilter.and(timeFilter);
        }
        DynamicObject[] orgDOs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"fullname ,number, org, org.id\uff0corg.name, parent,parent.id, createtime, modifytime, isfreeze", (QFilter[])new QFilter[]{qFilter}, (String)"level");
        if (orgDOs == null || orgDOs.length < 1) {
            logger.info("Line 68 orgDOs in");
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\uff0c\u7ec4\u7ec7\u66f4\u65b0\uff0c\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"DiDiTripOrgInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        String client_id = supplierMap.get("appkey");
        String access_token = DiDiServiceUtil.getCacheToken(new Date());
        logger.info("Line 76 access_token{}", (Object)access_token);
        if (access_token == null) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\uff0c\u83b7\u53d6\u6ef4\u6ef4token\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"DiDiTripOrgInvoke_1", (String)"fi-er-business", (Object[])new Object[0]));
            this.tripSyncLogParam.setStatus("B");
            return null;
        }
        String company_id = supplierMap.get("orationid");
        int type = 1;
        int budget_cycle = 0;
        int total_quota = 0;
        QFilter uFilter = new QFilter("server", "=", (Object)this.supplier());
        uFilter.and(new QFilter("datatype", "=", (Object)"bos_org"));
        Map<Object, Object> dataMappingMap = TripSyncDataMappingUtil.getDataMappingMapByFilter(uFilter, "innerdataid", "outdataid");
        HashMap<String, JSONArray> postOrgMap = new HashMap<String, JSONArray>();
        JSONArray addOrgList = new JSONArray();
        JSONArray updateOrgList = new JSONArray();
        logger.info("orgDOS size{}", (Object)orgDOs.length);
        Arrays.stream(orgDOs).forEach(orgDO -> {
            String name = orgDO.getString("fullname");
            String out_budget_id = String.valueOf(orgDO.getLong("org.id"));
            HashMap<String, Object> signMap = new HashMap<String, Object>();
            signMap.put("client_id", client_id);
            signMap.put("access_token", access_token);
            signMap.put("company_id", company_id);
            signMap.put("budget_cycle", budget_cycle);
            signMap.put("total_quota", total_quota);
            signMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
            signMap.put("type", type);
            signMap.put("name", name);
            signMap.put("out_budget_id", String.valueOf(out_budget_id));
            String signKey = (String)supplierMap.get("reservedfield1");
            String addDeptSign = DiDiServiceUtil.genSign(signMap, signKey);
            JSONObject addOrgObj = new JSONObject(signMap);
            addOrgObj.put("sign", (Object)addDeptSign);
            addOrgList.add((Object)addOrgObj);
            logger.info("Line 118 addOrgList size{}", (Object)addOrgList.size());
            Object externalOrgId = dataMappingMap.get(Long.valueOf(out_budget_id));
            if (dataMappingMap != null && dataMappingMap.size() > 0 && externalOrgId != null) {
                signMap.put("id", externalOrgId);
                signKey = (String)supplierMap.get("reservedfield1");
                String editDeptSign = DiDiServiceUtil.genSign(signMap, signKey);
                JSONObject editOrgObj = new JSONObject(signMap);
                editOrgObj.put("sign", (Object)editDeptSign);
                editOrgObj.remove((Object)"sign_key");
                updateOrgList.add((Object)editOrgObj);
            }
        });
        logger.info(String.format("addOrgList size %1$s updateOrgList size %2$s", addOrgList.size(), updateOrgList.size()));
        postOrgMap.put("add", addOrgList);
        postOrgMap.put("edit", updateOrgList);
        return postOrgMap;
    }

    protected Object convert(Object info) {
        return info;
    }

    protected String batPushProcess(Object data) {
        Map postOrgJSONArrayMap = (Map)data;
        if (postOrgJSONArrayMap == null || postOrgJSONArrayMap.size() <= 0) {
            String code = "200";
            if (this.tripSyncLogParam.getStatus().equals("B")) {
                code = "300";
            }
            if (StringUtils.isEmpty((CharSequence)this.tripSyncLogParam.getMessage())) {
                this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\uff0c\u7ec4\u7ec7\u66f4\u65b0\uff0c\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"DiDiTripOrgInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            }
            return code;
        }
        AtomicReference<Boolean> successflag = new AtomicReference<Boolean>(true);
        postOrgJSONArrayMap.forEach((syncKey, postOrgJSONArray) -> {
            String url = "";
            switch (syncKey) {
                case "add": {
                    url = (String)ExternalConstants.DIDIURLMAP.get("BudgetCenterAddKey");
                    break;
                }
                case "edit": {
                    url = (String)ExternalConstants.DIDIURLMAP.get("BudgetCenterEditKey");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)url)) {
                Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
                String signKey = supplierMap.get("reservedfield1");
                List<TripSyncDataMappingModel> dataMappingList = DiDiOrgAndUserInvokeUtil.postChangeData(successflag, syncKey, "bos_org", postOrgJSONArray, url, this.supplier(), this.tripSyncLogParam, this.tripSyncLogParamList, signKey);
                TripSyncDataMappingUtil.saveTripSyncDataMapping(dataMappingList);
            }
        });
        String code = "300";
        if (successflag.get().booleanValue()) {
            code = "200";
        }
        return code;
    }
}

