/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.invoke;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.business.trip.model.JourneyModel;
import kd.fi.er.business.trip.model.MulwaytoModel;
import kd.fi.er.business.trip.model.TripReqbillModel;
import kd.fi.er.business.trip.model.TripSyncDataMappingModel;
import kd.fi.er.business.trip.service.function.AbstractTripReqBillInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiTripCarRegulationUtil;
import kd.fi.er.business.trip.util.TripCityUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.util.TripSyncDataMappingUtil;
import kd.fi.er.common.ExternalConstants;
import org.apache.commons.lang.StringUtils;

public class DiDiTripReqBillInvoke
extends AbstractTripReqBillInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(DiDiTripReqBillInvoke.class);
    private static int APPROVAL_TYPE = 1;

    @Override
    protected String supplier() {
        return Supplier.DIDI.name();
    }

    protected Object convert(Object value) {
        String syncStatus;
        switch (syncStatus = (String)this.getParams().get("syncStatus")) {
            case "1": 
            case "3": {
                return this.convertPushBill(value, false);
            }
            case "2": {
                return this.convertStatusChange((TripReqbillModel)value);
            }
        }
        return null;
    }

    protected JSONObject convertPushBill(Object info) {
        return this.convertPushBill(info, false);
    }

    protected JSONObject convertPushBill(Object info, boolean updateFlag) {
        TripReqbillModel reqbill = (TripReqbillModel)info;
        String out_approval_id = reqbill.getBillNo();
        logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u51fa\u5dee\u7533\u8bf7\u5355,\u63a8\u9001\u5355\u636e,\u5f00\u59cb\u6570\u636e\u8f6c\u6362,\u51fa\u5dee\u5355\u53f7:" + out_approval_id);
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        String client_id = supplierMap.get("appkey");
        String company_id = supplierMap.get("orationid");
        String access_token = DiDiServiceUtil.getCacheToken(new Date());
        if (access_token == null) {
            this.tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\uff0c\u51fa\u5dee\u5355\u53f7\uff1a%s\uff0c\u83b7\u53d6\u6ef4\u6ef4token\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!", (String)"DiDiTripReqBillInvoke_0", (String)"fi-er-business", (Object[])new Object[0]), out_approval_id));
            this.tripSyncLogParam.setStatus("B");
            return null;
        }
        String phone = reqbill.getApplyEmpPhone();
        String regulation_id = DiDiTripCarRegulationUtil.getUserTripCarRegulation(phone, "2");
        if (StringUtils.isBlank((String)regulation_id)) {
            this.tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\uff0c\u51fa\u5dee\u5355\u53f7\uff1a%s\uff0c\u83b7\u53d6\u51fa\u5dee\u7528\u8f66\u5236\u5ea6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!", (String)"DiDiTripReqBillInvoke_1", (String)"fi-er-business", (Object[])new Object[0]), out_approval_id));
            this.tripSyncLogParam.setStatus("B");
            return null;
        }
        int approval_type = APPROVAL_TYPE;
        String reason = reqbill.getDesc();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("client_id", client_id);
        signMap.put("company_id", company_id);
        signMap.put("access_token", access_token);
        signMap.put("regulation_id", regulation_id);
        signMap.put("out_approval_id", out_approval_id);
        signMap.put("phone", phone);
        signMap.put("type", 1);
        QFilter uFilter = new QFilter("server", "=", (Object)this.supplier());
        uFilter.and(new QFilter("datatype", "=", (Object)"bos_org"));
        Map<Object, Object> dataOrgMappingMap = TripSyncDataMappingUtil.getDataMappingMapByFilter(uFilter, "innerdataid", "outdataid");
        Object budgetCenterId = null;
        if (dataOrgMappingMap.size() > 0) {
            budgetCenterId = TripSyncDataMappingUtil.getBudgetCenterId(null, reqbill, dataOrgMappingMap);
        }
        if (budgetCenterId != null) {
            signMap.put("budget_center_id", budgetCenterId);
        }
        signMap.put("approval_type", approval_type);
        signMap.put("reason", reason.trim());
        JSONObject travelDetailInfo = this.converTravelDetailInfo(reqbill);
        signMap.put("travel_detail", travelDetailInfo.toString());
        signMap.put("timestamp", timestamp);
        JSONArray companions = this.setCompanions(reqbill);
        signMap.put("passenger_list", companions.toString());
        JSONObject tripReqObj = new JSONObject();
        if (updateFlag) {
            QFilter updateFilter = new QFilter("server", "=", (Object)this.supplier());
            updateFilter.and(new QFilter("datatype", "=", (Object)"er_tripreq"));
            updateFilter.and(new QFilter("number", "=", (Object)out_approval_id));
            Map<Object, Object> updateDataOrgMappingMap = TripSyncDataMappingUtil.getDataMappingMapByFilter(updateFilter, "number", "outdataid");
            Object o = updateDataOrgMappingMap.get(out_approval_id);
            if (o != null) {
                signMap.put("approval_id", o);
                tripReqObj.put("approval_id", o);
            } else if (null != this.params.get("approval_id")) {
                signMap.put("approval_id", this.params.get("approval_id"));
                tripReqObj.put("approval_id", this.params.get("approval_id"));
            }
        }
        String tripreqSignKey = DiDiServiceUtil.genSign(signMap, supplierMap.get("reservedfield1"));
        tripReqObj.put("client_id", (Object)client_id);
        tripReqObj.put("company_id", (Object)company_id);
        tripReqObj.put("access_token", (Object)access_token);
        tripReqObj.put("timestamp", (Object)timestamp);
        tripReqObj.put("regulation_id", (Object)regulation_id);
        tripReqObj.put("out_approval_id", (Object)out_approval_id);
        tripReqObj.put("phone", (Object)phone);
        tripReqObj.put("approval_type", (Object)approval_type);
        tripReqObj.put("type", (Object)1);
        if (budgetCenterId != null) {
            tripReqObj.put("budget_center_id", budgetCenterId);
        }
        tripReqObj.put("reason", (Object)reason.trim());
        tripReqObj.put("travel_detail", (Object)travelDetailInfo);
        tripReqObj.put("passenger_list", (Object)companions);
        tripReqObj.put("sign", (Object)tripreqSignKey);
        return tripReqObj;
    }

    private JSONArray setCompanions(TripReqbillModel reqbill) {
        boolean paramValue = TripSyncConfigUtil.getBoolean("Reservation_ personnel_range", Boolean.FALSE);
        JSONArray jsonArray = new JSONArray();
        if (paramValue) {
            List<JourneyModel> journeyModelList = reqbill.getJourneyModelList();
            int size = journeyModelList.size();
            ArrayList userNumberList = Lists.newArrayListWithCapacity((int)16);
            for (int i = 0; i < size; ++i) {
                JourneyModel journeyModel = journeyModelList.get(i);
                Set<DynamicObject> travelers = journeyModel.getTravelers();
                Set travelNumberSet = travelers.stream().filter(traveler -> StringUtils.isNotEmpty((String)traveler.getString("number"))).map(traveler -> traveler.getString("number")).collect(Collectors.toSet());
                userNumberList.addAll(travelNumberSet);
            }
            if (!userNumberList.contains(reqbill.getCreatEmpNum())) {
                userNumberList.add(reqbill.getCreatEmpNum());
            }
            if (!userNumberList.contains(reqbill.getApplyEmpNum())) {
                userNumberList.add(reqbill.getApplyEmpNum());
            }
            if (CollectionUtils.isEmpty((Collection)userNumberList)) {
                return jsonArray;
            }
            DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)"number,name,id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)userNumberList)});
            for (DynamicObject user : users) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("member_type", (Object)"1");
                jsonObject.put("passenger_type", (Object)"0");
                jsonObject.put("employee_number", (Object)user.getString("number"));
                jsonObject.put("passenger_name", (Object)user.getString("name"));
                jsonArray.add((Object)jsonObject);
            }
        } else {
            String creatEmpNum = reqbill.getCreatEmpNum();
            String applyEmpNum = reqbill.getApplyEmpNum();
            if (StringUtils.isNotEmpty((String)creatEmpNum) && StringUtils.isNotEmpty((String)applyEmpNum) && creatEmpNum.equals(applyEmpNum)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("member_type", (Object)"1");
                jsonObject.put("passenger_type", (Object)"0");
                jsonObject.put("employee_number", (Object)creatEmpNum);
                jsonObject.put("passenger_name", (Object)reqbill.getCreatEmpName());
                jsonArray.add((Object)jsonObject);
            } else {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("member_type", (Object)"1");
                jsonObject.put("passenger_type", (Object)"0");
                jsonObject.put("employee_number", (Object)creatEmpNum);
                jsonObject.put("passenger_name", (Object)reqbill.getCreatEmpName());
                jsonArray.add((Object)jsonObject);
                jsonObject = new JSONObject();
                jsonObject.put("member_type", (Object)"1");
                jsonObject.put("passenger_type", (Object)"0");
                jsonObject.put("employee_number", (Object)applyEmpNum);
                jsonObject.put("passenger_name", (Object)reqbill.getApplyEmpName());
                jsonArray.add((Object)jsonObject);
            }
        }
        return jsonArray;
    }

    private JSONObject converTravelDetailInfo(TripReqbillModel reqbill) {
        JSONObject travelDetailInfo = new JSONObject();
        List<JourneyModel> tripentryList = reqbill.getJourneyModelList();
        if (tripentryList != null && tripentryList.size() > 0) {
            Date firstStartDate = tripentryList.get(0).getStartDate();
            Date endStartDate = tripentryList.get(tripentryList.size() - 1).getEndDate();
            DynamicObject tripControlsetting = TripCommonUtil.getTripControlSettings(reqbill.getCompanyId(), this.supplier());
            int start_city_rule = 1;
            int end_city_rule = 1;
            if (null != tripControlsetting && null != tripControlsetting.getString("startcityrule")) {
                start_city_rule = Integer.parseInt(tripControlsetting.getString("startcityrule"));
            }
            if (null != tripControlsetting && null != tripControlsetting.getString("endcityrule")) {
                end_city_rule = Integer.parseInt(tripControlsetting.getString("endcityrule"));
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("start_date", TripCommonUtil.date2TimeStamp(firstStartDate, "yyyy-MM-dd"));
            paramMap.put("end_date", TripCommonUtil.date2TimeStamp(endStartDate, "yyyy-MM-dd"));
            JSONArray trips = this.getTrips(new JSONArray(), tripentryList, paramMap);
            travelDetailInfo.put("start_date", (Object)TripCommonUtil.date2TimeStamp(firstStartDate, "yyyy-MM-dd"));
            travelDetailInfo.put("end_date", (Object)TripCommonUtil.date2TimeStamp(endStartDate, "yyyy-MM-dd"));
            travelDetailInfo.put("trips", (Object)trips);
            travelDetailInfo.put("start_city_rule", (Object)start_city_rule);
            travelDetailInfo.put("end_city_rule", (Object)end_city_rule);
        }
        return travelDetailInfo;
    }

    private JSONArray getTrips(JSONArray trips, List<JourneyModel> tripentryList, Map<String, Object> paramMap) {
        int dtrip_to_citys = TripSyncConfigUtil.getIntValue("dtrip_to_citys", 0);
        if (dtrip_to_citys == 1) {
            JSONObject tripObj = new JSONObject();
            if (tripentryList == null || tripentryList.size() == 0) {
                logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u51fa\u5dee\u7533\u8bf7\u5355,tripentryList\u4e3a\u7a7a");
                return trips;
            }
            JourneyModel tripentry = tripentryList.get(0);
            tripObj.put("departure_city", (Object)tripentry.getFromCity());
            tripObj.put("departure_city_id", TripCityUtil.getDiDiCityId(tripentry.getFromCityID()).get(tripentry.getFromCityID()));
            tripObj.put("start_date", paramMap.get("start_date"));
            tripObj.put("end_date", paramMap.get("end_date"));
            tripObj.put("trip_type", (Object)"1,2");
            tripObj.put("to_citys", this.getToCitys(tripentryList));
            trips.add((Object)tripObj);
        } else {
            for (int i = 0; i < tripentryList.size(); ++i) {
                JSONObject tripObj = new JSONObject();
                JourneyModel tripentry = tripentryList.get(i);
                tripObj.put("departure_city_id", TripCityUtil.getDiDiCityId(tripentry.getFromCityID()).get(tripentry.getFromCityID()));
                tripObj.put("destination_city_id", TripCityUtil.getDiDiCityId(tripentry.getToCityID()).get(tripentry.getToCityID()));
                tripObj.put("departure_city", (Object)tripentry.getFromCity());
                tripObj.put("destination_city", (Object)tripentry.getToCity());
                tripObj.put("start_date", (Object)TripCommonUtil.date2TimeStamp(tripentry.getStartDate(), "yyyy-MM-dd"));
                tripObj.put("end_date", (Object)TripCommonUtil.date2TimeStamp(tripentry.getEndDate(), "yyyy-MM-dd"));
                tripObj.put("trip_type", (Object)"1,2");
                trips.add((Object)tripObj);
            }
            JSONObject tripObj = new JSONObject();
            tripObj.put("departure_city_id", (Object)trips.getJSONObject(trips.size() - 1).getString("destination_city_id"));
            tripObj.put("destination_city_id", (Object)trips.getJSONObject(0).getString("departure_city_id"));
            tripObj.put("departure_city", (Object)trips.getJSONObject(trips.size() - 1).getString("destination_city"));
            tripObj.put("destination_city", (Object)trips.getJSONObject(0).getString("departure_city"));
            tripObj.put("start_date", (Object)trips.getJSONObject(trips.size() - 1).getString("end_date"));
            tripObj.put("end_date", (Object)trips.getJSONObject(trips.size() - 1).getString("end_date"));
            tripObj.put("trip_type", (Object)"1,2");
            trips.add((Object)tripObj);
        }
        return trips;
    }

    private Object getToCitys(List<JourneyModel> tripentryList) {
        JSONArray to_citys = new JSONArray();
        HashSet<Long> toCitySet = new HashSet<Long>();
        for (JourneyModel journeyModel : tripentryList) {
            toCitySet.add(journeyModel.getFromCityID());
            toCitySet.add(journeyModel.getToCityID());
            Set<MulwaytoModel> mulwaytos = journeyModel.getMulwaytos();
            if (mulwaytos == null) continue;
            for (MulwaytoModel obj : mulwaytos) {
                if (obj == null) continue;
                MulwaytoModel mulwayto = obj;
                toCitySet.add(mulwayto.getToCityID());
            }
        }
        QFilter filter = new QFilter("id", "in", toCitySet);
        Map cities = BusinessDataServiceHelper.loadFromCache((String)"er_city", (String)"id,didicityid,admindivisionid.name", (QFilter[])new QFilter[]{filter});
        if (cities == null) {
            return to_citys;
        }
        for (DynamicObject city : cities.values()) {
            DynamicObject admindivisionid = city.getDynamicObject("admindivisionid");
            if (admindivisionid == null || !StringUtils.isNotBlank((String)admindivisionid.getString("name"))) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)city.getLong("didicityid"));
            jsonObject.put("name", (Object)admindivisionid.getString("name"));
            to_citys.add((Object)jsonObject);
        }
        return to_citys;
    }

    private JSONObject convertStatusChange(TripReqbillModel reqbill) {
        String out_approval_id = reqbill.getBillNo();
        logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u51fa\u5dee\u7533\u8bf7\u5355,\u53d6\u6d88\u5355\u636e,\u5f00\u59cb\u6570\u636e\u8f6c\u6362,\u51fa\u5dee\u5355\u53f7:" + out_approval_id);
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        String client_id = supplierMap.get("appkey");
        String company_id = supplierMap.get("orationid");
        String access_token = DiDiServiceUtil.getCacheToken(new Date());
        if (access_token == null) {
            this.tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\uff0c\u51fa\u5dee\u5355\u53f7\uff1a%s\uff0c\u83b7\u53d6\u6ef4\u6ef4token\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e!", (String)"DiDiTripReqBillInvoke_0", (String)"fi-er-business", (Object[])new Object[0]), out_approval_id));
            this.tripSyncLogParam.setStatus("B");
            return null;
        }
        QFilter uFilter = new QFilter("server", "=", (Object)this.supplier());
        uFilter.and(new QFilter("datatype", "=", (Object)"er_tripreq"));
        Map<Object, Object> dataTripReqMappingMap = TripSyncDataMappingUtil.getDataMappingMapByFilter(uFilter, "number", "outdataid");
        Object tripReqBillId = dataTripReqMappingMap.get(out_approval_id);
        if (dataTripReqMappingMap != null && dataTripReqMappingMap.size() > 0 && tripReqBillId != null) {
            String approval_id = String.valueOf(tripReqBillId);
            if (approval_id == null || StringUtils.isEmpty((String)approval_id)) {
                this.tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\uff0c\u51fa\u5dee\u5355\u53f7\uff1a%s\uff0c\u83b7\u53d6\u6ef4\u6ef4\u4fa7\u51fa\u5dee\u7533\u8bf7\u5355id\u4e3a\u7a7a\uff0c\u8be5\u5355\u636e\u5c1a\u672a\u63a8\u9001,\u6682\u4e0d\u9700\u8981\u53d6\u6d88!", (String)"DiDiTripReqBillInvoke_2", (String)"fi-er-business", (Object[])new Object[0]), out_approval_id));
                this.tripSyncLogParam.setStatus("A");
                return null;
            }
            String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
            HashMap<String, Object> signMap = new HashMap<String, Object>();
            signMap.put("client_id", client_id);
            signMap.put("company_id", company_id);
            signMap.put("access_token", access_token);
            signMap.put("approval_id", approval_id);
            signMap.put("timestamp", timestamp);
            String tripreqCloseSignKey = DiDiServiceUtil.genSign(signMap, supplierMap.get("reservedfield1"));
            JSONObject tripreqCloseObj = new JSONObject(signMap);
            tripreqCloseObj.put("sign", (Object)tripreqCloseSignKey);
            return tripreqCloseObj;
        }
        return null;
    }

    protected String batPushProcess(Object value) {
        String syncStatus;
        if (value == null) {
            String code = "200";
            if (this.tripSyncLogParam.getStatus().equals("B")) {
                code = "300";
            }
            return code;
        }
        String jsonStr = JSON.toJSONString((Object)value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        String url = "";
        switch (syncStatus = (String)this.getParams().get("syncStatus")) {
            case "1": 
            case "3": {
                url = (String)ExternalConstants.DIDIURLMAP.get("approvalAddKey");
                break;
            }
            case "2": {
                url = (String)ExternalConstants.DIDIURLMAP.get("approvalCancelKey");
            }
        }
        this.tripSyncLogParam.setRequestdata(value);
        this.tripSyncLogParam.setRequesturl(url);
        String result = HttpRetryServiceHelper.PostData(url, jsonStr);
        this.tripSyncLogParam.setResponsedata(result);
        JSONObject resultJsonObject = JSONObject.parseObject((String)result);
        ArrayList<TripSyncDataMappingModel> dataMappingList = new ArrayList<TripSyncDataMappingModel>();
        if (resultJsonObject == null || resultJsonObject.getIntValue("errno") != 0 && resultJsonObject.getIntValue("errno") != 50506) {
            this.tripSyncLogParam.setStatus("B");
            return "300";
        }
        if (resultJsonObject.getIntValue("errno") == 50506) {
            logger.info("didi update api");
            String errmsg = resultJsonObject.getString("errmsg");
            if (null == errmsg) {
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u6ef4\u6ef4\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65\uff1a{}", (Object)resultJsonObject.toJSONString());
                return "300";
            }
            if (null == (errmsg = errmsg.substring(errmsg.lastIndexOf("("), errmsg.lastIndexOf(")")))) {
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u6ef4\u6ef4\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65\uff1a{}", (Object)resultJsonObject.toJSONString());
                return "300";
            }
            StringBuilder sb = new StringBuilder();
            for (char c : errmsg.toCharArray()) {
                if (!Character.isDigit(c)) continue;
                sb.append(c);
            }
            this.dealData(jsonStr);
            TripSyncDataMappingModel TripSyncDataMappingObj = new TripSyncDataMappingModel("er_tripreq", this.supplier());
            String outdataid = sb.toString();
            JSONObject reqJson = JSONObject.parseObject((String)jsonStr);
            String out_approval_id = reqJson.getString("out_approval_id");
            TripSyncDataMappingObj.setNumber(out_approval_id);
            TripSyncDataMappingObj.setOutdataid(Long.parseLong(outdataid));
            dataMappingList.add(TripSyncDataMappingObj);
            TripSyncDataMappingUtil.saveTripSyncDataMapping(dataMappingList);
            Object updateValue = this.redealJson();
            String updateJsonStr = JSON.toJSONString((Object)updateValue, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            TripSyncLogParam updateTripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), this.supplier(), this.function());
            String updateUrl = (String)ExternalConstants.DIDIURLMAP.get("approvalUpdateKey");
            updateTripSyncLogParam.setRequestdata(updateValue);
            Object billId = this.getParams().get("billId");
            updateTripSyncLogParam.setBillno(String.valueOf(billId));
            updateTripSyncLogParam.setRequesturl(updateUrl);
            String updateResult = HttpRetryServiceHelper.PostData(updateUrl, updateJsonStr);
            updateTripSyncLogParam.setResponsedata(updateResult);
            JSONObject updateResultJsonObject = JSONObject.parseObject((String)updateResult);
            if (updateResultJsonObject == null || updateResultJsonObject.getIntValue("errno") != 0) {
                updateTripSyncLogParam.setStatus("B");
            } else {
                updateTripSyncLogParam.setStatus("A");
            }
            TripSyncLogUtils.saveErrorLog(Collections.singletonList(updateTripSyncLogParam));
            return "200";
        }
        this.tripSyncLogParam.setStatus("A");
        if (StringUtils.equals((String)syncStatus, (String)"1") || StringUtils.equals((String)syncStatus, (String)"3")) {
            this.dealData(jsonStr);
            TripSyncDataMappingModel TripSyncDataMappingObj = new TripSyncDataMappingModel("er_tripreq", this.supplier());
            JSONObject data = JSON.parseObject((String)JSON.toJSONString((Object)resultJsonObject.get((Object)"data")));
            String outdataid = data.getString("approval_id");
            String billNo = JSON.parseObject((String)JSON.toJSONString((Object)value)).getString("out_approval_id");
            TripSyncDataMappingObj.setNumber(billNo);
            TripSyncDataMappingObj.setOutdataid(Long.parseLong(outdataid));
            dataMappingList.add(TripSyncDataMappingObj);
        }
        TripSyncDataMappingUtil.saveTripSyncDataMapping(dataMappingList);
        return "200";
    }

    private void dealData(String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        if (jsonObject != null) {
            String applyNumber = jsonObject.getString("out_approval_id");
            DeleteServiceHelper.delete((String)"er_tripsync_datamapping", (QFilter[])new QFilter[]{new QFilter("server", "=", (Object)this.supplier()), new QFilter("number", "=", (Object)applyNumber)});
        }
    }

    private static String gbEncoding(String s) {
        char[] c;
        StringBuilder buf = new StringBuilder();
        for (char tmp : c = s.toCharArray()) {
            buf = tmp > '\u00ff' ? buf.append("\\u").append(Integer.toHexString(tmp)) : buf.append(tmp);
        }
        return buf.toString();
    }

    private Object redealJson() {
        Object innerData = this.getInnerData();
        return this.convertPushBill(innerData, true);
    }
}

