/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.invoke.checking;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.CheckingBillHeaderModel;
import kd.fi.er.business.trip.model.CheckingBillModel;
import kd.fi.er.business.trip.model.VehicleCheckingBillDetailModel;
import kd.fi.er.business.trip.service.function.AbstractCheckingInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiTripPropMapping;
import kd.fi.er.business.trip.supplier.didi.systemexternal.IOffsetCaculateAble;
import kd.fi.er.business.trip.supplier.didi.systemexternal.TripJSONAnalysisConstruct;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.util.TripSyncDataMappingUtil;
import kd.fi.er.common.ExternalConstants;
import org.apache.commons.lang.StringUtils;

public class DiDiTripCheckingInvoke
extends AbstractCheckingInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(DiDiTripCheckingInvoke.class);
    private static final int[] BILLDETAIL_TYPE = new int[]{1, 2, 3};

    @Override
    protected String supplier() {
        return Supplier.DIDI.name();
    }

    protected Object process(Map params) {
        if (params != null && params.get("jsondata") != null) {
            JSONObject paramJson = JSONObject.parseObject((String)((String)params.get("jsondata")));
            if (paramJson.isEmpty()) {
                logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u7ed3\u7b97\u5355,\u96c6\u6210\u5de5\u5177\u8c03\u8bd5\u53c2\u6570\u89e3\u6790\u4e3a\u7a7a\uff01");
                return null;
            }
            JSONArray bills = paramJson.getJSONArray("bills");
            ArrayList<DiDiCheckingBillInfo> re = new ArrayList<DiDiCheckingBillInfo>(16);
            for (int i = 0; i < bills.size(); ++i) {
                JSONObject bill = bills.getJSONObject(i);
                JSONObject summary = new JSONObject();
                JSONArray detail = new JSONArray();
                JSONArray transactionDetail = new JSONArray();
                if (null != bill.getJSONObject("summary") && null != bill.getJSONObject("summary").getJSONObject("data")) {
                    summary = bill.getJSONObject("summary").getJSONObject("data");
                }
                if (null != bill.getJSONObject("detail") && null != bill.getJSONObject("detail").getJSONObject("data") && null != bill.getJSONObject("detail").getJSONObject("data").getJSONArray("orders")) {
                    detail = bill.getJSONObject("detail").getJSONObject("data").getJSONArray("orders");
                }
                if (null != bill.getJSONObject("transaction") && null != bill.getJSONObject("transaction").getJSONObject("data") && null != bill.getJSONObject("transaction").getJSONObject("data").getJSONArray("transaction_list")) {
                    transactionDetail = bill.getJSONObject("transaction").getJSONObject("data").getJSONArray("transaction_list");
                }
                DiDiCheckingBillInfo billInfo = new DiDiCheckingBillInfo(summary, detail, transactionDetail);
                re.add(billInfo);
            }
            JSONObject resutJson = new JSONObject();
            resutJson.put("result", re);
            resutJson.put("idMap", (Object)Maps.newHashMapWithExpectedSize((int)16));
            return resutJson;
        }
        HashMap billIdAndOutBudgetIdMap = Maps.newHashMapWithExpectedSize((int)16);
        List<DiDiCheckingBillInfo> result = this.getDiDiCheckingBillInfo(params, billIdAndOutBudgetIdMap);
        logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u7ed3\u7b97\u5355,\u83b7\u53d6\u6ef4\u6ef4\u7ed3\u7b97\u5355\u6570\u636e\u7ed3\u675f-------------");
        JSONObject resutJson = new JSONObject();
        resutJson.put("result", result);
        resutJson.put("idMap", (Object)billIdAndOutBudgetIdMap);
        return resutJson;
    }

    protected Object convert(Object o) {
        JSONObject jsonObject = (JSONObject)o;
        List checkingBillInfoList = (List)jsonObject.get((Object)"result");
        if (checkingBillInfoList == null || checkingBillInfoList.size() < 1) {
            return null;
        }
        ArrayList<CheckingBillModel> checkingBillModelList = new ArrayList<CheckingBillModel>(checkingBillInfoList.size());
        Map idMap = (Map)jsonObject.get((Object)"idMap");
        for (int i = 0; i < checkingBillInfoList.size(); ++i) {
            CheckingBillModel carCheckingBillModel = new CheckingBillModel();
            DiDiCheckingBillInfo checkingBillInfo = (DiDiCheckingBillInfo)checkingBillInfoList.get(i);
            JSONObject headInfo = checkingBillInfo.getBillSummaryInfo();
            this.batchPassenger(checkingBillInfo);
            CheckingBillHeaderModel headerModel = this.checkingBillHeadConvert(headInfo, idMap);
            carCheckingBillModel.setCheckingBillHeaderModel(headerModel);
            List<AbstractCheckingBillDetailModel> carCheckingBillDetailModelList = this.checkingBillDetailConvert(headerModel, checkingBillInfo.getBillDetailInfo(), checkingBillInfo.getTransactionDetailInfo());
            if (null == carCheckingBillDetailModelList || carCheckingBillDetailModelList.isEmpty()) continue;
            carCheckingBillModel.setCheckingBillDetailModels(carCheckingBillDetailModelList);
            checkingBillModelList.add(carCheckingBillModel);
        }
        return checkingBillModelList;
    }

    private void batchPassenger(DiDiCheckingBillInfo checkingBillInfo) {
        JSONObject detailInfo;
        int i;
        JSONObject detailInfo2;
        int i2;
        JSONArray billDetailInfo = checkingBillInfo.getBillDetailInfo();
        JSONArray transactionDetailInfo = checkingBillInfo.getTransactionDetailInfo();
        HashSet<Long> memberids = new HashSet<Long>(transactionDetailInfo.size() * billDetailInfo.size());
        HashSet<String> phones = new HashSet<String>(transactionDetailInfo.size() * billDetailInfo.size());
        for (i2 = 0; i2 < billDetailInfo.size(); ++i2) {
            detailInfo2 = billDetailInfo.getJSONObject(i2);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)detailInfo2.getString("member_id"))) {
                memberids.add(detailInfo2.getLong("member_id"));
                continue;
            }
            phones.add(detailInfo2.getString("passenger_phone"));
        }
        for (i2 = 0; i2 < transactionDetailInfo.size(); ++i2) {
            detailInfo2 = transactionDetailInfo.getJSONObject(i2);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)detailInfo2.getString("member_id"))) {
                memberids.add(detailInfo2.getLong("member_id"));
                continue;
            }
            phones.add(detailInfo2.getString("passenger_phone"));
        }
        Map<Object, Object> dataMapping = null;
        if (null != memberids && !memberids.isEmpty()) {
            QFilter qFilter = new QFilter("outdataid", "in", memberids);
            qFilter.and("datatype", "=", (Object)"bos_user");
            dataMapping = TripSyncDataMappingUtil.getDataMappingMapByFilter(qFilter, "outdataid", "number");
        }
        if (null != dataMapping && !dataMapping.isEmpty()) {
            for (i = 0; i < billDetailInfo.size(); ++i) {
                detailInfo = billDetailInfo.getJSONObject(i);
                if (null != dataMapping.get(detailInfo.getLong("member_id"))) {
                    detailInfo.put("passenger", dataMapping.get(detailInfo.getLong("member_id")));
                    continue;
                }
                phones.add(detailInfo.getString("passenger_phone"));
            }
            for (i = 0; i < transactionDetailInfo.size(); ++i) {
                detailInfo = transactionDetailInfo.getJSONObject(i);
                if (null != dataMapping.get(detailInfo.getLong("member_id"))) {
                    detailInfo.put("passenger", dataMapping.get(detailInfo.getLong("member_id")));
                    continue;
                }
                phones.add(detailInfo.getString("passenger_phone"));
            }
        } else {
            for (i = 0; i < billDetailInfo.size(); ++i) {
                detailInfo = billDetailInfo.getJSONObject(i);
                phones.add(detailInfo.getString("passenger_phone"));
            }
            for (i = 0; i < transactionDetailInfo.size(); ++i) {
                detailInfo = transactionDetailInfo.getJSONObject(i);
                phones.add(detailInfo.getString("passenger_phone"));
            }
        }
        HashMap userMap = new HashMap(8);
        phones.removeIf(org.apache.commons.lang3.StringUtils::isBlank);
        if (!phones.isEmpty()) {
            int intValue = TripSyncConfigUtil.getIntValue("trip_sync_order_size", 100);
            ArrayList collect = new ArrayList(phones);
            logger.info("phones.size:{}", (Object)phones.size());
            List partition = Lists.partition(collect, (int)intValue);
            for (List phoneList : partition) {
                Map puserMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,number,phone", (QFilter[])new QFilter[]{new QFilter("phone", "in", (Object)phoneList)});
                if (null == puserMap) continue;
                userMap.putAll(puserMap);
            }
        }
        if (null != userMap && !userMap.isEmpty()) {
            DynamicObject user;
            JSONObject detailInfo3;
            int i3;
            HashMap dataMappingMap = new HashMap(8);
            HashMap finalUserMap = userMap;
            userMap.values().stream().forEach(mapping -> dataMappingMap.put(mapping.getString("phone"), finalUserMap.get("id")));
            for (i3 = 0; i3 < billDetailInfo.size(); ++i3) {
                detailInfo3 = billDetailInfo.getJSONObject(i3);
                user = (DynamicObject)dataMappingMap.get(detailInfo3.getString("passenger_phone"));
                if (user == null || detailInfo3.getString("passenger") != null && !detailInfo3.getString("passenger").trim().isEmpty() || !user.getString("phone").equals(detailInfo3.getString("passenger_phone"))) continue;
                detailInfo3.put("passenger", (Object)user.getString("number"));
                break;
            }
            for (i3 = 0; i3 < transactionDetailInfo.size(); ++i3) {
                detailInfo3 = transactionDetailInfo.getJSONObject(i3);
                user = (DynamicObject)dataMappingMap.get(detailInfo3.getString("passenger_phone"));
                if (user == null || detailInfo3.getString("passenger") != null && !detailInfo3.getString("passenger").trim().isEmpty() || !user.getString("phone").equals(detailInfo3.getString("passenger_phone"))) continue;
                detailInfo3.put("passenger", (Object)user.getString("number"));
                break;
            }
        }
    }

    private CheckingBillHeaderModel checkingBillHeadConvert(JSONObject headJson, Map<String, String> idMap) {
        CheckingBillHeaderModel headerModel = new CheckingBillHeaderModel();
        headerModel.setServer(Supplier.DIDI.name());
        String bill_id = headJson.getString("bill_id");
        headerModel.setBillNo(bill_id);
        headerModel.setSettlemain(idMap.get(bill_id));
        String billPeriod = headJson.getString("bill_period");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)billPeriod)) {
            String startDateStr;
            billPeriod = billPeriod.replaceAll("\\s", "");
            String endDateStr = null;
            if (billPeriod.length() > 11) {
                startDateStr = billPeriod.substring(0, 10);
                endDateStr = billPeriod.substring(11);
            } else {
                startDateStr = billPeriod;
            }
            headerModel.setPeriodStartDate(TripCommonUtil.convertToDate(startDateStr));
            headerModel.setPeriodEndDate(TripCommonUtil.convertToDate(endDateStr));
        }
        headerModel.setBillstatusname("1");
        headerModel.setSettlementAmount(headJson.getBigDecimal("amount_money"));
        return headerModel;
    }

    private List<AbstractCheckingBillDetailModel> checkingBillDetailConvert(CheckingBillHeaderModel headerModel, JSONArray billDetailInfo, JSONArray transactionDetailInfo) {
        int detailSize = 0;
        if (billDetailInfo != null) {
            detailSize += billDetailInfo.size();
        }
        if (transactionDetailInfo != null) {
            detailSize += transactionDetailInfo.size();
        }
        if (detailSize == 0) {
            return new ArrayList<AbstractCheckingBillDetailModel>(1);
        }
        ArrayList<AbstractCheckingBillDetailModel> carCheckingBillDetailModelList = new ArrayList<AbstractCheckingBillDetailModel>(detailSize);
        List<AbstractCheckingBillDetailModel> billDetailModelList = this.billDetailConvert(headerModel, billDetailInfo);
        List<AbstractCheckingBillDetailModel> transactionlDetailModelList = this.transactionlDetailConvert(headerModel, transactionDetailInfo);
        if (billDetailModelList != null) {
            carCheckingBillDetailModelList.addAll(billDetailModelList);
        }
        if (transactionlDetailModelList != null) {
            carCheckingBillDetailModelList.addAll(transactionlDetailModelList);
        }
        return carCheckingBillDetailModelList;
    }

    private List<AbstractCheckingBillDetailModel> billDetailConvert(CheckingBillHeaderModel headerModel, JSONArray billDetailInfoList) {
        if (billDetailInfoList == null) {
            return null;
        }
        ArrayList<AbstractCheckingBillDetailModel> billDetailModelList = new ArrayList<AbstractCheckingBillDetailModel>(billDetailInfoList.size());
        for (int i = 0; i < billDetailInfoList.size(); ++i) {
            JSONObject detailInfo = billDetailInfoList.getJSONObject(i);
            if (detailInfo == null) continue;
            VehicleCheckingBillDetailModel checkingBillDetailModel = this.detailConvert(headerModel, detailInfo);
            String orderNum = detailInfo.getString("order_id");
            Date payDate = TripCommonUtil.convertToDate(detailInfo.getString("pay_time"));
            checkingBillDetailModel.setParentordernum(orderNum);
            Date periodStartDate = headerModel.getPeriodStartDate();
            if (payDate != null && null != periodStartDate && payDate.before(periodStartDate)) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");
                orderNum = orderNum + "-" + dateFormat.format(periodStartDate);
                checkingBillDetailModel.setServiceFee(BigDecimal.ZERO);
                BigDecimal payAmount = BigDecimal.ZERO.subtract(detailInfo.getBigDecimal("company_real_refund"));
                checkingBillDetailModel.setTotalAmount(payAmount);
                checkingBillDetailModel.setDealAmount(payAmount);
            }
            checkingBillDetailModel.setOrderNum(orderNum);
            billDetailModelList.add(checkingBillDetailModel);
        }
        return billDetailModelList;
    }

    private List<AbstractCheckingBillDetailModel> transactionlDetailConvert(CheckingBillHeaderModel headerModel, JSONArray transactionDetailInfo) {
        if (transactionDetailInfo == null) {
            return null;
        }
        ArrayList<AbstractCheckingBillDetailModel> billDetailModelList = new ArrayList<AbstractCheckingBillDetailModel>(transactionDetailInfo.size());
        for (int i = 0; i < transactionDetailInfo.size(); ++i) {
            JSONObject detailInfo = transactionDetailInfo.getJSONObject(i);
            if (!"\u7ebf\u4e0b\u7528\u8f66\u4f01\u4e1a\u652f\u4ed8".equals(detailInfo.getString("type")) && !"\u4e2a\u4eba\u8f6c\u4f01\u4e1a\u652f\u4ed8\u6263\u6b3e".equals(detailInfo.getString("type"))) continue;
            VehicleCheckingBillDetailModel checkingBillDetailModel = this.detailConvert(headerModel, detailInfo);
            if (detailInfo == null) continue;
            StringBuilder orderNum = new StringBuilder();
            String orderId = detailInfo.getString("order_id");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)orderId) || orderId.equals("0")) {
                orderId = detailInfo.getString("transaction_id");
                orderNum = orderNum.append(orderId);
            } else {
                orderNum.append(orderId);
                Date periodStartDate = headerModel.getPeriodStartDate();
                Date payDate = TripCommonUtil.convertToDate(detailInfo.getString("pay_time"));
                if (payDate != null && payDate.before(periodStartDate)) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");
                    orderNum = orderNum.append("-").append(dateFormat.format(periodStartDate));
                }
            }
            BigDecimal payAmount = detailInfo.getBigDecimal("out_money");
            checkingBillDetailModel.setTotalAmount(payAmount);
            checkingBillDetailModel.setDealAmount(payAmount);
            checkingBillDetailModel.setParentordernum(orderId);
            checkingBillDetailModel.setOrderNum(orderNum.toString());
            billDetailModelList.add(checkingBillDetailModel);
        }
        return billDetailModelList;
    }

    private VehicleCheckingBillDetailModel detailConvert(CheckingBillHeaderModel headerModel, JSONObject detailInfo) {
        String productType;
        if (detailInfo == null) {
            return null;
        }
        String billId = headerModel.getBillNo();
        VehicleCheckingBillDetailModel detail = new VehicleCheckingBillDetailModel();
        detail.setBillPeriod(headerModel.getPeriodStartDate());
        String pay_type = detailInfo.getString("pay_type");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pay_type)) {
            detail.setProductType(DiDiTripPropMapping.getPayTypeByStr(pay_type));
        }
        String string = productType = detail.getProductType() == null ? "" : detail.getProductType().getKey();
        if (StringUtils.equals((String)productType, (String)"1")) {
            detail.setOrderNatrue(AbstractOrderModel.OrderNatrue.A);
        } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)productType)) {
            detail.setOrderNatrue(AbstractOrderModel.OrderNatrue.B);
        }
        detail.setBatchno(billId);
        detail.setOaBillNum(detailInfo.getString("out_approval_id"));
        detail.setOrderDate(TripCommonUtil.convertToDate(detailInfo.getString("create_time")));
        detail.setHappendDate(TripCommonUtil.convertToDate(detailInfo.getString("pay_time")));
        detail.setSourceBookedId(detailInfo.getString("employee_number"));
        detail.setBookedname(detailInfo.getString("member_name"));
        detail.setPasseger(detailInfo.getString("passenger"));
        detail.setPassegerName(detailInfo.getString("passenger_name"));
        String statusPram = detailInfo.getString("status");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)statusPram)) {
            detail.setOrderstatus(DiDiTripPropMapping.setCheckingOrderStatus(statusPram).getKey());
        }
        BigDecimal payAmount = detailInfo.getBigDecimal("company_real_pay").subtract(detailInfo.getBigDecimal("company_real_refund"));
        detail.setTotalAmount(payAmount);
        detail.setDealAmount(payAmount);
        detail.setServiceFee(detailInfo.getBigDecimal("discount_after_price"));
        detail.setPersonalFee(detailInfo.getBigDecimal("personal_real_pay"));
        detail.setCityName(detailInfo.getString("city"));
        detail.setDepartAddress(detailInfo.getString("actual_start_name"));
        detail.setArriveAddress(detailInfo.getString("actual_end_name"));
        detail.setUseTime(detailInfo.getDate("begin_charge_time"));
        detail.setDistance(detailInfo.getString("normal_distance"));
        detail.setTravelWays(detailInfo.getString("rule_name"));
        String budgetId = detailInfo.getString("budget_id");
        detail.setServer(Supplier.DIDI.name());
        AbstractOrderModel.OrderType orderType = AbstractOrderModel.OrderType.O;
        if ("3".equals(statusPram) || "7".equals(statusPram)) {
            orderType = AbstractOrderModel.OrderType.T;
        }
        detail.setOrderType(orderType);
        detail.setOrderSort(AbstractCheckingBillDetailModel.OrderSort.A);
        detail.setVendorname(ResManager.loadKDString((String)"\u6ef4\u6ef4", (String)"DiDiTripCheckingInvoke_1", (String)"fi-er-business", (Object[])new Object[0]));
        detail.setOperationType(AbstractOrderModel.OperationType.C);
        if (null != detailInfo.get((Object)"extend_info") && !detailInfo.getString("extend_info").trim().isEmpty()) {
            try {
                String invoiceInfo = detailInfo.getString("extend_info");
                JSONObject jsonObject = JSON.parseObject((String)invoiceInfo);
                detail.setSettlemain(jsonObject.getString("costCompanyId"));
                detail.setSettledept(jsonObject.getString("dptId"));
                detail.setOrg(jsonObject.getLong("dptId"));
                detail.setCompany(jsonObject.getLong("companyId"));
                detail.setStd_costcenter(jsonObject.getLong("stdCostcenterId"));
            }
            catch (Exception e) {
                logger.info("didi extend_info error:{}", (Object)detailInfo.getString("extend_info"));
            }
        }
        this.handleCarCheckingExtCovert(detail, detailInfo);
        return detail;
    }

    private List<DiDiCheckingBillInfo> getDiDiCheckingBillInfo(Map params, Map<String, String> billIdAndOutBudgetIdMap) {
        List<String> billIdList = this.getStructrueBillId(params, billIdAndOutBudgetIdMap);
        ArrayList<DiDiCheckingBillInfo> resultList = new ArrayList<DiDiCheckingBillInfo>(billIdList.size());
        for (int i = 0; i < billIdList.size(); ++i) {
            String billId = billIdList.get(i);
            JSONObject billSummmaryInfo = this.getBillSummaryInfoByBillId(billId);
            JSONArray billDetailInfo = this.getBillDetailInfoByBillId(billId);
            JSONArray transationDetailInfo = this.getTransactionDetailInfoByBillId(billId);
            resultList.add(new DiDiCheckingBillInfo(billSummmaryInfo, billDetailInfo, transationDetailInfo));
        }
        return resultList;
    }

    private JSONObject getBillSummaryInfoByBillId(String billId) {
        TripSyncLogParam tripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), this.supplier(), this.function());
        JSONObject result = null;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)billId)) {
            return result;
        }
        HashMap<String, Object> bizParam = new HashMap<String, Object>(16);
        bizParam.put("bill_id", billId);
        String url = (String)ExternalConstants.DIDIURLMAP.get("billSummaryGetKey");
        JSONArray resultArr = new JSONArray();
        DiDiServiceUtil.getExternalDataByRecure(url, bizParam, resultArr, new TripJSONAnalysisConstruct("data", null, null, 0, 1, null), tripSyncLogParam, this.tripSyncLogParamList);
        result = resultArr.size() > 0 ? resultArr.getJSONObject(0) : new JSONObject();
        logger.info("\u5f53\u524dbillId{},\u8fd4\u56deSummary{}", (Object)billId, (Object)result.size());
        return result;
    }

    private JSONArray getTransactionDetailInfoByBillId(String billId) {
        TripSyncLogParam tripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), this.supplier(), this.function());
        JSONArray resultArr = new JSONArray();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)billId)) {
            return resultArr;
        }
        HashMap<String, Object> bizParam = new HashMap<String, Object>(16);
        bizParam.put("bill_id", billId);
        String url = (String)ExternalConstants.DIDIURLMAP.get("transactionDetailKey");
        IOffsetCaculateAble offsetCaculate = new IOffsetCaculateAble(){

            @Override
            public Object caculateOffset(Object initOffset, int maxLength, JSONObject data) {
                return data.getLong("last_id");
            }
        };
        DiDiServiceUtil.getExternalDataByRecure(url, bizParam, resultArr, new TripJSONAnalysisConstruct("data", "transaction_list", "last_id", 0, 100, offsetCaculate), tripSyncLogParam, this.tripSyncLogParamList);
        return resultArr;
    }

    private JSONArray getBillDetailInfoByBillId(String billId) {
        TripSyncLogParam tripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), this.supplier(), this.function());
        JSONArray resultArr = new JSONArray();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)billId)) {
            return resultArr;
        }
        HashMap<String, Object> bizParam = new HashMap<String, Object>(16);
        bizParam.put("bill_id", billId);
        String url = (String)ExternalConstants.DIDIURLMAP.get("billDetailGetKey");
        IOffsetCaculateAble offsetCaculate = new IOffsetCaculateAble(){

            @Override
            public Object caculateOffset(Object initOffset, int maxLength, JSONObject data) {
                return data.getLong("last_id");
            }
        };
        for (int type : BILLDETAIL_TYPE) {
            bizParam.remove("sign");
            bizParam.put("type", type);
            DiDiServiceUtil.getExternalDataByRecure(url, bizParam, resultArr, new TripJSONAnalysisConstruct("data", "orders", "last_id", 0, 100, offsetCaculate), tripSyncLogParam.clone(), this.tripSyncLogParamList);
        }
        logger.info("\u5f53\u524dbillId{},\u8fd4\u56deBillDetailInfo{}", (Object)billId, (Object)resultArr.size());
        return resultArr;
    }

    private List<String> getToBeConfirmedBillId() {
        ArrayList<String> toBeConfirmedIdList = new ArrayList<String>();
        HashMap<String, Object> bizParam = new HashMap<String, Object>(16);
        bizParam.put("bill_status", 1);
        JSONArray resultArr = new JSONArray();
        TripJSONAnalysisConstruct construct = new TripJSONAnalysisConstruct("data", "records", "offset", 0, 100, new TripJSONAnalysisConstruct.DefaultOffsetCaculation());
        String url = (String)ExternalConstants.DIDIURLMAP.get("billListGetKey");
        DiDiServiceUtil.getExternalDataByRecure(url, bizParam, resultArr, construct, this.tripSyncLogParam.clone(), this.tripSyncLogParamList);
        for (int i = 0; i < resultArr.size(); ++i) {
            JSONObject didiBillInfo = (JSONObject)resultArr.get(i);
            String billId = didiBillInfo.getString("bill_id");
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)billId)) continue;
            toBeConfirmedIdList.add(billId);
        }
        return toBeConfirmedIdList;
    }

    private List<String> getStructrueBillId(Map<String, Object> params, Map<String, String> billIdAndOutBudgetIdMap) {
        ArrayList<String> toBeConfirmedIdList = new ArrayList<String>();
        HashMap<String, Object> bizParam = new HashMap<String, Object>(16);
        if (null != params && null != params.get("perioddate")) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)params.get("perioddate"));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            cal.set(5, cal.getActualMinimum(5));
            String startDate = format.format(cal.getTime());
            cal.set(5, cal.getActualMaximum(5));
            String endDate = format.format(cal.getTime());
            bizParam.put("payment_period", startDate + "~" + endDate);
        }
        JSONArray resultArr = new JSONArray();
        TripJSONAnalysisConstruct construct = new TripJSONAnalysisConstruct("data", "list", "offset", 0, 100, new TripJSONAnalysisConstruct.DefaultOffsetCaculation());
        String url = (String)ExternalConstants.DIDIURLMAP.get("getBillStructure");
        DiDiServiceUtil.getExternalDataByRecure(url, bizParam, resultArr, construct, this.tripSyncLogParam.clone(), this.tripSyncLogParamList);
        for (int i = 0; i < resultArr.size(); ++i) {
            Object pid;
            LinkedHashMap didiBillMap = (LinkedHashMap)resultArr.get(i);
            Object billId = didiBillMap.get("bill_id");
            Object out_budget_id = didiBillMap.get("out_budget_id");
            if ((out_budget_id == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)out_budget_id.toString())) && didiBillMap.containsKey("out_bill_split_group_key")) {
                out_budget_id = didiBillMap.get("out_bill_split_group_key");
            }
            if ((pid = didiBillMap.get("pid")) != null && "0".equals(pid.toString()) || null != params && null != params.get("org") && out_budget_id != null && !params.get("org").toString().equals(out_budget_id.toString()) || billId == null || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)billId.toString())) continue;
            String billIdStr = billId.toString();
            if (out_budget_id != null) {
                String outBudgetIdStr = out_budget_id.toString();
                billIdAndOutBudgetIdMap.put(billIdStr, outBudgetIdStr);
            }
            toBeConfirmedIdList.add(billIdStr);
        }
        return toBeConfirmedIdList;
    }

    private static class DiDiCheckingBillInfo {
        private JSONObject billSummaryInfo;
        private JSONArray billDetailInfo;
        private JSONArray transactionDetailInfo;

        public DiDiCheckingBillInfo(JSONObject billSummaryInfo, JSONArray billDetailInfo, JSONArray transactionDetailInfo) {
            this.billDetailInfo = billDetailInfo;
            this.billSummaryInfo = billSummaryInfo;
            this.transactionDetailInfo = transactionDetailInfo;
        }

        public JSONObject getBillSummaryInfo() {
            return this.billSummaryInfo;
        }

        public void setBillSummaryInfo(JSONObject billSummaryInfo) {
            this.billSummaryInfo = billSummaryInfo;
        }

        public JSONArray getBillDetailInfo() {
            return this.billDetailInfo;
        }

        public void setBillDetailInfo(JSONArray billDetailInfo) {
            this.billDetailInfo = billDetailInfo;
        }

        public JSONArray getTransactionDetailInfo() {
            return this.transactionDetailInfo;
        }

        public void setTransactionDetailInfo(JSONArray transactionDetailInfo) {
            this.transactionDetailInfo = transactionDetailInfo;
        }
    }
}

