/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.systemexternal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.didi.systemexternal.TripJSONAnalysisConstruct;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ExternalConstants;
import kd.fi.er.common.utils.MD5;
import org.apache.commons.lang3.StringUtils;

public class DiDiServiceUtil {
    private static Log logger = LogFactory.getLog(DiDiServiceUtil.class);
    private static final String CURENTTIME_BEFORE = "_before";
    private static final String CURENTTIME_AFTER = "_after";

    public static String genSign(Map<String, Object> params, String signKey) {
        params.put("sign_key", signKey);
        params.remove("sign");
        String result = "";
        try {
            ArrayList<Map.Entry<String, Object>> infoIds = new ArrayList<Map.Entry<String, Object>>(params.entrySet());
            Collections.sort(infoIds, new Comparator<Map.Entry<String, Object>>(){

                @Override
                public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            StringBuilder buf = new StringBuilder();
            for (Map.Entry entry : infoIds) {
                String val;
                if (entry.getKey() == null && "".equals(entry.getKey())) continue;
                String key = (String)entry.getKey();
                String string = val = entry.getValue() == null ? "" : entry.getValue().toString();
                if ("".equals(buf.toString())) {
                    buf = buf.append(key).append("=").append(val);
                    continue;
                }
                buf = buf.append("&").append(key).append("=").append(val);
            }
            result = buf.toString();
            params.remove("sign_key");
        }
        catch (TripException e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u83b7\u53d6\u7b7e\u540d,\u5931\u8d25:", (Throwable)((Object)e));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u83b7\u53d6\u7b7e\u540d,\u5931\u8d25:%s", (String)"DiDiServiceUtil_1", (String)"fi-er-business", (Object[])new Object[0]), new Object[]{e}));
        }
        return MD5.md5crypt((String)result);
    }

    public static String getAccessToken() {
        String token = null;
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(Supplier.DIDI.name());
        if (supplierMap == null || supplierMap.size() < 1 || supplierMap.get("appkey") == null || supplierMap.get("appsecurity") == null) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u83b7\u53d6token,\u670d\u52a1\u5546\u8bbe\u7f6e\u4e3a\u7a7a,\u6ca1\u6709\u914d\u7f6e\u670d\u52a1\u5546\u8bbe\u7f6e!");
            return token;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("client_id", supplierMap.get("appkey"));
        map.put("client_secret", supplierMap.get("appsecurity"));
        map.put("grant_type", "client_credentials");
        map.put("phone", supplierMap.get("reservedfield2"));
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        map.put("timestamp", timestamp);
        String signKey = supplierMap.get("reservedfield1");
        String accessTokenSign = DiDiServiceUtil.genSign(map, signKey);
        JSONObject postJson = new JSONObject();
        postJson.put("client_id", (Object)supplierMap.get("appkey"));
        postJson.put("client_secret", (Object)supplierMap.get("appsecurity"));
        postJson.put("grant_type", (Object)"client_credentials");
        postJson.put("phone", (Object)supplierMap.get("reservedfield2"));
        postJson.put("timestamp", (Object)timestamp);
        postJson.put("sign", (Object)accessTokenSign);
        String tokenUrl = (String)ExternalConstants.DIDIURLMAP.get("authorizeKey");
        String result = HttpRetryServiceHelper.PostData(tokenUrl, postJson.toJSONString());
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject != null && !StringUtils.isEmpty((CharSequence)jsonObject.getString("access_token"))) {
            token = jsonObject.getString("access_token");
        }
        return token;
    }

    public static String getCacheToken(Date nowDate) {
        String tokenKey = DiDiServiceUtil.getTokenKey(nowDate);
        String cacheToken = ErCommonUtils.getKeyValueFromAppCache(tokenKey, String.class);
        if (StringUtils.isBlank((CharSequence)cacheToken)) {
            cacheToken = DiDiServiceUtil.getAccessToken();
            ErCommonUtils.putKeyValueToAppCache(tokenKey, cacheToken);
        }
        return cacheToken;
    }

    private static String getTokenKey(Date nowDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String dateNowStr = sdf.format(nowDate);
        int hour = Calendar.getInstance().get(11);
        int minute = Calendar.getInstance().get(12);
        String currentTimeKey = null;
        if (0 < minute && minute <= 29) {
            currentTimeKey = CURENTTIME_BEFORE;
        } else if (30 <= minute && minute < 60) {
            currentTimeKey = CURENTTIME_AFTER;
        }
        String tokenKey = dateNowStr + hour + currentTimeKey;
        return tokenKey;
    }

    public static HashMap<String, Object> getDiDiUserInfo(String userPhone) {
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(Supplier.DIDI.name());
        String client_id = supplierMap.get("appkey");
        String company_id = supplierMap.get("orationid");
        String access_token = DiDiServiceUtil.getCacheToken(new Date());
        if (access_token == null) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u83b7\u53d6token,\u5931\u8d25,\u8fd4\u56detoken\u4e3a\u7a7a,\u65e0\u6cd5\u67e5\u770b\u4eba\u5458\u7684\u7528\u8f66\u5236\u5ea6,\u8bf7\u68c0\u67e5\u914d\u7f6e!");
        }
        HashMap<String, Object> signMap = new HashMap<String, Object>();
        signMap.put("client_id", client_id);
        signMap.put("company_id", company_id);
        signMap.put("access_token", access_token);
        signMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        signMap.put("phone", userPhone);
        signMap.put("offset", 0);
        signMap.put("length", 100);
        String signKey = supplierMap.get("reservedfield1");
        String userListSign = DiDiServiceUtil.genSign(signMap, signKey);
        HashMap<String, Object> userListparamMap = new HashMap<String, Object>();
        userListparamMap.put("client_id", client_id);
        userListparamMap.put("company_id", company_id);
        userListparamMap.put("access_token", access_token);
        userListparamMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        userListparamMap.put("phone", userPhone);
        userListparamMap.put("offset", 0);
        userListparamMap.put("length", 100);
        userListparamMap.put("sign", userListSign);
        JSONObject result = HttpRetryServiceHelper.doGet((String)ExternalConstants.DIDIURLMAP.get("memberGetKey"), userListparamMap, JSONObject.class);
        if (Integer.parseInt(String.valueOf(result.get((Object)"errno"))) == 0) {
            HashMap userInfoMap = (HashMap)result.get((Object)"data");
            HashMap<String, Object> userParamInfo = new HashMap<String, Object>();
            ArrayList records = (ArrayList)userInfoMap.get("records");
            int total = (Integer)userInfoMap.get("total");
            if (total == 1) {
                HashMap didiUser = (HashMap)records.get(0);
                userParamInfo.put("name", didiUser.get("realname"));
                userParamInfo.put("outUserId", didiUser.get("id"));
                userParamInfo.put("regulation_id", (ArrayList)didiUser.get("regulation_id"));
            }
            return userParamInfo;
        }
        return null;
    }

    public static void getExternalDataByRecure(String url, Map<String, Object> requestParam, JSONArray resultArr, TripJSONAnalysisConstruct construct, TripSyncLogParam tripSyncLogParam, List<TripSyncLogParam> tripSyncLogParamList) {
        if (StringUtils.isNotEmpty((CharSequence)construct.getRecordsProName())) {
            requestParam.put(construct.getOffsetProName(), construct.getInitOffset());
            requestParam.put("length", construct.getMaxLength());
        }
        requestParam = DiDiServiceUtil.buildRequestParams(requestParam, tripSyncLogParam);
        tripSyncLogParam.setRequesturl(url);
        tripSyncLogParam.setRequestdata(requestParam);
        JSONObject result = HttpRetryServiceHelper.doGet(url, requestParam, JSONObject.class);
        tripSyncLogParam.setResponsedata(result);
        tripSyncLogParamList.add(tripSyncLogParam);
        if (result == null || !result.getString("errno").equals("0")) {
            resultArr.clear();
            tripSyncLogParam.setStatus("B");
            if (result == null) {
                tripSyncLogParam.setMessage(result);
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u8c03\u7528\u63a5\u53e3" + url + "\u5931\u8d25\uff0c\u7ed3\u679c\u4e3a\uff1a" + result);
            } else {
                String err = result.getString("errmsg");
                tripSyncLogParam.setMessage(err);
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u8c03\u7528\u63a5\u53e3" + url + "\u5931\u8d25\uff0cerrmsg\uff1a" + err);
            }
            return;
        }
        JSONObject data = result.getJSONObject(construct.getDataProName());
        String recordProName = construct.getRecordsProName();
        if (StringUtils.isNotEmpty((CharSequence)recordProName)) {
            JSONArray records = data.getJSONArray(recordProName);
            if (records == null || records.size() == 0) {
                return;
            }
            resultArr.addAll((Collection)records);
            if (construct.getMaxLength() == records.size()) {
                construct.setInitOffset(construct.getOffsetCaculate().caculateOffset(construct.getInitOffset(), construct.getMaxLength(), data));
                DiDiServiceUtil.getExternalDataByRecure(url, requestParam, resultArr, construct, tripSyncLogParam.clone(), tripSyncLogParamList);
            }
        } else {
            resultArr.add((Object)data);
        }
    }

    public static Map<String, Object> buildRequestParams(Map<String, Object> bizParam, TripSyncLogParam tripSyncLogParam) {
        String access_token = DiDiServiceUtil.getCacheToken(new Date());
        if (access_token == null) {
            String errInfo = ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\uff0c\u65e0\u6cd5\u83b7\u53d6\u6ef4\u6ef4token\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"DiDiServiceUtil_2", (String)"fi-er-business", (Object[])new Object[0]);
            tripSyncLogParam.setMessage(errInfo);
            throw new KDBizException(errInfo);
        }
        if (bizParam == null) {
            bizParam = new HashMap<String, Object>();
        }
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(Supplier.DIDI.getValue());
        String client_id = supplierMap.get("appkey");
        String company_id = supplierMap.get("orationid");
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String signKey = supplierMap.get("reservedfield1");
        bizParam.put("client_id", client_id);
        bizParam.put("company_id", company_id);
        bizParam.put("access_token", access_token);
        bizParam.put("timestamp", timestamp);
        String sign = DiDiServiceUtil.genSign(bizParam, signKey);
        bizParam.put("sign", sign);
        return bizParam;
    }
}

