/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.systemexternal;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;

public class DiDiTripCarRegulationUtil {
    private static Log logger = LogFactory.getLog(DiDiTripCarRegulationUtil.class);

    public static String getUserTripCarRegulation(String userPhone, String scenetype) {
        HashMap<String, Object> didiUserMap = DiDiServiceUtil.getDiDiUserInfo(userPhone);
        if (didiUserMap == null || didiUserMap.size() == 0) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u4eba\u5458\u7528\u8f66\u5236\u5ea6,\u5f53\u524d\u624b\u673a\u53f7\u4e3a:" + userPhone + "\u7684\u4eba\u5458,\u51fa\u5dee\u7528\u8f66\u5236\u5ea6\u6570\u636e\u4e3a\u7a7a!");
            return null;
        }
        ArrayList regulationIds = (ArrayList)didiUserMap.get("regulation_id");
        if (regulationIds == null || regulationIds.size() == 0) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u4eba\u5458\u7528\u8f66\u5236\u5ea6,\u5f53\u524d\u624b\u673a\u53f7\u4e3a:" + userPhone + "\u7684\u4eba\u5458,\u51fa\u5dee\u7528\u8f66\u5236\u5ea6\u6570\u636e\u4e3a\u7a7a!");
            return null;
        }
        Map<String, DynamicObject> tripRegulationObjOutIdMap = DiDiTripCarRegulationUtil.getAllTripCarRegulation(scenetype);
        if (tripRegulationObjOutIdMap == null || tripRegulationObjOutIdMap.size() == 0) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u4eba\u5458\u7528\u8f66\u5236\u5ea6,\u5f53\u524d\u51fa\u5dee\u7528\u8f66\u5236\u5ea6\u6570\u636e\u4e3a\u7a7a!");
            return null;
        }
        ArrayList curUserTripRegulationList = new ArrayList();
        for (int i = 0; i < regulationIds.size(); ++i) {
            DynamicObject tripRegulation;
            if (!tripRegulationObjOutIdMap.containsKey(regulationIds.get(i)) || !"1".equals((tripRegulation = tripRegulationObjOutIdMap.get(regulationIds.get(i))).getString("enable")) || "0".equals(tripRegulation.getString("approvaltype"))) continue;
            curUserTripRegulationList.add(regulationIds.get(i));
        }
        String userTripRegulationOutId = null;
        if (curUserTripRegulationList != null && curUserTripRegulationList.size() >= 1) {
            userTripRegulationOutId = (String)curUserTripRegulationList.get(0);
        }
        return userTripRegulationOutId;
    }

    public static Map<String, DynamicObject> getAllTripCarRegulation(String scenetype) {
        QFilter qFilter = new QFilter("scenetype", "=", (Object)scenetype);
        String setectProperties = "id,number,name,status,enable,createtime,modifytime,scenetype,isapprove,is`usequota,approvaltype";
        return DiDiTripCarRegulationUtil.getData(qFilter, setectProperties);
    }

    private static Map getData(QFilter qFilter, String setectProperties) {
        Map tripRegulationObjInnerIdMap = BusinessDataServiceHelper.loadFromCache((String)"er_trip_carregulation", (String)setectProperties, (QFilter[])new QFilter[]{qFilter});
        if (tripRegulationObjInnerIdMap == null || tripRegulationObjInnerIdMap.size() < 1) {
            return null;
        }
        HashMap tripRegulationObjOutIdMap = Maps.newHashMapWithExpectedSize((int)tripRegulationObjInnerIdMap.size());
        for (Map.Entry entry : tripRegulationObjInnerIdMap.entrySet()) {
            DynamicObject tripRegulationObj = (DynamicObject)entry.getValue();
            String tripRegulationOutId = (String)tripRegulationObj.get("number");
            tripRegulationObjOutIdMap.put(tripRegulationOutId, entry.getValue());
        }
        return tripRegulationObjOutIdMap;
    }

    public static String getUserTripCarRegulationByVehicle(String userPhone, Integer approvalType) {
        String setectProperties;
        HashMap<String, Object> didiUserMap = DiDiServiceUtil.getDiDiUserInfo(userPhone);
        ArrayList regulationIds = (ArrayList)didiUserMap.get("regulation_id");
        if (regulationIds == null || regulationIds.size() == 0) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u4eba\u5458\u7528\u8f66\u5236\u5ea6,\u5f53\u524d\u624b\u673a\u53f7\u4e3a:" + userPhone + "\u7684\u4eba\u5458,\u51fa\u5dee\u7528\u8f66\u5236\u5ea6\u6570\u636e\u4e3a\u7a7a!");
            return null;
        }
        QFilter qFilter = new QFilter("approvaltype", "=", (Object)String.valueOf(approvalType));
        Map tripRegulationObjOutIdMap = DiDiTripCarRegulationUtil.getData(qFilter, setectProperties = "id,number,name,status,enable,createtime,modifytime,scenetype,isapprove,isusequota,approvaltype");
        if (tripRegulationObjOutIdMap == null || tripRegulationObjOutIdMap.size() == 0) {
            logger.info("Line 86 \u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u4eba\u5458\u7528\u8f66\u5236\u5ea6,\u5f53\u524d\u51fa\u5dee\u7528\u8f66\u5236\u5ea6\u6570\u636e\u4e3a\u7a7a!");
            return null;
        }
        ArrayList curUserTripRegulationList = new ArrayList();
        for (int i = 0; i < regulationIds.size(); ++i) {
            if (!tripRegulationObjOutIdMap.containsKey(regulationIds.get(i))) continue;
            curUserTripRegulationList.add(regulationIds.get(i));
        }
        String userTripRegulationOutId = null;
        if (curUserTripRegulationList != null && curUserTripRegulationList.size() >= 1) {
            userTripRegulationOutId = (String)curUserTripRegulationList.get(0);
        }
        return userTripRegulationOutId;
    }
}

