/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.didi.systemexternal;

import java.util.HashMap;
import java.util.Map;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.VehicleOrderModel;
import org.apache.commons.lang3.StringUtils;

public class DiDiTripPropMapping {
    public static AbstractOrderModel.ProductType getPayTypeEnumByKey(String payType) {
        String payTypeValue = DiDiTripPropMapping.payTypeMap().get(payType);
        for (AbstractOrderModel.ProductType payTypeEnum : AbstractOrderModel.ProductType.values()) {
            if (!StringUtils.equals((CharSequence)payTypeValue, (CharSequence)payTypeEnum.getKey())) continue;
            return payTypeEnum;
        }
        return null;
    }

    public static Map<String, String> payTypeMap() {
        HashMap<String, String> payTypeMap = new HashMap<String, String>();
        payTypeMap.put("0", "1");
        payTypeMap.put("1", "2");
        payTypeMap.put("2", "1");
        return payTypeMap;
    }

    public static AbstractOrderModel.ProductType getPayTypeByStr(String payType) {
        switch (payType) {
            case "\u4f01\u4e1a\u652f\u4ed8": 
            case "\u6df7\u5408\u652f\u4ed8": {
                return AbstractOrderModel.ProductType.A;
            }
            case "\u4e2a\u4eba\u57ab\u4ed8": 
            case "\u4e2a\u4eba\u73b0\u4ed8": {
                return AbstractOrderModel.ProductType.B;
            }
        }
        return null;
    }

    public static VehicleOrderModel.VehicleType setVehicleType(String vehicleType) {
        if ("600".equalsIgnoreCase(vehicleType)) {
            return VehicleOrderModel.VehicleType.A;
        }
        if ("100".equalsIgnoreCase(vehicleType) || "900".equalsIgnoreCase(vehicleType)) {
            return VehicleOrderModel.VehicleType.B;
        }
        if ("200".equalsIgnoreCase(vehicleType)) {
            return VehicleOrderModel.VehicleType.C;
        }
        if ("400".equalsIgnoreCase(vehicleType)) {
            return VehicleOrderModel.VehicleType.D;
        }
        return VehicleOrderModel.VehicleType.A;
    }

    public static VehicleOrderModel.OrderStatus setOrderStatus(int orderStatus) {
        switch (orderStatus) {
            case 2: {
                return VehicleOrderModel.OrderStatus.G;
            }
            case 3: {
                return VehicleOrderModel.OrderStatus.I;
            }
            case 4: {
                return VehicleOrderModel.OrderStatus.F;
            }
            case 7: {
                return VehicleOrderModel.OrderStatus.J;
            }
        }
        return null;
    }

    public static VehicleOrderModel.OrderStatus setCheckingOrderStatus(String orderStatus) {
        switch (orderStatus) {
            case "\u6b63\u5e38": {
                return VehicleOrderModel.OrderStatus.G;
            }
            case "\u5931\u8d25": {
                break;
            }
            case "\u5168\u90e8\u652f\u4ed8": {
                return VehicleOrderModel.OrderStatus.G;
            }
            case "\u5168\u90e8\u9000\u6b3e": {
                return VehicleOrderModel.OrderStatus.I;
            }
            case "\u8d85\u65f6\u53d6\u6d88\u6263\u8d39": {
                return VehicleOrderModel.OrderStatus.F;
            }
            case "\u5f85\u652f\u4ed8": {
                return VehicleOrderModel.OrderStatus.H;
            }
            case "\u90e8\u5206\u652f\u4ed8": {
                break;
            }
            case "\u90e8\u5206\u9000\u6b3e": {
                return VehicleOrderModel.OrderStatus.J;
            }
        }
        return VehicleOrderModel.OrderStatus.UNKNOWN;
    }
}

