/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.meituan.invoke.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.RateLimiter;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.model.MealOrderModel;
import kd.fi.er.business.trip.service.function.AbstractOrderInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.meituan.enums.MeiTuanPayStatus;
import kd.fi.er.business.trip.supplier.meituan.enums.MeiTuanSqtType;
import kd.fi.er.business.trip.supplier.meituan.invoke.order.MTripOrderMealConvert;
import kd.fi.er.business.trip.supplier.meituan.utils.MeiTuanTripUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErCommonUtils;

public class MTripOrderInvoke
extends AbstractOrderInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(MTripOrderInvoke.class);
    private Date lastSyncOrderBillTamp;
    private Date currSyncOrderBillTamp;
    private DynamicObject bizInfoObject = null;
    private Boolean isScheduledTask = Boolean.TRUE;
    private AtomicReference<Boolean> syncSuccessFlag;
    private String queryListUrl;
    private String queryDetailUrl;
    private static final String LASTSYNCORDERBILLTAMP_PROP = "lastsyncorderbilltamp";

    protected Object process(Map params) {
        logger.info("\u5546\u65c5\u96c6\u6210,\u7f8e\u56e2\u8ba2\u5355,\u83b7\u53d6\u7f8e\u56e2\u8ba2\u5355\u6570\u636e\u5f00\u59cb-------------");
        if (params != null) {
            this.syncSuccessFlag = new AtomicReference<Boolean>(false);
            if (params.get("structrue_param") != null && params.get("detail_param") != null) {
                JSONObject structrue_param = JSONObject.parseObject((String)((String)params.get("structrue_param")));
                JSONObject detail_param = JSONObject.parseObject((String)((String)params.get("detail_param")));
                JSONObject billDetailInfo = detail_param.getJSONObject("data");
                Long sqtBizOrderId = billDetailInfo.getJSONObject("orderBaseInfo").getLong("sqtBizOrderId");
                JSONArray result = structrue_param.getJSONArray("result");
                for (int i = 0; i < result.size(); ++i) {
                    JSONObject billStructrueInfo = result.getJSONObject(i);
                    if (!billStructrueInfo.getLong("sqtBizOrderId").equals(sqtBizOrderId)) continue;
                    MeiTuanOrderBillInfo orderBillInfo = new MeiTuanOrderBillInfo(billStructrueInfo, billDetailInfo);
                    ArrayList<MeiTuanOrderBillInfo> resultList = new ArrayList<MeiTuanOrderBillInfo>();
                    resultList.add(orderBillInfo);
                    return resultList;
                }
            }
        }
        List<MeiTuanOrderBillInfo> resultList = this.getMeiTuanOrderBillInfo(params);
        logger.info("\u5546\u65c5\u96c6\u6210,\u7f8e\u56e2\u8ba2\u5355,\u83b7\u53d6\u7f8e\u56e2\u8ba2\u5355\u6570\u636e\u7ed3\u675f\uff0c\u83b7\u53d6\u5230" + resultList.size() + "\u6761");
        return resultList;
    }

    protected Object convert(Object o) {
        List orderBillInfoList = (List)o;
        if (orderBillInfoList == null || orderBillInfoList.size() < 1) {
            return null;
        }
        ArrayList<MealOrderModel> orderModels = new ArrayList<MealOrderModel>(orderBillInfoList.size());
        block6: for (int i = 0; i < orderBillInfoList.size(); ++i) {
            MeiTuanOrderBillInfo meiTuanOrderBillInfo = (MeiTuanOrderBillInfo)orderBillInfoList.get(i);
            JSONObject billStructrueInfo = meiTuanOrderBillInfo.getBillStructrueInfo();
            JSONObject billDetailInfo = meiTuanOrderBillInfo.getBillDetailInfo();
            Integer payStatus = billStructrueInfo.getInteger("payStatus");
            Integer sqtType = billStructrueInfo.getInteger("orderType");
            switch (this.needReceiveOrderType(payStatus, sqtType)) {
                case "meal": {
                    orderModels.add(MTripOrderMealConvert.convert(billStructrueInfo, billDetailInfo));
                    continue block6;
                }
                default: {
                    logger.info(String.format("\u5546\u65c5\u96c6\u6210,\u7f8e\u56e2\u8ba2\u5355,covert\u7f8e\u56e2\u8ba2\u5355\u6570\u636e\u8df3\u8fc7\u7684\u8ba2\u5355\uff0c\u652f\u4ed8\u72b6\u6001\u4e3a%s,\u5546\u4f01\u901a\u8ba2\u5355\u4e1a\u52a1\u7c7b\u578b\u4e3a%s", payStatus, sqtType));
                }
            }
        }
        return orderModels;
    }

    private List<MeiTuanOrderBillInfo> getMeiTuanOrderBillInfo(Map params) {
        JSONArray dataArray = new JSONArray();
        this.getStructrueOrderList(dataArray, params);
        ArrayList<MeiTuanOrderBillInfo> resultList = new ArrayList<MeiTuanOrderBillInfo>(dataArray.size());
        this.generateOrderDetail(resultList, dataArray);
        return resultList;
    }

    private void getStructrueOrderList(JSONArray dataArray, Map params) {
        if (this.isScheduledTask.booleanValue()) {
            this.getTripLastSyncOrderBillTamp();
        }
        this.syncSuccessFlag = new AtomicReference<Boolean>(Boolean.TRUE);
        String url = "/queryOrderList";
        this.queryListUrl = MeiTuanTripUtil.getMeiTuanUrl() + url;
        int index = 0;
        int pageSize = TripSyncConfigUtil.getIntValue("ttrip_sync_orderbill_size", 500);
        RateLimiter limiter = RateLimiter.create((double)1.6);
        this.startQueryOrderListData(index, pageSize, dataArray, params, limiter);
    }

    private void generateOrderDetail(List<MeiTuanOrderBillInfo> resultList, JSONArray dataArray) {
        String url = "/queryOrderDetail";
        this.queryDetailUrl = MeiTuanTripUtil.getMeiTuanUrl() + url;
        RateLimiter limiter = RateLimiter.create((double)1.6);
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject billStructrueInfo = new JSONObject((Map)dataArray.get(i));
            limiter.acquire();
            JSONObject jsonObject = this.startQueryOrderDetailData(billStructrueInfo);
            if (null != jsonObject) {
                MeiTuanOrderBillInfo orderBillInfo = new MeiTuanOrderBillInfo(billStructrueInfo, jsonObject.getJSONObject("data"));
                resultList.add(orderBillInfo);
                continue;
            }
            this.syncSuccessFlag.set(Boolean.FALSE);
            logger.warn(String.format("\u5546\u65c5\u96c6\u6210,\u7f8e\u56e2\u8ba2\u5355,\u7ec4\u88c5\u8ba2\u5355\u6570\u636e\u65f6\u672a\u83b7\u53d6\u5230\u8ba2\u5355\u53f7\u4e3a%s\u7684\u8ba2\u5355\u8be6\u60c5\uff0c\u8bf7\u6ce8\u610f\u3002", billStructrueInfo.getLong("sqtBizOrderId")));
        }
    }

    private JSONObject startQueryOrderDetailData(JSONObject billStructrueInfo) {
        JSONObject dataJson = new JSONObject();
        TripSyncLogParam currentLog = this.tripSyncLogParam.clone();
        Long sqtBizOrderId = billStructrueInfo.getLong("sqtBizOrderId");
        dataJson.put("sqtBizOrderId", (Object)sqtBizOrderId);
        JSONObject response = MeiTuanTripUtil.doHttpPost(dataJson, this.queryDetailUrl, "order_detail_query", this.syncSuccessFlag, currentLog, this.tripSyncLogParamList);
        return response;
    }

    private void startQueryOrderListData(int index, int pageSize, JSONArray dataArray, Map params, RateLimiter limiter) {
        if (this.isScheduledTask.booleanValue()) {
            this.currSyncOrderBillTamp = new Date();
        }
        JSONObject dataJson = new JSONObject();
        TripSyncLogParam currentLog = this.tripSyncLogParam.clone();
        if (null != params) {
            if (null != params.get("mealNum")) {
                dataJson.put("outerApplyNo", params.get("mealNum"));
                this.isScheduledTask = Boolean.FALSE;
            }
            if (null != params.get("beginDate") && null != params.get("endDate")) {
                this.lastSyncOrderBillTamp = TripCommonUtil.strToDate(String.valueOf(params.get("beginDate")), "EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                this.currSyncOrderBillTamp = TripCommonUtil.strToDate(String.valueOf(params.get("endDate")), "EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                this.isScheduledTask = Boolean.FALSE;
            }
        }
        dataJson.put("pageSize", (Object)pageSize);
        dataJson.put("pageNum", (Object)index);
        dataJson.put("orderUpdateStart", (Object)this.lastSyncOrderBillTamp);
        dataJson.put("orderUpdateEnd", (Object)this.currSyncOrderBillTamp);
        limiter.acquire();
        JSONObject response = MeiTuanTripUtil.doHttpPost(dataJson, this.queryListUrl, "order_list_query", this.syncSuccessFlag, currentLog, this.tripSyncLogParamList);
        if (response == null) {
            dataArray.clear();
            this.tripSyncLogParamList.clear();
            this.tripSyncLogParamList.add(currentLog);
            this.syncSuccessFlag.set(Boolean.FALSE);
            return;
        }
        JSONObject data = response.getJSONObject("data");
        JSONArray result = data.getJSONArray("result");
        Long totalCount = data.getLong("totalCount");
        if (result == null) {
            return;
        }
        dataArray.addAll((Collection)result);
        if ((long)(++index * pageSize) < totalCount) {
            this.startQueryOrderListData(index, pageSize, dataArray, params, limiter);
        }
    }

    @Override
    public void execute() throws TripException {
        logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u8ba2\u5355,save\u5dee\u65c5\u58f9\u53f7\u8ba2\u5355\u6570\u636e\u5f00\u59cb-------------");
        super.execute();
        if (this.isScheduledTask.booleanValue()) {
            this.saveLastSyncOrderbilltTamp();
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u8ba2\u5355,save\u5dee\u65c5\u58f9\u53f7\u8ba2\u5355\u6570\u636e\u7ed3\u675f-------------");
    }

    private void getTripLastSyncOrderBillTamp() {
        String orderbillStartdate = TripSyncConfigUtil.getTripsyncSettingByKey("mtrip_orderbill_startdate");
        if (null != orderbillStartdate && !orderbillStartdate.trim().isEmpty()) {
            this.lastSyncOrderBillTamp = TripCommonUtil.strToDate(orderbillStartdate, "yyyy-MM-dd HH:mm:ss");
            return;
        }
        this.bizInfoObject = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)LASTSYNCORDERBILLTAMP_PROP, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
        this.lastSyncOrderBillTamp = this.bizInfoObject.getDate(LASTSYNCORDERBILLTAMP_PROP);
        if (this.lastSyncOrderBillTamp.before(ErCommonUtils.getDateFromLocalDate(LocalDate.of(2000, 1, 1)))) {
            this.lastSyncOrderBillTamp = TripCommonUtil.delayByMonth(new Date(), -1);
        }
    }

    private String needReceiveOrderType(Integer payStatus, Integer sqtType) {
        String result = "";
        if (MeiTuanPayStatus.NOT_PAY.getValue().equals(payStatus)) {
            return result;
        }
        switch (MeiTuanSqtType.getEnum(sqtType)) {
            case A: 
            case B: 
            case C: 
            case D: 
            case L: 
            case P: 
            case Q: 
            case S: 
            case T: {
                result = "meal";
                break;
            }
        }
        return result;
    }

    @Override
    protected String supplier() {
        return Supplier.MEITUAN.name();
    }

    private void saveLastSyncOrderbilltTamp() {
        if (this.syncSuccessFlag.get().booleanValue()) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u7f8e\u56e2\u8ba2\u5355,\u66f4\u65b0\u540c\u6b65\u8ba2\u5355\u65f6\u95f4\u6233\u4e3a\uff1a" + this.currSyncOrderBillTamp);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String currentTime = sdf.format(this.currSyncOrderBillTamp);
            this.bizInfoObject.set(LASTSYNCORDERBILLTAMP_PROP, (Object)currentTime);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.bizInfoObject});
        }
    }

    private static class MeiTuanOrderBillInfo {
        private JSONObject billStructrueInfo;
        private JSONObject billDetailInfo;

        public MeiTuanOrderBillInfo(JSONObject billStructrueInfo, JSONObject billDetailInfo) {
            this.billStructrueInfo = billStructrueInfo;
            this.billDetailInfo = billDetailInfo;
        }

        public JSONObject getBillStructrueInfo() {
            return this.billStructrueInfo;
        }

        public void setBillStructrueInfo(JSONObject billStructrueInfo) {
            this.billStructrueInfo = billStructrueInfo;
        }

        public JSONObject getBillDetailInfo() {
            return this.billDetailInfo;
        }

        public void setBillDetailInfo(JSONObject billDetailInfo) {
            this.billDetailInfo = billDetailInfo;
        }
    }
}

