/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.meituan.invoke.order;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.MealOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class MTripOrderMealConvert {
    public static MealOrderModel convert(JSONObject billStructrueInfo, JSONObject billDetailInfo) {
        MealOrderModel mealOrderModel = new MealOrderModel();
        JSONObject orderBaseInfo = billDetailInfo.getJSONObject("orderBaseInfo");
        JSONObject staffInfo = billDetailInfo.getJSONObject("staffInfo");
        JSONObject controlInfo = billDetailInfo.getJSONObject("controlInfo");
        JSONObject payInfo = billDetailInfo.getJSONObject("payInfo");
        mealOrderModel.setServer(Supplier.MEITUAN.name());
        mealOrderModel.setOrderDate(TripCommonUtil.convertToDate(billStructrueInfo.getString("orderTime")));
        mealOrderModel.setOrderNum(billStructrueInfo.getString("sqtBizOrderId"));
        mealOrderModel.setParentOrderNum(billStructrueInfo.getString("sqtBizOrderId"));
        mealOrderModel.setOrderType(AbstractOrderModel.OrderType.O);
        mealOrderModel.setOperationType(AbstractOrderModel.OperationType.H);
        mealOrderModel.setOrderNatrue(MTripOrderMealConvert.setOrderNatrue(!orderBaseInfo.containsKey((Object)"bizOrPersonal") ? Integer.valueOf(0) : orderBaseInfo.getInteger("bizOrPersonal")));
        mealOrderModel.setHappendDate(TripCommonUtil.convertToDate(billStructrueInfo.getString("payTime")));
        mealOrderModel.setSourceBookedId(staffInfo.getString("staffEntNum"));
        mealOrderModel.setBookedname(staffInfo.getString("staffName"));
        mealOrderModel.setOaBillNum(billStructrueInfo.getString("outerApplyNo"));
        mealOrderModel.setOrderStatus(MTripOrderMealConvert.setOrderStatus(billStructrueInfo.getInteger("payStatus")));
        mealOrderModel.setProductType(MTripOrderMealConvert.setProductType(!payInfo.containsKey((Object)"payType") ? Integer.valueOf(0) : payInfo.getInteger("payType")));
        mealOrderModel.setTotalAmount(MTripOrderMealConvert.calculateTotalAmount(billStructrueInfo));
        mealOrderModel.setMealtime(TripCommonUtil.convertToDate(billStructrueInfo.getString("orderTime")));
        mealOrderModel.setMealcityname(billStructrueInfo.getString("expenseCity"));
        mealOrderModel.setServiceFee(MTripOrderMealConvert.calculateServiceFee(billStructrueInfo));
        mealOrderModel.setPersonalFee(billStructrueInfo.getBigDecimal("staffPayAmount"));
        mealOrderModel.setShopname(orderBaseInfo.getString("shopName"));
        mealOrderModel.setShopaddress(orderBaseInfo.getString("shopAddress"));
        if (controlInfo.containsKey((Object)"applyQuotaExceedLimitInfo") && null != controlInfo.getJSONObject("applyQuotaExceedLimitInfo")) {
            String overdesc = controlInfo.getJSONObject("applyQuotaExceedLimitInfo").getString("reason");
            mealOrderModel.setOverdesc(overdesc);
        }
        return mealOrderModel;
    }

    private static BigDecimal calculateTotalAmount(JSONObject billStructrueInfo) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal entPayAmount = billStructrueInfo.getBigDecimal("entPayAmount") == null ? BigDecimal.ZERO : billStructrueInfo.getBigDecimal("entPayAmount");
        BigDecimal entRefundAmount = billStructrueInfo.getBigDecimal("entRefundAmount") == null ? BigDecimal.ZERO : billStructrueInfo.getBigDecimal("entRefundAmount");
        BigDecimal staffRefundAmount = billStructrueInfo.getBigDecimal("staffRefundAmount") == null ? BigDecimal.ZERO : billStructrueInfo.getBigDecimal("staffRefundAmount");
        BigDecimal realtimeServiceFee = billStructrueInfo.getBigDecimal("realtimeServiceFee") == null ? BigDecimal.ZERO : billStructrueInfo.getBigDecimal("realtimeServiceFee");
        BigDecimal afterServiceFeePayAmount = billStructrueInfo.getBigDecimal("afterServiceFeePayAmount") == null ? BigDecimal.ZERO : billStructrueInfo.getBigDecimal("afterServiceFeePayAmount");
        totalAmount = totalAmount.add(entPayAmount).subtract(entRefundAmount).add(staffRefundAmount).add(realtimeServiceFee).add(afterServiceFeePayAmount);
        return totalAmount;
    }

    private static BigDecimal calculateServiceFee(JSONObject billStructrueInfo) {
        BigDecimal serviceFee = BigDecimal.ZERO;
        BigDecimal entPayAmount = billStructrueInfo.getBigDecimal("realtimeServiceFee") == null ? BigDecimal.ZERO : billStructrueInfo.getBigDecimal("realtimeServiceFee");
        BigDecimal entRefundAmount = billStructrueInfo.getBigDecimal("afterServiceFeePayAmount") == null ? BigDecimal.ZERO : billStructrueInfo.getBigDecimal("afterServiceFeePayAmount");
        serviceFee = serviceFee.add(entPayAmount).add(entRefundAmount);
        return serviceFee;
    }

    private static AbstractOrderModel.OrderNatrue setOrderNatrue(Integer bizOrPersonal) {
        if (null == bizOrPersonal) {
            return AbstractOrderModel.OrderNatrue.A;
        }
        switch (bizOrPersonal) {
            case 0: {
                return AbstractOrderModel.OrderNatrue.A;
            }
        }
        return AbstractOrderModel.OrderNatrue.B;
    }

    private static MealOrderModel.OrderStatus setOrderStatus(Integer payStatus) {
        switch (payStatus) {
            case 20: {
                return MealOrderModel.OrderStatus.B;
            }
            case 31: {
                return MealOrderModel.OrderStatus.C;
            }
            case 32: {
                return MealOrderModel.OrderStatus.D;
            }
        }
        return null;
    }

    private static AbstractOrderModel.ProductType setProductType(Integer payType) {
        switch (payType) {
            case 10: 
            case 50: {
                return AbstractOrderModel.ProductType.A;
            }
            case 20: {
                return AbstractOrderModel.ProductType.B;
            }
        }
        return AbstractOrderModel.ProductType.A;
    }
}

