/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.er.business.dao.impl.ErOrm;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.business.trip.model.TTripCheckingBillImageModel;
import kd.fi.er.business.trip.service.function.AbstractCheckingBillImageInvoke;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TravelNoOneSync;
import kd.fi.er.business.trip.util.TripCheckingInvoiceImageInfoUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.RSAUtils;

public class TTripInvoiceImageInfoInvoke
extends AbstractCheckingBillImageInvoke {
    private static Log logger = LogFactory.getLog(TTripInvoiceImageInfoInvoke.class);
    private static final String TTRIPINVOICEIMAGEINFOINVOKE = "TTripInvoiceImageInfoInvoke";
    private static final Integer PAGE_SIZE = 500;
    public static String SELECT_FIELDS = "billno,server,billnum,settlemain,isreconciliation,iscreatevoucher,operationtype,billstatusname,currency,settlementamount,periodstartdate,periodenddate,invoiceentry.invoicetype,invoiceentry.invoicecode,invoiceentry.invoiceno,invoiceentry.flightitineraryandtrain,invoiceentry.totalamount,invoiceentry.taxamount_invoice,invoiceentry.checkingbillno,invoiceentry.passengername,invoiceentry.invoicefromcity,invoiceentry.invoicetocity,invoiceentry.buyerorgname,invoiceentry.makeoutcompname,invoiceentry.downloadurl,invoiceentry.innerdownloadurl";

    protected Object process(Map params) {
        Map<String, List<String>> checkingBillDatas = this.getCheckingBillDatas();
        if (checkingBillDatas.isEmpty()) {
            return null;
        }
        List<String> all = checkingBillDatas.get("all");
        if (CollectionUtils.isEmpty(all)) {
            return null;
        }
        return this.getImageInfoData(checkingBillDatas);
    }

    private Map<String, HashSet<JSONObject>> getImageInfoData(Map<String, List<String>> checkingBillDatas) {
        String url = TripCommonUtil.getTravelNoOneApiUrl("queryInvoiceImageInfoByBillNo");
        this.tripSyncLogParam.setRequesturl(url);
        this.tripSyncLogParam.setStatus("A");
        ErCommonUtils.removeKeyFromAppCache(TTRIPINVOICEIMAGEINFOINVOKE);
        HashSet<List<String>> allReqDataSet = TripCheckingInvoiceImageInfoUtil.getReqDataSet(checkingBillDatas.get("all"));
        HashSet<JSONObject> allResultSet = this.getJsonObjects(url, allReqDataSet);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        resultMap.put("all", allResultSet);
        return resultMap;
    }

    private HashSet<JSONObject> getJsonObjects(String url, HashSet<List<String>> reqDataSet) {
        Iterator<List<String>> iterator = reqDataSet.iterator();
        int tmpPageSize = PAGE_SIZE;
        ArrayList logLists = Lists.newArrayListWithCapacity((int)reqDataSet.size());
        HashSet resultSet = Sets.newHashSetWithExpectedSize((int)reqDataSet.size());
        while (iterator.hasNext()) {
            List<String> tmpBillNos = iterator.next();
            int pageIndex = 1;
            this.sendRequest(tmpBillNos, tmpPageSize, pageIndex, logLists, url, resultSet);
        }
        logger.info("\u53d1\u7968\u5f71\u50cf\u4fe1\u606f,\u9700\u8981\u6dfb\u52a0\u7684\u6570\u636e\u957f\u5ea6:{}", (Object)resultSet.size());
        TripSyncLogUtils.saveErrorLog(logLists);
        return resultSet;
    }

    private void sendRequest(List<String> tmpBillNos, int pageSize, int pageIndex, List<TripSyncLogParam> logLists, String url, HashSet<JSONObject> resultSet) {
        String reqStr = this.buildRequestParam(tmpBillNos, pageSize, pageIndex);
        TripSyncLogParam tripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), this.supplier(), this.function());
        logLists.add(tripSyncLogParam);
        tripSyncLogParam.setRequesturl(url);
        tripSyncLogParam.setRequestdata(reqStr);
        JSONObject jsonObject = HttpServiceHelper.doPost(url, reqStr, JSONObject.class);
        if (jsonObject == null || !jsonObject.getString("errcode").equals("0")) {
            tripSyncLogParam.setStatus("B");
            logger.info("\u5546\u65c5\u96c6\u6210,\u6839\u636e\u7f16\u53f7\u83b7\u53d6\u83b7\u53d6\u98de\u673a\u884c\u7a0b\u5355/\u706b\u8f66\u7968\u6839\u5f71\u50cf\u4fe1\u606f,continue");
            return;
        }
        tripSyncLogParam.setStatus("A");
        tripSyncLogParam.setResponsedata(jsonObject);
        resultSet.add(jsonObject);
        boolean hasNextPage = this.judgeHasNextPage(jsonObject, pageSize);
        if (jsonObject.get((Object)"hasNextPage") != null && jsonObject.getBoolean("hasNextPage").booleanValue() || hasNextPage) {
            this.sendRequest(tmpBillNos, pageSize, ++pageIndex, logLists, url, resultSet);
        }
    }

    private boolean judgeHasNextPage(JSONObject jsonObject, int pageSize) {
        logger.info("\u5224\u65ad\u662f\u5426\u9700\u8981\u7ee7\u7eed\u8bfb\u53d6\u4e0b\u4e00\u9875");
        JSONObject data = jsonObject.getJSONObject("data");
        if (data != null) {
            JSONArray invoiceInfo = data.getJSONArray("invoiceInfo");
            if (invoiceInfo == null) {
                return false;
            }
            int size = invoiceInfo.size();
            logger.info("\u8fd4\u56de\u6570\u636e\u96c6\u5408size{}", (Object)size);
            if (size == pageSize) {
                return true;
            }
        }
        return false;
    }

    private String buildRequestParam(List<String> tmpBillNos, int pageSize, int pageIndex) {
        String accessToken = TravelNoOneSync.getCacheToken(TTRIPINVOICEIMAGEINFOINVOKE);
        JSONObject requestJson = new JSONObject();
        requestJson.put("data", tmpBillNos);
        requestJson.put("pageIndex", (Object)pageIndex);
        requestJson.put("pageSize", (Object)pageSize);
        requestJson.put("access_token", (Object)accessToken);
        return SerializationUtils.toJsonString((Object)requestJson);
    }

    protected Object convert(Object o) {
        if (o == null) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u83b7\u53d6\u53d1\u7968\u5f71\u50cf\u6570\u636e\u4e3a\u7a7a!", (String)"TTripInvoiceImageInfoInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            this.tripSyncLogParam.setStatus("B");
            return null;
        }
        Map convertResult = (Map)o;
        if (convertResult.isEmpty()) {
            return null;
        }
        HashSet allSets = (HashSet)convertResult.get("all");
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isNotEmpty((Collection)allSets)) {
            Iterator<JSONObject> iterator = allSets.iterator();
            List<TTripCheckingBillImageModel> models = this.gettTripCheckingBillImageModels(iterator);
            resultMap.put("all", models);
        }
        return resultMap;
    }

    private List<TTripCheckingBillImageModel> gettTripCheckingBillImageModels(Iterator<JSONObject> iterator) {
        ArrayList models = Lists.newArrayListWithCapacity((int)16);
        while (iterator.hasNext()) {
            JSONObject next = iterator.next();
            List<TTripCheckingBillImageModel> imageModels = TripCheckingInvoiceImageInfoUtil.dealInvoiceJSON(next, "invoiceInfo");
            this.handleSpecialFieldValue(imageModels);
            models.addAll(imageModels);
        }
        return models;
    }

    @Override
    protected void saveInfos(Object infos) {
        if (infos == null) {
            return;
        }
        logger.info("TTripInvoiceImageInfoInvoke saveInfos");
        Map resultModelsMap = (Map)infos;
        if (resultModelsMap.isEmpty()) {
            return;
        }
        this.dao = new ErOrm("er_checkingbill");
        ArrayList dynamicObjects = Lists.newArrayListWithCapacity((int)16);
        String lockKey = "kd.fi.er.business.trip.supplier.travelno1.invoke.TTripInvoiceImageInfoInvoke";
        try (DLock dLock = DLock.create((String)lockKey);){
            boolean isLock = dLock.tryLock(30000L);
            if (isLock) {
                List models = (List)resultModelsMap.get("all");
                Map<String, List<TTripCheckingBillImageModel>> billNoGroup = models.stream().collect(Collectors.groupingBy(TTripCheckingBillImageModel::getBillNo));
                HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
                Set<Map.Entry<String, List<TTripCheckingBillImageModel>>> entries = billNoGroup.entrySet();
                for (Map.Entry<String, List<TTripCheckingBillImageModel>> entry : entries) {
                    String key = entry.getKey();
                    List<TTripCheckingBillImageModel> value = entry.getValue();
                    if (CollectionUtils.isEmpty(value)) continue;
                    Set invoiceNos = value.stream().map(object -> object.getInvoiceCode() + object.getInvoiceNum()).collect(Collectors.toSet());
                    paramMap.put(key, invoiceNos);
                }
                dynamicObjects.addAll(this.handleFieldValue(models, this.dao, "all"));
                Map<String, Long> checkingBillMap = dynamicObjects.stream().collect(Collectors.toMap(dynamicObject -> TripCheckingInvoiceImageInfoUtil.dealBillNum(dynamicObject.getString("billnum")), ErCommonUtils::getPk));
                TripCheckingInvoiceImageInfoUtil.deleteOldData(paramMap, checkingBillMap);
                if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                }
            } else {
                logger.info("\u5c1d\u8bd5\u83b7\u53d6\u6240\u5931\u8d25:{}", (Object)lockKey);
            }
        }
        catch (Exception e) {
            logger.error("TTripInvoiceImageInfoInvoke saveinfos error", (Throwable)e);
        }
    }

    public List<DynamicObject> handleFieldValue(List models, ErOrm erDao) {
        if (CollectionUtils.isEmpty((Collection)models)) {
            return null;
        }
        return null;
    }

    private List<DynamicObject> handleFieldValue(List<TTripCheckingBillImageModel> models, ErOrm erDao, String key) {
        if (CollectionUtils.isEmpty(models)) {
            return new ArrayList<DynamicObject>();
        }
        HashMap billNoMap = Maps.newHashMapWithExpectedSize((int)16);
        switch (key) {
            case "all": {
                billNoMap.putAll(models.stream().filter(imageModel -> StringUtils.isNotEmpty((String)imageModel.getBillNo())).collect(Collectors.groupingBy(TTripCheckingBillImageModel::getBillNo)));
            }
        }
        if (billNoMap.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        Set billNos = billNoMap.keySet();
        HashSet checkingBillNos = Sets.newHashSetWithExpectedSize((int)16);
        for (String billNo : billNos) {
            checkingBillNos.add(billNo + "-1");
            checkingBillNos.add(billNo + "-2");
            checkingBillNos.add(billNo + "-3");
            checkingBillNos.add(billNo + "-4");
            checkingBillNos.add(billNo + "-5");
            checkingBillNos.add(billNo + "-6");
            checkingBillNos.add(billNo + "-8");
        }
        DynamicObject[] checkingBills = erDao.query(SELECT_FIELDS, new QFilter[]{new QFilter("billnum", "in", (Object)checkingBillNos)});
        Map<String, List<DynamicObject>> checkingBillMap = Arrays.stream(checkingBills).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("billnum")));
        HashMap waitUpdateCheckingBillMap = Maps.newHashMapWithExpectedSize((int)16);
        checkingBillMap.forEach((k, v) -> waitUpdateCheckingBillMap.put(TripCheckingInvoiceImageInfoUtil.dealBillNum(k), v));
        return this.getResultObject(billNoMap, waitUpdateCheckingBillMap);
    }

    private List<DynamicObject> getResultObject(Map<String, List<TTripCheckingBillImageModel>> billNoMap, Map<String, List<DynamicObject>> checkingBillMap) {
        Class<TTripCheckingBillImageModel> clazz = TTripCheckingBillImageModel.class;
        Field[] declaredFields = clazz.getDeclaredFields();
        String supplier = this.supplier();
        Set<Map.Entry<String, List<TTripCheckingBillImageModel>>> entries = billNoMap.entrySet();
        ArrayList resultList = Lists.newArrayListWithCapacity((int)16);
        for (Map.Entry<String, List<TTripCheckingBillImageModel>> entry : entries) {
            String key = entry.getKey();
            List<DynamicObject> dynamicObjects = checkingBillMap.get(key);
            if (CollectionUtils.isEmpty(dynamicObjects)) continue;
            DynamicObject dynamicObject = dynamicObjects.get(0);
            List<TTripCheckingBillImageModel> tmpModels = entry.getValue();
            HashSet sets = Sets.newHashSet(tmpModels);
            Iterator iterator = sets.iterator();
            DynamicObjectCollection invoiceentry = dynamicObject.getDynamicObjectCollection("invoiceentry");
            while (iterator.hasNext()) {
                DynamicObject newEntry = invoiceentry.addNew();
                TTripCheckingBillImageModel model = (TTripCheckingBillImageModel)iterator.next();
                TripCheckingInvoiceImageInfoUtil.dealFieldValue(declaredFields, model, newEntry);
                String decryptImageAddress = RSAUtils.decrypt(model.getImageAddress());
                model.setImageAddress(decryptImageAddress);
                model.setServer(supplier);
                newEntry.set("innerdownloadurl", (Object)TripCheckingInvoiceImageInfoUtil.convertInnerDownLoadLink(decryptImageAddress, model.getImageSuffixes(), model.getServer(), model.getInvoiceNum()));
                newEntry.set("downloadurl", (Object)decryptImageAddress);
                switch (model.getInvoiceSpecies()) {
                    case 0: {
                        newEntry.set("invoicetype", (Object)3);
                        break;
                    }
                    case 1: {
                        newEntry.set("invoicetype", (Object)4);
                        break;
                    }
                    case 2: {
                        newEntry.set("invoicetype", (Object)1);
                        break;
                    }
                    case 3: {
                        newEntry.set("invoicetype", (Object)14);
                        break;
                    }
                    case 4: {
                        newEntry.set("invoicetype", (Object)2);
                        break;
                    }
                    case 9: {
                        newEntry.set("invoicetype", (Object)7);
                        break;
                    }
                    case 81: {
                        newEntry.set("invoicetype", (Object)27);
                        newEntry.set("invoiceno", (Object)(model.getInvoiceCode() + model.getInvoiceNum()));
                        break;
                    }
                    case 82: {
                        newEntry.set("invoicetype", (Object)26);
                        newEntry.set("invoiceno", (Object)(model.getInvoiceCode() + model.getInvoiceNum()));
                        break;
                    }
                    default: {
                        newEntry.set("invoicetype", (Object)11);
                    }
                }
                newEntry.set("flightitineraryandtrain", (Object)0);
                newEntry.set("totalamount", (Object)model.getTotalMoney().add(model.getTotalTax()));
            }
            this.dealDownLoadUrl(tmpModels, invoiceentry);
            resultList.add(dynamicObject);
        }
        return resultList;
    }

    private void dealDownLoadUrl(List<TTripCheckingBillImageModel> tmpModels, DynamicObjectCollection invoiceEntry) {
    }
}

