/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.service.function.AbstractLoginInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TravelNoOneSync;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.common.CarTypeEnum;
import kd.fi.er.common.ExternalConstants;
import org.apache.commons.lang3.StringUtils;

public class TTripLoginInvoke
extends AbstractLoginInvoke {
    private static final Log logger = LogFactory.getLog(TTripLoginInvoke.class);
    private String TOKEN_EXPIRES_CODE = "40002";

    public TTripLoginInvoke() {
    }

    public TTripLoginInvoke(Map<String, Object> param) {
        super(param);
    }

    @Override
    public String login() {
        Map<String, String> bizInfoMap = TripCommonUtil.getTripServiceInfo(Supplier.CHAILVYIHAO.name());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String dateNowStr = sdf.format(new Date());
        int hour = Calendar.getInstance().get(11);
        String token = TravelNoOneSync.getCacheToken("");
        String url = this.getSSOSignUrl(bizInfoMap, token);
        logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u767b\u5f55,loginUrl:" + url);
        return url;
    }

    private String getSSOSignUrl(Map<String, String> bizInfoMap, String token) {
        String ssologinurlhead = bizInfoMap.get("reservedfield3");
        ssologinurlhead = ssologinurlhead + (String)ExternalConstants.TRAVELNOONEURLMAP.get("ssoLoginKey");
        StringBuilder ssoUrlBuilder = new StringBuilder(ssologinurlhead);
        Map<String, Object> returnDataMap = this.getTicket(token, bizInfoMap);
        if (!returnDataMap.containsKey("ticket") || Objects.isNull(returnDataMap.get("ticket"))) {
            logger.info("current employee{}", this.param.get("employeeNumber"));
            IFormView view = (IFormView)this.param.get("view");
            view.getFormShowParameter().setCustomParam("error", (Object)"true");
            view.showErrorNotification(ResManager.loadKDString((String)"\u4eba\u5458\u672a\u540c\u6b65\u7ed9\u5546\u65c5\u5e73\u53f0\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u8fdb\u884c\u5904\u7406\u3002", (String)"TTripLoginInvoke_2", (String)"fi-er-business", (Object[])new Object[0]));
            return "";
        }
        String ssoUrl = "";
        if (returnDataMap.size() > 0) {
            QFilter qD;
            QFilter qC;
            QFilter qA;
            DynamicObject dynamice;
            String businessType = String.valueOf(this.param.get("businessType"));
            String ticket = (String)returnDataMap.get("ticket");
            String type = this.getBusinessType(businessType, (Boolean)this.param.get("isPC"));
            ssoUrlBuilder.append("?ticket=").append(ticket).append("&type=").append(type).append("&appid=").append(bizInfoMap.get("appkey"));
            if ("32".equals(type)) {
                String defaultDisplayType = "";
                if ("hotel".equals(businessType)) {
                    defaultDisplayType = "3";
                } else if ("train".equals(businessType)) {
                    defaultDisplayType = "2";
                }
                if (StringUtils.isNotBlank((CharSequence)defaultDisplayType)) {
                    ssoUrlBuilder.append("&defaultDisplayType=").append(defaultDisplayType);
                }
            }
            if (this.param.getOrDefault("dotneedreqbill", false).booleanValue() || "guide".equalsIgnoreCase(businessType)) {
                return ssoUrlBuilder.toString();
            }
            if (null != this.param.get("applyBillNumber") && !this.param.get("applyBillNumber").toString().isEmpty()) {
                ssoUrlBuilder.append("&applyId=").append(this.param.get("applyBillNumber"));
            } else if (!"meal".equalsIgnoreCase(businessType) && null != (dynamice = BusinessDataServiceHelper.loadSingleFromCache((String)"er_trip_vehicle_setting", (String)"number,name,vehicletype", (QFilter[])new QFilter[]{qA = new QFilter("enable", "=", (Object)"1"), qC = new QFilter("vehicletype", "=", (Object)CarTypeEnum.OVERTIME.getCode()), qD = new QFilter("server", "=", (Object)Supplier.CHAILVYIHAO.name())}))) {
                ssoUrlBuilder.append("&applyLevelOneNo=").append(dynamice.getString("number")).append("&applyLevelOne=").append(dynamice.getString("name"));
            }
            ssoUrl = ssoUrlBuilder.toString();
        }
        return ssoUrl;
    }

    private String getH5SignUrl(Map<String, String> bizInfoMap, String token) {
        String h5loginurlhead = bizInfoMap.get("reservedfield3");
        h5loginurlhead = h5loginurlhead + (String)ExternalConstants.TRAVELNOONEURLMAP.get("h5LoginKey");
        StringBuilder h5UrlBuilder = new StringBuilder(h5loginurlhead);
        String h5url = "";
        String employeeId = this.param.get("employeeNumber") != null ? (String)this.param.get("employeeNumber") : "";
        h5UrlBuilder.append("?token=").append(token).append("&account=").append(employeeId).append("&type=").append(this.getBusinessType(String.valueOf(this.param.get("businessType")), (Boolean)this.param.get("isPC"))).append("&skinid=").append(bizInfoMap.get("reservedfield4")).append("&appid=").append(bizInfoMap.get("appkey"));
        h5url = h5UrlBuilder.toString();
        return h5UrlBuilder.toString();
    }

    private String getPCLoginUrl(Map<String, String> bizInfoMap, String token) {
        String pcUrl = "";
        Map<String, Object> returnDataMap = this.getTicket(token, bizInfoMap);
        if (returnDataMap != null & returnDataMap.size() > 0) {
            String pcUrlHead = (String)returnDataMap.get("returnUrl");
            String ticket = (String)returnDataMap.get("ticket");
            StringBuilder pcUrlBuilder = new StringBuilder(pcUrlHead);
            pcUrlBuilder.append("?ticket=").append(ticket);
            pcUrl = pcUrlBuilder.toString();
        }
        return pcUrl;
    }

    private Map<String, Object> getTicket(String token, Map<String, String> bizInfoMap) {
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>();
        String url = TripCommonUtil.getTravelNoOneApiUrl("ticketLoginKey");
        JSONObject postJson = new JSONObject();
        postJson.put("access_token", (Object)token);
        JSONObject postDataJson = new JSONObject();
        postDataJson.put("employeeID", this.param.get("employeeNumber"));
        postDataJson.put("systemId", (Object)bizInfoMap.get("reservedfield5"));
        postJson.put("data", (Object)postDataJson);
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String datestr = dataFormat.format(new Date());
        postJson.put("requestid", (Object)datestr);
        postJson.put("version", (Object)"0.0.1");
        String result = HttpRetryServiceHelper.PostData(url, postJson.toJSONString());
        JSONObject ticketJsonObject = JSONObject.parseObject((String)result);
        if (ticketJsonObject != null) {
            String errmsg = ticketJsonObject.getString("errmsg");
            String errcode = ticketJsonObject.getString("errcode");
            if (errmsg.equals("\u6210\u529f")) {
                JSONObject data = ticketJsonObject.getJSONObject("data");
                String ticket = data.getString("ticket");
                String returnUrl = data.getString("returnUrl");
                returnDataMap.put("ticket", ticket);
                returnDataMap.put("returnUrl", returnUrl);
            }
            if (errcode.equals(this.TOKEN_EXPIRES_CODE)) {
                token = TravelNoOneSync.getCacheToken("");
                return this.getTicket(token, bizInfoMap);
            }
        }
        return returnDataMap;
    }

    private String getBusinessType(String typeKey, Boolean isPc) {
        String type = "1";
        if (isPc.booleanValue()) {
            return "32";
        }
        HashMap<String, String> businessTypeMap = new HashMap<String, String>();
        businessTypeMap.put("domair", "10");
        businessTypeMap.put("hotel", "4");
        businessTypeMap.put("car", "20");
        businessTypeMap.put("train", "2");
        businessTypeMap.put("orderlist", "13");
        businessTypeMap.put("meal", "51");
        businessTypeMap.put("home", "1");
        businessTypeMap.put("guide", "48");
        for (Map.Entry entry : businessTypeMap.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(typeKey)) continue;
            type = (String)entry.getValue();
            break;
        }
        return type;
    }

    @Override
    protected void process(String loginString) {
        IFormView formView = (IFormView)this.param.get("view");
        Boolean isPC = (Boolean)this.param.get("isPC");
        if (!isPC.booleanValue()) {
            formView.showMessage(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d", (String)"TTripLoginInvoke_1", (String)"fi-er-business", (Object[])new Object[0]));
        }
        formView.openUrl(loginString);
    }
}

