/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.service.function.AbstractMealApplicationBillInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TravelNoOneSync;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.MealSceneEnum;

public class TTripMealBillInvoke
extends AbstractMealApplicationBillInvoke {
    private static final Log logger = LogFactory.getLog(TTripMealBillInvoke.class);

    @Override
    protected String supplier() {
        return Supplier.CHAILVYIHAO.name();
    }

    @Override
    protected String function() {
        return "mealApplicationBillInvoke";
    }

    @Override
    protected Object getInnerData() {
        Object billId = this.getParams().get("billId");
        if (Objects.isNull(billId)) {
            return null;
        }
        DynamicObject info = BusinessDataServiceHelper.loadSingle(billId, (String)"er_mealapplication_bill");
        if (info == null) {
            this.tripSyncLogParam.setStatus("B");
            this.tripSyncLogParam.setMessage(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230ID\u4e3a\u201c%s\u201d\u7684\u7528\u9910\u7533\u8bf7\u5355\u6570\u636e\u3002", (String)"MeiTuanMealApplicationBillInvoke_0", (String)"fi-er-business", (Object[])new Object[0]), billId));
        } else {
            this.tripSyncLogParam.setBillno(info.getString("billno"));
        }
        return info;
    }

    protected Object convert(Object info) {
        if (info == null) {
            return null;
        }
        return this.dealBillData((DynamicObject)info);
    }

    protected String batPushProcess(Object value) {
        Boolean isSucess;
        String syncStatus;
        if (value == null) {
            return null;
        }
        JSONObject t = (JSONObject)value;
        String jsonStr = JSON.toJSONString((Object)t, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        String url = "";
        switch (syncStatus = (String)this.getParams().get("syncStatus")) {
            case "1": {
                url = TripCommonUtil.getTravelNoOneApiUrl("addMealApproval");
            }
        }
        this.tripSyncLogParam.setRequestdata(value);
        this.tripSyncLogParam.setRequesturl(url);
        String result = HttpServiceHelper.PostData(url, jsonStr);
        this.tripSyncLogParam.setResponsedata(result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject != null && (isSucess = jsonObject.getBoolean("successful")).booleanValue()) {
            return "200";
        }
        return "300";
    }

    private JSONObject dealBillData(DynamicObject dynamicObject) {
        JSONObject data = new JSONObject();
        data.put("applyId", (Object)dynamicObject.getString("billno"));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        data.put("applicationTime", (Object)dateFormat.format(dynamicObject.getDate("bizdate")));
        data.put("applyState", (Object)"1");
        data.put("mealApplyType", (Object)"3");
        int dinnerscene = dynamicObject.getInt("dinnerscene");
        String dinnerSceneName = "";
        if (dinnerscene == MealSceneEnum.WORK_DINNER.getCode()) {
            dinnerSceneName = MealSceneEnum.WORK_DINNER.getValue();
        } else if (dinnerscene == MealSceneEnum.GROUP_DINNER.getCode()) {
            dinnerSceneName = MealSceneEnum.GROUP_DINNER.getValue();
        } else if (dinnerscene == MealSceneEnum.BUSSINESS_DINNER.getCode()) {
            dinnerSceneName = MealSceneEnum.BUSSINESS_DINNER.getValue();
        }
        data.put("travelType", (Object)dinnerSceneName);
        data.put("applyReason", (Object)dynamicObject.getString("description"));
        DynamicObject cityField = dynamicObject.getDynamicObject("cityfield");
        data.put("mealCity", (Object)cityField.getLocaleString("name").getLocaleValue());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        data.put("mealBeginTime", (Object)format.format(dynamicObject.getDate("startdate")));
        data.put("mealEndTime", (Object)format.format(dynamicObject.getDate("enddate")));
        data.put("mealMoney", (Object)dynamicObject.getBigDecimal("dinneramount"));
        JSONObject submitStaff = new JSONObject();
        submitStaff.put("empID", dynamicObject.get("creator.number"));
        submitStaff.put("staffName", (Object)dynamicObject.getLocaleString("creator.name").getLocaleValue());
        JSONObject applierStaff = new JSONObject();
        applierStaff.put("empID", dynamicObject.get("applier.number"));
        applierStaff.put("staffName", (Object)dynamicObject.getLocaleString("applier.name").getLocaleValue());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"er_mealapplication_bill", (String)"internalusers", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ErCommonUtils.getPk(dynamicObject))});
        JSONArray innerStaffJsonArray = new JSONArray();
        this.dealInnerStaffs(innerStaffJsonArray, load);
        data.put("mealStaffNames", (Object)innerStaffJsonArray);
        data.put("submitStaff", (Object)submitStaff);
        data.put("applicantStaff", (Object)applierStaff);
        Map<String, String> tripInfoDynamic = TripCommonUtil.getTripServiceInfo(Supplier.CHAILVYIHAO.name());
        this.setBaseDataInfo(tripInfoDynamic, data, dynamicObject);
        JSONArray dataJson = new JSONArray();
        dataJson.add((Object)data);
        JSONObject resultJson = new JSONObject();
        resultJson.put("data", (Object)dataJson);
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String datestr = dataFormat.format(new Date());
        resultJson.put("requestid", (Object)datestr);
        resultJson.put("access_token", (Object)TravelNoOneSync.getLoginToken());
        resultJson.put("version", (Object)"0.0.1");
        return resultJson;
    }

    private void setBaseDataInfo(Map<String, String> tripInfoDynamic, JSONObject data, DynamicObject dynamicObject) {
        boolean tripReqSyncIdFlag = TripSyncConfigUtil.getBoolean("ttrip_issyncorg_num");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_adminorg", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ErCommonUtils.getPk(dynamicObject.get("org")))});
        DynamicObject[] userInfos = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,number,entryentity.dpt,entryentity.ispartjob,entryentity.id", (QFilter[])new QFilter[]{new QFilter("number", "=", dynamicObject.get("applier.number"))});
        DynamicObject orgInfo = null;
        if (userInfos != null) {
            DynamicObjectCollection entryEntity = userInfos[0].getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject deptDynamicObject = (DynamicObject)entryEntity.get(i);
                boolean ispartjob = deptDynamicObject.getBoolean("ispartjob");
                if (ispartjob) continue;
                Long id = ErCommonUtils.getPk(deptDynamicObject.get("dpt"));
                try {
                    String param = tripInfoDynamic.get("syncreqbillsettleorg");
                    if ("1".equals(param)) {
                        Long companyId = CoreBaseBillServiceHelper.initCompanyByDept(id);
                        orgInfo = BusinessDataServiceHelper.loadSingle((String)"bos_adminorg", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)companyId)});
                        continue;
                    }
                    Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId(id);
                    orgInfo = BusinessDataServiceHelper.loadSingle((String)"bos_adminorg", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)accountOrgId)});
                    continue;
                }
                catch (Exception e) {
                    logger.info("\u83b7\u53d6\u4e3b\u804c\u4f4d\u6838\u7b97\u7ec4\u7ec7\u5931\u8d25" + e.getMessage());
                }
            }
        }
        JSONArray baseDataInfoDetail = new JSONArray();
        JSONObject detail = new JSONObject();
        if (tripReqSyncIdFlag) {
            if (load != null && load.length > 0) {
                detail.put("costCenterNO", load[0].get("number"));
                detail.put("costCenterName", (Object)load[0].getLocaleString("name").getLocaleValue());
            } else {
                detail.put("costCenterNO", (Object)"");
                detail.put("costCenterName", (Object)"");
            }
            if (orgInfo != null) {
                detail.put("regNO", orgInfo.get("number"));
                detail.put("regName", (Object)orgInfo.getLocaleString("name").getLocaleValue());
            } else {
                detail.put("regNO", (Object)"");
                detail.put("regName", (Object)"");
            }
        } else {
            if (load != null && load.length > 0) {
                detail.put("costCenterNO", load[0].get("id"));
                detail.put("costCenterName", (Object)load[0].getLocaleString("name").getLocaleValue());
            } else {
                detail.put("costCenterNO", (Object)"");
                detail.put("costCenterName", (Object)"");
            }
            if (orgInfo != null) {
                detail.put("regNO", orgInfo.get("id"));
                detail.put("regName", (Object)orgInfo.getLocaleString("name").getLocaleValue());
            } else {
                detail.put("regNO", (Object)"");
                detail.put("regName", (Object)"");
            }
        }
        baseDataInfoDetail.add((Object)detail);
        data.put("approvalBaseDataInfos", (Object)baseDataInfoDetail);
    }

    private void dealInnerStaffs(JSONArray innerStaffJsonArray, DynamicObject[] load) {
        if (load == null || load.length == 0) {
            return;
        }
        HashSet<Long> userIdSet = new HashSet<Long>();
        for (DynamicObject row : load) {
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)row.get("internalusers");
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                Long fbasedataid = ErCommonUtils.getPk(dynamicObject.get("fbasedataid"));
                userIdSet.add(fbasedataid);
            }
        }
        QFilter qFilter = new QFilter("id", "in", userIdSet);
        DynamicObject[] userArr = BusinessDataServiceHelper.load((String)"bos_user", (String)"number,name", (QFilter[])new QFilter[]{qFilter});
        if (userArr == null || userArr.length == 0) {
            return;
        }
        for (int i = 0; i < userArr.length; ++i) {
            DynamicObject dynamicObject = userArr[i];
            JSONObject userJson = new JSONObject();
            userJson.put("empID", dynamicObject.get("number"));
            userJson.put("staffName", (Object)dynamicObject.getLocaleString("name").getLocaleValue());
            innerStaffJsonArray.add((Object)userJson);
        }
    }
}

