/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.service.function.AbstractOrgInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.travelno1.invoke.TTripOrgAndUserInvokeUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.commons.lang3.StringUtils;

public class TTripOrgInvoke
extends AbstractOrgInvoke {
    private static Log logger = LogFactory.getLog(TTripOrgInvoke.class);

    @Override
    protected String supplier() {
        return Supplier.CHAILVYIHAO.name();
    }

    @Override
    protected Object getInnerData() {
        this.bizInfoObject = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)"lastsyncorgtamp", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
        this.lastSyncOrgTamp = this.bizInfoObject.getString("lastsyncorgtamp");
        return this.queryChangeInfo();
    }

    private Map<String, JSONArray> queryChangeInfo() {
        Date changetime = TripCommonUtil.convertToDate(this.lastSyncOrgTamp);
        QFilter qFilter = new QFilter("view", "=", (Object)1L);
        if (this.params != null && null != this.params.get("orgList")) {
            qFilter.and(new QFilter("org", "in", this.params.get("orgList")));
        } else {
            QFilter createtimeFilter = new QFilter("createtime", ">=", (Object)changetime);
            QFilter modifytimeFilter = new QFilter("modifytime", ">=", (Object)changetime);
            QFilter timeFilter = createtimeFilter.or(modifytimeFilter);
            qFilter.and(timeFilter);
        }
        DynamicObjectCollection orgDOs = QueryServiceHelper.query((String)"bos_org_structure", (String)"number, org, org.name, parent, createtime, modifytime, isfreeze", (QFilter[])new QFilter[]{qFilter}, (String)"level");
        Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(this.supplier());
        String companyId = supplierMap.get("orationid");
        String companyName = supplierMap.get("reservedfield1");
        HashMap<String, JSONArray> dataMap = new HashMap<String, JSONArray>();
        JSONArray updateList = new JSONArray();
        JSONArray enableEntryList = new JSONArray();
        JSONArray newList = new JSONArray();
        JSONArray disableEntryList = new JSONArray();
        orgDOs.stream().forEach(v -> {
            this.buildNewMap(newList, (DynamicObject)v, companyId, companyName);
            this.buildNewMap(updateList, (DynamicObject)v, companyId, companyName);
            if (v.getBoolean("isfreeze")) {
                this.buildEnableOrg(disableEntryList, (DynamicObject)v);
            } else {
                this.buildEnableOrg(enableEntryList, (DynamicObject)v);
            }
        });
        dataMap.put("new", newList);
        this.buildEnableMap(dataMap, "disable", disableEntryList, companyId, companyName);
        dataMap.put("update", updateList);
        this.buildEnableMap(dataMap, "enable", enableEntryList, companyId, companyName);
        return dataMap;
    }

    private void buildNewMap(JSONArray newList, DynamicObject v, String companyId, String companyName) {
        String parentDeptNO = String.valueOf(v.getLong("parent"));
        if (v.getLong("parent") == 0L) {
            parentDeptNO = companyId;
        }
        JSONObject newObj = new JSONObject();
        newObj.put("companyID", (Object)companyId);
        newObj.put("companyName", (Object)companyName);
        newObj.put("deptNO", (Object)v.getLong("org"));
        newObj.put("deptName", (Object)v.getString("org.name"));
        newObj.put("status", (Object)1);
        newObj.put("superDeptNO", (Object)parentDeptNO);
        newList.add((Object)newObj);
    }

    private void buildEnableOrg(JSONArray entryList, DynamicObject v) {
        JSONObject entryObj = new JSONObject();
        entryObj.put("outDeptNO", (Object)v.getLong("org"));
        entryObj.put("deptName", (Object)v.getString("org.name"));
        entryList.add((Object)entryObj);
    }

    private void buildEnableMap(Map map, String key, JSONArray entryList, String companyId, String companyName) {
        if (entryList != null && entryList.size() > 0) {
            JSONArray disableList = new JSONArray();
            JSONObject disableObj = new JSONObject();
            disableObj.put("deptInfoRequestBoList", (Object)entryList);
            disableObj.put("companyID", (Object)companyId);
            disableObj.put("companyName", (Object)companyName);
            disableList.add((Object)disableObj);
            map.put(key, disableList);
        }
    }

    protected Object convert(Object info) {
        return info;
    }

    protected String batPushProcess(Object data) {
        Map orgJSONArrayMap = (Map)data;
        if (orgJSONArrayMap == null || orgJSONArrayMap.size() <= 0) {
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210,\u7ec4\u7ec7\u66f4\u65b0,\u7ec4\u7ec7\u4e3a\u7a7a!", (String)"MeiTuanTripOrgInvoke_0", (String)"fi-er-business", (Object[])new Object[0]));
            return "200";
        }
        AtomicReference<Boolean> successflag = new AtomicReference<Boolean>(true);
        orgJSONArrayMap.forEach((key, value) -> {
            String url = "";
            switch (key) {
                case "new": {
                    url = TripCommonUtil.getTravelNoOneApiUrl("adddepturlkey");
                    break;
                }
                case "update": {
                    url = TripCommonUtil.getTravelNoOneApiUrl("modifydepturlkey");
                    break;
                }
                case "disable": {
                    url = TripCommonUtil.getTravelNoOneApiUrl("disabledepturlkey");
                    break;
                }
                case "enable": {
                    url = TripCommonUtil.getTravelNoOneApiUrl("enabledepturlkey");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)url)) {
                TTripOrgAndUserInvokeUtil.postChangeData(successflag, "TTripSyncOrg", value, url, this.tripSyncLogParam, this.tripSyncLogParamList);
            }
        });
        String code = "300";
        if (successflag.get().booleanValue()) {
            code = "200";
        }
        return code;
    }
}

