/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.model.JourneyModel;
import kd.fi.er.business.trip.model.TripReqbillModel;
import kd.fi.er.business.trip.service.function.AbstractTripReqBillInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TravelNoOneSync;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import org.apache.commons.lang.StringUtils;

public class TTripReqbillInvoke
extends AbstractTripReqBillInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(TTripReqbillInvoke.class);

    public TTripReqbillInvoke(Object pk) {
        super(pk);
    }

    public TTripReqbillInvoke() {
    }

    @Override
    protected String supplier() {
        return Supplier.CHAILVYIHAO.name();
    }

    protected JSONObject convert(Object value) {
        if (this.pk != null) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u51fa\u5dee\u7533\u8bf7\u5355,\u5355\u636ebillid\u4e3a:" + this.pk);
            return this.convertPushBill(value);
        }
        String syncStatus = (String)this.getParams().get("syncStatus");
        logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u51fa\u5dee\u7533\u8bf7\u5355,\u540c\u6b65\u7684\u72b6\u6001\u6709:1_\u63a8\u9001\u5355\u636e,2_\u5173\u95ed\u5355\u636e,3_\u542f\u7528\u5355\u636e,4_\u64a4\u9500\u5355\u636e,\u5f53\u524d\u72b6\u6001\u4e3a:" + syncStatus);
        switch (syncStatus) {
            case "1": {
                return this.convertPushBill(value);
            }
            case "2": 
            case "3": 
            case "4": {
                return this.convertStatusChange(value, syncStatus);
            }
        }
        return null;
    }

    protected JSONObject convertPushBill(Object info) {
        TripReqbillModel reqbill = (TripReqbillModel)info;
        logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u51fa\u5dee\u7533\u8bf7\u5355,\u63a8\u9001\u8f6c\u6362:" + reqbill.getBillNo());
        String routetype = reqbill.getRoutetype();
        List<JourneyModel> journeyModelList = reqbill.getJourneyModelList();
        JSONObject bodyDataJson = new JSONObject();
        JSONArray dataArray = new JSONArray();
        JSONArray applyList = new JSONArray();
        JSONArray voyageList = new JSONArray();
        JSONArray staffList = new JSONArray();
        JSONObject dataObject = new JSONObject();
        JSONObject applyObject = new JSONObject();
        JSONObject handoverStaff = new JSONObject();
        JSONObject submitStaff = new JSONObject();
        Boolean ispasswaypush = TripSyncConfigUtil.getBoolean("ctrip_PassWay_Push");
        HashMap travelerMap = new HashMap();
        for (int i = 0; i < journeyModelList.size(); ++i) {
            JSONObject voyageObject = new JSONObject();
            JourneyModel journeyModel = journeyModelList.get(i);
            String fromCity = journeyModel.getFromCity();
            String toCity = journeyModel.getToCity();
            if (ispasswaypush.booleanValue() && null != journeyModel.getMulwaytos() && journeyModel.getMulwaytos().size() > 0) {
                StringBuffer city = new StringBuffer();
                journeyModel.getMulwaytos().forEach(v -> {
                    city.append(v.getToCity());
                    city.append(",");
                });
                toCity = city + toCity + "," + fromCity;
            }
            String startDate = TripCommonUtil.date2TimeStamp(journeyModel.getStartDate(), "yyyy-MM-dd");
            String endDate = TripCommonUtil.date2TimeStamp(journeyModel.getEndDate(), "yyyy-MM-dd");
            String trafficTool = journeyModel.getTrafficTool();
            String travelType = this.getTravelType(trafficTool);
            String travelTypeName = this.getTravelTypeName(trafficTool);
            voyageObject.put("beginDate", (Object)startDate);
            voyageObject.put("endDate", (Object)endDate);
            voyageObject.put("fromCity", (Object)fromCity);
            if (StringUtils.isBlank((String)toCity)) {
                voyageObject.put("toCity", (Object)toCity);
            } else {
                Set toCitySet = Arrays.stream(toCity.split(",")).collect(Collectors.toSet());
                voyageObject.put("toCity", (Object)StringUtils.join(toCitySet, (String)","));
            }
            voyageObject.put("travelNo", (Object)(i + 1));
            voyageObject.put("travelType", (Object)travelType);
            voyageObject.put("travelTypeName", (Object)travelTypeName);
            voyageObject.put("voyageType", (Object)Integer.valueOf(routetype));
            voyageObject.put("voyageTypeName", (Object)(Integer.parseInt(routetype) == 0 ? ResManager.loadKDString((String)"\u5355\u7a0b", (String)"TTripReqbillInvoke_2", (String)"fi-er-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f80\u8fd4", (String)"TTripReqbillInvoke_0", (String)"fi-er-business", (Object[])new Object[0])));
            if (ispasswaypush.booleanValue()) {
                voyageObject.put("wayCity", (Object)"force");
            }
            voyageList.add((Object)voyageObject);
            Set<DynamicObject> travelers = journeyModel.getTravelers();
            travelers.stream().forEach(traveler -> {
                String name = traveler.getString("name");
                String number = traveler.getString("number");
                travelerMap.put(number, name);
            });
        }
        for (Map.Entry entry : travelerMap.entrySet()) {
            JSONObject staffObject = new JSONObject();
            staffObject.put("staffName", entry.getValue());
            staffObject.put("empID", entry.getKey());
            staffList.add((Object)staffObject);
        }
        applyObject.put("staffList", (Object)staffList);
        applyObject.put("voyageList", (Object)voyageList);
        applyList.add((Object)applyObject);
        handoverStaff.put("staffName", (Object)reqbill.getAduitEmpName());
        handoverStaff.put("empID", (Object)reqbill.getAduitEmpNum());
        submitStaff.put("staffName", (Object)reqbill.getCreatEmpName());
        submitStaff.put("empID", (Object)reqbill.getCreatEmpNum());
        dataObject.put("applyId", (Object)reqbill.getBillNo());
        dataObject.put("applyList", (Object)applyList);
        dataObject.put("applyPassState", (Object)0);
        dataObject.put("applyPurpose", (Object)ResManager.loadKDString((String)"\u51fa\u5dee", (String)"TTripReqbillInvoke_7", (String)"fi-er-business", (Object[])new Object[0]));
        dataObject.put("applyReason", (Object)reqbill.getDesc());
        dataObject.put("applyState", (Object)1);
        this.setReqBillSettleOrg(reqbill, dataObject);
        dataObject.put("costCenterType", (Object)1);
        dataObject.put("handoverStaff", (Object)handoverStaff);
        dataObject.put("submitStaff", (Object)submitStaff);
        dataArray.add((Object)dataObject);
        bodyDataJson.put("access_token", (Object)TravelNoOneSync.getLoginToken());
        bodyDataJson.put("data", (Object)dataArray);
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String datestr = dataFormat.format(new Date());
        bodyDataJson.put("requestid", (Object)datestr);
        bodyDataJson.put("version", (Object)"0.0.1");
        return bodyDataJson;
    }

    private void setReqBillSettleOrg(TripReqbillModel reqbill, JSONObject dataObject) {
        Map<String, String> tripInfoDynamic = TripCommonUtil.getTripServiceInfo(Supplier.CHAILVYIHAO.name());
        if (tripInfoDynamic != null && tripInfoDynamic.size() > 0) {
            String deptName;
            String companyName;
            String param = tripInfoDynamic.get("syncreqbillsettleorg");
            boolean flag = param == null || StringUtils.isBlank((String)param) || "0".equalsIgnoreCase(param);
            boolean isTtrpReqSyncId = TripSyncConfigUtil.getBoolean("ttrip_issyncorg_num");
            if (isTtrpReqSyncId) {
                String deptNum;
                String companyNum;
                if (flag) {
                    companyName = reqbill.getCostCompany();
                    companyNum = reqbill.getCostCompanyNum();
                    deptName = reqbill.getCostdept();
                    deptNum = reqbill.getCostdeptNum();
                } else {
                    companyName = reqbill.getCompany();
                    companyNum = reqbill.getCompanyNum();
                    deptName = reqbill.getDept();
                    deptNum = reqbill.getDeptNum();
                }
                dataObject.put("settlementEntityCode", (Object)companyNum);
                dataObject.put("costCenterNo", (Object)deptNum);
            } else {
                Long deptId;
                Long companyId;
                if (flag) {
                    companyName = reqbill.getCostCompany();
                    companyId = reqbill.getCostCompanyId();
                    deptName = reqbill.getCostdept();
                    deptId = reqbill.getCostdeptId();
                } else {
                    companyName = reqbill.getCompany();
                    companyId = reqbill.getCompanyId();
                    deptName = reqbill.getDept();
                    deptId = reqbill.getDeptId();
                }
                dataObject.put("settlementEntityCode", (Object)companyId);
                dataObject.put("costCenterNo", (Object)deptId);
            }
            dataObject.put("settlementEntityName", (Object)companyName);
            dataObject.put("costCenterName", (Object)deptName);
        }
    }

    private JSONObject convertStatusChange(Object info, String syncStatus) {
        TripReqbillModel reqbill = (TripReqbillModel)info;
        logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u51fa\u5dee\u7533\u8bf7\u5355,\u53d8\u66f4\u540c\u6b65\u72b6\u6001,\u7533\u8bf7\u5355\u7f16\u53f7:" + reqbill.getBillNo());
        JSONObject dataObject = new JSONObject();
        dataObject.put("thirdApplyID", (Object)reqbill.getBillNo());
        String createDate = TripCommonUtil.date2TimeStamp(reqbill.getCreatetime(), "yyyy-MM-dd hh:mm");
        dataObject.put("applicationTime", (Object)createDate);
        switch (syncStatus) {
            case "2": 
            case "3": {
                dataObject.put("applicationType", (Object)1);
                dataObject.put("dealType", (Object)syncStatus);
                break;
            }
            case "4": {
                dataObject.put("checkAllOrder", (Object)Boolean.FALSE);
                dataObject.put("checkOrderType", (Object)"0");
                dataObject.put("queryType", (Object)3);
            }
        }
        JSONObject bodyDataJson = new JSONObject();
        bodyDataJson.put("access_token", (Object)TravelNoOneSync.getLoginToken());
        bodyDataJson.put("data", (Object)dataObject);
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String datestr = dataFormat.format(new Date());
        bodyDataJson.put("requestid", (Object)datestr);
        bodyDataJson.put("version", (Object)"0.0.1");
        return bodyDataJson;
    }

    protected String batPushProcess(Object value) {
        String syncStatus;
        if (value == null) {
            return null;
        }
        JSONObject t = (JSONObject)value;
        String jsonStr = JSON.toJSONString((Object)t, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        String url = "";
        switch (syncStatus = (String)this.getParams().get("syncStatus")) {
            case "1": {
                url = TripCommonUtil.getTravelNoOneApiUrl("addapproval");
                break;
            }
            case "2": 
            case "3": {
                url = TripCommonUtil.getTravelNoOneApiUrl("updateApprovalStatus");
                break;
            }
            case "4": {
                url = TripCommonUtil.getTravelNoOneApiUrl("cancelApproval");
            }
        }
        this.tripSyncLogParam.setRequestdata(value);
        this.tripSyncLogParam.setRequesturl(url);
        String result = HttpRetryServiceHelper.PostData(url, jsonStr);
        this.tripSyncLogParam.setResponsedata(result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject != null) {
            if (syncStatus == "4") {
                String backCode = null;
                JSONArray relateOrderList = jsonObject.getJSONArray("relateOrderList");
                String errcode = jsonObject.getString("errcode");
                if ("0".equals(errcode)) {
                    backCode = "200";
                } else if ("1".equals(errcode)) {
                    backCode = relateOrderList == null ? "200" : "300";
                }
                return backCode;
            }
            Boolean isSucess = jsonObject.getBoolean("successful");
            if (isSucess.booleanValue()) {
                return "200";
            }
        }
        return null;
    }

    private String getTravelType(String trafficTool) {
        String travelType = "0";
        switch (trafficTool) {
            case "1": {
                travelType = "0";
                break;
            }
            case "2": {
                travelType = "1";
                break;
            }
            case "3": {
                travelType = "2";
                break;
            }
            case "4": 
            case "5": {
                travelType = "3";
            }
        }
        return travelType;
    }

    private String getTravelTypeName(String trafficTool) {
        String travelTypeName = ResManager.loadKDString((String)"\u98de\u673a", (String)"TTripReqbillInvoke_3", (String)"fi-er-business", (Object[])new Object[0]);
        switch (trafficTool) {
            case "1": {
                travelTypeName = ResManager.loadKDString((String)"\u98de\u673a", (String)"TTripReqbillInvoke_3", (String)"fi-er-business", (Object[])new Object[0]);
                break;
            }
            case "2": {
                travelTypeName = ResManager.loadKDString((String)"\u706b\u8f66", (String)"TTripReqbillInvoke_4", (String)"fi-er-business", (Object[])new Object[0]);
                break;
            }
            case "3": {
                travelTypeName = ResManager.loadKDString((String)"\u6c7d\u8f66", (String)"TTripReqbillInvoke_5", (String)"fi-er-business", (Object[])new Object[0]);
                break;
            }
            case "4": 
            case "5": {
                travelTypeName = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"TTripReqbillInvoke_6", (String)"fi-er-business", (Object[])new Object[0]);
            }
        }
        return travelTypeName;
    }
}

