/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke.checking;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.HotelCheckingBillDetailModel;
import kd.fi.er.business.trip.model.MealCheckingBillDetailModel;
import kd.fi.er.business.trip.model.PlaneCheckingBillDetailModel;
import kd.fi.er.business.trip.model.TrainCheckingBillDetailModel;
import kd.fi.er.business.trip.model.VehicleCheckingBillDetailModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TTripPropMapping;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.v2.utils.TripDataDealUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;

public class TTripCheckingCommonConvert {
    private static String splitSign = "-";
    private static final Log logger = LogFactory.getLog(TTripCheckingCommonConvert.class);

    public static void buildCheckingCommonData(AbstractCheckingBillDetailModel checkingModel, JSONObject checkingJson, JSONObject headJson) {
        BigDecimal productRealClearingMoney;
        checkingModel.setServer(Supplier.CHAILVYIHAO.name());
        checkingModel.setOrderNum(checkingJson.getString("orderId"));
        checkingModel.setBatchno(checkingJson.getString("billNo") + "-" + checkingJson.getString("productType"));
        checkingModel.setOaBillNum(checkingJson.getString("corporationApplyNo"));
        checkingModel.setOrderDate(TripCommonUtil.convertToDate(checkingJson.getString("tradeTime")));
        if (TripSyncConfigUtil.getBoolean("ttrip_period_value", Boolean.TRUE).booleanValue()) {
            checkingModel.setHappendDate(TripCommonUtil.convertToDate(checkingJson.getString("tradeTime")));
        } else {
            checkingModel.setHappendDate(TripCommonUtil.getLastMonthFirstDayByStr(headJson.getString("billPeriod")));
        }
        checkingModel.setOrderType(TTripPropMapping.getOrderTypeEnumByKey(checkingJson.getString("productSubTypeName")));
        checkingModel.setOperationType(TTripPropMapping.getOperationTypeEnumByKey(checkingJson.getString("productType")));
        checkingModel.setProductType(TTripPropMapping.getPayTypeEnumByKey(checkingJson.getString("payType")));
        checkingModel.setOrderNatrue("1".equalsIgnoreCase(checkingJson.getString("travelType")) ? AbstractOrderModel.OrderNatrue.A : AbstractOrderModel.OrderNatrue.B);
        checkingModel.setOrderSort("3".equalsIgnoreCase(checkingJson.getString("productType")) || "1".equalsIgnoreCase(checkingJson.getString("productType")) || "6".equalsIgnoreCase(checkingJson.getString("productType")) || "11".equalsIgnoreCase(checkingJson.getString("productType")) ? AbstractCheckingBillDetailModel.OrderSort.A : AbstractCheckingBillDetailModel.OrderSort.B);
        checkingModel.setSourceBookedId(checkingJson.getString("orderUserOutStaffNo"));
        checkingModel.setBookedname(checkingJson.getString("orderUserName"));
        String travelerNo = checkingJson.getString("passengerOutStaffNo");
        String travelerName = checkingJson.getString("passengersName");
        String joinNO = StringUtils.isNotBlank((CharSequence)travelerNo) ? travelerNo : travelerName;
        BigDecimal bigDecimal = productRealClearingMoney = checkingJson.getBigDecimal("productRealClearingMoney") == null ? BigDecimal.ZERO : checkingJson.getBigDecimal("productRealClearingMoney");
        if (checkingModel instanceof PlaneCheckingBillDetailModel) {
            ((PlaneCheckingBillDetailModel)checkingModel).setSourceTravelerId(travelerNo);
            ((PlaneCheckingBillDetailModel)checkingModel).setTravelername(travelerName);
            checkingModel.setPersonalFee(productRealClearingMoney);
        }
        if (checkingModel instanceof HotelCheckingBillDetailModel) {
            ((HotelCheckingBillDetailModel)checkingModel).setSourcetravelerid(travelerNo);
            ((HotelCheckingBillDetailModel)checkingModel).setTravelername(travelerName);
            checkingModel.setPersonalFee(productRealClearingMoney);
        }
        if (checkingModel instanceof TrainCheckingBillDetailModel) {
            ((TrainCheckingBillDetailModel)checkingModel).setPasseger(travelerNo);
            ((TrainCheckingBillDetailModel)checkingModel).setPassegername(travelerName);
            checkingModel.setPersonalFee(productRealClearingMoney);
        }
        if (checkingModel instanceof VehicleCheckingBillDetailModel) {
            ((VehicleCheckingBillDetailModel)checkingModel).setPasseger(travelerNo);
            ((VehicleCheckingBillDetailModel)checkingModel).setPassegerName(travelerName);
            checkingModel.setPersonalFee(productRealClearingMoney);
        }
        if (checkingModel instanceof MealCheckingBillDetailModel) {
            joinNO = checkingJson.getString("orderUserOutStaffNo");
        }
        checkingModel.setOrderNum(checkingModel.getOrderNum() + splitSign + joinNO);
        String parentNumStr = checkingJson.getString("originalOrderId");
        if (StringUtils.isNotBlank((CharSequence)parentNumStr)) {
            checkingModel.setParentordernum(parentNumStr + splitSign + joinNO);
        }
        if (checkingModel.getOrderType() == AbstractOrderModel.OrderType.O && StringUtils.isBlank((CharSequence)checkingModel.getParentordernum())) {
            checkingModel.setParentordernum(checkingModel.getOrderNum());
        }
        if (checkingModel instanceof PlaneCheckingBillDetailModel || checkingModel instanceof HotelCheckingBillDetailModel) {
            checkingModel.setProductsontype(TTripPropMapping.getProductsontypeEnumByKey(checkingJson.getString("productSonTypeName")));
        }
        checkingModel.setOrderamounttax(checkingJson.getBigDecimal("reBackMoney"));
        checkingModel.setServeOughtPayMoney(checkingJson.getBigDecimal("serveOughtPayMoney"));
        checkingModel.setReceiptMoneyTotal(checkingJson.getBigDecimal("receiptMoneyTotal"));
        checkingModel.setServeReceiptMoney(checkingJson.getBigDecimal("serveReceiptMoney"));
        checkingModel.setServeActualPayMoney(checkingJson.getBigDecimal("serveActualPayMoney"));
        checkingModel.setTotalAmount(checkingJson.getBigDecimal("orderMoney").subtract(productRealClearingMoney));
        checkingModel.setUniqueId(TripDataDealUtils.getValue(checkingJson, "keyId", "", String::new));
        TTripCheckingCommonConvert.queryAndBuildCostOrg(checkingModel, checkingJson.getString("settleSubjectNumber"), checkingJson.getString("costCenterCode"));
    }

    private static void queryAndBuildCostOrg(AbstractCheckingBillDetailModel checkingModel, String costcompanyNo, String costdeptNo) {
        if (StringUtils.isNotBlank((CharSequence)costcompanyNo) || StringUtils.isNotBlank((CharSequence)costdeptNo)) {
            boolean isTtrpReqSyncId = TripSyncConfigUtil.getBoolean("ttrip_issyncorg_num");
            QFilter noFilter = null;
            if (isTtrpReqSyncId) {
                ArrayList<String> orgNos = new ArrayList<String>();
                orgNos.add(costcompanyNo);
                orgNos.add(costdeptNo);
                noFilter = new QFilter("number", "in", orgNos);
            } else {
                ArrayList<Long> orgIds = new ArrayList<Long>();
                if (NumberUtils.isNumber((String)costcompanyNo)) {
                    orgIds.add(Long.parseLong(costcompanyNo));
                }
                if (NumberUtils.isNumber((String)costdeptNo)) {
                    orgIds.add(Long.parseLong(costdeptNo));
                }
                if (CollectionUtils.isEmpty(orgIds)) {
                    ArrayList<String> orgNos = new ArrayList<String>();
                    orgNos.add(costcompanyNo);
                    orgNos.add(costdeptNo);
                    noFilter = new QFilter("number", "in", orgNos);
                } else {
                    noFilter = new QFilter("id", "in", orgIds);
                }
            }
            QFilter[] qFilters = new QFilter[]{noFilter};
            Map costOrgDO = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id, number", (QFilter[])qFilters);
            if (costOrgDO != null && costOrgDO.size() > 0) {
                costOrgDO.forEach((key, value) -> {
                    if (NumberUtils.isNumber((String)costdeptNo) && NumberUtils.isNumber((String)costcompanyNo)) {
                        if (isTtrpReqSyncId) {
                            if (value != null && value.get("number") != null && StringUtils.isNotBlank((CharSequence)costcompanyNo) && value.getString("number").equalsIgnoreCase(costcompanyNo)) {
                                checkingModel.setSettlemain(value.getPkValue().toString());
                            }
                            if (value != null && value.get("number") != null && StringUtils.isNotBlank((CharSequence)costdeptNo) && value.getString("number").equalsIgnoreCase(costdeptNo)) {
                                checkingModel.setSettledept(value.getPkValue().toString());
                            }
                        } else {
                            if (value != null && value.getPkValue() != null && StringUtils.isNotBlank((CharSequence)costcompanyNo) && ((Long)value.getPkValue()).compareTo(Long.parseLong(costcompanyNo)) == 0) {
                                checkingModel.setSettlemain(value.getPkValue().toString());
                            }
                            if (value != null && value.getPkValue() != null && StringUtils.isNotBlank((CharSequence)costdeptNo) && ((Long)value.getPkValue()).compareTo(Long.parseLong(costdeptNo)) == 0) {
                                checkingModel.setSettledept(value.getPkValue().toString());
                            }
                        }
                    } else {
                        if (value != null && value.get("number") != null && StringUtils.isNotBlank((CharSequence)costcompanyNo) && (value.getString("number").equalsIgnoreCase(costcompanyNo) || value.getPkValue().toString().equalsIgnoreCase(costcompanyNo))) {
                            checkingModel.setSettlemain(value.getPkValue().toString());
                        }
                        if (value != null && value.get("number") != null && StringUtils.isNotBlank((CharSequence)costdeptNo) && (value.getString("number").equalsIgnoreCase(costdeptNo) || value.getPkValue().toString().equalsIgnoreCase(costdeptNo))) {
                            checkingModel.setSettledept(value.getPkValue().toString());
                        }
                    }
                });
            }
        }
    }
}

