/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke.checking;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.business.trip.model.AbstractCheckingBillDetailModel;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.CheckingBillHeaderModel;
import kd.fi.er.business.trip.model.CheckingBillModel;
import kd.fi.er.business.trip.model.HotelCheckingBillDetailModel;
import kd.fi.er.business.trip.model.MealCheckingBillDetailModel;
import kd.fi.er.business.trip.model.PlaneCheckingBillDetailModel;
import kd.fi.er.business.trip.model.TrainCheckingBillDetailModel;
import kd.fi.er.business.trip.model.VehicleCheckingBillDetailModel;
import kd.fi.er.business.trip.service.function.AbstractCheckingInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.travelno1.invoke.checking.TTripCheckingCarConvert;
import kd.fi.er.business.trip.supplier.travelno1.invoke.checking.TTripCheckingHeaderConvert;
import kd.fi.er.business.trip.supplier.travelno1.invoke.checking.TTripCheckingHotelConvert;
import kd.fi.er.business.trip.supplier.travelno1.invoke.checking.TTripCheckingMealConvert;
import kd.fi.er.business.trip.supplier.travelno1.invoke.checking.TTripCheckingPlaneConvert;
import kd.fi.er.business.trip.supplier.travelno1.invoke.checking.TTripCheckingTrainConvert;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TravelNoOneSync;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class TTripCheckingInvoke
extends AbstractCheckingInvoke<JSONObject> {
    private static Log logger = LogFactory.getLog(TTripCheckingInvoke.class);
    protected String TTRIPSYNCCHECKINGBILLSIGN = "TTripSyncCheck";
    private String perioddate;
    private String productType;
    private String settlemain;

    public TTripCheckingInvoke() {
    }

    public TTripCheckingInvoke(Map<String, ? extends Object> params) {
        super((Map)params);
    }

    @Override
    protected String supplier() {
        return Supplier.CHAILVYIHAO.name();
    }

    protected Object process(Map params) throws TripException {
        boolean aBoolean = TripSyncConfigUtil.getBoolean("checkingdata_by_billno");
        if (params != null && params.get("jsondata") != null && !aBoolean) {
            return JSONObject.parseObject((String)((String)params.get("jsondata"))).get((Object)"data");
        }
        if (params != null && params.get("structrue_param") != null && params.get("detail_param") != null && aBoolean) {
            JSONObject needDealDatas = new JSONObject();
            needDealDatas.put("head", (Object)JSONObject.parseObject((String)((String)params.get("structrue_param"))));
            needDealDatas.put("detail", (Object)JSONObject.parseObject((String)((String)params.get("detail_param"))));
            return needDealDatas;
        }
        JSONArray dataArray = new JSONArray();
        if (params != null && params.size() > 0 && params.get("perioddate") != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
            this.perioddate = format.format((Date)params.get("perioddate"));
            this.productType = (String)params.get("productType");
            this.settlemain = (String)params.get("settlemain");
        }
        this.queryCheckingData(dataArray);
        return dataArray;
    }

    private void queryCheckingData(JSONArray dataArray) {
        ErCommonUtils.removeKeyFromAppCache(this.TTRIPSYNCCHECKINGBILLSIGN);
        this.startQueryCheckingData(dataArray);
    }

    private void startQueryCheckingData(JSONArray dataArray) {
        String url = TripCommonUtil.getTravelNoOneApiUrl("querycheckingbillurlkey");
        String reqData = this.buildPostParams();
        this.tripSyncLogParam.setRequesturl(url);
        this.tripSyncLogParam.setRequestdata(reqData);
        String result = HttpRetryServiceHelper.PostData(url, reqData);
        this.tripSyncLogParam.setResponsedata(result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject == null || !jsonObject.getString("errcode").equals("0")) {
            this.tripSyncLogParam.setStatus("B");
            logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u7ed3\u7b97\u5355,\u83b7\u53d6\u5dee\u65c5\u58f9\u53f7\u7ed3\u7b97\u5355\u6570\u636e\u5931\u8d25, \u62a5\u9519\u4fe1\u606ferrmsg:" + result);
            return;
        }
        JSONArray currDataArray = jsonObject.getJSONArray("data");
        if (currDataArray == null) {
            return;
        }
        boolean checkingDataByBillNo = TripSyncConfigUtil.getBoolean("checkingdata_by_billno");
        if (checkingDataByBillNo) {
            this.getDetailDatsByBillNos(currDataArray);
        } else {
            dataArray.addAll((Collection)currDataArray);
        }
    }

    protected String buildPostParams() {
        JSONObject dataObject = new JSONObject();
        dataObject.put("beginTime", (Object)this.perioddate);
        dataObject.put("endTime", (Object)this.perioddate);
        dataObject.put("queryType", (Object)6);
        if (!StringUtils.isBlank((CharSequence)this.productType)) {
            if ("8".equals(this.productType)) {
                dataObject.put("includeProductId", (Object)"11,15");
            } else {
                dataObject.put("includeProductId", (Object)this.productType);
            }
        }
        if (!StringUtils.isBlank((CharSequence)this.settlemain)) {
            dataObject.put("becode", (Object)this.settlemain);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("access_token", (Object)TravelNoOneSync.getCacheToken(this.TTRIPSYNCCHECKINGBILLSIGN));
        jsonObject.put("data", (Object)dataObject);
        return SerializationUtils.toJsonString((Object)jsonObject);
    }

    protected Object convert(Object object) throws TripException {
        boolean checkingDataByBillNo = TripSyncConfigUtil.getBoolean("checkingdata_by_billno");
        if (!checkingDataByBillNo) {
            return this.originalLogic(object);
        }
        ArrayList<CheckingBillModel> checkingBillModelList = new ArrayList<CheckingBillModel>();
        if (object instanceof JSONObject) {
            JSONObject dealData = (JSONObject)object;
            JSONObject headData = JSON.parseObject((String)JSON.toJSONString((Object)dealData.get((Object)"head")));
            JSONArray detailsJsonArray = dealData.getJSONArray("detail");
            HashMap<String, List<JSONObject>> detailsDataTyepMap = new HashMap<String, List<JSONObject>>();
            for (int j = 0; j < detailsJsonArray.size(); ++j) {
                List<JSONObject> detailsDataList;
                JSONObject detailsData = JSON.parseObject((String)JSON.toJSONString((Object)detailsJsonArray.get(j)));
                String productType = detailsData.getString("productType");
                if (detailsDataTyepMap.get(productType) == null) {
                    detailsDataList = new ArrayList<JSONObject>();
                    detailsDataList.add(detailsData);
                    detailsDataTyepMap.put(productType, detailsDataList);
                    continue;
                }
                detailsDataList = (List)detailsDataTyepMap.get(productType);
                detailsDataList.add(detailsData);
            }
            this.convertDetalData(checkingBillModelList, headData, detailsDataTyepMap);
        }
        return checkingBillModelList;
    }

    private void getDetailDatsByBillNos(JSONArray currDataArray) {
        HashSet<String> billNos = new HashSet<String>(currDataArray.size());
        final HashMap<String, JSONObject> billNoAndHeadMap = new HashMap<String, JSONObject>(currDataArray.size());
        for (Object o : currDataArray) {
            if (!(o instanceof JSONObject)) continue;
            JSONObject json = (JSONObject)o;
            billNos.add(json.getString("billNo"));
            billNoAndHeadMap.put(json.getString("billNo"), JSON.parseObject((String)JSON.toJSONString((Object)json)));
        }
        int cpus = Runtime.getRuntime().availableProcessors();
        int fixedThreads = cpus << 1;
        int totalFixedThread = fixedThreads + 1;
        final String requestUrl = TripCommonUtil.getTravelNoOneApiUrl("querycheckingdetailbillurlkey");
        HashMap<String, Integer> billNoAndTotalMap = new HashMap<String, Integer>(billNos.size());
        for (String billNo : billNos) {
            String requestData = this.buildRequestParams(billNo, 1, 1);
            String result = HttpRetryServiceHelper.PostData(requestUrl, requestData);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (jsonObject == null || !jsonObject.getString("errcode").equals("0")) continue;
            int totalSize = jsonObject.getInteger("total");
            billNoAndTotalMap.put(billNo, totalSize);
        }
        if (billNoAndTotalMap.isEmpty()) {
            return;
        }
        Set entries = billNoAndTotalMap.entrySet();
        for (final Map.Entry entry : entries) {
            Integer total = (Integer)entry.getValue();
            int tmpTotalFixedThread = totalFixedThread;
            if (total <= 0) continue;
            logger.info("billNo:{},total:{}", entry.getKey(), (Object)total);
            int totalPage = total / 200 + 1;
            if (total % 200 == 0) {
                totalPage = total / 200;
            }
            int cycleCount = 0;
            if (tmpTotalFixedThread >= totalPage) {
                tmpTotalFixedThread = totalPage;
                cycleCount = totalPage;
            } else {
                cycleCount = tmpTotalFixedThread = totalFixedThread >> 1;
            }
            logger.info("\u5f53\u524d\u4f7f\u7528\u7ebf\u7a0b\u6570:{}", (Object)tmpTotalFixedThread);
            int everyThreadNeedDealPages = 0;
            everyThreadNeedDealPages = totalPage % tmpTotalFixedThread == 0 ? totalPage / tmpTotalFixedThread : totalPage / tmpTotalFixedThread + 1;
            for (int index = 0; index < cycleCount; ++index) {
                int startIndex = 0;
                startIndex = index == 0 ? 1 : everyThreadNeedDealPages * index + 1;
                final int endIndex = everyThreadNeedDealPages * index + everyThreadNeedDealPages;
                final int finalStartIndex = startIndex;
                ThreadService.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        int threadStartIndex = finalStartIndex;
                        ArrayList logLists = Lists.newArrayListWithCapacity((int)16);
                        TripSyncLogParam tripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), TTripCheckingInvoke.this.supplier(), TTripCheckingInvoke.this.function());
                        while (threadStartIndex <= endIndex) {
                            logLists.add(tripSyncLogParam);
                            tripSyncLogParam.setRequesturl(requestUrl);
                            String requestData = TTripCheckingInvoke.this.buildRequestParams((String)entry.getKey(), threadStartIndex++, 200);
                            tripSyncLogParam.setRequestdata(requestData);
                            String result = HttpRetryServiceHelper.PostData(requestUrl, requestData);
                            tripSyncLogParam.setResponsedata(result);
                            JSONObject jsonObject = JSONObject.parseObject((String)result);
                            if (jsonObject == null || !jsonObject.getString("errcode").equals("0")) {
                                tripSyncLogParam.setStatus("B");
                                continue;
                            }
                            tripSyncLogParam.setStatus("A");
                            JSONObject needDealDatas = new JSONObject();
                            needDealDatas.put("head", billNoAndHeadMap.get(entry.getKey()));
                            needDealDatas.put("detail", jsonObject.get((Object)"data"));
                            TTripCheckingInvoke.this.saveInfos(TTripCheckingInvoke.this.convert(needDealDatas));
                        }
                        TripSyncLogUtils.saveErrorLog(logLists);
                    }
                }, (TaskType)TaskType.ER_TRIP_CHECKING_TASK, (RequestContext)RequestContext.get());
            }
        }
    }

    private String buildRequestParams(String billNo, int pageIndex, int pageSize) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("condition", (Object)"billNo");
        dataObject.put("pageIndex", (Object)pageIndex);
        dataObject.put("pageSize", (Object)pageSize);
        JSONArray dataInfo = new JSONArray();
        dataInfo.add((Object)billNo);
        dataObject.put("dataInfo", (Object)dataInfo);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("access_token", (Object)TravelNoOneSync.getCacheToken(this.TTRIPSYNCCHECKINGBILLSIGN));
        jsonObject.put("data", (Object)dataObject);
        return jsonObject.toJSONString();
    }

    private Object originalLogic(Object object) {
        JSONArray resultJsonArray = JSON.parseArray((String)JSON.toJSONString((Object)object));
        if (resultJsonArray == null || resultJsonArray.size() < 1) {
            return null;
        }
        ArrayList<CheckingBillModel> checkingBillModelList = new ArrayList<CheckingBillModel>();
        HashMap<String, List<JSONObject>> detailsDataTyepMap = new HashMap<String, List<JSONObject>>();
        for (int i = 0; i < resultJsonArray.size(); ++i) {
            JSONObject headData = JSON.parseObject((String)JSON.toJSONString((Object)resultJsonArray.get(i)));
            JSONArray detailsJsonArray = headData.getJSONArray("relationConsumptionDetails");
            detailsDataTyepMap.clear();
            for (int j = 0; j < detailsJsonArray.size(); ++j) {
                List<JSONObject> detailsDataList;
                JSONObject detailsData = JSON.parseObject((String)JSON.toJSONString((Object)detailsJsonArray.get(j)));
                String productType = detailsData.getString("productType");
                if (detailsDataTyepMap.get(productType) == null) {
                    detailsDataList = new ArrayList<JSONObject>();
                    detailsDataList.add(detailsData);
                    detailsDataTyepMap.put(productType, detailsDataList);
                    continue;
                }
                detailsDataList = (List)detailsDataTyepMap.get(productType);
                detailsDataList.add(detailsData);
            }
            this.convertDetalData(checkingBillModelList, headData, detailsDataTyepMap);
        }
        return checkingBillModelList;
    }

    private void convertDetalData(List<CheckingBillModel> checkingBillModelList, JSONObject headData, Map<String, List<JSONObject>> detailsDataTyepMap) {
        detailsDataTyepMap.forEach((key, detailsList) -> {
            switch (key) {
                case "1": 
                case "2": {
                    if (!StringUtils.isBlank((CharSequence)this.productType) && !this.productType.equalsIgnoreCase((String)key)) break;
                    CheckingBillModel planeCheckingBillModel = new CheckingBillModel();
                    new TTripCheckingHeaderConvert();
                    CheckingBillHeaderModel planePheckingBillHeaderModel = TTripCheckingHeaderConvert.convert(key, headData);
                    this.handleHeadCheckingExtCovert(planePheckingBillHeaderModel, headData);
                    planeCheckingBillModel.setCheckingBillHeaderModel(planePheckingBillHeaderModel);
                    if (detailsList != null && detailsList.size() > 0) {
                        List<AbstractCheckingBillDetailModel> planeCheckingBillDetailModelList = new ArrayList<AbstractCheckingBillDetailModel>(detailsList.size());
                        for (int planeIndex = 0; planeIndex < detailsList.size(); ++planeIndex) {
                            PlaneCheckingBillDetailModel planeCheckingDetailModel = new PlaneCheckingBillDetailModel();
                            planeCheckingBillDetailModelList = TTripCheckingPlaneConvert.covert(planeCheckingDetailModel, headData, (JSONObject)detailsList.get(planeIndex), planeCheckingBillDetailModelList);
                            this.handlePlaneCheckingExtCovert((PlaneCheckingBillDetailModel)planeCheckingBillDetailModelList.get(planeIndex), (JSONObject)detailsList.get(planeIndex));
                        }
                        planeCheckingBillModel.setCheckingBillDetailModels(planeCheckingBillDetailModelList);
                    }
                    checkingBillModelList.add(planeCheckingBillModel);
                    break;
                }
                case "3": 
                case "4": {
                    if (!StringUtils.isBlank((CharSequence)this.productType) && !this.productType.equalsIgnoreCase((String)key)) break;
                    CheckingBillModel hotelCheckingBillModel = new CheckingBillModel();
                    CheckingBillHeaderModel hotelCheckingBillHeaderModel = TTripCheckingHeaderConvert.convert(key, headData);
                    this.handleHeadCheckingExtCovert(hotelCheckingBillHeaderModel, headData);
                    hotelCheckingBillModel.setCheckingBillHeaderModel(hotelCheckingBillHeaderModel);
                    if (detailsList != null && detailsList.size() > 0) {
                        List<AbstractCheckingBillDetailModel> hotelCheckingBillDetailModelList = new ArrayList<AbstractCheckingBillDetailModel>(detailsList.size());
                        for (int hotelIndex = 0; hotelIndex < detailsList.size(); ++hotelIndex) {
                            HotelCheckingBillDetailModel hotelCheckingDetailModel = new HotelCheckingBillDetailModel();
                            new TTripCheckingHotelConvert();
                            hotelCheckingBillDetailModelList = TTripCheckingHotelConvert.convert(hotelCheckingDetailModel, headData, (JSONObject)detailsList.get(hotelIndex), hotelCheckingBillDetailModelList);
                            this.handleHotelCheckingExtCovert((HotelCheckingBillDetailModel)hotelCheckingBillDetailModelList.get(hotelIndex), (JSONObject)detailsList.get(hotelIndex));
                        }
                        hotelCheckingBillModel.setCheckingBillDetailModels(hotelCheckingBillDetailModelList);
                    }
                    checkingBillModelList.add(hotelCheckingBillModel);
                    break;
                }
                case "6": {
                    if (!StringUtils.isBlank((CharSequence)this.productType) && !this.productType.equalsIgnoreCase((String)key)) break;
                    CheckingBillModel carCheckingBillModel = new CheckingBillModel();
                    CheckingBillHeaderModel carCheckingBillHeaderModel = TTripCheckingHeaderConvert.convert(key, headData);
                    this.handleHeadCheckingExtCovert(carCheckingBillHeaderModel, headData);
                    carCheckingBillModel.setCheckingBillHeaderModel(carCheckingBillHeaderModel);
                    if (detailsList != null && detailsList.size() > 0) {
                        List<AbstractCheckingBillDetailModel> carCheckingBillDetailModelList = new ArrayList<AbstractCheckingBillDetailModel>(detailsList.size());
                        for (int carIndex = 0; carIndex < detailsList.size(); ++carIndex) {
                            VehicleCheckingBillDetailModel carCheckingBillDetailModel = new VehicleCheckingBillDetailModel();
                            carCheckingBillDetailModelList = TTripCheckingCarConvert.convert(carCheckingBillDetailModel, headData, (JSONObject)detailsList.get(carIndex), carCheckingBillDetailModelList);
                            this.handleCarCheckingExtCovert((VehicleCheckingBillDetailModel)carCheckingBillDetailModelList.get(carIndex), (JSONObject)detailsList.get(carIndex));
                        }
                        carCheckingBillModel.setCheckingBillDetailModels(carCheckingBillDetailModelList);
                    }
                    checkingBillModelList.add(carCheckingBillModel);
                    break;
                }
                case "5": {
                    if (!StringUtils.isBlank((CharSequence)this.productType) && !this.productType.equalsIgnoreCase((String)key)) break;
                    CheckingBillModel trainCheckingBillModel = new CheckingBillModel();
                    new TTripCheckingHeaderConvert();
                    CheckingBillHeaderModel trainCheckingBillHeaderModel = TTripCheckingHeaderConvert.convert(key, headData);
                    this.handleHeadCheckingExtCovert(trainCheckingBillHeaderModel, headData);
                    trainCheckingBillModel.setCheckingBillHeaderModel(trainCheckingBillHeaderModel);
                    if (detailsList != null && detailsList.size() > 0) {
                        List<AbstractCheckingBillDetailModel> trainCheckingBillDetailModelList = new ArrayList<AbstractCheckingBillDetailModel>(detailsList.size());
                        for (int trainIndex = 0; trainIndex < detailsList.size(); ++trainIndex) {
                            TrainCheckingBillDetailModel trainCheckingBillDetailModel = new TrainCheckingBillDetailModel();
                            trainCheckingBillDetailModelList = TTripCheckingTrainConvert.convert(trainCheckingBillDetailModel, headData, (JSONObject)detailsList.get(trainIndex), trainCheckingBillDetailModelList);
                            this.handleTrainCheckingExtCovert((TrainCheckingBillDetailModel)trainCheckingBillDetailModelList.get(trainIndex), (JSONObject)detailsList.get(trainIndex));
                        }
                        trainCheckingBillModel.setCheckingBillDetailModels(trainCheckingBillDetailModelList);
                    }
                    checkingBillModelList.add(trainCheckingBillModel);
                    break;
                }
                case "11": 
                case "15": {
                    if (!StringUtils.isBlank((CharSequence)this.productType) && !this.productType.equalsIgnoreCase((String)key)) break;
                    CheckingBillModel mealCheckingBillModel = new CheckingBillModel();
                    new TTripCheckingHeaderConvert();
                    CheckingBillHeaderModel mealCheckingBillHeaderModel = TTripCheckingHeaderConvert.convert(key, headData);
                    this.handleHeadCheckingExtCovert(mealCheckingBillHeaderModel, headData);
                    mealCheckingBillModel.setCheckingBillHeaderModel(mealCheckingBillHeaderModel);
                    if (detailsList != null && detailsList.size() > 0) {
                        List<AbstractCheckingBillDetailModel> mealCheckingBillDetailModelList = new ArrayList<AbstractCheckingBillDetailModel>(detailsList.size());
                        for (int mealIndex = 0; mealIndex < detailsList.size(); ++mealIndex) {
                            MealCheckingBillDetailModel mealCheckingBillDetailModel = new MealCheckingBillDetailModel();
                            mealCheckingBillDetailModelList = TTripCheckingMealConvert.convert(mealCheckingBillDetailModel, headData, (JSONObject)detailsList.get(mealIndex), mealCheckingBillDetailModelList);
                            this.handleMealCheckingExtCovert((MealCheckingBillDetailModel)mealCheckingBillDetailModelList.get(mealIndex), (JSONObject)detailsList.get(mealIndex));
                        }
                        mealCheckingBillModel.setCheckingBillDetailModels(mealCheckingBillDetailModelList);
                    }
                    checkingBillModelList.add(mealCheckingBillModel);
                }
            }
        });
        this.dealOrderNum(checkingBillModelList);
    }

    @Override
    protected void handleAfterSave(Map<String, DynamicObject> checkingbillDetailMapping) {
        try {
            if (!this.supplier().equals(Supplier.CHAILVYIHAO.name())) {
                return;
            }
            if (checkingbillDetailMapping.isEmpty()) {
                return;
            }
            super.handleAfterSave(checkingbillDetailMapping);
            Set<String> checkingBillNums = checkingbillDetailMapping.keySet();
            DynamicObject[] checkingBills = BusinessDataServiceHelper.load((String)"er_traincheckingbill", (String)"ordernum,orderstatus,allorderbase,parentordernum", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", checkingBillNums), new QFilter("ordertype", "=", (Object)AbstractOrderModel.OrderType.O)});
            if (checkingBills == null || checkingBills.length == 0) {
                return;
            }
            Set allOrderIds = Arrays.stream(checkingBills).filter(dynamicObject -> dynamicObject.get("allorderbase") != null).map(dynamicObject -> ErCommonUtils.getPk(dynamicObject.get("allorderbase"))).collect(Collectors.toSet());
            DynamicObject[] allOrders = BusinessDataServiceHelper.load((String)"er_allorderbill", (String)"orderid,id", (QFilter[])new QFilter[]{new QFilter("id", "in", allOrderIds)});
            if (allOrders == null || allOrders.length == 0) {
                return;
            }
            Set orderIds = Arrays.stream(allOrders).filter(dynamicObject -> dynamicObject.get("orderid") != null).map(dynamicObject -> dynamicObject.getLong("orderid")).collect(Collectors.toSet());
            DynamicObject[] orderBills = BusinessDataServiceHelper.load((String)"er_trainbill", (String)"parentordernum,orderstatus,ordernum", (QFilter[])new QFilter[]{new QFilter("id", "in", orderIds)});
            Map<String, List<DynamicObject>> sameParentDatas = Arrays.stream(orderBills).filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("parentordernum"))).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("parentordernum")));
            Set<Map.Entry<String, List<DynamicObject>>> sameEntrys = sameParentDatas.entrySet();
            HashSet fitParentOrderNums = Sets.newHashSetWithExpectedSize((int)16);
            for (Map.Entry<String, List<DynamicObject>> sameEntry : sameEntrys) {
                List<DynamicObject> orders = sameEntry.getValue();
                List orderStatusList = orders.stream().filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("orderstatus"))).map(dynamicObject -> dynamicObject.getString("orderstatus")).collect(Collectors.toList());
                if (!orderStatusList.contains("3")) continue;
                fitParentOrderNums.add(sameEntry.getKey());
            }
            if (CollectionUtils.isEmpty((Collection)fitParentOrderNums)) {
                return;
            }
            Map<String, List<DynamicObject>> sameParentCheckingBills = Arrays.stream(checkingBills).filter(dynamicObject -> StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("parentordernum"))).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("parentordernum")));
            Set<Map.Entry<String, List<DynamicObject>>> sameCheckingEntrys = sameParentCheckingBills.entrySet();
            ArrayList needUpdateDatas = Lists.newArrayListWithCapacity((int)16);
            for (Map.Entry<String, List<DynamicObject>> sameCheckingEntry : sameCheckingEntrys) {
                String parentOrderNums = sameCheckingEntry.getKey();
                if (!fitParentOrderNums.contains(parentOrderNums)) continue;
                List<DynamicObject> fitCheckingBills = sameCheckingEntry.getValue();
                fitCheckingBills.forEach(dynamicObject -> {
                    dynamicObject.set("orderstatus", (Object)"3");
                    needUpdateDatas.add(dynamicObject);
                });
            }
            if (CollectionUtils.isEmpty((Collection)needUpdateDatas)) {
                return;
            }
            SaveServiceHelper.save((DynamicObject[])needUpdateDatas.toArray(new DynamicObject[needUpdateDatas.size()]));
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u706b\u8f66\u7ed3\u7b97\u5355\u8ba2\u5355\u72b6\u6001\u5931\u8d25:", (Throwable)e);
        }
    }

    private void dealOrderNum(List<CheckingBillModel> checkingBillModelList) {
        int intValue = TripSyncConfigUtil.getIntValue("links_open", 0, Arrays.asList(0, 1));
        if (checkingBillModelList.isEmpty() || 0 == intValue) {
            return;
        }
        List<TrainCheckingBillDetailModel> detailModels = this.extractTrainDetails(checkingBillModelList);
        if (detailModels.isEmpty()) {
            return;
        }
        Map<String, List<TrainCheckingBillDetailModel>> uniqueKeyIdMap = detailModels.stream().filter(obj -> StringUtils.isNotEmpty((CharSequence)obj.getOrderNum())).collect(Collectors.groupingBy(obj -> {
            String uniqueId = obj.getUniqueId();
            return obj.getOrderNum() + "-" + (StringUtils.isEmpty((CharSequence)uniqueId) || uniqueId.length() < 4 ? uniqueId : uniqueId.substring(uniqueId.length() - 4));
        }));
        Map<String, Set<String>> checkingNumMap = this.buildOrderNumMap(detailModels);
        Map<String, String> oldOrderNumAndNewOrderNumMap = this.buildOldAndNewOrderNumMap(detailModels);
        Set<String> keySet = oldOrderNumAndNewOrderNumMap.keySet();
        this.processExistingOrderNums(keySet, oldOrderNumAndNewOrderNumMap, detailModels, uniqueKeyIdMap);
        this.processDuplicateOrderNums(new HashSet<String>(oldOrderNumAndNewOrderNumMap.values()), keySet, detailModels);
        this.processMultipleOrderNums(checkingNumMap, keySet, uniqueKeyIdMap);
    }

    private List<TrainCheckingBillDetailModel> extractTrainDetails(List<CheckingBillModel> checkingBillModelList) {
        return checkingBillModelList.stream().filter(model -> !model.getCheckingBillDetailModels().isEmpty()).flatMap(model -> model.getCheckingBillDetailModels().stream()).filter(detail -> detail instanceof TrainCheckingBillDetailModel).map(detail -> (TrainCheckingBillDetailModel)detail).collect(Collectors.toList());
    }

    private Map<String, Set<String>> buildOrderNumMap(List<TrainCheckingBillDetailModel> detailModels) {
        return detailModels.stream().filter(detail -> StringUtils.isNotEmpty((CharSequence)detail.getOrderNum())).collect(Collectors.toMap(AbstractCheckingBillDetailModel::getOrderNum, detail -> {
            HashSet<String> value = new HashSet<String>();
            String uniqueId = detail.getUniqueId();
            value.add(detail.getOrderNum() + "-" + (StringUtils.isEmpty((CharSequence)uniqueId) || uniqueId.length() < 4 ? uniqueId : uniqueId.substring(uniqueId.length() - 4)));
            return value;
        }, (existing, newSet) -> {
            existing.addAll(newSet);
            return existing;
        }));
    }

    private Map<String, String> buildOldAndNewOrderNumMap(List<TrainCheckingBillDetailModel> detailModels) {
        return detailModels.stream().filter(detail -> StringUtils.isNotEmpty((CharSequence)detail.getOrderNum())).collect(Collectors.toMap(detail -> {
            String uniqueId = detail.getUniqueId();
            return detail.getOrderNum() + "-" + (StringUtils.isEmpty((CharSequence)uniqueId) || uniqueId.length() < 4 ? uniqueId : uniqueId.substring(uniqueId.length() - 4));
        }, AbstractCheckingBillDetailModel::getOrderNum, (exist, newData) -> newData));
    }

    private void processExistingOrderNums(Set<String> keySet, Map<String, String> oldOrderNumAndNewOrderNumMap, List<TrainCheckingBillDetailModel> detailModels, Map<String, List<TrainCheckingBillDetailModel>> uniqueKeyIdMap) {
        DynamicObjectCollection newOrderNumData = QueryServiceHelper.query((String)"er_traincheckingbill", (String)"ordernum", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", keySet)});
        if (!newOrderNumData.isEmpty()) {
            Set<String> existOrderNum = newOrderNumData.stream().map(obj -> obj.getString("ordernum")).collect(Collectors.toSet());
            existOrderNum.forEach(existUniqueKeyId -> {
                List orders = (List)uniqueKeyIdMap.get(existUniqueKeyId);
                if (orders == null || orders.isEmpty()) {
                    return;
                }
                orders.forEach(order -> order.setOrderNum((String)existUniqueKeyId));
                oldOrderNumAndNewOrderNumMap.remove(existUniqueKeyId);
            });
            keySet.removeAll(existOrderNum);
        }
    }

    private void processDuplicateOrderNums(Set<String> filterKeySet, Set<String> keySet, List<TrainCheckingBillDetailModel> detailModels) {
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"er_allcheckingbill", (String)"ordernum,uniqueid", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", filterKeySet)});
        if (!datas.isEmpty()) {
            Map<String, String> orderNumAndUniqueIdMap = datas.stream().collect(Collectors.toMap(obj -> obj.getString("ordernum"), obj -> obj.getString("uniqueid")));
            datas.stream().map(obj -> obj.getString("ordernum")).collect(Collectors.toSet()).forEach(existingOrderNum -> {
                List<TrainCheckingBillDetailModel> orders = detailModels.stream().filter(detail -> existingOrderNum.equals(detail.getOrderNum())).collect(Collectors.toList());
                orders.forEach(order -> {
                    String dbUniqueId = (String)orderNumAndUniqueIdMap.get(order.getOrderNum());
                    String uniqueId = order.getUniqueId();
                    if (!StringUtils.isEmpty((CharSequence)dbUniqueId) && !uniqueId.equalsIgnoreCase(dbUniqueId)) {
                        order.setOrderNum(order.getOrderNum() + "-" + (StringUtils.isEmpty((CharSequence)uniqueId) || uniqueId.length() < 4 ? uniqueId : uniqueId.substring(uniqueId.length() - 4)));
                    }
                });
            });
            HashSet exist = new HashSet();
            datas.forEach(obj -> {
                String uniqueId = obj.getString("uniqueid");
                exist.add(obj.getString("ordernum") + "-" + (StringUtils.isEmpty((CharSequence)uniqueId) || uniqueId.length() < 4 ? uniqueId : uniqueId.substring(uniqueId.length() - 4)));
            });
            keySet.removeAll(exist);
        }
    }

    private void processMultipleOrderNums(Map<String, Set<String>> checkingNumMap, Set<String> keySet, Map<String, List<TrainCheckingBillDetailModel>> uniqueKeyIdMap) {
        checkingNumMap.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() > 1).forEach(entry -> {
            Set uniqueIdSet = (Set)entry.getValue();
            uniqueIdSet.forEach(orderWithUniqueId -> {
                if (keySet.contains(orderWithUniqueId)) {
                    ((List)uniqueKeyIdMap.get(orderWithUniqueId)).forEach(detail -> detail.setOrderNum((String)orderWithUniqueId));
                }
            });
        });
    }
}

