/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.HotelOrderModel;
import kd.fi.er.business.trip.model.MealOrderModel;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.model.TrainOrderModel;
import kd.fi.er.business.trip.model.VehicleOrderModel;
import kd.fi.er.business.trip.service.function.AbstractOrderInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.travelno1.invoke.order.TTripOrderCarConvert;
import kd.fi.er.business.trip.supplier.travelno1.invoke.order.TTripOrderHotelConvert;
import kd.fi.er.business.trip.supplier.travelno1.invoke.order.TTripOrderMealConvert;
import kd.fi.er.business.trip.supplier.travelno1.invoke.order.TTripOrderPlaneConvert;
import kd.fi.er.business.trip.supplier.travelno1.invoke.order.TTripOrderTrainConvert;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TravelNoOneSync;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class TTripOrderInvoke
extends AbstractOrderInvoke<JSONObject> {
    private static Log logger = LogFactory.getLog(TTripOrderInvoke.class);
    private Date lastSyncOrderBillTamp;
    private Date currSyncOrderBillTamp;
    private AtomicReference<Boolean> syncSuccessFlag;
    private static final String LASTSYNCORDERBILLTAMP_PROP = "lastsyncorderbilltamp";
    private static final String TTRIPSYNCORDERBILLSIGN = "TTripSyncOrder";
    private DynamicObject bizInfoObject = null;
    private Boolean isScheduledTask = true;

    public TTripOrderInvoke() {
    }

    public TTripOrderInvoke(Map<String, ? extends Object> params) {
        super((Map)params);
    }

    @Override
    protected String supplier() {
        return Supplier.CHAILVYIHAO.name();
    }

    protected Object process(Map params) throws TripException {
        if (params != null && params.get("jsondata") != null) {
            this.syncSuccessFlag = new AtomicReference<Boolean>(false);
            return JSONObject.parseObject((String)((String)params.get("jsondata"))).getJSONArray("data");
        }
        JSONArray dataArray = new JSONArray();
        if (params != null && params.size() > 0 && params.get("beginDate") != null && params.get("endDate") != null) {
            Date beginNewDate = TripCommonUtil.strToDate(String.valueOf(params.get("beginDate")), "EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
            Date endNewDate = TripCommonUtil.strToDate(String.valueOf(params.get("endDate")), "EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
            this.lastSyncOrderBillTamp = beginNewDate;
            this.currSyncOrderBillTamp = endNewDate;
            this.isScheduledTask = false;
        } else {
            if (params != null && params.size() > 0 && params.containsKey("reqnum") && params.containsKey("date")) {
                this.tripSyncLogParam.setBillid(params.get("reqnum").toString());
                this.tripSyncLogParam.setBillno(params.get("reqnum").toString());
                this.isScheduledTask = false;
                this.queryOrderData(dataArray, params, 1);
                return dataArray;
            }
            this.isScheduledTask = true;
        }
        this.queryOrderData(dataArray);
        return dataArray;
    }

    private void queryOrderData(JSONArray dataArray, Map params, int index) {
        this.syncSuccessFlag = new AtomicReference<Boolean>(true);
        String url = TripCommonUtil.getTravelNoOneApiUrl("queryorderbillurlbyreqkey");
        JSONObject dataObject = new JSONObject();
        int pageSize = TripSyncConfigUtil.getIntValue("ttrip_sync_orderbill_size", 50);
        if (pageSize > 50) {
            pageSize = 50;
        }
        dataObject.put("orderId", params.get("reqnum"));
        dataObject.put("tradeStartTime", params.get("date"));
        dataObject.put("pageIndex", (Object)index);
        dataObject.put("pageSize", (Object)pageSize);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("access_token", (Object)TravelNoOneSync.getLoginToken());
        jsonObject.put("data", (Object)dataObject);
        JSONArray currDataArray = this.sendRequest(dataArray, url, jsonObject.toJSONString());
        if (currDataArray == null) {
            return;
        }
        if (pageSize == currDataArray.size()) {
            this.queryOrderData(dataArray, params, ++index);
        }
    }

    private void queryOrderData(JSONArray dataArray) {
        if (this.isScheduledTask.booleanValue()) {
            this.getTTripLastSyncOrderBillTamp();
        }
        this.syncSuccessFlag = new AtomicReference<Boolean>(true);
        int index = 1;
        int pageSize = TripSyncConfigUtil.getIntValue("ttrip_sync_orderbill_size", 500);
        ErCommonUtils.removeKeyFromAppCache(TTRIPSYNCORDERBILLSIGN);
        this.startQueryOrderData(index, pageSize, dataArray);
    }

    private void getTTripLastSyncOrderBillTamp() {
        this.bizInfoObject = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)LASTSYNCORDERBILLTAMP_PROP, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
        this.lastSyncOrderBillTamp = this.bizInfoObject.getDate(LASTSYNCORDERBILLTAMP_PROP);
        if (this.lastSyncOrderBillTamp.before(ErCommonUtils.getDateFromLocalDate(LocalDate.of(2000, 1, 1)))) {
            this.lastSyncOrderBillTamp = TripCommonUtil.delayByMonth(new Date(), -1);
        }
    }

    private void startQueryOrderData(int index, int pageSize, JSONArray dataArray) {
        String reqData;
        String url = TripCommonUtil.getTravelNoOneApiUrl("queryorderbillurlkey");
        JSONArray currDataArray = this.sendRequest(dataArray, url, reqData = this.buildPostParams(index, pageSize));
        if (currDataArray == null) {
            return;
        }
        if (pageSize == currDataArray.size()) {
            this.startQueryOrderData(++index, pageSize, dataArray);
        }
    }

    private JSONArray sendRequest(JSONArray dataArray, String url, String reqData) {
        TripSyncLogParam currentLog = this.tripSyncLogParam.clone();
        currentLog.setRequesturl(url);
        currentLog.setRequestdata(reqData);
        String result = HttpRetryServiceHelper.PostData(url, reqData);
        currentLog.setResponsedata(result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject == null || !jsonObject.getString("errcode").equals("0")) {
            currentLog.setStatus("B");
            this.syncSuccessFlag.set(false);
            dataArray.clear();
            logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u8ba2\u5355,\u83b7\u53d6\u5dee\u65c5\u58f9\u53f7\u8ba2\u5355\u6570\u636e\u5931\u8d25, \u62a5\u9519\u4fe1\u606ferrmsg: %s" + result);
            this.tripSyncLogParamList.add(currentLog);
            return null;
        }
        this.tripSyncLogParamList.add(currentLog);
        JSONArray currDataArray = jsonObject.getJSONArray("data");
        if (currDataArray == null) {
            return null;
        }
        dataArray.addAll((Collection)currDataArray);
        return currDataArray;
    }

    protected String buildPostParams(int index, int pageSize) {
        if (this.isScheduledTask.booleanValue()) {
            this.currSyncOrderBillTamp = new Date();
        }
        JSONObject dataObject = new JSONObject();
        dataObject.put("pageIndex", (Object)index);
        dataObject.put("pageSize", (Object)pageSize);
        dataObject.put("modifyStartingTime", (Object)TripCommonUtil.DateToStr(this.lastSyncOrderBillTamp));
        dataObject.put("modifyEndTime", (Object)TripCommonUtil.DateToStr(this.currSyncOrderBillTamp));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("access_token", (Object)TravelNoOneSync.getCacheToken(TTRIPSYNCORDERBILLSIGN));
        jsonObject.put("data", (Object)dataObject);
        return jsonObject.toJSONString();
    }

    protected Object convert(Object object) {
        JSONArray billArray = (JSONArray)object;
        if (billArray == null || billArray.size() < 1) {
            return new ArrayList();
        }
        ArrayList<AbstractOrderModel> orderModels = new ArrayList<AbstractOrderModel>();
        block17: for (int i = 0; i < billArray.size(); ++i) {
            String productType;
            JSONObject orderJson = billArray.getJSONObject(i);
            switch (productType = orderJson.getString("productType")) {
                case "1": 
                case "2": {
                    PlaneOrderModel planeOrderModel = TTripOrderPlaneConvert.convert(orderJson);
                    this.handlePlaneOrderExtCovert(planeOrderModel, orderJson);
                    orderModels.add(planeOrderModel);
                    continue block17;
                }
                case "3": 
                case "4": {
                    HotelOrderModel hotelOrderModel = TTripOrderHotelConvert.convert(orderJson);
                    this.handleHotelOrderExtCovert(hotelOrderModel, orderJson);
                    orderModels.add(hotelOrderModel);
                    continue block17;
                }
                case "6": {
                    VehicleOrderModel vehicleOrderModel = TTripOrderCarConvert.convert(orderJson);
                    this.handleCarOrderExtCovert(vehicleOrderModel, orderJson);
                    orderModels.add(vehicleOrderModel);
                    continue block17;
                }
                case "5": {
                    TrainOrderModel trainOrderModel = TTripOrderTrainConvert.convert(orderJson);
                    this.handleTrainOrderExtCovert(trainOrderModel, orderJson);
                    orderModels.add(trainOrderModel);
                    continue block17;
                }
                case "11": 
                case "15": {
                    MealOrderModel mealOrderModel = TTripOrderMealConvert.convert(orderJson);
                    this.handleMealOrderExtCovert(mealOrderModel, orderJson);
                    orderModels.add(mealOrderModel);
                }
            }
        }
        this.dealOrderNum(orderModels);
        return orderModels;
    }

    @Override
    public void execute() throws TripException {
        super.execute();
        if (this.isScheduledTask.booleanValue()) {
            this.saveLastSyncOrderbilltTamp();
        }
    }

    private void saveLastSyncOrderbilltTamp() {
        if (this.syncSuccessFlag.get().booleanValue()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String currentTime = sdf.format(this.currSyncOrderBillTamp);
            this.bizInfoObject.set(LASTSYNCORDERBILLTAMP_PROP, (Object)currentTime);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.bizInfoObject});
        }
    }

    @Override
    protected void handleAfterSave(Map<String, Map<String, DynamicObject>> orderMapping) {
        if (!Supplier.CHAILVYIHAO.name().equals(this.supplier())) {
            return;
        }
        Map<String, DynamicObject> planeBillMap = orderMapping.get("er_planebill");
        Map<String, DynamicObject> hotelBillMap = orderMapping.get("er_hotelbill");
        Map<String, DynamicObject> trainBillMap = orderMapping.get("er_trainbill");
        if (planeBillMap != null && !planeBillMap.isEmpty()) {
            ArrayList planeParentOrderNums = Lists.newArrayListWithCapacity((int)planeBillMap.size());
            Set<Map.Entry<String, DynamicObject>> entries = planeBillMap.entrySet();
            for (Map.Entry<String, DynamicObject> entry : entries) {
                String parentOrderNum;
                String ticketStatus;
                String orderStatus;
                DynamicObject dynamicObject = entry.getValue();
                if (dynamicObject == null || StringUtils.isEmpty((CharSequence)(orderStatus = dynamicObject.getString("orderstatus"))) || !"50302".equals(orderStatus) || StringUtils.isEmpty((CharSequence)(ticketStatus = dynamicObject.getString("ticketstatus"))) || !"REFOUND".equals(ticketStatus) || StringUtils.isEmpty((CharSequence)(parentOrderNum = dynamicObject.getString("parentordernum")))) continue;
                planeParentOrderNums.add(parentOrderNum);
            }
            DynamicObject[] orderBillData = this.update(planeParentOrderNums, "er_planebill");
            if (orderBillData != null) {
                for (DynamicObject orderBillDatum : orderBillData) {
                    orderBillDatum.set("ticketstatus", (Object)"REFOUND");
                }
                SaveServiceHelper.save((DynamicObject[])orderBillData);
            }
        }
        if (null != hotelBillMap && !hotelBillMap.isEmpty()) {
            this.setParentOrderStatus(hotelBillMap, "10");
        }
        if (null != trainBillMap && !trainBillMap.isEmpty()) {
            this.setParentOrderStatus(trainBillMap, "3");
        }
    }

    private void setParentOrderStatus(Map<String, DynamicObject> orderBillMap, String tmpOrderStatus) {
        ArrayList trainParentOrderNums = Lists.newArrayListWithCapacity((int)orderBillMap.size());
        Set<Map.Entry<String, DynamicObject>> entries = orderBillMap.entrySet();
        for (Map.Entry<String, DynamicObject> entry : entries) {
            String parentOrderNum;
            DynamicObject dynamicObject = entry.getValue();
            String orderStatus = dynamicObject.getString("orderstatus");
            if (StringUtils.isEmpty((CharSequence)orderStatus) || !tmpOrderStatus.equalsIgnoreCase(orderStatus) || StringUtils.isEmpty((CharSequence)(parentOrderNum = dynamicObject.getString("parentordernum")))) continue;
            trainParentOrderNums.add(parentOrderNum);
        }
        DynamicObject[] orderBillData = this.update(trainParentOrderNums, "er_trainbill");
        if (orderBillData != null) {
            for (DynamicObject hotelBillDatum : orderBillData) {
                hotelBillDatum.set("orderstatus", (Object)tmpOrderStatus);
            }
            SaveServiceHelper.save((DynamicObject[])orderBillData);
        }
    }

    private DynamicObject[] update(List<String> parentOrderNums, String entityName) {
        if (CollectionUtils.isNotEmpty(parentOrderNums)) {
            return BusinessDataServiceHelper.load((String)entityName, (String)"orderstatus,id,orderstatusname,ticketstatus", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", parentOrderNums)});
        }
        return null;
    }

    private void dealOrderNum(List<AbstractOrderModel> orderModels) {
        DynamicObjectCollection datas;
        int intValue = TripSyncConfigUtil.getIntValue("links_open", 0, Arrays.asList(0, 1));
        if (orderModels.isEmpty() || 0 == intValue) {
            return;
        }
        List trainOrders = orderModels.stream().filter(obj -> obj instanceof TrainOrderModel).collect(Collectors.toList());
        if (trainOrders.isEmpty()) {
            return;
        }
        HashMap<String, Set> ordernumMap = new HashMap<String, Set>(16);
        HashMap<String, List> uniqueKeyIdMap = new HashMap<String, List>(16);
        for (AbstractOrderModel order2 : trainOrders) {
            String uniqueId = order2.getUniqueId();
            String uniqueKeyId = order2.getOrderNum() + "-" + (StringUtils.isEmpty((CharSequence)uniqueId) || uniqueId.length() < 4 ? uniqueId : uniqueId.substring(uniqueId.length() - 4));
            ordernumMap.computeIfAbsent(order2.getOrderNum(), k -> new HashSet()).add(uniqueKeyId);
            uniqueKeyIdMap.computeIfAbsent(uniqueKeyId, k -> new ArrayList()).add(order2);
        }
        Map<String, String> oldOrderNumAndNewOrderNumMap = trainOrders.stream().collect(Collectors.toMap(obj -> {
            String uniqueId = obj.getUniqueId();
            String orderNum = obj.getOrderNum();
            return orderNum + "-" + (StringUtils.isEmpty((CharSequence)uniqueId) || uniqueId.length() < 4 ? uniqueId : uniqueId.substring(uniqueId.length() - 4));
        }, AbstractOrderModel::getOrderNum, (exist, newData) -> newData));
        Set<String> keySet = oldOrderNumAndNewOrderNumMap.keySet();
        DynamicObjectCollection newOrderNumData = QueryServiceHelper.query((String)"er_trainbill", (String)"ordernum", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", keySet)});
        if (!newOrderNumData.isEmpty()) {
            Set<String> existOrderNum = newOrderNumData.stream().map(obj -> obj.getString("ordernum")).collect(Collectors.toSet());
            existOrderNum.forEach(existUniqueKeyId -> {
                List orders = (List)uniqueKeyIdMap.get(existUniqueKeyId);
                if (orders != null) {
                    orders.forEach(order -> order.setOrderNum((String)existUniqueKeyId));
                    oldOrderNumAndNewOrderNumMap.remove(existUniqueKeyId);
                }
            });
            keySet.removeAll(existOrderNum);
        }
        if (!(datas = QueryServiceHelper.query((String)"er_allorderbill", (String)"ordernum,uniqueid", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", oldOrderNumAndNewOrderNumMap.values())})).isEmpty()) {
            Map<String, String> orderNumAndUniqueIdMap = datas.stream().collect(Collectors.toMap(obj -> obj.getString("ordernum"), obj -> obj.getString("uniqueid")));
            HashSet exist2 = new HashSet();
            datas.forEach(obj -> {
                String uniqueId = obj.getString("uniqueid");
                exist2.add(obj.getString("ordernum") + "-" + (StringUtils.isEmpty((CharSequence)uniqueId) || uniqueId.length() < 4 ? uniqueId : uniqueId.substring(uniqueId.length() - 4)));
            });
            keySet.removeAll(exist2);
            trainOrders.stream().filter(order -> orderNumAndUniqueIdMap.containsKey(order.getOrderNum())).forEach(order -> {
                String dbUniqueId = (String)orderNumAndUniqueIdMap.get(order.getOrderNum());
                String uniqueId = order.getUniqueId();
                if (StringUtils.isNotEmpty((CharSequence)dbUniqueId) && !uniqueId.equalsIgnoreCase(dbUniqueId)) {
                    order.setOrderNum(order.getOrderNum() + "-" + (StringUtils.isEmpty((CharSequence)uniqueId) || uniqueId.length() < 4 ? uniqueId : uniqueId.substring(uniqueId.length() - 4)));
                }
            });
        }
        ordernumMap.entrySet().stream().filter(entry -> ((Set)entry.getValue()).size() > 1).forEach(entry -> ((Set)entry.getValue()).forEach(orderWithUniqueId -> {
            List orders;
            if (keySet.contains(orderWithUniqueId) && (orders = (List)uniqueKeyIdMap.get(orderWithUniqueId)) != null) {
                orders.forEach(order -> order.setOrderNum((String)orderWithUniqueId));
            }
        }));
    }
}

