/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.model.DailyVehicleBillModel;
import kd.fi.er.business.trip.service.function.AbstractDailyVehicleBillInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class ETripDailyVehicleBillInvoke
extends AbstractDailyVehicleBillInvoke<JSONObject> {
    private static final Log logger = LogFactory.getLog(ETripDailyVehicleBillInvoke.class);
    private boolean isCtrl = false;

    public ETripDailyVehicleBillInvoke(Object pk) {
        super(pk);
    }

    public ETripDailyVehicleBillInvoke() {
    }

    @Override
    protected String supplier() {
        return Supplier.ZHONGXING.name();
    }

    protected JSONObject convert(Object value) {
        if (this.pk != null) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u51fa\u5dee\u7533\u8bf7\u5355,\u5355\u636ebillid\u4e3a:" + this.pk);
            return this.convertPushBill(value);
        }
        String syncStatus = (String)this.getParams().get("syncStatus");
        logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u51fa\u5dee\u7533\u8bf7\u5355,\u540c\u6b65\u7684\u72b6\u6001\u6709:1_\u63a8\u9001\u5355\u636e,2_\u5173\u95ed\u5355\u636e,3_\u542f\u7528\u5355\u636e,4_\u64a4\u9500\u5355\u636e,\u5f53\u524d\u72b6\u6001\u4e3a:" + syncStatus);
        switch (syncStatus) {
            case "1": {
                return this.convertPushBill(value);
            }
        }
        return null;
    }

    protected JSONObject convertPushBill(Object info) {
        String synBillSettleType;
        DailyVehicleBillModel reqbill = (DailyVehicleBillModel)info;
        JSONObject bodyDataJson = new JSONObject();
        JSONArray journeyInfos = new JSONArray();
        JSONArray policyPassengers = new JSONArray();
        JSONObject oneJourneyInfo = new JSONObject();
        oneJourneyInfo.put("seqNo", (Object)1);
        oneJourneyInfo.put("fromCity", (Object)reqbill.getVehiclecityName());
        oneJourneyInfo.put("toCity", (Object)reqbill.getVehiclecityName());
        oneJourneyInfo.put("journeyType", (Object)"RT");
        oneJourneyInfo.put("startDate", (Object)TripCommonUtil.date2TimeStamp(reqbill.getStartdate(), "yyyy-MM-dd"));
        oneJourneyInfo.put("endDate", (Object)TripCommonUtil.date2TimeStamp(reqbill.getEnddate(), "yyyy-MM-dd"));
        oneJourneyInfo.put("trafficTool", (Object)"other");
        journeyInfos.add((Object)oneJourneyInfo);
        this.setCompanionInfos(bodyDataJson, reqbill, policyPassengers);
        bodyDataJson.put("sourceType", (Object)"kingdee");
        bodyDataJson.put("sourceKey", (Object)reqbill.getBillNo());
        bodyDataJson.put("applyEmpNum", (Object)reqbill.getCreatEmpNum());
        bodyDataJson.put("errandEmpNum", (Object)reqbill.getApplyEmpNum());
        bodyDataJson.put("journeyType", (Object)"INLAND");
        bodyDataJson.put("reason", (Object)reqbill.getDesc());
        bodyDataJson.put("journeyInfos", (Object)journeyInfos);
        bodyDataJson.put("isCanModify", (Object)"modify");
        bodyDataJson.put("companionView", (Object)"Y");
        Map<String, String> tripInfoDynamic = TripCommonUtil.getTripServiceInfo(Supplier.ZHONGXING.name());
        if (tripInfoDynamic != null && (synBillSettleType = tripInfoDynamic.get("syncreqbillsettleorg")) != null && !synBillSettleType.equals("2")) {
            if (synBillSettleType.equals("0")) {
                bodyDataJson.put("corporation", (Object)reqbill.getCostCompanyId());
                bodyDataJson.put("corporationName", (Object)reqbill.getCostCompany());
            } else if (synBillSettleType.equals("1")) {
                bodyDataJson.put("corporation", (Object)reqbill.getCompanyId());
                bodyDataJson.put("corporationName", (Object)reqbill.getCompany());
            }
        }
        return bodyDataJson;
    }

    private void setCompanionInfos(JSONObject bodyDataJson, DailyVehicleBillModel reqbill, JSONArray policyPassengers) {
        JSONArray companionInfoArray = new JSONArray();
        JSONObject companionInfoObject = new JSONObject();
        JSONObject policyPassenger = new JSONObject();
        companionInfoObject.put("personnelType", (Object)"EMPLOYEE");
        companionInfoObject.put("empNum", (Object)reqbill.getApplyEmpNum());
        companionInfoObject.put("personnelName", (Object)reqbill.getApplyEmpName());
        policyPassenger.put("passengerName", (Object)reqbill.getApplyEmpName());
        companionInfoArray.add((Object)companionInfoObject);
        policyPassengers.add((Object)policyPassenger);
        if (!reqbill.getCreatEmpNum().equals(reqbill.getApplyEmpNum())) {
            JSONObject companionInfoObject2 = new JSONObject();
            JSONObject policyPassenger2 = new JSONObject();
            companionInfoObject2.put("personnelType", (Object)"EMPLOYEE");
            companionInfoObject2.put("empNum", (Object)reqbill.getCreatEmpNum());
            companionInfoObject2.put("personnelName", (Object)reqbill.getCreatEmpName());
            policyPassenger2.put("passengerName", (Object)reqbill.getCreatEmpName());
            companionInfoArray.add((Object)companionInfoObject2);
            policyPassengers.add((Object)policyPassenger2);
        }
        bodyDataJson.put("companionInfos", (Object)companionInfoArray);
    }

    protected String batPushProcess(Object value) {
        if (value == null) {
            return null;
        }
        String method = "errand.createbill";
        Map<String, String> ZTE_login_info = TripCommonUtil.getTripServiceInfo(this.supplier());
        String kingdee_user_name = ZTE_login_info.get("appkey");
        String kingdee_user_key = ZTE_login_info.get("appsecurity");
        String currentTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        ArrayList<NameValuePair> body_params = new ArrayList<NameValuePair>();
        body_params.add((NameValuePair)new BasicNameValuePair("userName", kingdee_user_name));
        body_params.add((NameValuePair)new BasicNameValuePair("currentTime", currentTime));
        String password = CommonServiceHelper.getMD5(kingdee_user_name + method + kingdee_user_key + currentTime).toUpperCase();
        body_params.add((NameValuePair)new BasicNameValuePair("password", password));
        body_params.add((NameValuePair)new BasicNameValuePair("format", "json"));
        body_params.add((NameValuePair)new BasicNameValuePair("method", method));
        String data = "";
        JSONObject bodyDataJson = JSON.parseObject((String)JSON.toJSONString((Object)value));
        try {
            String dataJson = JSON.toJSONString((Object)bodyDataJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            data = URLEncoder.encode(dataJson, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u7528\u8f66\u7533\u8bf7\u5355,encode\u5931\u8d25:", (Throwable)e);
            throw new RuntimeException(e);
        }
        body_params.add((NameValuePair)new BasicNameValuePair("data", data));
        String url = ZTE_login_info.get("reservedfield1");
        this.tripSyncLogParam.setRequestdata(value);
        this.tripSyncLogParam.setRequesturl(url);
        Map<String, Object> resultMap = HttpServiceHelper.httpPost(url, body_params);
        this.tripSyncLogParam.setResponsedata(resultMap);
        int resultCode = (Integer)resultMap.get("code");
        String resultMessage = (String)resultMap.get("message");
        return String.valueOf(resultCode);
    }
}

