/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.service.function.AbstractLoginInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.zte.systemexternal.BeeCityCodePlane;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class ETripLoginInvoke
extends AbstractLoginInvoke {
    private static final Log logger = LogFactory.getLog(ETripLoginInvoke.class);

    public ETripLoginInvoke() {
    }

    public ETripLoginInvoke(Map<String, Object> param) {
        super(param);
    }

    @Override
    public String login() {
        String url = null;
        try {
            Map urlDataMap = this.param;
            Map<String, String> beeMap = TripCommonUtil.getTripServiceInfo(Supplier.ZHONGXING.name());
            String kingdee_user_name = beeMap.get("appkey");
            String kingdee_user_key = beeMap.get("appsecurity");
            String currentTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            String password = CommonServiceHelper.getMD5(kingdee_user_name + "login.sso" + kingdee_user_key + currentTime).toUpperCase();
            String applierID = (String)urlDataMap.get("employeeNumber");
            ArrayList<NameValuePair> reqParams = new ArrayList<NameValuePair>();
            reqParams.add((NameValuePair)new BasicNameValuePair("userName", kingdee_user_name));
            reqParams.add((NameValuePair)new BasicNameValuePair("method", "login.sso"));
            reqParams.add((NameValuePair)new BasicNameValuePair("currentTime", currentTime));
            reqParams.add((NameValuePair)new BasicNameValuePair("password", password));
            reqParams.add((NameValuePair)new BasicNameValuePair("format", "json"));
            reqParams.add((NameValuePair)new BasicNameValuePair("data", URLEncoder.encode(applierID, StandardCharsets.UTF_8.name())));
            String BEE_URL = beeMap.get("reservedfield1");
            String BEE_SSO_URL = beeMap.get("reservedfield2");
            Map<String, Object> resultMap = HttpRetryServiceHelper.httpPost(BEE_URL, reqParams);
            if ((Integer)resultMap.get("code") == 500) {
                logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u767b\u5f55,\u8bf7\u6c42\u5931\u8d25:" + urlDataMap.get("applyBillNumber") + resultMap.get("message"));
            }
            String authenticationCode = (String)resultMap.get("data");
            String businessType = (String)urlDataMap.get("businessType");
            String pwd = CommonServiceHelper.getMD5(kingdee_user_name + applierID + authenticationCode + kingdee_user_key).toUpperCase();
            url = BEE_SSO_URL + "?callDirect=ssoSrv&pwd=" + pwd + "&authCode=" + authenticationCode + "&businessType=" + businessType + this.getParameter(urlDataMap, businessType);
            if (((Boolean)urlDataMap.get("isPC")).booleanValue()) {
                url = url.replace("NewWXWelcome", "NewWelcome");
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u767b\u5f55,\u6253\u5f00\u4e2d\u5174\u9875\u9762\u5931\u8d25:", (Throwable)e);
        }
        catch (KDException e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u767b\u5f55,\u6253\u5f00\u4e2d\u5174\u9875\u9762\u5931\u8d25:", (Throwable)e);
        }
        return url;
    }

    private String getParameter(Map<String, Object> urlDataMap, String businessType) throws UnsupportedEncodingException {
        String result = "";
        String oaBillNum = (String)urlDataMap.get("applyBillNumber");
        if (oaBillNum == null) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u767b\u5f55,\u51fa\u5dee\u7533\u8bf7\u5355\u53f7\u4e3a\u7a7a");
            return "";
        }
        String departName = URLEncoder.encode(((String)urlDataMap.get("from")).trim(), StandardCharsets.UTF_8.name());
        String arriveName = URLEncoder.encode(((String)urlDataMap.get("to")).trim(), StandardCharsets.UTF_8.name());
        String departDate = (String)urlDataMap.get("startDate");
        String queryType = "1";
        String returnDate = (String)urlDataMap.get("endDate");
        BeeCityCodePlane beeCityCodePlane = new BeeCityCodePlane();
        String departCodePlane = beeCityCodePlane.getCityCode(departName);
        String arriveCodePlane = beeCityCodePlane.getCityCode(arriveName);
        String checkInDate = (String)urlDataMap.get("startDate");
        String checkOutDate = (String)urlDataMap.get("endDate");
        String cityName = arriveName;
        switch (businessType) {
            case "domair": 
            case "intair": {
                result = "&oaBillNum=" + oaBillNum + "&queryType=" + queryType + "&departName=" + departName + "&departCode=" + departCodePlane + "&arriveName=" + arriveName + "&arriveCode=" + arriveCodePlane + "&departDate=" + departDate + "&returnDate=" + returnDate;
                break;
            }
            case "train": {
                result = "&oaBillNum=" + oaBillNum + "&departName=" + departName + "&arriveName=" + arriveName + "&departDate=" + departDate;
                break;
            }
            case "hotel": {
                result = "&oaBillNum=" + oaBillNum + "&checkInDate=" + checkInDate + "&checkOutDate=" + checkOutDate + "&cityName=" + cityName;
                break;
            }
            case "car": {
                result = "&oaBillNum=" + oaBillNum + "&departName=" + departName + "&arriveName=" + arriveName + "&departDate=" + departDate + "&returnDate=" + returnDate;
            }
        }
        return result;
    }

    @Override
    protected void process(String loginString) {
        IFormView formView = (IFormView)this.param.get("view");
        formView.openUrl(loginString);
    }
}

