/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.service.function.AbstractOrgInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.zte.systemexternal.ETripServiceUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;

public class ETripOrgInvoke
extends AbstractOrgInvoke {
    private static final int BATCH = 200;

    @Override
    protected String supplier() {
        return Supplier.ZHONGXING.name();
    }

    @Override
    protected Object getInnerData() {
        this.bizInfoObject = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (String)"lastsyncorgtamp", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.supplier())});
        this.lastSyncOrgTamp = this.bizInfoObject.getString("lastsyncorgtamp");
        return this.queryChangeInfo();
    }

    private JSONArray queryChangeInfo() {
        Date changetime = TripCommonUtil.convertToDate(this.lastSyncOrgTamp);
        QFilter qFilter = new QFilter("view", "=", (Object)1L);
        if (this.params != null && null != this.params.get("orgList")) {
            qFilter.and(new QFilter("org", "in", this.params.get("orgList")));
        } else {
            QFilter createtimeFilter = new QFilter("createtime", ">=", (Object)changetime);
            QFilter modifytimeFilter = new QFilter("modifytime", ">=", (Object)changetime);
            QFilter timeFilter = createtimeFilter.or(modifytimeFilter);
            qFilter.and(timeFilter);
        }
        DynamicObjectCollection orgDOs = QueryServiceHelper.query((String)"bos_org_structure", (String)"number, org, org.id,org.name,parent, parent.id, createtime, modifytime, isfreeze", (QFilter[])new QFilter[]{qFilter}, (String)"level");
        JSONArray orgEntryList = new JSONArray();
        orgDOs.stream().forEach(v -> this.buildOrgList(orgEntryList, (DynamicObject)v));
        return orgEntryList;
    }

    private void buildOrgList(JSONArray entryList, DynamicObject v) {
        JSONObject entryObj = new JSONObject();
        entryObj.put("deptCode", (Object)v.getLong("org.id"));
        entryObj.put("deptName", (Object)v.getString("org.name"));
        entryObj.put("parentDeptCode", (Object)v.getString("parent.id"));
        boolean isfreeze = v.getBoolean("isfreeze");
        String enabledFlag = isfreeze ? "N" : "Y";
        entryObj.put("enabledFlag", (Object)enabledFlag);
        entryList.add((Object)entryObj);
    }

    protected Object convert(Object info) {
        return info;
    }

    protected String batPushProcess(Object data) {
        String backCode = "200";
        JSONArray orgDataJson = (JSONArray)data;
        if (orgDataJson == null || orgDataJson.size() <= 0) {
            return backCode;
        }
        Map groupPostDataMap = TripSyncConfigUtil.groupPostDataMap(orgDataJson);
        for (int i = 0; i < groupPostDataMap.size(); ++i) {
            List currentData = (List)groupPostDataMap.get(i);
            String method = "zas.syncdept";
            String supplier = this.supplier();
            backCode = ETripServiceUtil.syncPushOrgOrUserDataToZTE(JSONArray.parseArray((String)JSON.toJSONString((Object)currentData)), supplier, method, this.tripSyncLogParam, this.tripSyncLogParamList);
            if ("200".equals(backCode)) continue;
            backCode = "300";
        }
        return backCode;
    }
}

