/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.RefObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.model.UserModel;
import kd.fi.er.business.trip.service.function.AbstractUserInvoke;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.zte.systemexternal.ETripServiceUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import org.apache.commons.lang.StringUtils;

public class ETripUserInvoke
extends AbstractUserInvoke<Set<JSONArray>> {
    private static final Log logger = LogFactory.getLog(ETripUserInvoke.class);

    @Override
    protected String supplier() {
        return Supplier.ZHONGXING.name();
    }

    public Set<JSONArray> convert(Object innerData) {
        int batch;
        Set userModelSet = (Set)innerData;
        HashSet<JSONArray> userJsonArray = new HashSet<JSONArray>();
        int batchTemp = batch = TripSyncConfigUtil.getIntValue("trip_sync_org_user_size", 10);
        JSONArray userBatch = new JSONArray();
        boolean isSyncOrg = TripSyncConfigUtil.getBoolean("ztrip_sync_org_user");
        for (UserModel user : userModelSet) {
            --batchTemp;
            JSONObject userJson = new JSONObject();
            userJson.put("employeeNumber", (Object)user.getEmployeeID());
            userJson.put("employeeName", (Object)user.getName());
            userJson.put("mobilePhone", (Object)user.getMobilePhone());
            userJson.put("email", (Object)user.getEmail());
            userJson.put("identityList", (Object)new JSONArray());
            userJson.put("enabledFlag", (Object)user.getEnableFlag());
            if (user.getReimburseleveName() != null) {
                userJson.put("personnelLevel", (Object)user.getReimburseleveName());
            }
            if (isSyncOrg) {
                userJson.put("deptCode", (Object)user.getDeptId());
            }
            userBatch.add((Object)userJson);
            if (batchTemp != 0) continue;
            userJsonArray.add(userBatch);
            batchTemp = batch;
            userBatch = new JSONArray();
        }
        if (userBatch.size() != 0) {
            userJsonArray.add(userBatch);
        }
        return userJsonArray;
    }

    protected String batPushProcess(Object set) {
        String backCode = "200";
        Set userJSONArraySet = (Set)set;
        if (userJSONArraySet == null || userJSONArraySet.size() <= 0) {
            return backCode;
        }
        for (JSONArray array : userJSONArraySet) {
            String method = "zas.syncemployee";
            String supplier = this.supplier();
            RefObject refObject = new RefObject(new ArrayList(10));
            backCode = ETripServiceUtil.syncPushOrgOrUserDataToZTE(array, supplier, method, this.tripSyncLogParam, this.tripSyncLogParamList, (RefObject<List<TripSyncLogParam>>)refObject);
            ((List)refObject.getValue()).stream().forEach(e -> this.addTripSyncLogParam((TripSyncLogParam)e));
            if ("200".equals(backCode)) continue;
            backCode = "300";
        }
        return backCode;
    }

    @Override
    protected boolean syncUserByPage() {
        return true;
    }

    @Override
    protected Object getInnerData(String changeTime, Integer pageIndex, Integer pageSize, Map<String, Object> map) {
        Set set = (Set)super.getInnerData(changeTime, pageIndex, pageSize, map);
        if (set != null) {
            set.removeIf(e -> StringUtils.isBlank((String)e.getEmployeeID()));
        }
        return set;
    }
}

