/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.invoke.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.HotelOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class ETripHotelOrderConvert {
    private static final Log logger = LogFactory.getLog(ETripHotelOrderConvert.class);

    public static List<AbstractOrderModel> convert(JSONObject orderJson) throws CloneNotSupportedException {
        logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u8ba2\u5355,\u63a5\u6536\u9152\u5e97\u8ba2\u5355" + orderJson.toJSONString());
        ArrayList orderModels = Lists.newArrayListWithExpectedSize((int)4);
        HotelOrderModel hotelOrderModel = new HotelOrderModel();
        hotelOrderModel.setOriOrderNum(orderJson.getString("oriOrderNum"));
        hotelOrderModel.setBookedName(orderJson.getString("bookedDeptName"));
        hotelOrderModel.setCityName(orderJson.getString("cityName"));
        hotelOrderModel.setRoomStyleName(orderJson.getString("roomStyleName"));
        hotelOrderModel.setRoomStyleName(orderJson.getString("roomStyleName"));
        hotelOrderModel.setHotelAddress(orderJson.getString("hotelAddress"));
        hotelOrderModel.setRoomCount(orderJson.getIntValue("roomCount"));
        hotelOrderModel.setUnbookFee(orderJson.getBigDecimal("unbookFee"));
        hotelOrderModel.setHotelName(orderJson.getString("hotelName"));
        hotelOrderModel.setTotalAmount(orderJson.getBigDecimal("totalAmount"));
        hotelOrderModel.setServiceFee(orderJson.getBigDecimal("serviceFee"));
        hotelOrderModel.setCheckinDate(TripCommonUtil.convertToDate(orderJson.getString("checkInDate")));
        hotelOrderModel.setCheckoutDate(TripCommonUtil.convertToDate(orderJson.getString("checkOutDate")));
        hotelOrderModel.setOrderDate(TripCommonUtil.convertToDate(orderJson.getString("orderDate")));
        hotelOrderModel.setSourceBookedId(orderJson.getString("sourceBookedId"));
        hotelOrderModel.setOrderNum(orderJson.getString("orderNum"));
        hotelOrderModel.setParentOrderNum(orderJson.getString("parentOrderNum"));
        hotelOrderModel.setOaBillNum(orderJson.getString("oaBillNum"));
        hotelOrderModel.setBookedName(orderJson.getString("bookedName"));
        hotelOrderModel.setHappendDate(TripCommonUtil.convertToDate(orderJson.getString("happendDate")));
        hotelOrderModel.setRoomAmount(orderJson.getBigDecimal("roomAmount"));
        hotelOrderModel.setServer(Supplier.ZHONGXING.name());
        hotelOrderModel.setOrderStatusName(orderJson.getString("orderStatusName"));
        hotelOrderModel.setOrderType(ETripHotelOrderConvert.setOrderType(orderJson.getString("orderType")));
        hotelOrderModel.setOrderStatus(ETripHotelOrderConvert.setOrderStatus(orderJson.getString("orderStatus")));
        hotelOrderModel.setOrderNatrue(ETripHotelOrderConvert.setOrderNatrue(orderJson.getString("errandType")));
        hotelOrderModel.setProductType(ETripHotelOrderConvert.setProductType(orderJson.getString("paymentType")));
        hotelOrderModel.setOperationType(AbstractOrderModel.OperationType.A);
        hotelOrderModel.setOrderSort(AbstractOrderModel.OrderSort.A);
        hotelOrderModel.setPersonalFee(orderJson.getBigDecimal("paymentPsFee"));
        JSONArray travelers = orderJson.getJSONArray("travelers");
        if (travelers != null && travelers.size() > 0) {
            JSONObject traveler = travelers.getJSONObject(0);
            hotelOrderModel.setSourceTravelerId(traveler.getString("sourceTravelerId"));
            hotelOrderModel.setTravelerName(traveler.getString("travelerName"));
            orderModels.add(hotelOrderModel);
        }
        return orderModels;
    }

    private static AbstractOrderModel.OrderNatrue setOrderNatrue(String orderNatrue) {
        if ("1".equals(orderNatrue)) {
            return AbstractOrderModel.OrderNatrue.A;
        }
        return AbstractOrderModel.OrderNatrue.B;
    }

    private static HotelOrderModel.OrderStatus setOrderStatus(String orderStatus) {
        switch (orderStatus) {
            case "1": {
                return HotelOrderModel.OrderStatus.A;
            }
            case "2": {
                return HotelOrderModel.OrderStatus.B;
            }
            case "3": {
                return HotelOrderModel.OrderStatus.C;
            }
            case "4": {
                return HotelOrderModel.OrderStatus.D;
            }
            case "5": {
                return HotelOrderModel.OrderStatus.E;
            }
            case "6": {
                return HotelOrderModel.OrderStatus.F;
            }
            case "7": {
                return HotelOrderModel.OrderStatus.G;
            }
            case "8": {
                return HotelOrderModel.OrderStatus.H;
            }
            case "10": {
                return HotelOrderModel.OrderStatus.I;
            }
            case "14": {
                return HotelOrderModel.OrderStatus.J;
            }
        }
        return HotelOrderModel.OrderStatus.A;
    }

    private static AbstractOrderModel.OrderType setOrderType(String orderType) {
        if ("O".equalsIgnoreCase(orderType)) {
            return AbstractOrderModel.OrderType.O;
        }
        if ("T".equalsIgnoreCase(orderType)) {
            return AbstractOrderModel.OrderType.T;
        }
        return AbstractOrderModel.OrderType.G;
    }

    private static AbstractOrderModel.ProductType setProductType(String productType) {
        if ("1".equals(productType)) {
            return AbstractOrderModel.ProductType.A;
        }
        return AbstractOrderModel.ProductType.B;
    }
}

