/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.zte.systemexternal;

import com.alibaba.fastjson.JSONArray;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.RefObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.util.TripCommonUtil;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class ETripServiceUtil {
    private static Log logger = LogFactory.getLog(ETripServiceUtil.class);

    public static String syncPushOrgOrUserDataToZTE(JSONArray orgDataJson, String supplier, String method, TripSyncLogParam tripSyncLogParam, List<TripSyncLogParam> tripSyncLogParamList) {
        return ETripServiceUtil.syncPushOrgOrUserDataToZTE(orgDataJson, supplier, method, tripSyncLogParam, tripSyncLogParamList, null);
    }

    public static String syncPushOrgOrUserDataToZTE(JSONArray orgDataJson, String supplier, String method, TripSyncLogParam tripSyncLogParam, List<TripSyncLogParam> tripSyncLogParamList, RefObject<List<TripSyncLogParam>> refLogList) {
        String code;
        try {
            Map<String, String> supplierMap = TripCommonUtil.getTripServiceInfo(supplier);
            String beeUrl = supplierMap.get("reservedfield1");
            String userName = supplierMap.get("appkey");
            String currentTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            String userKey = supplierMap.get("appsecurity");
            String password = CommonServiceHelper.getMD5(userName + method + userKey + currentTime).toUpperCase();
            ArrayList<NameValuePair> body_params = new ArrayList<NameValuePair>();
            body_params.add((NameValuePair)new BasicNameValuePair("userName", userName));
            body_params.add((NameValuePair)new BasicNameValuePair("currentTime", currentTime));
            body_params.add((NameValuePair)new BasicNameValuePair("password", password));
            body_params.add((NameValuePair)new BasicNameValuePair("format", "json"));
            body_params.add((NameValuePair)new BasicNameValuePair("method", method));
            body_params.add((NameValuePair)new BasicNameValuePair("data", URLEncoder.encode(orgDataJson.toJSONString(), "UTF-8")));
            TripSyncLogParam currentLog = tripSyncLogParam.clone();
            currentLog.setRequesturl(beeUrl);
            currentLog.setRequestdata(orgDataJson);
            Map<String, Object> resultMap = HttpRetryServiceHelper.httpPostRetry(beeUrl, body_params, 1000000);
            currentLog.setResponsedata(resultMap);
            code = String.valueOf(resultMap.get("code"));
            if (!"200".equals(String.valueOf(code))) {
                currentLog.setStatus("B");
            }
            tripSyncLogParamList.add(currentLog);
            if (refLogList != null) {
                ((List)refLogList.getValue()).add(currentLog);
            }
            logger.info("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u4eba\u5458\u6216\u7ec4\u7ec7," + method + ",\u8fd4\u56de\u4fe1\u606f:" + resultMap.get("message"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u4e2d\u5174\u4eba\u5458\u6216\u7ec4\u7ec7," + method + ",encode\u5931\u8d25:", (Throwable)e);
            throw new RuntimeException(e);
        }
        return code;
    }

    public static Map groupPostDataMap(JSONArray value, int defaultValueCount) {
        int i;
        int size = value.size() / defaultValueCount + 1;
        HashMap map = new HashMap(size);
        for (i = 0; i < size; ++i) {
            map.put(i, new ArrayList(defaultValueCount));
        }
        for (i = 0; i < value.size(); ++i) {
            int index = i / defaultValueCount;
            ((List)map.get(index)).add(value.getJSONObject(i));
        }
        return map;
    }
}

