/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.task.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.message.ErMessageServiceHelper;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang.StringUtils;

public class OrderOverPeriodConfrimTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        int day = TripSyncConfigUtil.getIntValue("order_confirm_date", 15);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, day * -1);
        ORM orm = ORM.create();
        QFilter dateDiff = new QFilter("happenddate", "<", (Object)calendar.getTime());
        QFilter notConfrim = new QFilter("isconfirm", "!=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{dateDiff, notConfrim};
        HashSet<String> orderTypes = new HashSet<String>(6);
        orderTypes.add("er_vehiclebill");
        orderTypes.add("er_trainbill");
        orderTypes.add("er_planebill");
        orderTypes.add("er_hotelbill");
        orderTypes.add("er_mealbill");
        for (String orderType : orderTypes) {
            DynamicObject[] collection;
            String sql = "company, id, feedback, isconfirm";
            if ("er_vehiclebill".equals(orderType)) {
                sql = "company, id, feedback, vehicletype,isconfirm";
            }
            if ((collection = BusinessDataServiceHelper.load((String)orderType, (String)sql, (QFilter[])qFilters, null, (int)1000)).length == 0) continue;
            Map<String, List<DynamicObject>> orderMap = Stream.of(collection).collect(Collectors.groupingBy(e -> ErMessageServiceHelper.getSysParamKey(e) + ErCommonUtils.getPk(e.get("company"))));
            for (Map.Entry<String, List<DynamicObject>> entry : orderMap.entrySet()) {
                DynamicObject d = entry.getValue().get(0);
                if (!ErMessageServiceHelper.autoSend(ErCommonUtils.getPk(d.get("company")), d)) continue;
                Iterator<DynamicObject> iterator = entry.getValue().iterator();
                ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(1000);
                while (iterator.hasNext()) {
                    DynamicObject row = iterator.next();
                    if (!StringUtils.isBlank((String)row.getString("feedback"))) continue;
                    saveList.add(row);
                }
                if (saveList.size() == 0) continue;
                saveList.forEach(e -> e.set("isconfirm", (Object)true));
                SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                QFilter qFilter = new QFilter("orderid", "in", saveList.stream().map(e -> String.valueOf(e.getLong("id"))).collect(Collectors.toList()));
                DynamicObject[] allDynamicObjects = BusinessDataServiceHelper.load((String)"er_allorderbill", (String)"isconfirm", (QFilter[])new QFilter[]{qFilter}, null, (int)1000);
                if (allDynamicObjects == null || allDynamicObjects.length <= 0) continue;
                Arrays.stream(allDynamicObjects).forEach(m -> m.set("isconfirm", (Object)true));
                SaveServiceHelper.save((DynamicObject[])allDynamicObjects);
            }
        }
    }
}

