/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.task.common;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.er.business.trip.overtime.TripOrderBillOvertimeHelper;
import kd.fi.er.business.utils.ErCommonUtils;

public class TripReimBillOverdueRemindTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(TripReimBillOverdueRemindTask.class);

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        List<DynamicObject> orderToRemind = new TripOrderBillOvertimeHelper().getOrderToRemind();
        HashMap<Long, Long> orderToRemindMap = new HashMap<Long, Long>();
        for (DynamicObject dynamicObject : orderToRemind) {
            Long creatorPkValue = ErCommonUtils.getPk(dynamicObject.get("sourcebookedid"));
            if (creatorPkValue == null) continue;
            if (!orderToRemindMap.containsKey(creatorPkValue)) {
                orderToRemindMap.put(creatorPkValue, 1L);
                continue;
            }
            Long count = (Long)orderToRemindMap.get(creatorPkValue);
            orderToRemindMap.put(creatorPkValue, count + 1L);
        }
        logger.info("\u5dee\u65c5\u8ba2\u5355\u62a5\u9500\u8d85\u671f\u63d0\u9192,\u53d1\u9001\u6d88\u606f\u4e2a\u6570\uff1a" + orderToRemindMap.size());
        for (Map.Entry entry : orderToRemindMap.entrySet()) {
            MessageInfo message = this.createMessageInfo((Long)entry.getKey(), (Long)entry.getValue());
            try {
                MessageCenterServiceHelper.sendMessage((MessageInfo)message);
            }
            catch (Exception e) {
                logger.warn("\u5dee\u65c5\u8ba2\u5355\u62a5\u9500\u8d85\u671f\u63d0\u9192,userId:" + entry.getKey() + ";\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a" + message + ";exceptMessage:" + e.getMessage());
            }
        }
    }

    private MessageInfo createMessageInfo(Long userId, Long count) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setTag(ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500", (String)"TripReimBillOverdueRemindTask_0", (String)"fi-er-business", (Object[])new Object[0]));
        messageInfo.setTitle(ResManager.loadKDString((String)"\u62a5\u9500\u63d0\u9192", (String)"TripReimBillOverdueRemindTask_1", (String)"fi-er-business", (Object[])new Object[0]));
        String content = ResManager.loadKDString((String)"\u60a8\u6709%1$s\u4e2a\u5546\u65c5\u8ba2\u5355\u5df2\u8d85\u671f\uff0c\u8bf7\u767b\u5f55\u7cfb\u7edf\u8fdb\u884c\u62a5\u9500\u3002", (String)"TripReimBillOverdueRemindTask_2", (String)"fi-er-business", (Object[])new Object[0]);
        List messageTemplate = MessageCenterServiceHelper.getMessageTemplateByFilters((String)"message", (String)"yunzhijia", (String)"er_order_overdue_remind_msg", (String)"er_tripreimbursebill");
        if (messageTemplate != null && messageTemplate.size() > 0) {
            content = JSONObject.parseObject((String)((String)messageTemplate.get(0))).getString("content");
        }
        messageInfo.setContent(String.format(content, count));
        messageInfo.setUserIds(new ArrayList<Long>(Collections.singletonList(userId)));
        messageInfo.setType("message");
        messageInfo.setMobContentUrl("");
        String messageChannels = MessageCenterServiceHelper.getChannelsOfMsgType((String)"message");
        messageInfo.setNotifyType(messageChannels);
        messageInfo.setPubaccNumber("systempubacc");
        return messageInfo;
    }
}

