/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.task.ctrip;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.executor.JobClient;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class CTripGetInvoiceDetailTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(CTripGetInvoiceDetailTask.class);

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        Boolean isEnble = TripCommonUtil.isEnbleServer(Supplier.XIECHENG.name());
        if (!isEnble.booleanValue()) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u670d\u52a1\u5546\u672a\u542f\u7528,\u8c03\u5ea6\u4efb\u52a1\u672a\u6267\u884c");
            return;
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u53d1\u7968\u63a5\u6536,\u8c03\u5ea6\u4efb\u52a1\u5f00\u59cb,executeGetInvoiceDetailTask");
        DynamicObject[] invoiceOrders = ErDaoFactory.getInstance("er_invoiceorderbill").query(new QFilter("invoicestatus", "=", (Object)"2").and(new QFilter("server", "=", (Object)Supplier.XIECHENG.getValue())));
        ITripService tripService = TripServiceFactory.getTripService("CTripService");
        if (null == invoiceOrders || invoiceOrders.length == 0) {
            return;
        }
        Map<String, List<Object>> params = Stream.of(invoiceOrders).collect(Collectors.groupingBy(v -> v.getString("accountid"), Collectors.mapping(v -> v.getString("id"), Collectors.toList())));
        logger.info("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u53d1\u7968\u63a5\u6536,\u8c03\u5ea6\u4efb\u52a1\u5165\u53c2:" + JSON.toJSONString(params));
        if (null == params || params.size() == 0) {
            return;
        }
        try {
            tripService.getInvoiceDetail(params);
        }
        catch (Exception e) {
            logger.error("\u5546\u65c5\u96c6\u6210,\u643a\u7a0b\u53d1\u7968\u63a5\u6536,\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25:", (Throwable)e);
        }
    }

    public static void executeTask() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setId("GetInvoiceDetailTask");
        jobInfo.setName(ResManager.loadKDString((String)"\u83b7\u53d6\u643a\u7a0b\u53d1\u7968\u5b9a\u65f6\u4efb\u52a1", (String)"CTripGetInvoiceDetailTask_0", (String)"fi-er-business", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setTaskClassname(CTripGetInvoiceDetailTask.class.getName());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        JobClient.dispatch((JobInfo)jobInfo);
    }
}

