/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.task.travelno1;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class TTripInvoiceGetTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(TTripInvoiceGetTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Boolean isEnble = TripCommonUtil.isEnbleServer(Supplier.CHAILVYIHAO.name());
        if (!isEnble.booleanValue()) {
            logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u4e00\u53f7\u670d\u52a1\u5546\u672a\u542f\u7528,\u8c03\u5ea6\u4efb\u52a1\u672a\u6267\u884c");
            return;
        }
        Date date = new Date();
        QFilter[] filterArray = new QFilter[]{new QFilter("invoicestatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"1", "2", "5", "6"})).and(new QFilter("server", "=", (Object)Supplier.CHAILVYIHAO)).and(new QFilter("invoicedate", ">=", (Object)TripCommonUtil.addDayByDate(date, -90))).and(new QFilter("invoicedate", "<=", (Object)date))};
        DynamicObjectCollection invoiceOrders = QueryServiceHelper.query((String)"er_invoiceorderbill", (String)"batchno,id,billno,invoicestatus,invoicecode,trdinvoiceid,invoicenum,invoicestatustime,invoicetax,invoiceamount,invoicetaxrate,systemtaxrate", (QFilter[])filterArray);
        if (null != invoiceOrders && invoiceOrders.size() > 0) {
            ITripService tripService = TripServiceFactory.getTripService("TTripService");
            List batchnos = invoiceOrders.stream().map(v -> v.getString("batchno")).collect(Collectors.toList());
            HashMap<String, List<Object>> params = new HashMap<String, List<Object>>(batchnos.size());
            params.put("batchnos", batchnos);
            tripService.getInvoiceDetail(params);
        }
    }
}

