/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.task.tripboards;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.trip.task.tripboards.HotelSummary;
import kd.fi.er.business.trip.task.tripboards.PlaneSummary;
import kd.fi.er.business.trip.task.tripboards.TrainSummary;
import kd.fi.er.business.trip.task.tripboards.VehicleSummary;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class OrderSummaryTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(OrderSummaryTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        ThreadPools.executeOnceIncludeRequestContext((String)"planeSummary", () -> new PlaneSummary().planeSummary());
        ThreadPools.executeOnceIncludeRequestContext((String)"hotelSummary", () -> new HotelSummary().hotelSummary());
        ThreadPools.executeOnceIncludeRequestContext((String)"trainSummary", () -> new TrainSummary().trainSummary());
        ThreadPools.executeOnceIncludeRequestContext((String)"vehicleSummary", () -> new VehicleSummary().vehicleSummary());
        ThreadPools.executeOnceIncludeRequestContext((String)"popularCitySummaryAndLinesSummary", this::planePopularCitySummary);
    }

    private void planePopularCitySummary() {
        try {
            Date tmp;
            DynamicObjectCollection summary = QueryServiceHelper.query((String)"er_city_routes_summary", (String)"max(summaryend) max", (QFilter[])new QFilter[0]);
            Date min = new Date();
            Date max = new Date();
            DynamicObjectCollection vehicleDatas = QueryServiceHelper.query((String)"er_vehiclebill", (String)"min(usetime) min,max(usetime) max", (QFilter[])new QFilter[0]);
            if (!vehicleDatas.isEmpty()) {
                min = ((DynamicObject)vehicleDatas.get(0)).getDate("min");
                max = ((DynamicObject)vehicleDatas.get(0)).getDate("max");
            }
            DynamicObjectCollection trainDatas = QueryServiceHelper.query((String)"er_trainbill", (String)"min(departtime) min,max(departtime) max", (QFilter[])new QFilter[0]);
            min = OrderSummaryTask.caclMinDate(trainDatas, min);
            max = OrderSummaryTask.caclMaxDate(trainDatas, max);
            DynamicObjectCollection hotelDatas = QueryServiceHelper.query((String)"er_hotelbill", (String)"min(checkindate) min,max(checkindate) max", (QFilter[])new QFilter[0]);
            min = OrderSummaryTask.caclMinDate(hotelDatas, min);
            max = OrderSummaryTask.caclMaxDate(hotelDatas, max);
            DynamicObjectCollection planeDatas = QueryServiceHelper.query((String)"er_planebill", (String)"min(takeofftime) min,max(takeofftime) max", (QFilter[])new QFilter[0]);
            min = OrderSummaryTask.caclMinDate(planeDatas, min);
            max = OrderSummaryTask.caclMaxDate(planeDatas, max);
            if (!summary.isEmpty() && (tmp = ((DynamicObject)summary.get(0)).getDate("max")) != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(tmp);
                calendar.add(2, -3);
                min = calendar.getTime();
                DeleteServiceHelper.delete((String)"er_city_routes_summary", (QFilter[])new QFilter[]{new QFilter("summaryend", "<=", (Object)max), new QFilter("summarystart", ">=", (Object)min)});
            }
            List<DateRange> dateRanges = OrderSummaryTask.getDateRanges(min, max);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"er_city_routes_summary");
            for (DateRange dateRange : dateRanges) {
                ConcurrentHashMap dataMap = new ConcurrentHashMap(16);
                ConcurrentHashMap cityDataMap = new ConcurrentHashMap(16);
                CountDownLatch count = new CountDownLatch(3);
                ThreadPools.executeOnceIncludeRequestContext((String)"plane_city", () -> {
                    try {
                        String filterKey = "ticketstatus";
                        List<String> filterValue = Arrays.asList("UNUSED", "USED", "CHANGED");
                        QFilter timeFilter = new QFilter("takeofftime", ">=", (Object)dateRange.startTime).and(new QFilter("takeofftime", "<=", (Object)dateRange.endTime));
                        DynamicObjectCollection billData = QueryServiceHelper.query((String)"er_planebill", (String)"totalamount,expcommitcomnum,expcommitdepnum,ticketstatus,sourcetravelerid,fromcityname,tocityname,takeofftime", (QFilter[])new QFilter[]{timeFilter});
                        List<DynamicObject> billList = this.filterData(billData, filterValue, filterKey);
                        this.functionCall(billList, "PLANE", cityDataMap, dataMap);
                    }
                    catch (Exception ex) {
                        logger.error("\u673a\u7968\u57ce\u5e02\u8def\u7ebf\u6c47\u603b\u62a5\u9519", (Throwable)ex);
                    }
                    finally {
                        count.countDown();
                    }
                });
                ThreadPools.executeOnceIncludeRequestContext((String)"hotel_city", () -> {
                    try {
                        QFilter timeFilter = new QFilter("checkindate", ">=", (Object)dateRange.start).and(new QFilter("checkindate", "<=", (Object)dateRange.end));
                        List<String> filterValue = Collections.singletonList("O");
                        String filterKey = "ordertype";
                        DynamicObjectCollection billData = QueryServiceHelper.query((String)"er_hotelbill", (String)"totalamount,expcommitcomnum,expcommitdepnum,sourcetravelerid,ordertype,cityname,checkindate", (QFilter[])new QFilter[]{timeFilter});
                        List<DynamicObject> billList = this.filterData(billData, filterValue, filterKey);
                        this.functionCall(billList, "HOTEL", cityDataMap, dataMap);
                    }
                    catch (Exception ex) {
                        logger.error("\u9152\u5e97\u57ce\u5e02\u8def\u7ebf\u6c47\u603b\u62a5\u9519", (Throwable)ex);
                    }
                    finally {
                        count.countDown();
                    }
                });
                ThreadPools.executeOnceIncludeRequestContext((String)"train_city", () -> {
                    try {
                        QFilter timeFilter = new QFilter("departtime", ">=", (Object)dateRange.start).and(new QFilter("departtime", "<=", (Object)dateRange.end));
                        List<String> filterValue = Arrays.asList("O", "G");
                        String filterKey = "ordertype";
                        DynamicObjectCollection billData = QueryServiceHelper.query((String)"er_trainbill", (String)"totalamount,passeger,expcommitcomnum,expcommitdepnum,ordertype,departtime,arrivecity", (QFilter[])new QFilter[]{timeFilter});
                        List<DynamicObject> billList = this.filterData(billData, filterValue, filterKey);
                        this.functionCall(billList, "TRAIN", cityDataMap, dataMap);
                    }
                    catch (Exception ex) {
                        logger.error("\u706b\u8f66\u57ce\u5e02\u8def\u7ebf\u6c47\u603b\u62a5\u9519", (Throwable)ex);
                    }
                    finally {
                        count.countDown();
                    }
                });
                count.await();
                HashMap<String, Map<String, FourTuple<Set<Long>, BigDecimal, Long, String>>> dbMap = new HashMap<String, Map<String, FourTuple<Set<Long>, BigDecimal, Long, String>>>(4);
                dbMap.put("Route", dataMap);
                dbMap.put("City", cityDataMap);
                OrderSummaryTask.addData(dateRange, dbMap, type);
            }
        }
        catch (Exception e) {
            logger.error("\u70ed\u95e8\u57ce\u5e02\u62a5\u9519:", (Throwable)e);
        }
    }

    private static void addData(DateRange dateRange, Map<String, Map<String, FourTuple<Set<Long>, BigDecimal, Long, String>>> dbMap, MainEntityType type) {
        ArrayList needAdd = Lists.newArrayListWithCapacity((int)16);
        HashMap<String, JSONArray> orgAndCityJson = new HashMap<String, JSONArray>(16);
        for (Map.Entry<String, Map<String, FourTuple<Set<Long>, BigDecimal, Long, String>>> entry : dbMap.entrySet()) {
            String outKey = entry.getKey();
            for (Map.Entry<String, FourTuple<Set<Long>, BigDecimal, Long, String>> tupleEntry : entry.getValue().entrySet()) {
                String[] split;
                JSONObject cityJson = new JSONObject();
                String key = tupleEntry.getKey();
                String orgId = "";
                String cityName = "";
                if (outKey.equalsIgnoreCase("Route") && key.contains("|")) {
                    split = key.split("\\|");
                    String routes = split[1];
                    cityJson.put("routes", (Object)routes);
                    String[] routesArr = routes.split("-");
                    cityName = routesArr[1];
                    orgId = split[0];
                } else {
                    split = key.split("-");
                    cityName = split[1];
                    orgId = split[0];
                }
                FourTuple<Set<Long>, BigDecimal, Long, String> value = tupleEntry.getValue();
                cityJson.put("ordernums", value.item3);
                cityJson.put("cityname", (Object)cityName);
                cityJson.put("summaryamount", value.item2);
                cityJson.put("ordertype", value.item4);
                cityJson.put("traveluser", value.item1);
                String finalOrgId = orgId + "-" + outKey;
                orgAndCityJson.compute(finalOrgId, (k, v) -> {
                    if (v == null) {
                        JSONArray jsonArray = new JSONArray();
                        jsonArray.add((Object)cityJson);
                        return jsonArray;
                    }
                    JSONArray cityArray = (JSONArray)orgAndCityJson.get(finalOrgId);
                    cityArray.add((Object)cityJson);
                    return cityArray;
                });
            }
        }
        for (Map.Entry<String, Map<String, Object>> entry : orgAndCityJson.entrySet()) {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)type);
            String key = entry.getKey();
            String[] split = key.split("-");
            String orgId = split[0];
            String outKey = split[1];
            dynamicObject.set("summarystart", (Object)TripBoardsUtil.converLocalDataToDate(dateRange.start));
            dynamicObject.set("summaryend", (Object)TripBoardsUtil.converLocalDataToDate(dateRange.end));
            dynamicObject.set("orgid", (Object)orgId);
            dynamicObject.set("datatype", (Object)outKey);
            dynamicObject.set("cityjson_tag", (Object)((JSONArray)entry.getValue()).toJSONString());
            needAdd.add(dynamicObject);
        }
        if (CollectionUtils.isNotEmpty((Collection)needAdd)) {
            SaveServiceHelper.save((DynamicObject[])needAdd.toArray(new DynamicObject[0]));
        }
    }

    private List<DynamicObject> filterData(DynamicObjectCollection billData, List<String> filterValue, String filterKey) {
        return billData.parallelStream().filter(obj -> filterValue.contains(obj.getString(filterKey))).collect(Collectors.toList());
    }

    private static Date caclMinDate(DynamicObjectCollection billData, Date min) {
        Date newMin;
        if (!billData.isEmpty() && (newMin = ((DynamicObject)billData.get(0)).getDate("min")).before(min)) {
            min = newMin;
        }
        return min;
    }

    private static Date caclMaxDate(DynamicObjectCollection billData, Date max) {
        Date newMax;
        if (!billData.isEmpty() && (newMax = ((DynamicObject)billData.get(0)).getDate("max")).after(max)) {
            max = newMax;
        }
        return max;
    }

    private void functionCall(List<DynamicObject> billData, String orderType, Map<String, FourTuple<Set<Long>, BigDecimal, Long, String>> cityDataMap, Map<String, FourTuple<Set<Long>, BigDecimal, Long, String>> dataMap) {
        if (!billData.isEmpty()) {
            Map<Long, List<DynamicObject>> comGroup = billData.parallelStream().collect(Collectors.groupingBy(obj -> obj.getLong("expcommitcomnum")));
            Map<Long, List<DynamicObject>> depGroup = billData.parallelStream().collect(Collectors.groupingBy(obj -> obj.getLong("expcommitdepnum")));
            this.popularCityDataCount(comGroup, orderType, cityDataMap, dataMap);
            this.popularCityDataCount(depGroup, orderType, cityDataMap, dataMap);
        }
    }

    private void popularCityDataCount(Map<Long, List<DynamicObject>> groupData, String orderType, Map<String, FourTuple<Set<Long>, BigDecimal, Long, String>> cityDataMap, Map<String, FourTuple<Set<Long>, BigDecimal, Long, String>> dataMap) {
        String travelKey;
        String string = travelKey = orderType.equals("TRAIN") ? "passeger" : "sourcetravelerid";
        String cityKey = orderType.equals("HOTEL") ? "cityname" : (orderType.equals("PLANE") ? "tocityname" : "arrivecity");
        if ("PLANE".equals(orderType)) {
            groupData.entrySet().parallelStream().forEach(entry -> {
                Long orgId = (Long)entry.getKey();
                List group = (List)entry.getValue();
                Map routeMap = group.parallelStream().filter(obj -> StringUtils.isNotBlank((String)obj.getString("fromcityname")) && StringUtils.isNotBlank((String)obj.getString(cityKey))).collect(Collectors.groupingByConcurrent(obj -> obj.getString("fromcityname") + "-" + obj.getString(cityKey)));
                routeMap.entrySet().parallelStream().forEach(routeEntry -> {
                    String key = orgId + "|" + (String)routeEntry.getKey();
                    List route = (List)routeEntry.getValue();
                    long userCount = route.parallelStream().map(obj -> obj.get(travelKey)).filter(Objects::nonNull).map(Object::toString).distinct().count();
                    Set travelUserIdSet = route.stream().map(obj -> obj.getLong(travelKey)).collect(Collectors.toSet());
                    long orderNums = route.size();
                    double totalAmount = route.parallelStream().map(obj -> obj.getBigDecimal("totalamount")).filter(Objects::nonNull).filter(amount -> amount.compareTo(ConvertUtil.getOrderAmountInit()) != 0).mapToDouble(BigDecimal::doubleValue).sum();
                    if (dataMap.containsKey(key)) {
                        FourTuple v = (FourTuple)dataMap.get(key);
                        Set item1 = (Set)v.item1;
                        item1.addAll(travelUserIdSet);
                        BigDecimal resultAmount = ((BigDecimal)v.item2).add(BigDecimal.valueOf(totalAmount));
                        Long resultOrderCount = (Long)v.item3 + orderNums;
                        dataMap.put(key, new FourTuple((Object)item1, (Object)resultAmount, (Object)resultOrderCount, (Object)orderType));
                    } else {
                        dataMap.put(key, new FourTuple(travelUserIdSet, (Object)BigDecimal.valueOf(totalAmount), (Object)orderNums, (Object)orderType));
                    }
                });
            });
        }
        groupData.entrySet().parallelStream().forEach(entry -> {
            Long orgId = (Long)entry.getKey();
            List group = (List)entry.getValue();
            Map cityGroup = group.stream().filter(obj -> StringUtils.isNotBlank((String)obj.getString(cityKey))).collect(Collectors.groupingByConcurrent(obj -> obj.getString(cityKey)));
            cityGroup.entrySet().forEach(cityEntry -> {
                String cityName = (String)cityEntry.getKey();
                String key = orgId + "-" + cityName;
                List cityMapValue = (List)cityEntry.getValue();
                Set travelUserIdSet = cityMapValue.stream().map(obj -> obj.getLong(travelKey)).collect(Collectors.toSet());
                long orderNums = cityMapValue.size();
                double totalAmount = cityMapValue.stream().map(obj -> obj.getBigDecimal("totalamount")).filter(Objects::nonNull).filter(amount -> amount.compareTo(ConvertUtil.getOrderAmountInit()) != 0).mapToDouble(BigDecimal::doubleValue).sum();
                if (cityDataMap.containsKey(key)) {
                    FourTuple v = (FourTuple)cityDataMap.get(key);
                    Set item1 = (Set)v.item1;
                    item1.addAll(travelUserIdSet);
                    BigDecimal resultAmount = ((BigDecimal)v.item2).add(BigDecimal.valueOf(totalAmount));
                    Long resultOrderCount = (Long)v.item3 + orderNums;
                    cityDataMap.put(key, new FourTuple((Object)item1, (Object)resultAmount, (Object)resultOrderCount, (Object)orderType));
                } else {
                    cityDataMap.put(key, new FourTuple(travelUserIdSet, (Object)BigDecimal.valueOf(totalAmount), (Object)orderNums, (Object)orderType));
                }
            });
        });
    }

    public static List<DateRange> getDateRanges(Date min, Date max) {
        LocalDate endDate;
        LocalDate startDate = TripBoardsUtil.convertDateToLocalDate(min);
        List<DateRange> dateRanges = OrderSummaryTask.getMonthlyDateRanges(startDate, endDate = TripBoardsUtil.convertDateToLocalDate(max));
        if (!dateRanges.isEmpty()) {
            dateRanges.remove(dateRanges.size() - 1);
        }
        return dateRanges;
    }

    public static List<DateRange> getMonthlyDateRanges(LocalDate startDate, LocalDate endDate) {
        ArrayList dateRanges = Lists.newArrayListWithCapacity((int)16);
        LocalDate firstStart = startDate;
        LocalDate firstEnd = startDate.withDayOfMonth(startDate.lengthOfMonth());
        dateRanges.add(new DateRange(firstStart, firstEnd, firstStart.atTime(LocalTime.MIN), firstEnd.atTime(LocalTime.MAX)));
        LocalDate currentStart = firstEnd.plusDays(1L);
        while (currentStart.isBefore(endDate.withDayOfMonth(1))) {
            LocalDate currentEnd = currentStart.withDayOfMonth(currentStart.lengthOfMonth());
            dateRanges.add(new DateRange(currentStart, currentEnd, currentStart.atTime(LocalTime.MIN), currentEnd.atTime(LocalTime.MAX)));
            currentStart = currentEnd.plusDays(1L);
        }
        dateRanges.add(new DateRange(currentStart, endDate, currentStart.atTime(LocalTime.MIN), endDate.atTime(LocalTime.MAX)));
        return dateRanges;
    }

    public static class DateRange {
        LocalDate start;
        LocalDate end;
        LocalDateTime startTime;
        LocalDateTime endTime;

        public DateRange(LocalDate start, LocalDate end, LocalDateTime startTime, LocalDateTime endTime) {
            this.start = start;
            this.end = end;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public LocalDate getStart() {
            return this.start;
        }

        public void setStart(LocalDate start) {
            this.start = start;
        }

        public LocalDate getEnd() {
            return this.end;
        }

        public void setEnd(LocalDate end) {
            this.end = end;
        }

        public LocalDateTime getStartTime() {
            return this.startTime;
        }

        public void setStartTime(LocalDateTime startTime) {
            this.startTime = startTime;
        }

        public LocalDateTime getEndTime() {
            return this.endTime;
        }

        public void setEndTime(LocalDateTime endTime) {
            this.endTime = endTime;
        }
    }
}

