/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.task.tripboards;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.task.tripboards.OrderSummaryTask;
import kd.fi.er.formplugin.web.tripboards.tripindex.financeindex.VehicleDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class VehicleSummary {
    private static final Log logger = LogFactory.getLog(VehicleSummary.class);

    public void vehicleSummary() {
        try {
            Date tmp;
            DynamicObjectCollection summary = QueryServiceHelper.query((String)"er_vehicle_summary", (String)"max(summaryend) max", (QFilter[])new QFilter[0]);
            Date min = new Date();
            Date max = new Date();
            DynamicObjectCollection vehicleDatas = QueryServiceHelper.query((String)"er_vehiclebill", (String)"min(usetime) min,max(usetime) max", (QFilter[])new QFilter[0]);
            if (!vehicleDatas.isEmpty()) {
                min = ((DynamicObject)vehicleDatas.get(0)).getDate("min");
                max = ((DynamicObject)vehicleDatas.get(0)).getDate("max");
            }
            if (!summary.isEmpty() && (tmp = ((DynamicObject)summary.get(0)).getDate("max")) != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(tmp);
                calendar.add(2, -3);
                min = calendar.getTime();
                DeleteServiceHelper.delete((String)"er_vehicle_summary", (QFilter[])new QFilter[]{new QFilter("summaryend", "<=", (Object)max), new QFilter("summarystart", ">=", (Object)min)});
            }
            List<OrderSummaryTask.DateRange> dateRanges = OrderSummaryTask.getDateRanges(min, max);
            VehicleDataProcessHandle dataProcessHandle = new VehicleDataProcessHandle();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"er_vehicle_summary");
            for (OrderSummaryTask.DateRange dateRange : dateRanges) {
                QFilter timeFilter = new QFilter("usetime", ">=", (Object)dateRange.startTime).and(new QFilter("usetime", "<=", (Object)dateRange.endTime));
                DynamicObjectCollection vehicleBillDatas = QueryServiceHelper.query((String)"er_vehiclebill", (String)"totalamount,servicefee,expcommitcomnum,expcommitdepnum,passeger,vehicletype,orderstatus,distance,usetime,id", (QFilter[])new QFilter[]{timeFilter});
                if (vehicleBillDatas.isEmpty()) continue;
                Map<Long, List<DynamicObject>> comGroup = vehicleBillDatas.parallelStream().collect(Collectors.groupingBy(obj -> obj.getLong("expcommitcomnum")));
                Map<Long, List<DynamicObject>> depGroup = vehicleBillDatas.parallelStream().collect(Collectors.groupingBy(obj -> obj.getLong("expcommitdepnum")));
                this.vehicleDataCount(dateRange, comGroup, dataProcessHandle, type, "company");
                this.vehicleDataCount(dateRange, depGroup, dataProcessHandle, type, "dept");
            }
        }
        catch (Exception ex) {
            logger.error("vehicleSummary \u62a5\u9519", (Throwable)ex);
        }
    }

    private void vehicleDataCount(OrderSummaryTask.DateRange dateRange, Map<Long, List<DynamicObject>> groupData, VehicleDataProcessHandle dataProcessHandle, MainEntityType type, String orgType) {
        ArrayList needAdd = Lists.newArrayListWithCapacity((int)16);
        groupData.entrySet().parallelStream().forEach(entry -> {
            Long orgId = (Long)entry.getKey();
            List group = (List)entry.getValue();
            try {
                Map<Long, List<DynamicObject>> vehicleGroup = group.parallelStream().collect(Collectors.groupingBy(obj -> obj.getLong("vehicletype")));
                vehicleGroup.entrySet().parallelStream().forEach(vehicleTypeEntry -> {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
                    List value = (List)vehicleTypeEntry.getValue();
                    dataProcessHandle.dataDeal(resultMap, value, Boolean.FALSE);
                    Set travelUserIdSet = value.parallelStream().filter(obj -> obj.get("passeger") != null).map(obj -> obj.getLong("passeger")).collect(Collectors.toSet());
                    DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)type);
                    dynamicObject.set("orgtype", (Object)orgType);
                    Object avgMilePrice = resultMap.getOrDefault("v_avmile_price", BigDecimal.ZERO);
                    dynamicObject.set("summaryavmileprice", avgMilePrice == null ? BigDecimal.ZERO : ("-".equals(avgMilePrice.toString()) ? BigDecimal.ZERO : avgMilePrice));
                    dynamicObject.set("summaryamount", (Object)TripBoardsUtil.getTotalamount(value));
                    dynamicObject.set("ordernums", resultMap.get("v_order_nums") == null ? Integer.valueOf(0) : resultMap.get("v_order_nums"));
                    dynamicObject.set("summaryactivepeople", resultMap.getOrDefault("v_active_people", BigDecimal.ZERO) == null ? BigDecimal.ZERO : resultMap.getOrDefault("v_active_people", BigDecimal.ZERO));
                    dynamicObject.set("orgid", (Object)orgId);
                    dynamicObject.set("summarystart", (Object)TripBoardsUtil.converLocalDataToDate(dateRange.start));
                    dynamicObject.set("summaryend", (Object)TripBoardsUtil.converLocalDataToDate(dateRange.end));
                    dynamicObject.set("vehicletype", vehicleTypeEntry.getKey());
                    List collect = travelUserIdSet.stream().map(String::valueOf).collect(Collectors.toList());
                    dynamicObject.set("traveluser_tag", (Object)String.join((CharSequence)",", collect));
                    JSONObject dataJson = new JSONObject();
                    JSONArray orderNums = new JSONArray();
                    for (DynamicObject order : value) {
                        long id = order.getLong("id");
                        BigDecimal totalamount = order.getBigDecimal("totalamount");
                        totalamount = totalamount == null ? BigDecimal.ZERO : totalamount;
                        orderNums.add((Object)(id + "$" + totalamount));
                    }
                    dataJson.put("orderNumsAndAmount", (Object)orderNums);
                    dynamicObject.set("otherdatasummary_tag", (Object)dataJson);
                    List list = needAdd;
                    synchronized (list) {
                        needAdd.add(dynamicObject);
                    }
                });
            }
            catch (Exception ex) {
                logger.error("vehicle\u62a5\u9519", (Throwable)ex);
            }
        });
        if (!needAdd.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])needAdd.toArray(new DynamicObject[0]));
        }
    }
}

