/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.er.business.dao.impl.ErOrm;
import kd.fi.er.business.fileservice.ErFileServiceHelper;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.annotation.KDTripField;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.business.trip.model.FlightItineraryImageAndTrainImageModel;
import kd.fi.er.business.trip.model.TTripCheckingBillImageModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TravelNoOneSync;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.RSAUtils;

public class TripCheckingInvoiceImageInfoUtil<T> {
    private static Log logger = LogFactory.getLog(TripCheckingInvoiceImageInfoUtil.class);
    private static final String suffixes = "jpeg|jpg|png|pdf|gif|ofd";
    public static final Integer EXPECT_SIZE = 10;
    private static final String ABSTRACTCHECKINGBILLIMAGEINVOKE = "AbstractCheckingBillImageInvoke";
    public static String SELECT_FIELDS = "billno,server,billnum,settlemain,isreconciliation,iscreatevoucher,operationtype,billstatusname,currency,settlementamount,periodstartdate,periodenddate,invoiceentry.invoicetype,invoiceentry.invoicecode,invoiceentry.invoiceno,invoiceentry.flightitineraryandtrain,invoiceentry.totalamount,invoiceentry.taxamount_invoice,invoiceentry.checkingbillno,invoiceentry.passengername,invoiceentry.invoicefromcity,invoiceentry.invoicetocity,invoiceentry.buyerorgname,invoiceentry.makeoutcompname,invoiceentry.downloadurl,invoiceentry.innerdownloadurl";

    public static String getMonthOfDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, -1);
        cal.set(5, cal.getActualMinimum(5));
        return format.format(cal.getTime());
    }

    public static String dealBillNum(String billnum) {
        if (billnum.contains("-")) {
            billnum = billnum.substring(0, billnum.indexOf("-"));
        }
        return billnum;
    }

    public static void dealFieldValue(Field[] declaredFields, Object model, DynamicObject dynamicObject) {
        Stream.of(declaredFields).forEach(field -> {
            try {
                KDTripField annotation = field.getAnnotation(KDTripField.class);
                if (annotation == null) {
                    return;
                }
                String fieldName = annotation.alias();
                String trueFieldName = annotation.name();
                boolean ignore = annotation.ignore();
                Object value = TripCheckingInvoiceImageInfoUtil.getFiledValue(field, model);
                if (StringUtils.isNotEmpty((String)trueFieldName)) {
                    if (!ignore && value != null) {
                        dynamicObject.set(trueFieldName, value);
                    }
                } else if (StringUtils.isNotEmpty((String)fieldName) && !ignore && value != null) {
                    dynamicObject.set(fieldName, value);
                }
            }
            catch (Exception e) {
                logger.error("TripCheckingInvoiceImageInfoUtil dealFieldValue error", (Throwable)e);
            }
        });
    }

    public static String convertInnerDownLoadLink(String decryptImageAddress, String modelSuffixes, String server, String orderNum) {
        String tempSuffixes = suffixes;
        if (StringUtils.isNotEmpty((String)modelSuffixes)) {
            tempSuffixes = modelSuffixes;
        }
        String type = "pdf";
        Pattern pat = Pattern.compile("[\\w]+[\\.](" + tempSuffixes + ")");
        Matcher mc = pat.matcher(decryptImageAddress);
        while (mc.find()) {
            String name = mc.group();
            logger.info("TripCheckingInvoiceImageInfoUtil>>> matchname{}", (Object)name);
            type = name.substring(name.lastIndexOf(".") + 1);
        }
        return ErFileServiceHelper.uploadFile(decryptImageAddress, server + "_" + orderNum + "." + type, "/travelnoone/checkinginvoices/");
    }

    public static HashSet<List<String>> getReqDataSet(List<String> billNums) {
        HashSet set = Sets.newHashSetWithExpectedSize((int)16);
        int tmpExpectSize = EXPECT_SIZE;
        if (billNums.size() > tmpExpectSize) {
            List lists = Lists.partition(billNums, (int)tmpExpectSize);
            set.addAll(lists);
        } else {
            set.addAll(Collections.singleton(billNums));
        }
        return set;
    }

    public static HashSet<JSONObject> getTripResponseData(List<String> planeBillNums, String url, String key) {
        ErCommonUtils.removeKeyFromAppCache(ABSTRACTCHECKINGBILLIMAGEINVOKE);
        HashSet<List<String>> reqDataSet = TripCheckingInvoiceImageInfoUtil.getReqDataSet(planeBillNums);
        Iterator<List<String>> iterator = reqDataSet.iterator();
        ArrayList logLists = Lists.newArrayListWithCapacity((int)reqDataSet.size());
        HashSet resultSet = Sets.newHashSetWithExpectedSize((int)reqDataSet.size());
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("tokenId", TravelNoOneSync.getCacheToken(ABSTRACTCHECKINGBILLIMAGEINVOKE));
        while (iterator.hasNext()) {
            int pageIndex = 1;
            List<String> reqData = iterator.next();
            TripCheckingInvoiceImageInfoUtil.sendRequest(reqData, url, logLists, resultSet, headMap, pageIndex);
        }
        logger.info("\u673a\u7968\u884c\u7a0b\u5355\u4fe1\u606f,\u9700\u8981\u6dfb\u52a0\u7684\u6570\u636e\u957f\u5ea6:{}", (Object)resultSet.size());
        TripSyncLogUtils.saveErrorLog(logLists);
        return resultSet;
    }

    private static void sendRequest(List<String> reqData, String url, List<TripSyncLogParam> logLists, HashSet<JSONObject> resultSet, Map<String, String> headMap, int pageIndex) {
        TripSyncLogParam tripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), Supplier.CHAILVYIHAO.name(), "imageInvoke");
        logLists.add(tripSyncLogParam);
        tripSyncLogParam.setRequesturl(url);
        String reqJson = TripCheckingInvoiceImageInfoUtil.buildRequestParams(reqData, pageIndex);
        tripSyncLogParam.setRequestdata(reqJson);
        JSONObject jsonObject = HttpServiceHelper.doPost(url, headMap, reqJson, JSONObject.class, "application/json");
        tripSyncLogParam.setResponsedata(jsonObject);
        logger.info("\u5546\u65c5\u96c6\u6210,\u6839\u636e\u7f16\u53f7\u83b7\u53d6\u83b7\u53d6\u98de\u673a\u884c\u7a0b\u5355/\u706b\u8f66\u7968\u6839\u5f71\u50cf\u4fe1\u606f");
        if (jsonObject == null || !jsonObject.getString("errcode").equals("0")) {
            tripSyncLogParam.setStatus("B");
            logger.info("\u5546\u65c5\u96c6\u6210,\u6839\u636e\u7f16\u53f7\u83b7\u53d6\u83b7\u53d6\u98de\u673a\u884c\u7a0b\u5355/\u706b\u8f66\u7968\u6839\u5f71\u50cf\u4fe1\u606f,continue");
            return;
        }
        tripSyncLogParam.setStatus("A");
        resultSet.add(jsonObject);
        boolean hasNextPage = TripCheckingInvoiceImageInfoUtil.judgeHasNextPage(jsonObject);
        if (jsonObject.get((Object)"hasNextPage") != null && jsonObject.getBoolean("hasNextPage").booleanValue() || hasNextPage) {
            TripCheckingInvoiceImageInfoUtil.sendRequest(reqData, url, logLists, resultSet, headMap, ++pageIndex);
        }
    }

    private static boolean judgeHasNextPage(JSONObject jsonObject) {
        logger.info("\u5224\u65ad\u662f\u5426\u9700\u8981\u7ee7\u7eed\u8bfb\u53d6\u4e0b\u4e00\u9875");
        JSONObject data = jsonObject.getJSONObject("data");
        if (data != null) {
            JSONArray travelInfo = data.getJSONArray("travelInfo");
            if (travelInfo == null) {
                return false;
            }
            int size = travelInfo.size();
            logger.info("\u8fd4\u56de\u6570\u636e\u96c6\u5408size{}", (Object)size);
            return size == 500;
        }
        return false;
    }

    private static String buildRequestParams(List<String> billNos, int pageIndex) {
        JSONArray dataInfo = new JSONArray();
        dataInfo.addAll(billNos);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dataInfo", (Object)dataInfo);
        jsonObject.put("condition", (Object)"BusinessBillNo");
        jsonObject.put("pageSize", (Object)500);
        jsonObject.put("pageIndex", (Object)pageIndex);
        String reqJson = SerializationUtils.toJsonString((Object)jsonObject);
        logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u83b7\u53d6\u5f71\u50cf\u4fe1\u606f\uff0c\u4e0a\u9001\u6570\u636epostdata: " + reqJson);
        return reqJson;
    }

    public static List<FlightItineraryImageAndTrainImageModel> dealJSON(JSONObject jsonObject, String key) {
        JSONObject data = jsonObject.getJSONObject("data");
        JSONArray travelInfo = data.getJSONArray(key);
        if (travelInfo != null) {
            ArrayList models = Lists.newArrayListWithCapacity((int)16);
            int size = travelInfo.size();
            for (int i = 0; i < size; ++i) {
                models.add(JSON.toJavaObject((JSON)travelInfo.getJSONObject(i), FlightItineraryImageAndTrainImageModel.class));
            }
            logger.info("convert java obj size{}", (Object)models.size());
            return models;
        }
        return Lists.newArrayList();
    }

    public static List<TTripCheckingBillImageModel> dealInvoiceJSON(JSONObject jsonObject, String key) {
        JSONObject data = jsonObject.getJSONObject("data");
        JSONArray info = data.getJSONArray(key);
        if (info != null) {
            ArrayList models = Lists.newArrayListWithCapacity((int)16);
            int size = info.size();
            for (int i = 0; i < size; ++i) {
                models.add(JSON.toJavaObject((JSON)info.getJSONObject(i), TTripCheckingBillImageModel.class));
            }
            logger.info("TTripCheckingBillImageModel convert java obj size{}", (Object)models.size());
            return models;
        }
        return Lists.newArrayList();
    }

    public static List<DynamicObject> innerHandleFieldValue(List<FlightItineraryImageAndTrainImageModel> models, ErOrm erDao) throws ParseException {
        String selectFields = SELECT_FIELDS;
        Class<FlightItineraryImageAndTrainImageModel> clazz = FlightItineraryImageAndTrainImageModel.class;
        Field[] declaredFields = clazz.getDeclaredFields();
        Map<String, List<FlightItineraryImageAndTrainImageModel>> billNoMap = models.stream().filter(model -> StringUtils.isNotEmpty((String)model.getBillNo())).collect(Collectors.groupingBy(model -> model.getBillNo() + "-" + model.getProductType()));
        Set<String> billNos = billNoMap.keySet();
        DynamicObject[] checkingBills = erDao.query(selectFields, new QFilter[]{new QFilter("billnum", "in", billNos)});
        Map<String, List<DynamicObject>> checkingBillMap = Arrays.stream(checkingBills).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("billnum")));
        Set<Map.Entry<String, List<FlightItineraryImageAndTrainImageModel>>> entries = billNoMap.entrySet();
        ArrayList resultList = Lists.newArrayListWithCapacity((int)models.size());
        TripCheckingInvoiceImageInfoUtil.finalDeal(declaredFields, checkingBillMap, entries, resultList);
        logger.info("need save datas size{}", (Object)resultList.size());
        return resultList;
    }

    private static void finalDeal(Field[] declaredFields, Map<String, List<DynamicObject>> checkingBillMap, Set<Map.Entry<String, List<FlightItineraryImageAndTrainImageModel>>> entries, List<DynamicObject> resultList) throws ParseException {
        String supplier = Supplier.CHAILVYIHAO.name();
        long startTime = System.currentTimeMillis();
        for (Map.Entry<String, List<FlightItineraryImageAndTrainImageModel>> entry : entries) {
            DynamicObject dynamicObject;
            String billNo = entry.getKey();
            List<DynamicObject> checkingBill = checkingBillMap.get(billNo);
            if (CollectionUtils.isEmpty(checkingBill) || (dynamicObject = checkingBill.get(0)) == null) continue;
            List<FlightItineraryImageAndTrainImageModel> tmpModels = entry.getValue();
            HashSet sets = Sets.newHashSet(tmpModels);
            Iterator iterator = sets.iterator();
            DynamicObjectCollection invoiceentry = dynamicObject.getDynamicObjectCollection("invoiceentry");
            long whileStartTime = System.currentTimeMillis();
            ArrayList models = Lists.newArrayListWithCapacity((int)16);
            while (iterator.hasNext()) {
                DynamicObject newEntry = invoiceentry.addNew();
                FlightItineraryImageAndTrainImageModel model = (FlightItineraryImageAndTrainImageModel)iterator.next();
                models.add(model);
                long dealFieldValueStartTime = System.currentTimeMillis();
                TripCheckingInvoiceImageInfoUtil.dealFieldValue(declaredFields, model, newEntry);
                long dealFieldValueEndTime = System.currentTimeMillis();
                logger.info("dealFieldValue usedtime{}", (Object)(dealFieldValueEndTime - dealFieldValueStartTime));
                newEntry.set("checkingbillno", (Object)(model.getOrderId() + "-" + model.getPassengerOutStaffNo()));
                model.setServer(supplier);
                Integer imageType = model.getImageType();
                if (imageType == 3) {
                    newEntry.set("invoicetype", (Object)10);
                    newEntry.set("totalamount", (Object)model.getTicketTotalPrice());
                } else if (imageType == 6) {
                    newEntry.set("invoicetype", (Object)9);
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                    if (model.getTravelTime() == null) {
                        model.setTravelTime(new Date());
                    }
                    String invoicecode = format.format(model.getTravelTime());
                    newEntry.set("invoicecode", (Object)invoicecode);
                    newEntry.set("invoiceno", (Object)model.getRealOrderId());
                }
                newEntry.set("flightitineraryandtrain", (Object)1);
            }
            TripCheckingInvoiceImageInfoUtil.dealDownLoadUrl(models, invoiceentry);
            long whileEndTime = System.currentTimeMillis();
            logger.info("\u5f53\u524dcheckingbillno{},while usedtime{}", (Object)billNo, (Object)(whileEndTime - whileStartTime));
            resultList.add(dynamicObject);
        }
        long endTime = System.currentTimeMillis();
        logger.info("finalDeal usedtime{}", (Object)(endTime - startTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dealDownLoadUrl(List<FlightItineraryImageAndTrainImageModel> models, DynamicObjectCollection invoiceEntry) {
        if (CollectionUtils.isEmpty(models)) {
            return;
        }
        final Map<String, List<DynamicObject>> invoiceEntryMap = invoiceEntry.stream().filter(dynamicObject -> StringUtils.isNotEmpty((String)dynamicObject.getString("checkingbillno"))).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("checkingbillno")));
        final List partition = Lists.partition(models, (int)10);
        int size = partition.size();
        final CountDownLatch countDownLatch = new CountDownLatch(size);
        int i = 0;
        while (i < size) {
            final int finalI = i++;
            ThreadService.execute((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        List tmpModels = (List)partition.get(finalI);
                        for (FlightItineraryImageAndTrainImageModel tmpModel : tmpModels) {
                            String checkingBillNo = tmpModel.getOrderId() + "-" + tmpModel.getPassengerOutStaffNo();
                            List dynamicObjects = (List)invoiceEntryMap.get(checkingBillNo);
                            DynamicObject newEntry = (DynamicObject)dynamicObjects.get(0);
                            long decryptStartTime = System.currentTimeMillis();
                            String decryptImageAddress = RSAUtils.decrypt(tmpModel.getImageAddress());
                            long decryptEndTime = System.currentTimeMillis();
                            logger.info("decrypt usedtime{}", (Object)(decryptEndTime - decryptStartTime));
                            tmpModel.setImageAddress(decryptImageAddress);
                            long convertDownLinkStartTime = System.currentTimeMillis();
                            String innerUrl = TripCheckingInvoiceImageInfoUtil.convertInnerDownLoadLink(decryptImageAddress, tmpModel.getImageSuffixes(), tmpModel.getServer(), tmpModel.getOrderId());
                            newEntry.set("innerdownloadurl", (Object)innerUrl);
                            long convertDownLinkEndTime = System.currentTimeMillis();
                            logger.info("convertInnerDownLoadLink usedtime{}", (Object)(convertDownLinkEndTime - convertDownLinkStartTime));
                            newEntry.set("downloadurl", (Object)decryptImageAddress);
                            logger.info("sub thread downloadUrl{}", (Object)innerUrl);
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u7ebf\u7a0b\u6267\u884c\u5f02\u5e38", (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            }, (TaskType)TaskType.ER_LOWFREQUENCYTASK_TASK, (RequestContext)RequestContext.get());
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            logger.error("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", (Throwable)e);
        }
    }

    public static void deleteOldData(Map<String, Set<String>> billNoAndInvoiceNosMap, Map<String, Long> checkingBillMap) {
        Set<Map.Entry<String, Set<String>>> entries = billNoAndInvoiceNosMap.entrySet();
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        for (Map.Entry<String, Set<String>> entry : entries) {
            String key = entry.getKey();
            Long id = checkingBillMap.getOrDefault(key, 0L);
            Set<String> invoiceNos = entry.getValue();
            Iterator<String> iterator = invoiceNos.iterator();
            while (iterator.hasNext()) {
                Object[] objects = new Object[]{iterator.next(), id};
                paramList.add(objects);
            }
        }
        if (CollectionUtils.isEmpty((Collection)paramList)) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"delete from t_er_checkinginvoice where finvoiceno = ? and fid= ? ", (List)paramList);
    }

    public static void delData(List<FlightItineraryImageAndTrainImageModel> models, String productType) {
        Map<String, List<FlightItineraryImageAndTrainImageModel>> collect = models.stream().collect(Collectors.groupingBy(FlightItineraryImageAndTrainImageModel::getBillNo));
        Set<Map.Entry<String, List<FlightItineraryImageAndTrainImageModel>>> entries = collect.entrySet();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, List<FlightItineraryImageAndTrainImageModel>> entry : entries) {
            String key = entry.getKey();
            List<FlightItineraryImageAndTrainImageModel> value = entry.getValue();
            if (CollectionUtils.isEmpty(value)) continue;
            Set<Object> invoiceNos = Sets.newHashSetWithExpectedSize((int)16);
            if ("train".equals(productType)) {
                invoiceNos = value.stream().map(FlightItineraryImageAndTrainImageModel::getRealOrderId).collect(Collectors.toSet());
            } else if ("plane".equals(productType)) {
                invoiceNos = value.stream().map(FlightItineraryImageAndTrainImageModel::getOtherNo).collect(Collectors.toSet());
            }
            paramMap.put(key, invoiceNos);
        }
        Set billNos = models.stream().map(model -> model.getBillNo() + "-" + model.getProductType()).collect(Collectors.toSet());
        DynamicObjectCollection checkingBills = QueryServiceHelper.query((String)"er_checkingbill", (String)"id,billnum", (QFilter[])new QFilter[]{new QFilter("billnum", "in", billNos)});
        Map<String, Long> checkingBillMap = checkingBills.stream().collect(Collectors.toMap(dynamicObject -> TripCheckingInvoiceImageInfoUtil.dealBillNum(dynamicObject.getString("billnum")), dynamicObject -> dynamicObject.getLong("id")));
        TripCheckingInvoiceImageInfoUtil.deleteOldData(paramMap, checkingBillMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getFiledValue(Field field, Object obj) throws IllegalAccessException {
        boolean access = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(obj);
            return object;
        }
        finally {
            field.setAccessible(access);
        }
    }
}

