/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.util;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.model.DailyVehicleBillModel;
import kd.fi.er.business.trip.model.TripReqbillModel;
import kd.fi.er.business.trip.model.TripSyncDataMappingModel;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import org.apache.commons.lang3.StringUtils;

public class TripSyncDataMappingUtil {
    private static Log logger = LogFactory.getLog(TripSyncDataMappingUtil.class);
    public static final String ORG = "bos_org";
    public static final String USER = "bos_user";
    public static final String TRIPREQ = "er_tripreq";
    public static final String DAILYVEHICLE = "er_dailyvehicle";

    public static void saveTripSyncDataMapping(List<TripSyncDataMappingModel> dataMappingList) {
        if (dataMappingList == null || dataMappingList.size() < 1) {
            return;
        }
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)"er_tripsync_datamapping");
        TripSyncDataMappingModel model = dataMappingList.get(0);
        HashMap<Object, Object> mappingData = Maps.newHashMapWithExpectedSize((int)16);
        if (model.getInnerdataid() != null) {
            mappingData = TripSyncDataMappingUtil.getIdDataMappingMap(model.getServer(), model.getDatatype());
        }
        if (model.getNumber() != null) {
            mappingData = TripSyncDataMappingUtil.getNumDataMappingMap(model.getServer(), model.getDatatype());
        }
        HashMap<Object, Object> idMappingData = TripSyncDataMappingUtil.getMappingDataId(model.getServer(), model.getDatatype());
        LinkedList dynamicObjects = new LinkedList();
        HashMap<Object, Object> finalMappingData = mappingData;
        dataMappingList.stream().forEach(arg_0 -> TripSyncDataMappingUtil.lambda$saveTripSyncDataMapping$0((DynamicObjectType)billType, finalMappingData, idMappingData, dynamicObjects, arg_0));
        if (dynamicObjects.size() > 0) {
            LinkedList updateDynamicObjects = new LinkedList();
            LinkedList newAddDynamicObjects = new LinkedList();
            logger.info("Line 57 \u5f85\u65b0\u589e\u6570\u636e" + dynamicObjects);
            dynamicObjects.forEach(dynamicObject -> {
                if (dynamicObject.get("innerdataid") != null && dynamicObject.getLong("innerdataid") != 0L && finalMappingData.containsKey(dynamicObject.get("innerdataid"))) {
                    updateDynamicObjects.add(dynamicObject);
                }
                if (dynamicObject.get("number") != null && StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("number")) && finalMappingData.containsKey(dynamicObject.get("number"))) {
                    updateDynamicObjects.add(dynamicObject);
                }
                if (dynamicObject.get("innerdataid") != null && dynamicObject.getLong("innerdataid") != 0L && !finalMappingData.containsKey(dynamicObject.get("innerdataid"))) {
                    newAddDynamicObjects.add(dynamicObject);
                }
                if (dynamicObject.get("number") != null && StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("number")) && !finalMappingData.containsKey(dynamicObject.get("number"))) {
                    newAddDynamicObjects.add(dynamicObject);
                }
            });
            SaveServiceHelper.save((DynamicObject[])newAddDynamicObjects.toArray(new DynamicObject[newAddDynamicObjects.size()]));
            SaveServiceHelper.update((DynamicObject[])updateDynamicObjects.toArray(new DynamicObject[updateDynamicObjects.size()]));
        }
    }

    public static void saveTripSyncDataMappingByInnerId(List<TripSyncDataMappingModel> dataMappingList) {
        if (dataMappingList == null || dataMappingList.size() < 1) {
            return;
        }
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)"er_tripsync_datamapping");
        HashSet idSet = new HashSet();
        dataMappingList.stream().forEach(v -> idSet.add(v.getInnerdataid()));
        QFilter filter = new QFilter("innerdataid", "in", idSet);
        filter.and(new QFilter("datatype", "=", (Object)dataMappingList.get(0).getDatatype()));
        filter.and(new QFilter("server", "=", (Object)dataMappingList.get(0).getServer()));
        DynamicObjectCollection existDataMapping = QueryServiceHelper.query((String)"er_tripsync_datamapping", (String)"id,innerdataid", (QFilter[])new QFilter[]{filter});
        HashMap existDataIdMap = new HashMap();
        existDataMapping.stream().forEach(v -> existDataIdMap.put(v.getLong("innerdataid"), v.getLong("id")));
        ArrayList<DynamicObject> newAddDynamicObjects = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateDynamicObjects = new ArrayList<DynamicObject>();
        for (TripSyncDataMappingModel dataMapping : dataMappingList) {
            Long innerDataId = dataMapping.getInnerdataid();
            DynamicObject newData = new DynamicObject((DynamicObjectType)billType);
            newData.set("server", (Object)dataMapping.getServer());
            newData.set("datatype", (Object)dataMapping.getDatatype());
            newData.set("innerdataid", (Object)innerDataId);
            if (dataMapping.getNumber() != null) {
                newData.set("number", (Object)dataMapping.getNumber());
            }
            if (dataMapping.getOutdataid() != null) {
                newData.set("outdataid", (Object)dataMapping.getOutdataid());
            }
            if (dataMapping.getOutDataNumber() != null) {
                newData.set("outdatanumber", (Object)dataMapping.getOutDataNumber());
            }
            if (!existDataIdMap.containsKey(innerDataId)) {
                newData.set("createtime", (Object)dataMapping.getCreatetime());
                newData.set("modifytime", (Object)dataMapping.getCreatetime());
                newAddDynamicObjects.add(newData);
                continue;
            }
            newData.set("id", existDataIdMap.get(innerDataId));
            newData.set("modifytime", (Object)new Date());
            updateDynamicObjects.add(newData);
        }
        SaveServiceHelper.save((IDataEntityType)billType, (Object[])newAddDynamicObjects.toArray());
        SaveServiceHelper.update((DynamicObject[])updateDynamicObjects.toArray(new DynamicObject[updateDynamicObjects.size()]));
    }

    @Deprecated
    public static HashMap<Object, Object> getNumDataMappingMap(String server, String dataType) {
        QFilter uFilter = new QFilter("server", "=", (Object)server);
        uFilter.and(new QFilter("datatype", "=", (Object)dataType));
        return (HashMap)TripSyncDataMappingUtil.getDataMappingMapByFilter(uFilter, "number", "outdataid");
    }

    @Deprecated
    public static HashMap<Object, Object> getIdDataMappingMap(String server, String dataType) {
        QFilter uFilter = new QFilter("server", "=", (Object)server);
        uFilter.and(new QFilter("datatype", "=", (Object)dataType));
        return (HashMap)TripSyncDataMappingUtil.getDataMappingMapByFilter(uFilter, "innerdataid", "outdataid");
    }

    public static Map<Object, Object> getDataMappingMapByFilter(QFilter uFilter, String keyProp, String valueProp) {
        QFilter[] qFilters = new QFilter[]{uFilter = uFilter.and(new QFilter("outdataid", "!=", (Object)0L))};
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"er_tripsync_datamapping", (String)"id,datatype,number,innerdataid,outdataid", (QFilter[])qFilters);
        if (objectDynamicObjectMap == null || objectDynamicObjectMap.size() < 1) {
            return new HashMap<Object, Object>();
        }
        HashMap<Object, Object> dataMappingMap = new HashMap<Object, Object>(2);
        objectDynamicObjectMap.values().stream().forEach(mapping -> dataMappingMap.put(mapping.get(keyProp), mapping.get(valueProp)));
        return dataMappingMap;
    }

    public static HashMap<Object, Object> getMappingDataId(String server, String dataType) {
        QFilter uFilter = new QFilter("server", "=", (Object)server);
        uFilter.and(new QFilter("datatype", "=", (Object)dataType));
        return (HashMap)TripSyncDataMappingUtil.getDataMappingMapByFilter(uFilter, "innerdataid", "id");
    }

    public static Object getBudgetCenterId(DailyVehicleBillModel billModel, TripReqbillModel reqbill, Map<Object, Object> dataOrgMappingMap) {
        int paramValue = TripSyncConfigUtil.getIntValue("budget_center_id", 1);
        Object returnValue = null;
        switch (paramValue) {
            case 0: {
                Long dept = null;
                if (billModel != null) {
                    dept = billModel.getDeptId();
                } else if (reqbill != null) {
                    dept = reqbill.getDeptId();
                }
                logger.info("getBudgetCenterId current dept {}", (Object)dept);
                if (dept == null) {
                    return null;
                }
                returnValue = dataOrgMappingMap.get(dept);
                break;
            }
            case 1: {
                Long companyId = null;
                if (billModel != null) {
                    companyId = billModel.getCompanyId();
                } else if (reqbill != null) {
                    companyId = reqbill.getCompanyId();
                }
                logger.info("getBudgetCenterId current companyid {}", (Object)companyId);
                if (companyId == null) {
                    return null;
                }
                returnValue = dataOrgMappingMap.get(companyId);
                break;
            }
            case 2: {
                Long costDeptId = null;
                if (billModel != null) {
                    costDeptId = billModel.getCostdeptId();
                } else if (reqbill != null) {
                    costDeptId = reqbill.getCostdeptId();
                }
                logger.info("getBudgetCenterId current costDeptId {}", (Object)costDeptId);
                if (costDeptId == null) {
                    return null;
                }
                returnValue = dataOrgMappingMap.get(costDeptId);
                break;
            }
            case 3: {
                Long costCompanyId = null;
                if (billModel != null) {
                    costCompanyId = billModel.getCostCompanyId();
                } else if (reqbill != null) {
                    costCompanyId = reqbill.getCostCompanyId();
                }
                logger.info("getBudgetCenterId current costCompanyId {}", (Object)costCompanyId);
                if (costCompanyId == null) {
                    return null;
                }
                returnValue = dataOrgMappingMap.get(costCompanyId);
            }
        }
        return returnValue;
    }

    private static /* synthetic */ void lambda$saveTripSyncDataMapping$0(DynamicObjectType billType, HashMap finalMappingData, HashMap idMappingData, List dynamicObjects, TripSyncDataMappingModel dataMapping) {
        DynamicObject dataMappingInfo = new DynamicObject(billType);
        dataMappingInfo.set("server", (Object)dataMapping.getServer());
        dataMappingInfo.set("datatype", (Object)dataMapping.getDatatype());
        if (!finalMappingData.containsKey(dataMapping.getInnerdataid())) {
            dataMappingInfo.set("createtime", (Object)dataMapping.getCreatetime());
        }
        dataMappingInfo.set("modifytime", (Object)new Date());
        if (dataMapping.getNumber() != null) {
            dataMappingInfo.set("number", (Object)dataMapping.getNumber());
        }
        if (dataMapping.getInnerdataid() != null) {
            dataMappingInfo.set("innerdataid", (Object)dataMapping.getInnerdataid());
        }
        if (dataMapping.getOutdataid() != null) {
            dataMappingInfo.set("outdataid", (Object)dataMapping.getOutdataid());
        }
        if (idMappingData.containsKey(dataMapping.getInnerdataid())) {
            dataMappingInfo.set("id", idMappingData.get(dataMapping.getInnerdataid()));
        }
        dynamicObjects.add(dataMappingInfo);
    }
}

