/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.function.template;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.utils.ThrowableHelper;

public class LogInvoke {
    private static Log logger = LogFactory.getLog(LogInvoke.class);
    protected List<TripSyncLogParam> tripSyncLogParamList = null;
    protected TripSyncLogParam tripSyncLogParam = null;
    protected Map params;

    public Map getParams() {
        return this.params;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public void initSyncLogParamList() {
        this.tripSyncLogParamList = new LinkedList<TripSyncLogParam>();
    }

    public void initSyncLogParam() {
        this.tripSyncLogParam = new TripSyncLogParam();
        DynamicObject filemapping = (DynamicObject)this.params.get("fieldmap");
        if (null == filemapping) {
            this.tripSyncLogParam.setStatus("B");
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002", (String)"AbstractPushInvoke_01", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        String number = filemapping.getString("number");
        DynamicObject dfunction = filemapping.getDynamicObject("function");
        if (null == dfunction) {
            this.tripSyncLogParam.setStatus("B");
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04[%s]\uff0c\u661f\u7ff0\u5bf9\u63a5\u529f\u80fd\u672a\u914d\u7f6e\u3002", (String)"AbstractPullInvoke_09", (String)"fi-er-business", (Object[])new Object[]{number}));
            return;
        }
        DynamicObject server = filemapping.getDynamicObject("server");
        if (null == server) {
            this.tripSyncLogParam.setStatus("B");
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04\u201c%s\u201d\uff0c\u672a\u8bbe\u7f6e\u670d\u52a1\u5546\u3002", (String)"AbstractPullInvoke_12", (String)"fi-er-business", (Object[])new Object[]{number}));
            return;
        }
        String functionname = filemapping.getDynamicObject("function").getLocaleString("name").getLocaleValue();
        String functiontype = filemapping.getDynamicObject("function").getString("number");
        String servername = filemapping.getDynamicObject("server").getLocaleString("name").getLocaleValue();
        this.tripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), servername, functionname, functiontype);
        this.tripSyncLogParam.setRequesturl(filemapping.getString("url"));
        this.tripSyncLogParam.setSynctime(new Date());
    }

    public void setErrorMsg(Exception e) {
        this.tripSyncLogParam.setStatus("B");
        this.tripSyncLogParam.setMessage(ThrowableHelper.toString((Exception)e));
    }

    public void handleErrorLog() {
        final DynamicObject filemapping = (DynamicObject)this.params.get("fieldmap");
        if (null == filemapping) {
            return;
        }
        final String function = filemapping.getDynamicObject("function").getString("id");
        final ArrayList<TripSyncLogParam> loglist = new ArrayList<TripSyncLogParam>();
        loglist.addAll(this.tripSyncLogParamList);
        ThreadService.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (null == loglist || loglist.size() < 1) {
                    return;
                }
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u65e5\u5fd7\u4fdd\u5b58\uff1aloglist:{},traceid:{}", (Object)loglist.size(), (Object)((TripSyncLogParam)loglist.get(0)).getTraceid());
                if (null == function || function.isEmpty()) {
                    return;
                }
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"er_trip_log");
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                for (TripSyncLogParam logParam : loglist) {
                    DynamicObject triplog = new DynamicObject((DynamicObjectType)entityType);
                    if ("er_biz_info".equals(logParam.getFunctiontype()) && logParam.getStatus().equals("A")) continue;
                    triplog.set("traceid", (Object)logParam.getTraceid());
                    triplog.set("server", (Object)logParam.getServer());
                    triplog.set("function", (Object)logParam.getFunction());
                    triplog.set("status", (Object)logParam.getStatus());
                    triplog.set("message", (Object)TripSyncLogUtils.genErrorStr(logParam.getMessage()));
                    triplog.set("message_tag", (Object)logParam.getMessage());
                    triplog.set("requesturl", (Object)logParam.getRequesturl());
                    triplog.set("requestdata", TripSyncLogUtils.genJsonStr(logParam.getRequestdata()));
                    triplog.set("requestdata_tag", TripSyncLogUtils.genClobJsonStr(logParam.getRequestdata()));
                    triplog.set("responsedata", TripSyncLogUtils.genJsonStr(logParam.getResponsedata()));
                    triplog.set("responsedata_tag", TripSyncLogUtils.genClobJsonStr(logParam.getResponsedata()));
                    triplog.set("billno", (Object)TripSyncLogUtils.genErrorStr(logParam.getBillno()));
                    triplog.set("billno_tag", (Object)logParam.getBillno());
                    triplog.set("username", (Object)"");
                    triplog.set("opname", (Object)"");
                    triplog.set("opdesc", (Object)triplog.getString("billno"));
                    triplog.set("fieldmappingnumber", (Object)filemapping.getString("number"));
                    triplog.set("fieldmappingname", (Object)filemapping.getLocaleString("name").getLocaleValue());
                    list.add(triplog);
                }
                LogORM logORM = LogORM.create();
                try {
                    logORM.insert(list);
                }
                catch (Exception e) {
                    logger.info("\u5546\u65c5\u96c6\u6210,\u65e5\u5fd7\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)ThrowableHelper.toString((Exception)e));
                }
            }
        }, (TaskType)TaskType.ER_LOG_TASK, (RequestContext)RequestContext.get());
    }

    protected void updateLastsyncTamp() {
        DynamicObject filemapping = (DynamicObject)this.params.get("fieldmap");
        logger.info("\u5b57\u6bb5\u6620\u5c04,updateLastsyncTamp----\u5f00\u59cb");
        if (null == filemapping) {
            logger.info("\u5b57\u6bb5\u6620\u5c04,updateLastsyncTamp----filemapping\u4e3a\u7a7a");
            return;
        }
        Object orgId = this.params.get("entryentity.dpt.id");
        boolean isScheduledTask = this.params.getOrDefault("isScheduledTask", false);
        if (!isScheduledTask && orgId == null) {
            logger.info("\u5b57\u6bb5\u6620\u5c04,updateLastsyncTamp---\u975e\u8c03\u5ea6\u4e0d\u8fdb\u884c\u66f4\u65b0");
            return;
        }
        Date syncTime = null;
        for (TripSyncLogParam syncLogParam : this.tripSyncLogParamList) {
            if ("B".equals(syncLogParam.getStatus())) {
                logger.info("\u5b57\u6bb5\u6620\u5c04,updateLastsyncTamp----\u5b58\u5728\u5931\u8d25\u4e0d\u66f4\u65b0\u65f6\u95f4\u6233");
                return;
            }
            if (null == syncTime) {
                syncTime = syncLogParam.getSynctime();
            }
            if (null == syncTime || !syncLogParam.getSynctime().before(syncTime)) continue;
            syncTime = syncLogParam.getSynctime();
        }
        if (null != syncTime) {
            String functionNumber = filemapping.getDynamicObject("function").getString("number");
            Long serverId = filemapping.getDynamicObject("server").getLong("id");
            DynamicObject server = BusinessDataServiceHelper.loadSingle((String)"er_biz_info", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)serverId)});
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String currentTime = sdf.format(syncTime);
            logger.info(String.format("\u6700\u540e\u5dee\u91cf\u540c\u6b65%1$s\u65f6\u95f4\u6233lastsynctamp = %2$s", filemapping.getDynamicObject("function").getString("name"), currentTime));
            switch (functionNumber) {
                case "bos_user": {
                    String syncusertype = server.getString("syncusertype");
                    DynamicObjectCollection entryentity = server.getDynamicObjectCollection("entryentity");
                    if ("1".equals(syncusertype)) {
                        server.set("lastsyncpeopletamp", (Object)currentTime);
                        for (DynamicObject dynamicObject : entryentity) {
                            dynamicObject.set("lastsyncstamp", (Object)syncTime);
                        }
                    } else {
                        if (orgId == null) {
                            return;
                        }
                        for (DynamicObject dynamicObject : entryentity) {
                            if (!orgId.equals(ErCommonUtils.getPk(dynamicObject.getDynamicObject("org")))) continue;
                            logger.info("\u5b57\u6bb5\u6620\u5c04,updateLastsyncTamp---\u66f4\u65b0\u5206\u5f55\u65f6\u95f4\u6233:{},orgid:{}", (Object)TripCommonUtil.DateToStr(syncTime), orgId);
                            dynamicObject.set("lastsyncstamp", (Object)syncTime);
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{server});
                            return;
                        }
                    }
                    break;
                }
                case "bos_org_structure": {
                    server.set("lastsyncorgtamp", (Object)currentTime);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{server});
        }
    }

    public static Boolean checkFieldmap(Object datas, TripSyncLogParam tripSyncLogParam, Map params) {
        if (null == datas) {
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u6e90\u5355\u6570\u636e\u4e3a\u7a7a\u3002", (String)"AbstractPullInvoke_16", (String)"fi-er-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (null == params.get("fieldmap")) {
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04\u672a\u914d\u7f6e\u3002", (String)"AbstractPullInvoke_07", (String)"fi-er-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        DynamicObject fieldmapping = (DynamicObject)params.get("fieldmap");
        String number = fieldmapping.getString("number");
        DynamicObjectCollection fieldmapentry = fieldmapping.getDynamicObjectCollection("fieldmapentry");
        if (null == fieldmapentry) {
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04[%s],\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\u672a\u914d\u7f6e\u3002", (String)"AbstractPullInvoke_17", (String)"fi-er-business", (Object[])new Object[]{number}));
            return Boolean.FALSE;
        }
        DynamicObject dfunction = fieldmapping.getDynamicObject("function");
        if (null == dfunction) {
            tripSyncLogParam.setStatus("B");
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04[%s]\uff0c\u661f\u7ff0\u5bf9\u63a5\u529f\u80fd\u672a\u914d\u7f6e\u3002", (String)"AbstractPullInvoke_09", (String)"fi-er-business", (Object[])new Object[]{number}));
            return Boolean.FALSE;
        }
        String primarykey = TripCommonUtil.getPkeyByMapsource(fieldmapentry);
        if (null == primarykey) {
            tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5546\u65c5\u5b57\u6bb5\u6620\u5c04[%s]\uff0c\u672a\u8bbe\u7f6e\u4e3b\u952e\u3002", (String)"AbstractPullInvoke_01", (String)"fi-er-business", (Object[])new Object[]{number}));
            tripSyncLogParam.setStatus("B");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean discontinue() {
        return TripSyncConfigUtil.getBoolean("trip_discontinue");
    }

    public static String selectReqFields() {
        return "billno, company, org,costcompany,costdept, currency, tripentry, tripentry.from, tripentry.to, tripentry.startdate, tripentry.enddate,tripentry.travelers";
    }

    public static String selectVehicleFields() {
        return "billno, company, org,costcompany,costdept,  vehicletype,billstatus";
    }

    public static String selectApplyFields() {
        return "billno, company, org,costcompany,costdept, currency, reimbursetype";
    }

    public static String selectMealFields() {
        return "billno, company, org,costcompany,costdept, currency, dinnerscene";
    }

    public static String userSelectFields() {
        return "id,number,name,entryentity.id,entryentity.position,entryentity.dpt,entryentity.ispartjob";
    }
}

