/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.plugin.dtgtrip;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.fi.er.business.cache.TraceCache;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.dao.UserDao;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public class DtgTripPlugin {
    private static final ThreadLocal<TraceCache<String, LinkedHashMap<Long, Integer>>> THREAD_LOCAL = ThreadLocal.withInitial(TraceCache::new);
    private static final String CACHE_KEY = "DtgTripPlugin_parentId";
    private static final Log logger = LogFactory.getLog(DtgTripPlugin.class);

    public Object getCacheToken(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DistributeSessionlessCache distributeSessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String access_token = (String)distributeSessionlessCache.get("TongCheng_Access_Token");
        if (StringUtils.isNotEmpty((String)access_token)) {
            return access_token;
        }
        Object result = TripCommonUtil.invoke(Supplier.TONGCHENG.getValue(), "er_biz_info", null, null, new HashMap<String, Object>());
        if (result instanceof List) {
            List resultList = (List)result;
            if (CollectionUtils.isEmpty((Collection)resultList)) {
                return "";
            }
            Map resultMap = (Map)resultList.get(0);
            if (resultMap.isEmpty() || !((Boolean)resultMap.get("success")).booleanValue()) {
                return "";
            }
            Object data = resultMap.get("data");
            JSONArray dataArray = JSON.parseArray((String)JSON.toJSONString(data));
            if (dataArray.size() == 0) {
                return "";
            }
            JSONObject dataJson = dataArray.getJSONObject(0);
            JSONObject data1 = dataJson.getJSONObject("data");
            if (data1 == null) {
                return "";
            }
            Object result_Token = data1.get(map.get("jsonfield"));
            if (result_Token != null) {
                distributeSessionlessCache.put("TongCheng_Access_Token", (Object)result_Token.toString(), 0x6DDD00, TimeUnit.MILLISECONDS);
            }
            return result_Token;
        }
        return "";
    }

    public Object getPositionLevelName(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        DynamicObject company;
        Map context = (Map)map.get("context");
        if (context == null) {
            return "";
        }
        Object employeeNumber = context.get("param.outEmployeeId");
        DynamicObject user = (DynamicObject)map.get("bill");
        Long deptId = this.getUserDeptId(user);
        if (employeeNumber == null || deptId == null) {
            logger.info("\u672a\u83b7\u53d6\u5230\u5458\u5de5{}\u6216\u8005\u90e8\u95e8{}", employeeNumber, (Object)deptId);
            return "";
        }
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", employeeNumber)});
        if (dynamicObject == null) {
            logger.info("\u6839\u636e\u5458\u5de5number\u672a\u83b7\u53d6\u5230\u5458\u5de5{}", employeeNumber);
            return "";
        }
        long userId = dynamicObject.getLong("id");
        paramMap.put("id", userId);
        Long companyId = CoreBaseBillServiceHelper.initCompanyByDept(Long.parseLong(deptId.toString()));
        paramMap.put("companyId", companyId);
        Map<Long, String> reimburseLevelMap = UserDao.getReimburseLevelNumberNew(Collections.singletonList(paramMap));
        if (reimburseLevelMap.isEmpty()) {
            logger.info("\u65e5\u5fd7\u8bb0\u5f55\u6392\u67e5:\u5bf9\u5e94\u5458\u5de5ID{}\u516c\u53f8ID{}\u672a\u83b7\u53d6\u5230\u62a5\u9500\u7ea7\u522b\u6570\u636e", (Object)userId, (Object)companyId);
        }
        if ((company = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)companyId)})) == null) {
            logger.info("\u65e5\u5fd7\u8bb0\u5f55\u6392\u67e5:\u5458\u5de5{}\u6839\u636e\u516c\u53f8ID{}\u672a\u83b7\u53d6\u5230\u516c\u53f8\u6570\u636e", employeeNumber, (Object)companyId);
        }
        String result = "";
        int intValue = TripSyncConfigUtil.getIntValue("dttrip_personnel_rank", 4, Arrays.asList(1, 2, 3, 4, 5));
        switch (intValue) {
            case 1: {
                if (reimburseLevelMap.isEmpty() || !StringUtils.isNotEmpty((String)reimburseLevelMap.get(userId)) || company == null) break;
                result = company.getString("number") + "-" + reimburseLevelMap.get(userId);
                break;
            }
            case 2: {
                if (reimburseLevelMap.isEmpty() || !StringUtils.isNotEmpty((String)reimburseLevelMap.get(userId))) break;
                result = reimburseLevelMap.get(userId);
                break;
            }
            case 3: {
                if (!reimburseLevelMap.isEmpty() && StringUtils.isNotEmpty((String)reimburseLevelMap.get(userId)) && company != null) {
                    result = company.getString("number") + "-" + reimburseLevelMap.get(userId);
                    break;
                }
                if (company == null) break;
                result = company.getString("number") + "-General-01";
                break;
            }
            default: {
                if (!reimburseLevelMap.isEmpty() && StringUtils.isNotEmpty((String)reimburseLevelMap.get(userId))) {
                    result = reimburseLevelMap.get(userId);
                    break;
                }
                result = "General-01";
                break;
            }
            case 5: {
                result = !reimburseLevelMap.isEmpty() && StringUtils.isNotEmpty((String)reimburseLevelMap.get(userId)) && company != null ? company.getString("number") + "-" + reimburseLevelMap.get(userId) : "General-01";
            }
        }
        return result;
    }

    private Long getUserDeptId(DynamicObject user) {
        Long deptId = null;
        DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
        for (DynamicObject userEntry : userEntrys) {
            DynamicObject dept = userEntry.getDynamicObject("dpt");
            boolean isPartjob = userEntry.getBoolean("ispartjob");
            if (isPartjob || null == dept) continue;
            deptId = dept.getLong("id");
        }
        return deptId;
    }

    public Object getCostCenter(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map context = (Map)map.get("context");
        if (context == null) {
            return "";
        }
        Long deptId = this.getUserDeptId((DynamicObject)map.get("bill"));
        if (deptId == null) {
            return "";
        }
        Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId(Long.parseLong(deptId.toString()));
        if (accountOrgId == null) {
            return "";
        }
        return accountOrgId;
    }

    public Object getCostCenterName(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Object costCenter = this.getCostCenter(map, tripSyncLogParam);
        if (costCenter == null || StringUtils.isEmpty((String)costCenter.toString())) {
            return "";
        }
        DynamicObject company = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_adminorg", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", costCenter)});
        if (company == null) {
            logger.info("\u83b7\u53d6\u8d39\u7528\u627f\u62c5\u4e2d\u5fc3\u540d\u79f0 \u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a{}", costCenter);
            return "";
        }
        return company.getString("name");
    }

    @Deprecated
    public Object getQueryParamParentId(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Integer count;
        long parentId;
        TraceCache<String, LinkedHashMap<Long, Integer>> traceCache = THREAD_LOCAL.get();
        if (!traceCache.isCurrentTrace()) {
            traceCache.clearAndSetTraceId();
        } else if (traceCache.isCurrentTrace() && traceCache.containKey(CACHE_KEY)) {
            LinkedHashMap<Long, Integer> parentIdCountMap = traceCache.get(CACHE_KEY);
            ArrayList<Map.Entry<Long, Integer>> entries = new ArrayList<Map.Entry<Long, Integer>>(parentIdCountMap.entrySet());
            Map.Entry<Long, Integer> parentIdAndCount = entries.get(0);
            Integer value = parentIdAndCount.getValue();
            Long parentId2 = parentIdAndCount.getKey();
            Integer n = value;
            Integer n2 = value = Integer.valueOf(value - 1);
            parentIdCountMap.put(parentId2, value);
            if (value == 0) {
                parentIdCountMap.remove(parentId2);
                THREAD_LOCAL.get().put(CACHE_KEY, parentIdCountMap);
            }
            return parentId2;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info", (String)"lastsyncorgtamp", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)Supplier.TONGCHENG.name())});
        QFilter or = new QFilter("createtime", ">=", (Object)dynamicObject.getDate("lastsyncorgtamp")).or(new QFilter("modifytime", ">=", (Object)dynamicObject.getDate("lastsyncorgtamp")));
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"parent,id", (QFilter[])new QFilter[]{new QFilter("view", "=", (Object)1), or}, (String)"level");
        LinkedHashMap parentCountMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (DynamicObject org : orgs) {
            parentId = org.getLong("parent");
            if (parentId != 0L) continue;
            if (parentCountMap.containsKey(parentId)) {
                count = (Integer)parentCountMap.get(parentId);
                count = count + 1;
                parentCountMap.put(parentId, count);
                continue;
            }
            parentCountMap.put(parentId, 1);
        }
        for (DynamicObject org : orgs) {
            parentId = org.getLong("parent");
            if (parentId == 0L) continue;
            if (parentCountMap.containsKey(parentId)) {
                count = (Integer)parentCountMap.get(parentId);
                count = count + 1;
                parentCountMap.put(parentId, count);
                continue;
            }
            parentCountMap.put(parentId, 1);
        }
        THREAD_LOCAL.get().put(CACHE_KEY, parentCountMap);
        ArrayList entries = new ArrayList(parentCountMap.entrySet());
        return entries.get(0).getKey();
    }

    public Object getPlat(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Map params = (Map)map.get("params");
        Object o = params.get("isPC");
        if (o != null && ((Boolean)o).booleanValue()) {
            return 0;
        }
        return 1;
    }

    public Object getEntrance(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        return ((Map)map.get("params")).get("entrance");
    }

    public Object getUserNo(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_user", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currUserId)});
        if (dynamicObject == null) {
            return "";
        }
        return dynamicObject.getString("number");
    }

    public Object getReqStatus(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (!map.containsKey("params")) {
            return "1";
        }
        Map params = (Map)map.get("params");
        if (!params.containsKey("status")) {
            return "1";
        }
        return params.get("status");
    }

    public Object getReqPersonList(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (!map.containsKey("bill")) {
            return new JSONArray();
        }
        DynamicObject reqBill = (DynamicObject)map.get("bill");
        String name = reqBill.getDynamicObjectType().getName();
        long applier_id = reqBill.getLong("applier_id");
        long creator_id = reqBill.getLong("creator_id");
        JSONArray jsonArray = new JSONArray();
        if (ErEntityTypeUtils.isTripReqBill(name)) {
            DynamicObjectCollection tripentry = reqBill.getDynamicObjectCollection("tripentry");
            if (CollectionUtils.isEmpty((Collection)tripentry)) {
                return new JSONArray();
            }
            HashSet allUserIds = Sets.newHashSetWithExpectedSize((int)16);
            for (DynamicObject dynamicObject : tripentry) {
                DynamicObjectCollection travelers = dynamicObject.getDynamicObjectCollection("travelers");
                if (CollectionUtils.isEmpty((Collection)travelers)) continue;
                Set userIds = travelers.stream().filter(obj -> obj.get("fbasedataid") != null).map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toSet());
                allUserIds.addAll(userIds);
            }
            DynamicObjectCollection userInfos = QueryServiceHelper.query((String)"bos_user", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)allUserIds)});
            for (DynamicObject userInfo : userInfos) {
                this.dealJson(jsonArray, userInfo);
            }
            return jsonArray;
        }
        DynamicObjectCollection userInfos = QueryServiceHelper.query((String)"bos_user", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)applier_id)});
        for (DynamicObject userInfo : userInfos) {
            this.dealJson(jsonArray, userInfo);
        }
        return jsonArray;
    }

    private void dealJson(JSONArray jsonArray, DynamicObject userInfo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)userInfo.getString("name"));
        jsonObject.put("outEmployeeId", (Object)userInfo.getString("number"));
        jsonObject.put("relation", (Object)"0");
        jsonObject.put("passengerType", (Object)"0");
        jsonArray.add((Object)jsonObject);
    }

    public Object getDepartCity(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (!this.judgeExistKey(map, "bill").booleanValue()) {
            return "";
        }
        DynamicObject reqBill = (DynamicObject)map.get("bill");
        DynamicObjectCollection tripentry = reqBill.getDynamicObjectCollection("tripentry");
        if (CollectionUtils.isEmpty((Collection)tripentry)) {
            return "";
        }
        Set departCityNameList = tripentry.stream().filter(dynamicObject -> dynamicObject.getDynamicObject("from") != null).map(dynamicObject -> dynamicObject.getDynamicObject("from").getString("name")).collect(Collectors.toSet());
        if (departCityNameList.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)",", departCityNameList);
    }

    public Object getArriveCity(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (!this.judgeExistKey(map, "bill").booleanValue()) {
            return "";
        }
        DynamicObject reqBill = (DynamicObject)map.get("bill");
        DynamicObjectCollection tripentry = reqBill.getDynamicObjectCollection("tripentry");
        if (CollectionUtils.isEmpty((Collection)tripentry)) {
            return "";
        }
        Set arriveCityNameList = tripentry.stream().filter(dynamicObject -> dynamicObject.getDynamicObject("to") != null).map(dynamicObject -> dynamicObject.getDynamicObject("to").getString("name")).collect(Collectors.toSet());
        if (arriveCityNameList.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)",", arriveCityNameList);
    }

    public Object getOtherCity(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (!this.judgeExistKey(map, "bill").booleanValue()) {
            return "";
        }
        DynamicObject reqBill = (DynamicObject)map.get("bill");
        DynamicObjectCollection tripentry = reqBill.getDynamicObjectCollection("tripentry");
        if (CollectionUtils.isEmpty((Collection)tripentry)) {
            return "";
        }
        HashSet allCityId = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dynamicObject2 : tripentry) {
            DynamicObjectCollection mulwayto = dynamicObject2.getDynamicObjectCollection("mulwayto");
            Set cityIds = mulwayto.stream().filter(obj -> obj.get("fbasedataid") != null).map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toSet());
            allCityId.addAll(cityIds);
        }
        if (CollectionUtils.isEmpty((Collection)allCityId)) {
            return "";
        }
        DynamicObjectCollection citys = QueryServiceHelper.query((String)"bd_admindivision", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)allCityId)});
        if (citys.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)",", citys.stream().filter(dynamicObject -> StringUtils.isNotEmpty((String)dynamicObject.getString("name"))).map(dynamicObject -> dynamicObject.getString("name")).collect(Collectors.toSet()));
    }

    private Boolean judgeExistKey(Map<String, Object> map, String key) {
        if (!map.containsKey(key)) {
            return false;
        }
        return true;
    }

    public Object getApproveList(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (!this.judgeExistKey(map, "bill").booleanValue()) {
            return new JSONArray();
        }
        DynamicObject bill = (DynamicObject)map.get("bill");
        if (bill == null) {
            return new JSONArray();
        }
        Object pkValue = bill.getPkValue();
        if (pkValue == null) {
            return new JSONArray();
        }
        List coordinate = WorkflowServiceHelper.getAllApprovalRecordInclCoordinate((String)pkValue.toString());
        int approveLevel = 0;
        JSONArray jsonArray = new JSONArray();
        for (IApprovalRecordGroup record : coordinate) {
            String operateType = record.getGroupDecisionType();
            if ("submit".equals(operateType)) continue;
            List children = record.getChildren();
            ++approveLevel;
            for (IApprovalRecordItem child : children) {
                Long userId = child.getUserId();
                DynamicObject user = QueryServiceHelper.queryOne((String)"bos_user", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userId)});
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("outEmployeeId", (Object)(user == null ? "" : user.getString("number")));
                jsonObject.put("approverType", (Object)"0");
                jsonObject.put("approverGrade", (Object)approveLevel);
                jsonArray.add((Object)jsonObject);
            }
        }
        if (coordinate.isEmpty()) {
            return new JSONArray();
        }
        return jsonArray;
    }

    public Object getVehicleType(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (!this.judgeExistKey(map, "bill").booleanValue()) {
            return "";
        }
        DynamicObject bill = (DynamicObject)map.get("bill");
        int vehicletype = bill.getInt("vehicletype");
        return vehicletype == 2 ? ResManager.loadKDString((String)"\u516c\u52a1\u51fa\u884c\u7528\u8f66", (String)"CarTypeEnum_2", (String)"fi-er-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5468\u672b/\u8282\u5047\u65e5\u52a0\u73ed\u7528\u8f66", (String)"CarTypeEnum_4", (String)"fi-er-common", (Object[])new Object[0]);
    }

    public Object getBookAbleProducts(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        if (!this.judgeExistKey(map, "bill").booleanValue()) {
            return "";
        }
        DynamicObject reqBill = (DynamicObject)map.get("bill");
        String name = reqBill.getDynamicObjectType().getName();
        if (ErEntityTypeUtils.isDailyVehicleBill(name)) {
            return "6";
        }
        DynamicObject org = reqBill.getDynamicObject("org");
        if (org == null) {
            return "";
        }
        Long deptId = ErCommonUtils.getPk(org);
        Long companyId = ErCommonUtils.getPk(reqBill.getDynamicObject("company"));
        HashMap orgIdAndCompanyIdMap = Maps.newHashMapWithExpectedSize((int)2);
        orgIdAndCompanyIdMap.put("orgId", deptId);
        orgIdAndCompanyIdMap.put("companyId", companyId);
        return TripCommonUtil.getBookAbleProducts(Supplier.TONGCHENG.name(), orgIdAndCompanyIdMap, name);
    }

    public Object getDeptName(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        Long deptId = this.getUserDeptId((DynamicObject)map.get("bill"));
        if (deptId == null) {
            return "";
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"fullname", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)deptId)});
        ILocaleString fullname = dynamicObject.getLocaleString("fullname");
        if (fullname == null) {
            return "";
        }
        return dynamicObject.getLocaleString("fullname").getLocaleValue().replaceAll("_", "/");
    }

    public Object getTime(Map<String, Object> map, TripSyncLogParam tripSyncLogParam) {
        String billfield = map.getOrDefault("billfield", "").toString();
        try {
            Object ctx = TripCommonUtil.getDValueByfield((DynamicObject)map.get("bill"), billfield);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            logger.info("{}\u65f6\u95f4{}", (Object)billfield, (Object)sdf.format(sdf.parse(ctx.toString())));
            return sdf.format(sdf.parse(ctx.toString()));
        }
        catch (Exception ex) {
            logger.error("=============" + billfield);
            logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38", (Throwable)ex);
            return "";
        }
    }
}

