/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.v2.server.alitrip;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.v2.function.LoginInvoke;
import kd.fi.er.business.trip.v2.plugin.alitrip.ALiTripPlugin;
import org.apache.commons.lang.StringUtils;

public class ALiTripLoginInvoke
extends LoginInvoke {
    private static Log logger = LogFactory.getLog(ALiTripLoginInvoke.class);

    @Override
    public void execute(Map<String, Object> params) {
        super.execute(params);
        IFormView view = (IFormView)params.get("view");
        if (null == this.tripSyncLogParamList) {
            return;
        }
        for (TripSyncLogParam tripSyncLogParam : this.tripSyncLogParamList) {
            if (!"B".equals(tripSyncLogParam.getStatus())) continue;
            if (null == tripSyncLogParam.getResponsedata() || tripSyncLogParam.getResponsedata().toString().trim().isEmpty() || !(tripSyncLogParam.getResponsedata() instanceof JSONObject)) {
                logger.info(tripSyncLogParam.getMessage());
                view.showTipNotification(ResManager.loadKDString((String)"\u767b\u9646\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ALiTripLoginInvoke_1", (String)"fi-er-business", (Object[])new Object[0]));
                return;
            }
            JSONObject data = (JSONObject)tripSyncLogParam.getResponsedata();
            String code = data.getString("code");
            String message = data.getString("msg");
            if ("success".equals(code)) continue;
            logger.error("\u963f\u91cc\u5355\u70b9\u767b\u5f55\u5931\u8d25{}", (Object)message);
            view.showTipNotification(ResManager.loadKDString((String)"\u8df3\u8f6c\u963f\u91cc\u5546\u65c5\u5931\u8d25\uff0c\u963f\u91cc\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"ALiTripLoginInvoke_0", (String)"fi-er-business", (Object[])new Object[]{message}));
            view.getFormShowParameter().setCustomParam("error", (Object)"true");
            return;
        }
    }

    @Override
    public String buildUrl(Object t) {
        if (t == null) {
            return null;
        }
        JSONObject requestJson = (JSONObject)t;
        DynamicObject fieldmapping = (DynamicObject)this.params.get("fieldmap");
        String url = fieldmapping.getString("url");
        this.tripSyncLogParam.setRequestdata(requestJson);
        String result = this.httpPost(url, requestJson);
        if (StringUtils.isBlank((String)result)) {
            this.tripSyncLogParam.setStatus("B");
            if (StringUtils.isBlank((String)this.tripSyncLogParam.getMessage())) {
                this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u5355\u70b9\u767b\u5f55\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\u3002", (String)"ALiTripLoginInvoke_2", (String)"fi-er-business", (Object[])new Object[0]));
            }
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if ("success".equals(jsonObject.getString("code"))) {
            JSONObject data = jsonObject.getJSONObject("data");
            return data.getString("url");
        }
        logger.info("\u963f\u91cc\u5355\u70b9\u8bf7\u6c42\u8fd4\u56de\u6570\u636e{}", (Object)result);
        this.tripSyncLogParam.setStatus("B");
        this.tripSyncLogParam.setMessage(jsonObject.getString("msg"));
        this.tripSyncLogParam.setResponsedata(jsonObject);
        return null;
    }

    @Override
    public String httpPost(String url, Object o) {
        if (TripSyncConfigUtil.getBoolean("trip_isdev")) {
            DynamicObject fieldmapping = (DynamicObject)this.params.get("fieldmap");
            String datajson_tag = fieldmapping.getString("datajson_tag");
            this.tripSyncLogParam.setResponsedata(datajson_tag);
            return datajson_tag;
        }
        DynamicObject server = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info", (String)"appkey", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)Supplier.ALI.getValue())});
        if (server == null) {
            this.tripSyncLogParam.setStatus("B");
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u670d\u52a1\u5546\u8bbe\u7f6e\u4e2d\u662f\u5426\u6709\u7f16\u7801\u4e3aALI\u7684\u670d\u52a1\u5546\u3002", (String)"ALiTripLoginInvoke_4", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        String appKey = server.getString("appkey");
        if (StringUtils.isBlank((String)appKey)) {
            this.tripSyncLogParam.setStatus("B");
            this.tripSyncLogParam.setMessage(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u963f\u91cc\u670d\u52a1\u5546\u8bbe\u7f6e\u4e2d\u7684\u63a5\u5165appkey\u662f\u5426\u6b63\u786e\u914d\u7f6e\u3002", (String)"ALiTripLoginInvoke_3", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        String cacheToken = ALiTripPlugin.getCacheToken(appKey);
        url = url + "?app_key=" + appKey + "&so_corp_token=" + cacheToken;
        this.tripSyncLogParam.setRequesturl(url);
        return super.httpPost(url, o);
    }

    @Override
    public Object querycriteria() {
        return new DynamicObject[]{(DynamicObject)this.params.get("fieldmap")};
    }
}

