/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public class AmountCheckUtil {
    private static final Log logger = LogFactory.getLog(AmountCheckUtil.class);
    public static final String applyCheckType = "applyCheckType";
    private static String loanClearKey = null;
    private static String entryKey = null;
    private static String entityId = null;
    private static String entryCurrencyKey = null;
    private static String entryAmtOriKey = null;
    private static String checkCurrencyKey = null;
    private static String checkAmtOriKey = null;
    private static String checkAmtKey = null;
    private static String checkBalanceAmtOriKey = null;
    private static String checkBalanceAmtKey = null;
    private static boolean removeMonthlyAmt = false;

    public static String loanClearEntryCheck(DynamicObject bill, String loanType, String checkType) {
        try {
            Optional<BigDecimal> bg;
            AmountCheckUtil.initKeyValues(bill, checkType);
            DynamicObjectCollection clearLoanEntrys = bill.getDynamicObjectCollection(loanClearKey);
            boolean checkAmtError = clearLoanEntrys.stream().anyMatch(clearLoanEntry -> clearLoanEntry.getBigDecimal(checkAmtKey).compareTo(clearLoanEntry.getBigDecimal(checkBalanceAmtKey)) > 0 || clearLoanEntry.getBigDecimal(checkAmtOriKey).compareTo(clearLoanEntry.getBigDecimal(checkBalanceAmtOriKey)) > 0);
            if (checkAmtError) {
                return ResManager.loadKDString((String)"\u51b2\u9500\u91d1\u989d\u4e0d\u5f97\u8d85\u8fc7\u53ef\u62a5\u9500\u91d1\u989d\u6216\u501f\u6b3e\u4f59\u989d\u3002", (String)"AmountCheckUtil_0", (String)"fi-er-business", (Object[])new Object[0]);
            }
            if (loanType.equals("1")) {
                Map<String, BigDecimal> entryMap = AmountCheckUtil.groupCurrencyAmount(bill.getDynamicObjectCollection(entryKey), entryCurrencyKey, entryAmtOriKey, removeMonthlyAmt);
                Map<String, BigDecimal> checkMap = AmountCheckUtil.groupCurrencyAmount(clearLoanEntrys, checkCurrencyKey, checkAmtOriKey, removeMonthlyAmt);
                if (entryMap.size() > 0 && checkMap.size() > 0) {
                    for (Map.Entry<String, BigDecimal> entry : entryMap.entrySet()) {
                        BigDecimal checkAmt;
                        if (!checkMap.containsKey(entry.getKey())) {
                            return ResManager.loadKDString((String)"\u62a5\u9500\u5e01\u79cd\u4e0d\u80fd\u8d85\u51fa\u4e0a\u6e38\u7533\u8bf7\u5355\u5e01\u79cd\u7684\u8303\u56f4\u3002", (String)"AmountCheckUtil_1", (String)"fi-er-business", (Object[])new Object[0]);
                        }
                        BigDecimal entryAmt = entry.getValue();
                        if (entryAmt.compareTo(checkAmt = checkMap.get(entry.getKey())) <= 0) continue;
                        return ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5bf9\u5e94\u5e01\u79cd\u7684\u53ef\u62a5\u9500\u91d1\u989d\u3002", (String)"AmountCheckUtil_2", (String)"fi-er-business", (Object[])new Object[0]);
                    }
                }
            } else if (loanType.equals("2") && (bg = clearLoanEntrys.stream().filter(clearLoanEntry -> clearLoanEntry.getBigDecimal(checkAmtKey) != null).map(clearLoanEntry -> clearLoanEntry.getBigDecimal(checkAmtKey)).reduce((a, b) -> a.add((BigDecimal)b))).isPresent()) {
                BigDecimal totalcheckAmt = bg.get();
                BigDecimal totalAmt = bill.getBigDecimal("approveamount");
                if (removeMonthlyAmt) {
                    BigDecimal monthlyAmt = BigDecimal.ZERO;
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryKey);
                    if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
                        for (DynamicObject entry : entrys) {
                            DynamicObjectCollection entryentrys = entry.getDynamicObjectCollection("entryentity");
                            monthlyAmt = monthlyAmt.add(AmountCheckUtil.countMonthlyAmt(entryentrys, "entryappamount"));
                        }
                    } else if (ErEntityTypeUtils.isPublicReimburseBill(entityId) || ErEntityTypeUtils.isDailyReimburseBill(entityId)) {
                        monthlyAmt = AmountUtils.getEntryAmount(entrys, "tripbookcuramount");
                    }
                    totalAmt = totalAmt.subtract(monthlyAmt);
                }
                if (totalAmt.compareTo(totalcheckAmt) > 0) {
                    return ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u7533\u8bf7\u91d1\u989d\u3002", (String)"AmountCheckUtil_3", (String)"fi-er-business", (Object[])new Object[0]);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            return ex.getMessage();
        }
        return null;
    }

    private static void initKeyValues(DynamicObject bill, String checkType) {
        entityId = bill.getDataEntityType().getName();
        if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            removeMonthlyAmt = true;
            entryKey = "tripentry";
            entryCurrencyKey = "tripcurrency";
            entryAmtOriKey = "tripapporiamount";
            loanClearKey = "clearloanentry";
            checkCurrencyKey = "loancurrency";
            checkAmtOriKey = "loanclearoriamount";
            checkAmtKey = "loanclearamount";
            checkBalanceAmtOriKey = "loanoribalanceamount";
            checkBalanceAmtKey = "loanaccbalanceamount";
        } else if (ErEntityTypeUtils.isDailyReimburseBill(entityId) || ErEntityTypeUtils.isPublicReimburseBill(entityId)) {
            if (checkType.equals(applyCheckType)) {
                removeMonthlyAmt = true;
                entryKey = "expenseentryentity";
                entryCurrencyKey = "entrycurrency";
                entryAmtOriKey = "expeapproveamount";
                loanClearKey = "writeoffapply";
                checkCurrencyKey = "applycurrency";
                checkAmtOriKey = "reimbursedamount";
                checkAmtKey = "reimbursedcurramount";
                checkBalanceAmtOriKey = "orgiexpebalanceamount";
                checkBalanceAmtKey = "expebalanceamount";
            } else {
                removeMonthlyAmt = false;
                entryKey = "expenseentryentity";
                entryCurrencyKey = "entrycurrency";
                entryAmtOriKey = "expeapproveamount";
                loanClearKey = "writeoffmoney";
                checkCurrencyKey = "loancurrency";
                checkAmtOriKey = "accloanamount";
                checkAmtKey = "curraccloanamount";
                checkBalanceAmtOriKey = "loanamount";
                checkBalanceAmtKey = "currloanamount";
            }
        }
    }

    private static Map<String, BigDecimal> groupCurrencyAmount(DynamicObjectCollection entrys, String currencyKey, String amtKey, boolean removeMonthlyAmt) {
        DynamicObject currency = null;
        String currencyId = null;
        BigDecimal currencyAmt = null;
        HashMap<String, BigDecimal> currencyMap = new HashMap<String, BigDecimal>();
        for (DynamicObject entry : entrys) {
            currency = entry.getDynamicObject(currencyKey);
            currencyId = currency.getString("id");
            currencyAmt = BigDecimal.ZERO;
            if (currencyMap.get(currencyId) != null) {
                currencyAmt = (BigDecimal)currencyMap.get(currencyId);
            }
            if (removeMonthlyAmt) {
                if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
                    DynamicObjectCollection entryentrys = entry.getDynamicObjectCollection("entryentity");
                    BigDecimal monthlyAmt = AmountCheckUtil.countMonthlyAmt(entryentrys, "orientryappamount");
                    currencyAmt = currencyAmt.subtract(monthlyAmt);
                } else if ((ErEntityTypeUtils.isPublicReimburseBill(entityId) || ErEntityTypeUtils.isDailyReimburseBill(entityId)) && entry.containsProperty("tripbookamount")) {
                    currencyAmt = currencyAmt.subtract(entry.getBigDecimal("tripbookamount"));
                }
            }
            currencyMap.put(currencyId, currencyAmt.add(entry.getBigDecimal(amtKey)));
        }
        return currencyMap;
    }

    private static BigDecimal countMonthlyAmt(DynamicObjectCollection entrys, String amtKey) {
        Optional<BigDecimal> bg = entrys.stream().filter(entry -> "2".equalsIgnoreCase(entry.getString("settlementtype")) && entry.getBigDecimal(amtKey) != null).map(entry -> entry.getBigDecimal(amtKey)).reduce((a, b) -> a.add((BigDecimal)b));
        if (bg.isPresent()) {
            return bg.get();
        }
        return BigDecimal.ZERO;
    }
}

