/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.utils.ErStdConfig;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AttachmentCountUtils {
    private static Log logger = LogFactory.getLog(AttachmentCountUtils.class);
    public static final String UID_PREFIX_XH = "rc-upload-ix-";
    public static final String UID_PREFIX_AWS = "rc-upload-ia-";
    public static final String HISTORY_PREFIX = "rc-invoice-";

    public static boolean isInvoiceAttach(String prefixUid) {
        return prefixUid.startsWith(AttachmentCountUtils.getAttachmentUidPrefix());
    }

    public static String getRealAttachNo(String prefixUid) {
        return prefixUid.replace(AttachmentCountUtils.getAttachmentUidPrefix(), "");
    }

    public static String getAttachmentUidPrefix() {
        return KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud() ? UID_PREFIX_XH : UID_PREFIX_AWS;
    }

    private AttachmentCountUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void setAttachmentCount(FormOperate operate, IDataModel model, IFormView view) {
        Assert.isTrue((model != null ? 1 : 0) != 0, (String)"model can't be null");
        Assert.isTrue((view != null ? 1 : 0) != 0, (String)"view can't be null");
        AttachmentPanel filePanel = AttachmentCountUtils.getAttachmentPanel(view);
        if (filePanel == null && model.getProperty("invoiceattachinfo") == null) {
            return;
        }
        if (model.getProperty("attachmentcount") == null) {
            return;
        }
        String operateKey = operate.getOperateKey();
        String operateType = operate.getType();
        logger.info(String.format("\u8bbe\u7f6e\u9644\u4ef6\u6570 operateKey: %s, operateType\uff1a %s", operateKey, operateType));
        HashSet operations = Sets.newHashSet((Object[])new String[]{"save", "submit", "saveinvoice"});
        if (!operations.contains(operateKey) && !"submit".equalsIgnoreCase(operateType)) {
            return;
        }
        Integer attachmentCount = (Integer)ObjectUtils.defaultIfNull((Object)model.getValue("attachmentcount"), (Object)0);
        Long invoiceCount = 0L;
        if (model.getProperty("invoiceentry") != null) {
            DynamicObjectCollection collection = model.getDataEntity(true).getDynamicObjectCollection("invoiceentry");
            invoiceCount = collection.stream().filter(m -> !InvoiceFrom.PurReceipt.getValue().equals(m.get("invoicefrom")) && !InvoiceFrom.TripBusiness.getValue().equals(m.get("invoicefrom"))).count();
        }
        long attachCount = AttachmentCountUtils.getInvoiceAttachmentCount(view);
        logger.info("\u539f\u6709\u9644\u4ef6\u6570 attachmentcount \uff1a " + attachmentCount + ", \u53d1\u7968\u6570\uff1a " + invoiceCount + ", \u9644\u4ef6\u6570\uff1a " + attachCount);
        attachmentCount = invoiceCount.intValue() + (int)attachCount;
        model.setValue("attachmentcount", (Object)attachmentCount);
        logger.info("\u66f4\u65b0\u540e\u9644\u4ef6\u6570 attachmentcount \uff1a " + attachmentCount);
    }

    public static long getInvoiceAttachmentCount(IFormView view) {
        if (view.getModel().getProperty("invoiceattachinfo") != null) {
            int count = view.getModel().getEntryRowCount("invoiceattachinfo");
            return count;
        }
        return 0L;
    }

    private static AttachmentPanel getAttachmentPanel(IFormView view) {
        AttachmentPanel filePanel = (AttachmentPanel)view.getControl("attachmentpanel");
        return filePanel;
    }

    public static long getInvoiceAttachmentCount(DynamicObject dataEntity) {
        return AttachmentCountUtils.getInvoiceAttachmentSerialNos(dataEntity).size();
    }

    public static String getInvoiceAttachmentSerialNoString(DynamicObject dataEntity) {
        Set<String> serialNos = AttachmentCountUtils.getInvoiceAttachmentSerialNos(dataEntity);
        return serialNos.stream().collect(Collectors.joining(","));
    }

    public static Set<String> getInvoiceAttachmentSerialNos(DynamicObject dataEntity) {
        return AttachmentCountUtils.getInvoiceAttachmentSerialNos(dataEntity, new HashSet());
    }

    public static Set<String> getInvoiceAttachmentSerialNos(DynamicObject dataEntity, Set tempDeleteAttachNo) {
        boolean syncAttachmentToBill = ErStdConfig.getBoolean("invoicecloud.syncattachmenttobill");
        HashSet<String> serialNos = new HashSet<String>(0);
        if (syncAttachmentToBill) {
            String formId = dataEntity.getDynamicObjectType().getName();
            Long billId = (Long)dataEntity.getPkValue();
            List attachmentData = AttachmentServiceHelper.getAttachments((String)formId, (Object)billId, (String)"attachmentpanel");
            Set serialNosFromPanel = AttachmentCountUtils.getInvoiceAttachments(attachmentData).map(e -> ((String)e.get("uid")).replace(AttachmentCountUtils.getAttachmentUidPrefix(), "").replace(HISTORY_PREFIX, "")).collect(Collectors.toSet());
            logger.info("\u9644\u4ef6\u9762\u677f\u6765\u81ea\u53d1\u7968\u4e91\u9644\u4ef6\u6d41\u6c34\u53f7\uff1a" + serialNosFromPanel);
            serialNos.addAll(serialNosFromPanel);
        }
        if (dataEntity.getDataEntityType().getProperties().containsKey((Object)"invoiceattachinfo")) {
            DynamicObjectCollection attachEntries = dataEntity.getDynamicObjectCollection("invoiceattachinfo");
            Set serialNosFromEntry = attachEntries.stream().map(e -> e.getString("attachno")).collect(Collectors.toSet());
            logger.info("\u9644\u4ef6\u5206\u5f55\u6765\u81ea\u53d1\u7968\u4e91\u9644\u4ef6\u6d41\u6c34\u53f7\uff1a" + serialNosFromEntry);
            tempDeleteAttachNo.removeAll(serialNosFromEntry);
            serialNosFromEntry.removeAll(tempDeleteAttachNo);
            serialNos.addAll(serialNosFromEntry);
        }
        return serialNos;
    }

    public static Set<String> getInvoiceAttachmentSerialNoSet(AttachmentPanel filePanel) {
        if (filePanel == null) {
            return new HashSet<String>(0);
        }
        List attachmentData = filePanel.getAttachmentData();
        Set<String> serialNos = attachmentData.stream().map(e -> ((String)e.get("uid")).replace(AttachmentCountUtils.getAttachmentUidPrefix(), "")).collect(Collectors.toSet());
        return serialNos;
    }

    private static Stream<Map<String, Object>> getInvoiceAttachments(List<Map<String, Object>> data) {
        Stream<Map<String, Object>> stream = data.stream().filter(e -> e != null && (StringUtils.startsWith((CharSequence)((String)e.get("uid")), (CharSequence)AttachmentCountUtils.getAttachmentUidPrefix()) || StringUtils.startsWith((CharSequence)((String)e.get("uid")), (CharSequence)HISTORY_PREFIX)));
        return stream;
    }
}

