/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.service.AssignQueryService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.multilang.MultiLangEnumBridge;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;

public class BaseDataUtil {
    public static Set<Long> getAvailableOrgByBaseData(String entityId, String viewType, Long pk) throws Exception {
        if (!BaseDataServiceHelper.checkBaseDataCtrl((String)entityId).booleanValue()) {
            return new HashSet<Long>(OrgUnitServiceHelper.getAllOrg((String)viewType));
        }
        DynamicObject baseDataObj = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)entityId);
        String ctrlStrategy = baseDataObj.getString("ctrlstrategy");
        if (BaseDataStrategy.GlobalShare().equals(ctrlStrategy)) {
            return BaseDataServiceHelper.getAllUseOrg((String)entityId).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        }
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            Long createOrgPk = ErCommonUtils.getPk(baseDataObj.getDynamicObject("createorg"));
            AssignQueryService service = new AssignQueryService(entityId);
            return service.assignQueryByData(entityId, Collections.singletonList(pk), createOrgPk, ctrlStrategy).keySet();
        }
        IDataEntityType dataEntityType = baseDataObj.getDataEntityType();
        String selectSql = String.format("select distinct fuseorgid from %s_u where fdataid = %s;", dataEntityType.getAlias(), pk);
        return (Set)DB.query((DBRoute)DBRoute.of((String)dataEntityType.getDBRouteKey()), (String)selectSql, rs -> {
            HashSet<Long> result = new HashSet<Long>(16);
            while (rs.next()) {
                result.add(rs.getLong("fuseorgid"));
            }
            return result;
        });
    }

    public static enum BaseDataStrategy {
        ALLOCATE_BY_LEVEL("1", new MultiLangEnumBridge("\u9010\u7ea7\u5206\u914d", "BaseDataUtil_0", "fi-er-business")),
        FREE_DISTRIBUTION("2", new MultiLangEnumBridge("\u81ea\u7531\u5206\u914d", "BaseDataUtil_1", "fi-er-business")),
        GLOBAL_SHARE("5", new MultiLangEnumBridge("\u5168\u5c40\u5171\u4eab", "BaseDataUtil_2", "fi-er-business")),
        SHARE_WITHIN_THE_CONTROL_RANGE("6", new MultiLangEnumBridge("\u7ba1\u63a7\u8303\u56f4\u5185\u5171\u4eab", "BaseDataUtil_3", "fi-er-business")),
        PRIVATE_CONTROL("7", new MultiLangEnumBridge("\u79c1\u6709", "BaseDataUtil_4", "fi-er-business"));

        private String value;
        private String desciption;

        private BaseDataStrategy(String value, MultiLangEnumBridge multiLangEnumBridge) {
            this.value = value;
            this.desciption = multiLangEnumBridge.loadKDString();
        }

        private String getValue() {
            return this.value;
        }

        public static String AllocateByLevel() {
            return ALLOCATE_BY_LEVEL.getValue();
        }

        public static String FreeDistribution() {
            return FREE_DISTRIBUTION.getValue();
        }

        public static String GlobalShare() {
            return GLOBAL_SHARE.getValue();
        }

        public static String ShareWithinTheControlRange() {
            return SHARE_WITHIN_THE_CONTROL_RANGE.getValue();
        }

        public static String PrivateControl() {
            return PRIVATE_CONTROL.getValue();
        }
    }
}

