/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.tripstd.model.TripStandardDetail;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripHighSeasonStandardUtil;
import kd.fi.er.common.ControlMethodEnum;
import kd.fi.er.common.constant.ErTripExpenseItemConstant;
import kd.fi.er.formplugin.web.tripstandard.util.TripStandardUtils;
import org.apache.commons.lang3.StringUtils;

public class CalculateTripSumUtil {
    private static HashSet<String> vehicleAttributes = Sets.newHashSet((Object[])new String[]{"2", "4", "7", "3"});
    private static HashSet<String> accommodationAttributes = Sets.newHashSet((Object[])new String[]{"5"});
    private static HashSet<String> allowanceAttributes = Sets.newHashSet((Object[])new String[]{"1"});
    private static HashSet<String> notOthers = Sets.newHashSet((Object[])new String[]{"2", "4", "7", "5", "1", "3"});
    private static Log logger = LogFactory.getLog(CalculateTripSumUtil.class);

    public static DynamicObject calculate(DynamicObject bill, IFormView view) {
        Long companyId = ErCommonUtils.getPk(bill.get("company"));
        companyId = companyId == null ? Long.valueOf(0L) : companyId;
        boolean sumcheck = SystemParamterUtil.getTripStdNeedSumCheck(companyId);
        boolean tripStdNeedOnlySumCheck = SystemParamterUtil.getTripStdNeedOnlySumCheck(companyId);
        boolean isEnableStandard = CalculateTripSumUtil.isEnableStandard(companyId);
        boolean isEnableAccdAllowance = CalculateTripSumUtil.isEnableAccdAllowance(companyId);
        boolean enableAccdAllowanceStd = isEnableStandard && isEnableAccdAllowance;
        boolean highSeason = isEnableStandard && isEnableAccdAllowance && CalculateTripSumUtil.isOpenHighSeasonStd(companyId);
        boolean enableVehicleStd = CalculateTripSumUtil.isEnableStandard(companyId) && CalculateTripSumUtil.isEnableVehicle(companyId);
        CurrencyBO currencyBO = new CurrencyBO(ErCommonUtils.getPk(bill.get("currency")));
        String billKind = bill.getString("billkind");
        DynamicObjectCollection tripEntryCollction = bill.getDynamicObjectCollection("tripentry");
        for (int tripEntryIndex = 0; tripEntryIndex < tripEntryCollction.size(); ++tripEntryIndex) {
            DynamicObject tripEntry = (DynamicObject)tripEntryCollction.get(tripEntryIndex);
            BigDecimal tripvehicleamount = BigDecimal.ZERO;
            BigDecimal tripaccommodationamount = BigDecimal.ZERO;
            BigDecimal tripallowanceamount = BigDecimal.ZERO;
            BigDecimal tripotheramount = BigDecimal.ZERO;
            BigDecimal tripaccommodationover = BigDecimal.ZERO;
            BigDecimal tripallowanceover = BigDecimal.ZERO;
            String tripvehicleover = "0";
            ArrayList<String> groupby = new ArrayList<String>(4);
            DynamicObjectCollection detailEntryCollction = tripEntry.getDynamicObjectCollection("entryentity");
            for (int detailEntryIndex = 0; detailEntryIndex < detailEntryCollction.size(); ++detailEntryIndex) {
                String attribute;
                DynamicObject detailEntry = (DynamicObject)detailEntryCollction.get(detailEntryIndex);
                DynamicObject expenseItem = (DynamicObject)detailEntry.get("expenseitem");
                String string = attribute = expenseItem == null ? "" : expenseItem.getString("attribute");
                if (expenseItem != null && vehicleAttributes.contains(attribute)) {
                    tripvehicleamount = tripvehicleamount.add(detailEntry.getBigDecimal("entryappamount"));
                    if (!Arrays.asList("2", "4", "7").contains(attribute) || !enableVehicleStd || !"1".equals(detailEntry.getString("isover"))) continue;
                    tripvehicleover = "1";
                    continue;
                }
                RefObject refObject = new RefObject((Object)BigDecimal.ZERO);
                boolean isover = detailEntry.getBoolean("isover");
                boolean over = detailEntry.getBoolean("isover");
                if (enableAccdAllowanceStd && (accommodationAttributes.contains(attribute) || allowanceAttributes.contains(attribute))) {
                    if (!tripStdNeedOnlySumCheck) {
                        CalculateTripSumUtil.checkAccdAllowanceEntryStdIsOver(companyId, detailEntry, tripEntryIndex, detailEntryIndex, currencyBO.getPrecision(), highSeason, (RefObject<BigDecimal>)refObject);
                    }
                    if (sumcheck && !"1".equals(billKind) && over) {
                        if (!groupby.contains(TripStandardUtils.fetchGroupKey(detailEntry, "expenseitem", "entrycurrency"))) {
                            if (!detailEntry.getBoolean("useroutstdctrl")) {
                                CalculateTripSumUtil.checkSumGroupStdIsOver(bill, detailEntry, detailEntryCollction, tripEntryIndex, detailEntryIndex, currencyBO.getPrecision(), (RefObject<BigDecimal>)refObject, "expenseitem", "entrycurrency");
                                groupby.add(TripStandardUtils.fetchGroupKey(detailEntry, "expenseitem", "entrycurrency"));
                            }
                        } else {
                            refObject = new RefObject((Object)BigDecimal.ZERO);
                        }
                    }
                }
                if (expenseItem == null || !notOthers.contains(attribute)) {
                    tripotheramount = tripotheramount.add(detailEntry.getBigDecimal("entryappamount"));
                    continue;
                }
                if (accommodationAttributes.contains(attribute)) {
                    tripaccommodationamount = tripaccommodationamount.add(detailEntry.getBigDecimal("entryappamount"));
                    if (tripStdNeedOnlySumCheck && over) {
                        tripaccommodationover = tripaccommodationover.add((BigDecimal)refObject.getValue());
                        continue;
                    }
                    if (!isover && !over) continue;
                    tripaccommodationover = tripaccommodationover.add((BigDecimal)refObject.getValue());
                    continue;
                }
                if (!allowanceAttributes.contains(attribute)) continue;
                tripallowanceamount = tripallowanceamount.add(detailEntry.getBigDecimal("entryappamount"));
                if (tripStdNeedOnlySumCheck && over) {
                    tripallowanceover = tripallowanceover.add((BigDecimal)refObject.getValue());
                    continue;
                }
                if (!isover && !over) continue;
                tripallowanceover = tripallowanceover.add((BigDecimal)refObject.getValue());
            }
            if (view != null && !(view instanceof IMobileView)) {
                view.getModel().setValue("tripvehicleamount", (Object)tripvehicleamount, tripEntryIndex);
                view.getModel().setValue("tripvehicleover", (Object)tripvehicleover, tripEntryIndex);
                view.getModel().setValue("tripaccommodationamt", (Object)tripaccommodationamount, tripEntryIndex);
                view.getModel().setValue("tripaccommodationover", (Object)tripaccommodationover, tripEntryIndex);
                view.getModel().setValue("tripallowanceamount", (Object)tripallowanceamount, tripEntryIndex);
                view.getModel().setValue("tripallowanceover", (Object)tripallowanceover, tripEntryIndex);
                view.getModel().setValue("tripotheramount", (Object)tripotheramount, tripEntryIndex);
            }
            tripEntry.set("tripvehicleamount", (Object)tripvehicleamount);
            tripEntry.set("tripvehicleover", (Object)tripvehicleover);
            tripEntry.set("tripaccommodationamt", (Object)tripaccommodationamount);
            tripEntry.set("tripaccommodationover", (Object)tripaccommodationover);
            tripEntry.set("tripallowanceamount", (Object)tripallowanceamount);
            tripEntry.set("tripallowanceover", (Object)tripallowanceover);
            tripEntry.set("tripotheramount", (Object)tripotheramount);
        }
        return bill;
    }

    public static void setTripOver(DynamicObject bill, IFormView view, int tripEntryIndex) {
        Long companyId = ErCommonUtils.getPk(bill.get("company"));
        if (companyId == null) {
            return;
        }
        boolean sumcheck = false;
        boolean tripStdNeedOnlySumCheck = false;
        Object tripstdsummarycheck = ErCommonUtils.getEMParameter(companyId, "tripstdsummarycheck");
        if ("yes".equals(tripstdsummarycheck) || "onlytrip".equals(tripstdsummarycheck)) {
            sumcheck = true;
        }
        if ("onlytrip".equals(tripstdsummarycheck)) {
            tripStdNeedOnlySumCheck = true;
        }
        boolean isEnableStandard = CalculateTripSumUtil.isEnableStandard(companyId);
        boolean isEnableAccdAllowance = CalculateTripSumUtil.isEnableAccdAllowance(companyId);
        boolean enableAccdAllowanceStd = isEnableStandard && isEnableAccdAllowance;
        boolean highSeason = isEnableStandard && isEnableAccdAllowance && CalculateTripSumUtil.isOpenHighSeasonStd(companyId);
        CurrencyBO currencyBO = new CurrencyBO(ErCommonUtils.getPk(bill.get("currency")));
        String billKind = bill.getString("billkind");
        DynamicObjectCollection tripEntryCollction = bill.getDynamicObjectCollection("tripentry");
        if (tripEntryCollction == null || tripEntryCollction.size() < 1) {
            return;
        }
        DynamicObject tripEntry = (DynamicObject)tripEntryCollction.get(tripEntryIndex);
        BigDecimal tripaccommodationamount = BigDecimal.ZERO;
        BigDecimal tripallowanceamount = BigDecimal.ZERO;
        BigDecimal tripaccommodationover = BigDecimal.ZERO;
        BigDecimal tripallowanceover = BigDecimal.ZERO;
        String tripvehicleover = "0";
        ArrayList<String> groupby = new ArrayList<String>(4);
        DynamicObjectCollection detailEntryCollction = tripEntry.getDynamicObjectCollection("entryentity");
        for (int detailEntryIndex = 0; detailEntryIndex < detailEntryCollction.size(); ++detailEntryIndex) {
            DynamicObject detailEntry = (DynamicObject)detailEntryCollction.get(detailEntryIndex);
            DynamicObject expenseItem = (DynamicObject)detailEntry.get("expenseitem");
            String attribute = expenseItem == null ? "" : expenseItem.getString("attribute");
            RefObject refObject = new RefObject((Object)BigDecimal.ZERO);
            boolean isover = detailEntry.getBoolean("isover");
            boolean over = detailEntry.getBoolean("isover");
            if (enableAccdAllowanceStd && (accommodationAttributes.contains(attribute) || allowanceAttributes.contains(attribute))) {
                if (!tripStdNeedOnlySumCheck) {
                    CalculateTripSumUtil.checkAccdAllowanceEntryStdIsOver(companyId, detailEntry, tripEntryIndex, detailEntryIndex, currencyBO.getPrecision(), highSeason, (RefObject<BigDecimal>)refObject);
                }
                if (sumcheck && !"1".equals(billKind) && over) {
                    if (!groupby.contains(TripStandardUtils.fetchGroupKey(detailEntry, "expenseitem", "entrycurrency"))) {
                        if (!detailEntry.getBoolean("useroutstdctrl")) {
                            CalculateTripSumUtil.checkSumGroupStdIsOver(bill, detailEntry, detailEntryCollction, tripEntryIndex, detailEntryIndex, currencyBO.getPrecision(), (RefObject<BigDecimal>)refObject, "expenseitem", "entrycurrency");
                            groupby.add(TripStandardUtils.fetchGroupKey(detailEntry, "expenseitem", "entrycurrency"));
                        }
                    } else {
                        refObject = new RefObject((Object)BigDecimal.ZERO);
                    }
                }
            }
            if (expenseItem == null || !notOthers.contains(attribute)) continue;
            if (accommodationAttributes.contains(attribute)) {
                tripaccommodationamount = tripaccommodationamount.add(detailEntry.getBigDecimal("entryappamount"));
                if (tripStdNeedOnlySumCheck && over) {
                    tripaccommodationover = tripaccommodationover.add((BigDecimal)refObject.getValue());
                    continue;
                }
                if (!isover && !over) continue;
                tripaccommodationover = tripaccommodationover.add((BigDecimal)refObject.getValue());
                continue;
            }
            if (!allowanceAttributes.contains(attribute)) continue;
            tripallowanceamount = tripallowanceamount.add(detailEntry.getBigDecimal("entryappamount"));
            if (tripStdNeedOnlySumCheck && over) {
                tripallowanceover = tripallowanceover.add((BigDecimal)refObject.getValue());
                continue;
            }
            if (!isover && !over) continue;
            tripallowanceover = tripallowanceover.add((BigDecimal)refObject.getValue());
        }
        if (view != null && !(view instanceof IMobileView)) {
            view.getModel().setValue("tripaccommodationamt", (Object)tripaccommodationamount, tripEntryIndex);
            view.getModel().setValue("tripaccommodationover", (Object)tripaccommodationover, tripEntryIndex);
            view.getModel().setValue("tripallowanceamount", (Object)tripallowanceamount, tripEntryIndex);
            view.getModel().setValue("tripallowanceover", (Object)tripallowanceover, tripEntryIndex);
        }
        tripEntry.set("tripaccommodationamt", (Object)tripaccommodationamount);
        tripEntry.set("tripaccommodationover", (Object)tripaccommodationover);
        tripEntry.set("tripallowanceamount", (Object)tripallowanceamount);
        tripEntry.set("tripallowanceover", (Object)tripallowanceover);
    }

    public static void setTripSumLabel(IFormView view, int tripEntryIndex) {
        String billKind = view.getModel().getDataEntity().getString("billkind");
        DynamicObjectCollection tripCollection = view.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        if ("0".equals(billKind) && tripCollection.size() > 0 && !(view instanceof IMobileView)) {
            CurrencyBO currencyBO = new CurrencyBO(ErCommonUtils.getPk(view.getModel().getDataEntity().get("currency")));
            Format moneyFormatter = AmountUtils.getMoneyFormatter(RequestContext.get().getCurrUserId(), currencyBO.getSymbol(), currencyBO.getPrecision());
            for (String key : Arrays.asList("tripvehicleamount", "tripaccommodationamt", "tripaccommodationover", "tripallowanceamount", "tripallowanceover", "tripotheramount", "tripappnottaxamount")) {
                BigDecimal amount = (BigDecimal)view.getModel().getValue(key, tripEntryIndex);
                CalculateTripSumUtil.setTripLabelValue(view, key, amount, moneyFormatter);
            }
            String msg = ResManager.loadKDString((String)"\u662f", (String)"CalculateTripSumUtil_0", (String)"fi-er-business", (Object[])new Object[0]);
            if (view.getModel().getValue("tripvehicleover", tripEntryIndex) instanceof Boolean && ((Boolean)view.getModel().getValue("tripvehicleover", tripEntryIndex)).booleanValue()) {
                CalculateTripSumUtil.setLabelColor(view, "tripvehicleover", "#FF0000");
            } else {
                msg = ResManager.loadKDString((String)"\u5426", (String)"CalculateTripSumUtil_1", (String)"fi-er-business", (Object[])new Object[0]);
                CalculateTripSumUtil.setLabelColor(view, "tripvehicleover", "#999999");
            }
            Label tripVehicleOver = (Label)view.getControl("labvtripvehicleover");
            if (tripVehicleOver != null) {
                tripVehicleOver.setText(msg);
            }
            CalculateTripSumUtil.setLabelTripdeductibletax(view, tripEntryIndex);
            CalculateTripSumUtil.setLabelTripappnottaxamount(view, tripEntryIndex);
        }
    }

    private static void setLabelColor(IFormView view, String tripVehicleover, String color) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fc", color);
        view.updateControlMetadata("labv" + tripVehicleover, map);
    }

    private static void setTripLabelValue(IFormView view, String key, BigDecimal amount, Format moneyFormatter) {
        if (amount == null) {
            return;
        }
        Label label = (Label)view.getControl("labv" + key);
        if (label == null) {
            return;
        }
        String text = moneyFormatter.format(amount);
        label.setText(text);
        if (Arrays.asList("tripaccommodationover", "tripallowanceover").contains(key)) {
            if (amount.compareTo(BigDecimal.ZERO) > 0) {
                CalculateTripSumUtil.setLabelColor(view, key, "#FF0000");
            } else {
                CalculateTripSumUtil.setLabelColor(view, key, "#999999");
            }
        }
    }

    public static void setLabelTripappnottaxamount(IFormView view, int tripEntryIndex) {
        if (view instanceof IMobileView) {
            return;
        }
        Label labtripappnottaxamount = (Label)view.getControl("labvtripappnottaxamount");
        if (labtripappnottaxamount == null) {
            return;
        }
        DynamicObject currency = (DynamicObject)view.getModel().getValue("currency");
        int amtprecision = CalculateTripSumUtil.getAmtprecision(currency);
        BigDecimal val = (BigDecimal)view.getModel().getValue("tripappnottaxamount", tripEntryIndex);
        val = val == null ? BigDecimal.ZERO : val;
        labtripappnottaxamount.setText(AmountFormatsUtil.getLabelAmountAfterFormat(currency == null ? "" : currency.getString("sign"), val, amtprecision));
    }

    private static int getAmtprecision(DynamicObject currency) {
        int amtprecision = 0;
        if (currency != null) {
            amtprecision = currency.getInt("amtprecision");
        }
        if (amtprecision < 0 || amtprecision > 10) {
            amtprecision = 2;
        }
        return amtprecision;
    }

    public static void setLabelTripdeductibletax(IFormView view, int tripEntryIndex) {
        if (view instanceof IMobileView) {
            return;
        }
        Label taxamounttotalori = (Label)view.getControl("labvtripdeductibletax");
        if (taxamounttotalori == null) {
            return;
        }
        BigDecimal val = (BigDecimal)view.getModel().getValue("tripdeductibletax", tripEntryIndex);
        if (val == null) {
            val = BigDecimal.ZERO;
        }
        DynamicObject tripcurrency = (DynamicObject)view.getModel().getValue("tripcurrency", tripEntryIndex);
        int amtprecision = CalculateTripSumUtil.getAmtprecision(tripcurrency);
        taxamounttotalori.setText(AmountFormatsUtil.getLabelAmountAfterFormat(val, amtprecision));
    }

    public static void calculateAppnotaxamount(IFormView view, int tripEntryIndex) {
        DynamicObject tripEntry = (DynamicObject)view.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(tripEntryIndex);
        BigDecimal val = AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)tripEntry.getDynamicObjectCollection("entryentity"), "curprice");
        view.getModel().setValue("tripappnottaxamount", (Object)val, tripEntryIndex);
    }

    private static boolean checkAccdAllowanceEntryStdIsOver(Long companyId, DynamicObject entry, int parentEntryIndex, int curEntryIndex, int amtprecision, boolean highSeason, RefObject<BigDecimal> refObject) {
        boolean isOverStd = false;
        boolean isCancelOrder = entry.getBoolean("iscancelorder");
        BigDecimal oriEntryAmount = entry.getBigDecimal("entryappamount");
        boolean userOutStdCtrl = entry.getBoolean("useroutstdctrl");
        BigDecimal oriMaxStdAmount = TripHighSeasonStandardUtil.getStandardamountTotal(highSeason, entry);
        oriMaxStdAmount = CalculateTripSumUtil.getCurrencyAmount(entry, amtprecision, oriMaxStdAmount);
        if (!userOutStdCtrl && !isCancelOrder && oriEntryAmount.compareTo(oriMaxStdAmount) > 0) {
            isOverStd = true;
            refObject.setValue((Object)oriEntryAmount.subtract(oriMaxStdAmount));
        }
        return isOverStd;
    }

    private static BigDecimal getCurrencyAmount(DynamicObject entry, int precision, BigDecimal oriMaxStdAmount) {
        BigDecimal stdexchangerate = entry.getBigDecimal("stdexchangerate");
        if (precision < 0 || precision > 10) {
            precision = 2;
        }
        if ("0".equals(entry.getString("stdexpquotetype"))) {
            oriMaxStdAmount = oriMaxStdAmount.multiply(stdexchangerate).setScale(precision, RoundingMode.HALF_UP);
        } else if (stdexchangerate.compareTo(BigDecimal.ZERO) != 0) {
            oriMaxStdAmount = oriMaxStdAmount.divide(stdexchangerate, precision, RoundingMode.HALF_UP);
        }
        return oriMaxStdAmount;
    }

    private static boolean checkSumGroupStdIsOver(DynamicObject tripObject, DynamicObject entryObject, DynamicObjectCollection entryColl, int cardIndex, int rowIndex, int amtprecision, RefObject<BigDecimal> refObject, String ... groupPrppertyName) {
        boolean isOver = false;
        if (entryObject == null || entryColl == null || entryColl.isEmpty() || ArrayUtils.isEmpty((Object[])groupPrppertyName)) {
            return isOver;
        }
        Map<String, List<DynamicObject>> sumGroupEntry = entryColl.stream().collect(Collectors.groupingBy(entry -> TripStandardUtils.fetchGroupKey(entry, groupPrppertyName)));
        List entryOfGroup = sumGroupEntry.getOrDefault(TripStandardUtils.fetchGroupKey(entryObject, groupPrppertyName), new ArrayList());
        BigDecimal sumStdAmount = BigDecimal.ZERO;
        BigDecimal sumReimAmount = BigDecimal.ZERO;
        DynamicObject tripExp = entryObject.getDynamicObject("expenseitem");
        if (tripExp != null) {
            BigDecimal daycount = BigDecimal.valueOf(entryObject.getInt("daycount"));
            String attributeType = tripExp.getString("attribute");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)attributeType)) {
                daycount = daycount.add(CalculateTripSumUtil.getTripDelayDay(cardIndex, rowIndex, tripObject));
            }
            Long companyId = ErCommonUtils.getPk(tripObject.get("company"));
            BigDecimal highSeasonDays = CalculateTripSumUtil.getTripHighDays(entryObject, companyId);
            if (!entryOfGroup.isEmpty()) {
                TripStandardDetail tripStdDetail;
                DynamicObjectCollection travelers = ((DynamicObject)entryObject.getParent()).getDynamicObjectCollection("travelers");
                List<Long> userIds = travelers.stream().filter(traveler -> traveler.get("fbasedataid") != null).map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toList());
                String mulTraStdCtrType = SystemParamterUtil.getMultiTravelerStdControlType(companyId);
                HashMap<String, Object> expMap = new HashMap<String, Object>();
                expMap.put("applyCompany", tripObject.get("company"));
                if (TripStandardUtils.overrideGetAccmodationStd()) {
                    expMap.put("view", null);
                    expMap.put("bill", tripObject);
                    expMap.put("parentIndex", cardIndex);
                    expMap.put("index", rowIndex);
                    expMap.put("entry", entryObject);
                }
                if ((tripStdDetail = CalculateTripSumUtil.getSumGroupStd(expMap, userIds, entryObject, mulTraStdCtrType)) != null) {
                    BigDecimal tripSTDAmount = tripStdDetail.getStandardamount();
                    BigDecimal highSeasonTripSTDAmount = tripStdDetail.getHighSeasonStandardamount();
                    String attribute = entryObject.getDynamicObject("expenseitem").getString("attribute");
                    if ("5".equals(attribute) && "max".equals(mulTraStdCtrType)) {
                        tripSTDAmount = tripSTDAmount.multiply(BigDecimal.valueOf(userIds.size()));
                        highSeasonTripSTDAmount = highSeasonTripSTDAmount.multiply(BigDecimal.valueOf(userIds.size()));
                    }
                    sumStdAmount = sumStdAmount.add(tripSTDAmount.multiply(daycount.subtract(highSeasonDays))).add(highSeasonTripSTDAmount.multiply(highSeasonDays));
                }
                for (DynamicObject entry2 : entryOfGroup) {
                    sumReimAmount = sumReimAmount.add(entry2.getBigDecimal("entryappamount"));
                }
            }
            if (sumReimAmount.compareTo(sumStdAmount = CalculateTripSumUtil.getCurrencyAmount(entryObject, amtprecision, sumStdAmount)) > 0) {
                isOver = true;
                refObject.setValue((Object)sumReimAmount.subtract(sumStdAmount));
            }
        }
        return isOver;
    }

    private static boolean isOpenTripDateControl(DynamicObject tripObject) {
        return SystemParamterUtil.isOpenTripDateControl(ErCommonUtils.getPk(tripObject.get("company"))) && (!tripObject.getBoolean("istravelers") || tripObject.getBoolean("istravelers") && tripObject.getBoolean("travelerssamestd")) && tripObject.getBoolean("isopentripstd");
    }

    private static BigDecimal getTripDelayDay(int cardIndex, int rowIndex, DynamicObject tripObject) {
        Long companyId = ErCommonUtils.getPk(tripObject.get("company"));
        String billKind = tripObject.getString("billkind");
        DynamicObjectCollection mainPageTripEntry = tripObject.getDynamicObjectCollection("tripentry");
        DynamicObjectCollection tripEntry = tripObject.getDynamicObjectCollection("tripentry");
        DynamicObjectCollection detailEntry = ((DynamicObject)tripEntry.get(cardIndex)).getDynamicObjectCollection("entryentity");
        DynamicObject curRow = (DynamicObject)detailEntry.get(rowIndex);
        if (curRow.getDynamicObject("expenseitem") == null || !StringUtils.equals((CharSequence)ErTripExpenseItemConstant.Attribute.Subsidy.getValue(), (CharSequence)curRow.getDynamicObject("expenseitem").getString("attribute"))) {
            return BigDecimal.ZERO;
        }
        if (!CalculateTripSumUtil.isOpenTripDateControl(tripObject)) {
            return TripHighSeasonStandardUtil.getDelayDay(companyId);
        }
        switch (billKind) {
            case "0": {
                if (cardIndex == 0) {
                    return TripHighSeasonStandardUtil.getDelayDay(companyId);
                }
                Date preTripEndDay = ((DynamicObject)mainPageTripEntry.get(cardIndex - 1)).getDate("enddate");
                Date curTripStartDay = ((DynamicObject)tripEntry.get(cardIndex)).getDate("startdate");
                if (preTripEndDay != null && curTripStartDay != null && preTripEndDay.getTime() != curTripStartDay.getTime()) {
                    return TripHighSeasonStandardUtil.getDelayDay(companyId);
                }
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    private static BigDecimal getTripHighDays(DynamicObject entry, Long companyId) {
        if (!SystemParamterUtil.isEnableTripStandard(companyId) || !SystemParamterUtil.isEnableHighSeasonTripStandard(companyId) || SystemParamterUtil.getTripStandardControlLevel(companyId) == ControlMethodEnum.NO_CONTROL) {
            return BigDecimal.ZERO;
        }
        return entry.getBigDecimal("originhighseasondays");
    }

    private static TripStandardDetail getSumGroupStd(Map<String, Object> expMap, List<Long> userIds, DynamicObject entryObject, String mulTraStdCtrType) {
        if (userIds == null || userIds.size() == 0) {
            return null;
        }
        DynamicObject entryCurrency = entryObject.getDynamicObject("entrycurrency");
        DynamicObject tripArea = entryObject.getDynamicObject("triparea");
        DynamicObject expenseItem = entryObject.getDynamicObject("expenseitem");
        if (tripArea == null || (Long)tripArea.getPkValue() == 0L) {
            tripArea = ((DynamicObject)entryObject.getParent()).getDynamicObject("tripentryarea");
        }
        TripStandardDetail tripStdDetail = null;
        DynamicObject parent = (DynamicObject)((DynamicObject)entryObject.getParent()).getParent();
        TripStandardUtils.threadLocal.set("CalculateTripSumUtil" + parent.get("billno"));
        if (entryCurrency != null && tripArea != null) {
            List<TripStandardDetail> tripStdDetailList = TripStandardUtils.getAccmodationStdFromPageCache(userIds, null, mulTraStdCtrType, entryCurrency.getPkValue(), tripArea.getPkValue(), expenseItem, expMap);
            tripStdDetail = tripStdDetailList == null || tripStdDetailList.isEmpty() ? null : tripStdDetailList.get(0);
            String logStr = "billNo:%s,CalculateTripSumUtil_user :%s,company:%s,currency:%s,area:%s,expenseitem:%s-----------result=%s";
            logger.info(String.format(logStr, parent.get("billno"), JSONObject.toJSONString(userIds), expMap.get("applyCompany") != null ? ((DynamicObject)expMap.get("applyCompany")).getPkValue() : "null", entryCurrency.getPkValue(), tripArea.getPkValue(), expenseItem.getPkValue(), JSONObject.toJSONString((Object)tripStdDetail)));
        }
        logger.info(TripStandardUtils.threadLocal.get() + JSONObject.toJSONString(tripStdDetail));
        TripStandardUtils.threadLocal.remove();
        return tripStdDetail;
    }

    private static boolean isEnableStandard(Long companyId) {
        return SystemParamterUtil.isEnableTripStandard(companyId);
    }

    private static boolean isEnableAccdAllowance(Long companyId) {
        return SystemParamterUtil.getTripStandardControlLevel(companyId) != ControlMethodEnum.NO_CONTROL;
    }

    private static boolean isEnableVehicle(Long companyId) {
        return SystemParamterUtil.getVehicleStdControlLevel(companyId) != ControlMethodEnum.NO_CONTROL;
    }

    private static boolean isOpenHighSeasonStd(Long companyId) {
        return SystemParamterUtil.isEnableHighSeasonTripStandard(companyId);
    }
}

