/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.EntityTypeEnum;

public class CheckExchangerateUtil {
    private static final HashMap<Object, List<ExchangerateEntry>> map = new HashMap(18);

    public static boolean checkExchangerate(DynamicObject company, DynamicObject costCompany, DynamicObject currency, Object entryCurrency) {
        if (entryCurrency != null && currency != null && company != null) {
            BigDecimal exchangeRate;
            Long targetCurrencyId = (Long)currency.getPkValue();
            Long exrateTableId = BaseCurrencyServiceHelper.getExrateTableId(company.getPkValue(), costCompany);
            Map exchangeRateMap = new HashMap(2);
            if (exrateTableId != null) {
                exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)ErCommonUtils.getPk(entryCurrency), (Long)targetCurrencyId, (Long)exrateTableId, (Date)new Date());
            }
            if ((exchangeRate = (BigDecimal)exchangeRateMap.get("exchangeRate")) == null || BigDecimal.ZERO.compareTo(exchangeRate) == 0) {
                return true;
            }
        }
        return false;
    }

    public static List<String> checkExchangetate(DynamicObject dynamicObject) {
        ArrayList<String> messages = new ArrayList<String>(1);
        IDataEntityProperty property = (IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get((Object)"currency");
        if (property == null) {
            return messages;
        }
        Long currency = ErCommonUtils.getPk(property.getValueFast((Object)dynamicObject));
        if (currency == null) {
            return messages;
        }
        ErrorMsgMap r = new ErrorMsgMap(4);
        List<ExchangerateEntry> list = CheckExchangerateUtil.getExchangerate(dynamicObject.getDataEntityType().getName());
        for (ExchangerateEntry entry : list) {
            String[] entryNames;
            DynamicObjectCollection entryCollection;
            if (ErEntityTypeUtils.isTripReimburseBill(dynamicObject.getDataEntityType().getName()) && "1".equals(dynamicObject.getString("billkind")) && entry.getEntryName().equals("tripentry") || (entryCollection = dynamicObject.getDynamicObjectCollection((entryNames = entry.getEntryName().split("\\."))[0])).size() == 0) continue;
            if (entryNames.length > 1 && ((DynamicObject)entryCollection.get(0)).getDataEntityType().getProperties().stream().filter(e -> e instanceof EntryProp).findFirst().isPresent()) {
                for (DynamicObject d : entryCollection) {
                    DynamicObjectCollection collection = d.getDynamicObjectCollection(entryNames[1]);
                    if (collection.size() == 0) continue;
                    IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)collection.get(0)).getDataEntityType().getProperties().get((Object)entry.getPropertyName());
                    IDataEntityProperty currencyProperty = (IDataEntityProperty)((DynamicObject)collection.get(0)).getDataEntityType().getProperties().get((Object)entry.getEntryCurrency());
                    RefObject refObject = new RefObject();
                    Map<Integer, Set<String>> result = CheckExchangerateUtil.checkExchangerate(currency, d.getDynamicObjectCollection(entryNames[1]), dataEntityProperty, currencyProperty, refObject);
                    for (Map.Entry<Integer, Set<String>> e2 : result.entrySet()) {
                        r.put(e2.getKey(), e2.getValue());
                    }
                }
                continue;
            }
            IDataEntityProperty dataEntityProperty = (IDataEntityProperty)((DynamicObject)entryCollection.get(0)).getDataEntityType().getProperties().get((Object)entry.getPropertyName());
            IDataEntityProperty currencyProperty = (IDataEntityProperty)((DynamicObject)entryCollection.get(0)).getDataEntityType().getProperties().get((Object)entry.getEntryCurrency());
            RefObject refObject = new RefObject();
            Map<Integer, Set<String>> result = CheckExchangerateUtil.checkExchangerate(currency, entryCollection, dataEntityProperty, currencyProperty, refObject);
            for (Map.Entry<Integer, Set<String>> e3 : result.entrySet()) {
                r.put(e3.getKey(), e3.getValue());
            }
        }
        StringBuilder sb = CheckExchangerateUtil.getErrorMsg(r);
        if (sb.length() > 0) {
            sb.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"CheckExchangerateUtil_1", (String)"fi-er-business", (Object[])new Object[0]));
            messages.add(sb.toString());
        }
        return messages;
    }

    private static StringBuilder getErrorMsg(Map<Integer, Set<String>> result) {
        StringBuilder sb = new StringBuilder();
        if (result.get(0) != null && result.get(0).size() > 0) {
            sb.append(String.join((CharSequence)"\u3001", result.get(0).toArray(new String[0])));
            sb.append(String.format(ResManager.loadKDString((String)"\u6c47\u7387\u4e3a%s", (String)"CheckExchangerateUtil_2", (String)"fi-er-business", (Object[])new Object[0]), 0));
        }
        if (result.get(1) != null && result.get(1).size() > 0) {
            sb.append(String.join((CharSequence)"\u3001", result.get(1).toArray(new String[0])));
            sb.append(String.format(ResManager.loadKDString((String)"\u6c47\u7387\u4e3a%s", (String)"CheckExchangerateUtil_2", (String)"fi-er-business", (Object[])new Object[0]), 1));
        }
        if (sb.length() > 0) {
            sb.append("\uff0c");
        }
        return sb;
    }

    private static Map<Integer, Set<String>> checkExchangerate(Long currency, DynamicObjectCollection collection, IDataEntityProperty rateProperty, IDataEntityProperty currencyProperty, RefObject refObject) {
        ErrorMsgMap result = new ErrorMsgMap(2);
        if (rateProperty == null || currencyProperty == null) {
            return result;
        }
        HashSet<String> zero = new HashSet<String>(2);
        for (DynamicObject dynamicObject : collection) {
            Object rate = rateProperty.getValueFast((Object)dynamicObject);
            Long entryCurrency = ErCommonUtils.getPk(currencyProperty.getValueFast((Object)dynamicObject));
            if (entryCurrency == null || entryCurrency.equals(currency) || rate == null || BigDecimal.ZERO.compareTo((BigDecimal)rate) != 0) continue;
            zero.add(CheckExchangerateUtil.getCurrencyName(entryCurrency));
        }
        if (zero.size() > 0) {
            result.put(0, zero);
        }
        return result;
    }

    private static String getCurrencyName(Long entryCurrency) {
        DynamicObject entryCur = QueryServiceHelper.queryOne((String)"bd_currency", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)entryCurrency)});
        if (entryCur != null) {
            return entryCur.getString("name");
        }
        return "";
    }

    public static List<ExchangerateEntry> getExchangerate(String entityId) {
        EntityTypeEnum entityTypeEnum = ErEntityTypeUtils.getEntityType(entityId);
        return map.get(entityTypeEnum) == null ? new ArrayList() : map.get(entityTypeEnum);
    }

    static {
        ExchangerateEntry accountentry = new ExchangerateEntry("accountentry", "accexchangerate", "accountcurrency");
        ExchangerateEntry tripentry = new ExchangerateEntry("tripentry", "tripexchangerate", "tripcurrency");
        ExchangerateEntry expenseentryentity = new ExchangerateEntry("expenseentryentity", "exchangerate", "entrycurrency");
        ExchangerateEntry entry = new ExchangerateEntry("tripentry.entryentity", "exchangerate", "entrycurrency");
        ArrayList<ExchangerateEntry> tripList = new ArrayList<ExchangerateEntry>(2);
        tripList.add(accountentry);
        tripList.add(tripentry);
        map.put(EntityTypeEnum.TRIPREQBILL, tripList);
        ArrayList<ExchangerateEntry> tripreimburseList = new ArrayList<ExchangerateEntry>(3);
        tripreimburseList.add(accountentry);
        tripreimburseList.add(tripentry);
        tripreimburseList.add(entry);
        map.put(EntityTypeEnum.TRIPREIMBURSEBILL, tripreimburseList);
        map.put(EntityTypeEnum.DAILYAPPLYBILL, Collections.singletonList(expenseentryentity));
        ArrayList<ExchangerateEntry> dailyLoanBill = new ArrayList<ExchangerateEntry>(2);
        dailyLoanBill.add(accountentry);
        dailyLoanBill.add(expenseentryentity);
        map.put(EntityTypeEnum.DAILYLOANBILL, dailyLoanBill);
        map.put(EntityTypeEnum.DAILYREIMBURSEBILL, dailyLoanBill);
        ExchangerateEntry assetentry = new ExchangerateEntry("assetentry", "assetexchangerate", "assetcurrency");
        ArrayList<ExchangerateEntry> list = new ArrayList<ExchangerateEntry>(3);
        list.addAll(dailyLoanBill);
        list.add(assetentry);
        map.put(EntityTypeEnum.PUBLICREIMBURSEBILL, list);
        ArrayList<ExchangerateEntry> repaymentList = new ArrayList<ExchangerateEntry>(2);
        repaymentList.add(new ExchangerateEntry("repaymententry", "repayexchangerate", "accountcurrency"));
        map.put(EntityTypeEnum.REPAYMENTBILL, repaymentList);
        map.put(EntityTypeEnum.PREPAYBILL, dailyLoanBill);
        map.put(EntityTypeEnum.APPLYPROJECTBILL, Collections.singletonList(expenseentryentity));
        map.put(EntityTypeEnum.WITHHOLDINGBILL, Collections.singletonList(expenseentryentity));
        map.put(EntityTypeEnum.ER_APPLYPAYBILL, dailyLoanBill);
        map.put(EntityTypeEnum.COSTESTIMATEBILL, Collections.singletonList(expenseentryentity));
        map.put(EntityTypeEnum.EXPENSESHAREBILL, Collections.singletonList(expenseentryentity));
    }

    private static class ErrorMsgMap
    extends HashMap {
        public ErrorMsgMap(int c) {
            super(c);
        }

        @Override
        public Object put(Object key, Object value) {
            Object v = this.get(key);
            if (v instanceof Set && value instanceof HashSet) {
                ((Set)v).addAll((Collection)value);
            } else {
                super.put(key, value);
            }
            return value;
        }
    }

    static class ExchangerateEntry {
        private String entryName;
        private String propertyName;
        private String entryCurrency;

        public ExchangerateEntry(String entryName, String propertyName, String entryCurrency) {
            this.entryName = entryName;
            this.propertyName = propertyName;
            this.entryCurrency = entryCurrency;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getEntryCurrency() {
            return this.entryCurrency;
        }
    }
}

