/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.ais.model.ShowBillFormData;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.form.FormService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.QueryInvoiceDetailBO;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.utils.MD5;

public class ErAIUtils {
    private static final Log logger = LogFactory.getLog(ErAIUtils.class);

    public static IFormView getView(String formId) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("formId", formId);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(mapParam);
        IFormView personView = parameter.createViewForWebApi();
        personView.initialize(parameter);
        return personView;
    }

    public static IDataModel getModel(IFormView view, Long fid) {
        IBillModel personModel = (IBillModel)view.getModel();
        personModel.load((Object)fid);
        return personModel;
    }

    public static Map<String, Object> getInvoiceDataParam(InvoiceCloudCfgBO config) {
        HashMap<String, Object> dataParam = new HashMap<String, Object>();
        dataParam.put("baseUrl", ErAIUtils.httpOrHttps() + ErStdConfig.getInvoiceCloudApiDomain());
        dataParam.put("env", ErStdConfig.isProduct() ? "prod" : "test");
        String clientId = config.getClientId();
        String clientSecret = config.getClientSecret();
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String sign = MD5.md5crypt((String)(clientId + clientSecret + timeStamp));
        dataParam.put("client_id", clientId);
        dataParam.put("client_secret", clientSecret);
        dataParam.put("tin", config.getTaxRegnum());
        dataParam.put("eid", RequestContext.get().getCurrUserId());
        dataParam.put("sign", sign);
        dataParam.put("ghf_mc", config.getFirmname());
        dataParam.put("timestamp", timeStamp);
        dataParam.put("ticketParam", config.genTicketParam());
        dataParam.put("billType", "quickReim");
        dataParam.put("bxd_key", "QucikReimId-" + timeStamp);
        dataParam.put("billNumber", "QR-" + UUID.randomUUID());
        dataParam.put("timestampo", timeStamp);
        return dataParam;
    }

    public static Map<String, Object> getInvoiceDataParam(InvoiceCloudCfgBO config, String bxd_key, String billType) {
        Map<String, Object> dataParam = ErAIUtils.getInvoiceDataParam(config);
        dataParam.put("bxd_key", bxd_key);
        dataParam.put("billType", billType);
        return dataParam;
    }

    public static String httpOrHttps() {
        String httpOfPC = ErStdConfig.get("invoicecloud.httpOfPC");
        if (StringUtils.isBlank((CharSequence)httpOfPC) || !StringUtils.equals((CharSequence)"http://", (CharSequence)httpOfPC)) {
            return "https://";
        }
        return httpOfPC;
    }

    public static ApiResult executeSaveOperation(String formId, String data) {
        String invokeAppid = ((FormService)ServiceFactory.getService(FormService.class)).getAppId(formId);
        String result = (String)DispatchServiceHelper.invokeBOSService((String)invokeAppid, (String)"OperationWebApi", (String)"save", (Object[])new Object[]{formId, data});
        Map ret = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        return ApiResult.fromMap((Map)ret);
    }

    public static String parsePkId(ApiResult ret) {
        Object data = ret.getData();
        if (data instanceof Map) {
            List pkIds = (List)((Map)data).get("successPkIds");
            return pkIds != null && !pkIds.isEmpty() ? pkIds.get(0).toString() : null;
        }
        return null;
    }

    public static QueryInvoiceDetailBO buildQueryInvoiceDetailBO(IFormView view, String serialNosStr) {
        IDataModel model = view.getModel();
        QueryInvoiceDetailBO queryInvoiceDetailBO = new QueryInvoiceDetailBO();
        queryInvoiceDetailBO.setSerialNo(serialNosStr);
        DynamicObject costCompanyDO = ErAIUtils.getCostCompanyDO(model);
        if (costCompanyDO != null) {
            InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(ErCommonUtils.getPk(costCompanyDO));
            if (config == null) {
                return null;
            }
            queryInvoiceDetailBO.setTaxNo(config.getTaxRegnum());
            queryInvoiceDetailBO.setCompanyName(config.getFirmname());
            queryInvoiceDetailBO.setCostCompany(costCompanyDO.getPkValue().toString());
        } else {
            logger.info("\u5c0fKcostCompany is Null...");
        }
        queryInvoiceDetailBO.setBxdKey(APIHelper.getBillNoCachedInCloud(model.getDataEntity()));
        queryInvoiceDetailBO.setView(view);
        return queryInvoiceDetailBO;
    }

    public static DynamicObject getCostCompanyDO(IDataModel model) {
        return (DynamicObject)model.getValue("costcompany");
    }

    public static String importInvoiceToBill(IFormView view, Map params) {
        String errMsg = "";
        Object invoceId = params.get("invoceId");
        if (null == invoceId) {
            errMsg = ResManager.loadKDString((String)"\u672a\u4f20\u5165\u53d1\u7968\u5e8f\u5217\u53f7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ErAIUtils_0", (String)"fi-er-business", (Object[])new Object[0]);
            return errMsg;
        }
        QueryInvoiceDetailBO queryInvoiceDetailBO = ErAIUtils.buildQueryInvoiceDetailBO(view, invoceId.toString());
        if (queryInvoiceDetailBO == null) {
            errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d39\u7528\u627f\u62c5\u516c\u53f8\u672a\u914d\u7f6e\u53d1\u7968\u4e91\u3002", (String)"ErAIUtils_1", (String)"fi-er-business", (Object[])new Object[0]);
            return errMsg;
        }
        try {
            List<InvoiceVO> invoiceVOs = APIHelper.queryInvoiceDetailBySerialNo(queryInvoiceDetailBO);
            Class<?> o = Class.forName(InvoicePlugin.getInvoicePlugin(view.getEntityId()));
            Method setView = o.getMethod("setView", IFormView.class);
            Object o1 = o.newInstance();
            Method processInvoiceVO = o.getMethod("executeProcess", List.class);
            setView.invoke(o1, view);
            processInvoiceVO.invoke(o1, invoiceVOs);
        }
        catch (Exception exception) {
            errMsg = exception.getMessage();
        }
        return errMsg;
    }

    public static String getUrl(String formId, String formidmob, String appId, Long billId, Map<String, Object> params) {
        String YZJ_CHATBOT;
        String url = "";
        switch (YZJ_CHATBOT = params.get("AI_DEVICE").toString()) {
            case "APP_CHATBOT": {
                StringBuilder urlBuilder = new StringBuilder(RequestContext.get().getClientFullContextPath()).append((CharSequence)new StringBuilder("mobile.html#/form/")).append(formidmob).append("?");
                urlBuilder.append("billStatusValue=1&").append("pkId=").append(billId);
                urlBuilder.append("&returnDefaultHome=true&isAI=true&app=").append(appId);
                url = urlBuilder.toString();
                break;
            }
            case "CQ_CHATBOT": {
                String data = SerializationUtils.toJsonString((Object)new ShowBillFormData(appId, formId, (Object)billId));
                url = String.format("bizAction://%s?%s", "ShowBillForm", data);
            }
        }
        logger.info("\u5c0fK\u751f\u6210\u7684url\u4e3a:" + url);
        return url;
    }

    public static String getAmountStr(DynamicObject dataEntity, String currencyPropName, String amountPropName) {
        String currencySign = dataEntity.getDynamicObject(currencyPropName) == null ? "\uffe5" : dataEntity.getDynamicObject(currencyPropName).getString("sign");
        String amount = dataEntity.getBigDecimal(amountPropName).compareTo(BigDecimal.ZERO) == 0 ? "0" : dataEntity.getBigDecimal(amountPropName).setScale(2, RoundingMode.HALF_UP).toString();
        return currencySign + amount;
    }

    public static enum InvoicePlugin {
        DAILYREIMBURSE("er_dailyreimbursebill", "kd.fi.er.formplugin.invoicecloud.v2.ImportInvoiceForDailyReimPCPlugin"),
        PUBLICREIMBURSE("er_publicreimbursebill", "kd.fi.er.formplugin.invoicecloud.v2.pubreim.ImportInvoiceForPubReimPCPlugin");

        private String formId;
        private String invoicePlugin;

        public String getFormId() {
            return this.formId;
        }

        public String getInvoicePlugin() {
            return this.invoicePlugin;
        }

        private InvoicePlugin(String formId, String invoicePlugin) {
            this.formId = formId;
            this.invoicePlugin = invoicePlugin;
        }

        public static String getInvoicePlugin(String formId) {
            for (InvoicePlugin invoicePlugin : InvoicePlugin.values()) {
                if (!invoicePlugin.getFormId().equals(formId)) continue;
                return invoicePlugin.getInvoicePlugin();
            }
            return null;
        }
    }
}

